/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.text.Transliterator;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.ant.CLDRConverterTool;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckCoverage;
import org.unicode.cldr.test.CoverageLevel;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LDMLUtilities;
import org.unicode.cldr.util.StandardCodes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CheckIBMCoverage
extends CLDRConverterTool {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int VERBOSE = 4;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR(), UOption.DESTDIR(), UOption.VERBOSE()};
    private String sourceDir = null;
    private String destDir = null;
    private boolean verbose = false;
    static Transliterator prettyPath = CheckCLDR.getTransliteratorFromFile("ID", "prettyPath.txt");
    private static final String RULES = "//ldml/collations/collation[@type=\"standard\"]/rules";
    private static final String COLLATIONS = "//ldml/collations";

    private void usage() {
        System.out.println("\nUsage: CheckIBMCoverage [OPTIONS] [FILES]\nCheckIBMCoverage [OPTIONS] -w [DIRECTORY] \nThis program is used to convert LDML files to ICU ResourceBundle TXT files.\nPlease refer to the following options. Options are not case sensitive.\nOptions:\n-s or --sourcedir          source directory for files followed by path, default is current directory.\n-d or --destdir            destination directory, followed by the path, default is current directory.\n-h or -? or --help         this usage text.\n-v or --verbose            print out verbose output.\nexample: org.unicode.cldr.icu.CheckIBMCoverage -s xxx -d yyy en.xml");
        System.exit(-1);
    }

    private void printInfo(String message) {
        if (this.verbose) {
            System.out.println("INFO : " + message);
        }
    }

    private void printWarning(String fileName, String message) {
        System.err.println(fileName + ": WARNING : " + message);
    }

    private void printError(String fileName, String message) {
        System.err.println(fileName + ": ERROR : " + message);
    }

    public static void main(String[] args) {
        CheckIBMCoverage cov = new CheckIBMCoverage();
        cov.processArgs(args);
    }

    public void processArgs(String[] args) {
        int remainingArgc = 0;
        for (int i = 0; i < options.length; ++i) {
            CheckIBMCoverage.options[i].doesOccur = false;
        }
        try {
            remainingArgc = UOption.parseArgs((String[])args, (UOption[])options);
        }
        catch (Exception e) {
            this.printError("", "(parsing args): " + e.toString());
            e.printStackTrace();
            this.usage();
        }
        if (args.length == 0 || CheckIBMCoverage.options[0].doesOccur || CheckIBMCoverage.options[1].doesOccur) {
            this.usage();
        }
        if (CheckIBMCoverage.options[2].doesOccur) {
            this.sourceDir = CheckIBMCoverage.options[2].value;
        }
        if (CheckIBMCoverage.options[3].doesOccur) {
            this.destDir = CheckIBMCoverage.options[3].value;
        }
        if (CheckIBMCoverage.options[4].doesOccur) {
            this.verbose = true;
        }
        if (this.destDir == null) {
            this.destDir = ".";
        }
        try {
            if (this.localesMap != null && this.localesMap.size() > 0) {
                this.processMap();
            } else if (remainingArgc > 0) {
                for (int i = 0; i < remainingArgc; ++i) {
                    this.processFile(args[i], this.verbose);
                }
            } else if (this.sourceDir != null) {
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.matches(".*_.*\\.xml");
                    }
                };
                File myDir = new File(this.sourceDir);
                String[] files = myDir.list(filter);
                if (this.localesMap == null) {
                    this.localesMap = new TreeMap();
                }
                for (int i = 0; i < files.length; ++i) {
                    this.localesMap.put(files[i], "");
                }
                this.processMap();
            } else {
                this.printError("", "No files specified for processing. Please check the arguments and try again");
                this.usage();
            }
        }
        catch (IOException ex) {
            this.printError("", ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void processMap() throws IOException {
        FileWriter fw = new FileWriter(this.destDir + File.separator + "IBMCoverage.html");
        fw.write("<html>\n");
        fw.write("\t<body>\n");
        fw.write("\t\t<table border=\"1\">\n");
        fw.write("\t\t\t<tr>\n");
        fw.write("\t\t\t\t<th>Locale</td>\n");
        fw.write("\t\t\t\t<th>Group</td>\n");
        fw.write("\t\t\t\t<th>Minimum Coverage(POSIX)</td>\n");
        fw.write("\t\t\t\t<th>Minimum Coverage(BASIC)</td>\n");
        fw.write("\t\t\t\t<th>Minimum Coverage(ICU)</td>\n");
        fw.write("\t\t\t</tr>\n");
        int bp = 0;
        int bf = 0;
        int mp = 0;
        int mf = 0;
        int gp = 0;
        int gf = 0;
        Iterator iter = this.localesMap.keySet().iterator();
        while (iter.hasNext()) {
            String fileName = (String)iter.next();
            int index = fileName.indexOf(".");
            String locale = fileName.substring(0, index);
            String glf = locale.concat("_group.log");
            String blf = locale.concat("_basic.log");
            String plf = locale.concat("_posix.log");
            StandardCodes sc = StandardCodes.make();
            String group = sc.getGroup(locale, "IBM");
            if (group == null) {
                this.printWarning(locale, " not required by IBM whitepaper");
                continue;
            }
            CoverageLevel.Level level = CoverageLevel.Level.get(group);
            fw.write("\t\t\t<tr>\n");
            fw.write("\t\t\t\t<td>" + locale + "</td>\n");
            fw.write("\t\t\t\t<td>" + group + "</td>\n");
            int posix = this.processFile(locale, this.destDir + File.separator + plf, CoverageLevel.Level.POSIX, group, true);
            if (posix == 0) {
                fw.write("\t\t\t\t<td><img src=\"blue_check.gif\" border=\"0\" ALT=\"Pass\"></td>\n");
                ++mp;
            } else {
                fw.write("\t\t\t\t<td><a href=\"" + plf + "\"><img src=\"red_x.gif\" border=\"0\" ALT=\"Fail\"></a></td>\n");
                ++mf;
            }
            int basic = this.processFile(locale, this.destDir + File.separator + blf, CoverageLevel.Level.BASIC, group, true);
            if (basic == 0) {
                fw.write("\t\t\t\t<td><img src=\"blue_check.gif\" border=\"0\" ALT=\"Pass\"></td>\n");
                ++bp;
            } else {
                fw.write("\t\t\t\t<td><a href=\"" + blf + "\"><img src=\"red_x.gif\" border=\"0\" ALT=\"Fail\"></a></td>\n");
                ++bf;
            }
            if (level.equals(CoverageLevel.Level.POSIX)) {
                if (posix == 0) {
                    fw.write("\t\t\t\t<td><img src=\"blue_check.gif\" border=\"0\" ALT=\"Pass\"></td>\n");
                    ++gp;
                } else {
                    fw.write("\t\t\t\t<td><a href=\"" + glf + "\"><img src=\"red_x.gif\" border=\"0\" ALT=\"Fail\"></a></td>\n");
                    ++gf;
                }
            } else if (level.equals(CoverageLevel.Level.BASIC)) {
                if (basic == 0) {
                    fw.write("\t\t\t\t<td><img src=\"blue_check.gif\" border=\"0\" ALT=\"Pass\"></td>\n");
                    ++gp;
                } else {
                    fw.write("\t\t\t\t<td><a href=\"" + glf + "\"><img src=\"red_x.gif\" border=\"0\" ALT=\"Fail\"></a></td>\n");
                    ++gf;
                }
            } else {
                int out = this.processFile(locale, this.destDir + File.separator + glf, level, group, true);
                if (out == 0) {
                    fw.write("\t\t\t\t<td><img src=\"blue_check.gif\" border=\"0\" ALT=\"Pass\"></td>\n");
                    ++gp;
                } else {
                    fw.write("\t\t\t\t<td><a href=\"" + glf + "\"><img src=\"red_x.gif\" border=\"0\" ALT=\"Fail\"></a></td>\n");
                    ++gf;
                }
            }
            fw.write("\t\t\t</tr>\n");
            fw.flush();
        }
        fw.write("\t\t</table>\n");
        fw.write("\t\t<br><b><i>Note: </i></b>\n");
        fw.write("\t\t<ol>\n");
        fw.write("\t\t\t<il>POSIX==G4</il>\n");
        fw.write("\t\t\t<il>Basic==G3</il>\n");
        fw.write("\t\t\t<il>Moderate==G2</il>\n");
        fw.write("\t\t\t<il>Modern==G1</il>\n");
        fw.write("\t\t\t<il>Comprehensive==G0</il>\n");
        fw.write("\t\t</ol>\n");
        fw.write("\t\t<br><b>Basic Requirement Passed: " + bp + "</b>\n");
        fw.write("\t\t<br><b>Basic Requirement Failed: " + bf + "</b>\n");
        fw.write("\t\t<br><b>Total: " + (bp + bf) + "</b>\n");
        fw.write("\t\t<br><b>Posix Requirement Passed: " + mp + "</b>\n");
        fw.write("\t\t<br><b>Posix Requirement Failed: " + mf + "</b>\n");
        fw.write("\t\t<br><b>Total: " + (mp + mf) + "</b>\n");
        fw.write("\t</body>\n");
        fw.write("</html>\n");
        fw.flush();
        fw.close();
    }

    private int processFile(String fileName, boolean pretty) throws IOException {
        int index = fileName.indexOf(".");
        String locale = fileName.substring(0, index);
        StandardCodes sc = StandardCodes.make();
        String group = sc.getGroup(locale, "IBM");
        if (group == null) {
            this.printWarning(locale, " not required by IBM whitepaper");
            return -1;
        }
        CoverageLevel.Level level = CoverageLevel.Level.get(group);
        int out = this.processFile(locale, this.destDir + File.separator + locale + "_posix.log", CoverageLevel.Level.POSIX, group, pretty);
        out = this.processFile(locale, this.destDir + File.separator + locale + "_basic.log", CoverageLevel.Level.BASIC, group, pretty);
        out = this.processFile(locale, this.destDir + File.separator + locale + "_group.log", level, group, pretty);
        return out;
    }

    private int processFile(String locale, String logFile, CoverageLevel.Level level, String group, boolean pretty) throws IOException {
        FileWriter fw = new FileWriter(logFile);
        int ret = this.check(locale, group, level, fw);
        if (level.compareTo(CoverageLevel.Level.POSIX) == 0) {
            Node rules;
            Document node = LDMLUtilities.getFullyResolvedLDML(this.sourceDir + "/../collation", locale, false, true, false, false);
            Node collation = LDMLUtilities.getNode(node, COLLATIONS);
            String validSubLocales = LDMLUtilities.getAttributeValue(collation, "validSubLocales");
            if (validSubLocales == null || !validSubLocales.matches(".*\\b" + locale + ".*\\b")) {
                fw.write("//ldml/collations : Found but not valid according to validSublocales attribute");
                fw.write("\n");
            }
            if ((rules = LDMLUtilities.getNode(node, RULES)) == null) {
                fw.write("//ldml/collations/collation[@type=\"standard\"]/rules : Not found. Required for POSIX level coverage");
                fw.write("\n");
            }
        }
        fw.flush();
        fw.close();
        return ret;
    }

    private int check(String locale, String group, CoverageLevel.Level level, FileWriter fw) throws IOException {
        CheckCoverage coverage = new CheckCoverage();
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make(this.sourceDir, "xml");
        CLDRFile file = cldrFactory.make(locale, true);
        CoverageLevel covLevel = new CoverageLevel();
        ArrayList result = new ArrayList();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("CoverageLevel.localeType", group);
        options.put("CheckCoverage.requiredLevel", group);
        options.put("submission", "true");
        this.printInfo("Processing file " + locale);
        coverage.setCldrFileToCheck(file, options, result);
        covLevel.setFile(file, options, null, result);
        CLDRFile resolved = coverage.getResolvedCldrFileToCheck();
        TreeSet paths = new TreeSet(CLDRFile.ldmlComparator);
        CollectionUtilities.addAll((Iterator)resolved.iterator(), paths);
        int ret = 0;
        if (level != null) {
            coverage.setRequiredLevel(level);
        }
        Iterator it2 = paths.iterator();
        while (it2.hasNext()) {
            String path = (String)it2.next();
            String value = file.getStringValue(path);
            String fullPath = file.getFullXPath(path);
            if (this.verbose) {
                System.out.println(fullPath);
            }
            result.clear();
            if (level.compareTo(CoverageLevel.Level.POSIX) == 0) {
                covLevel.checkPosixCoverage(path, fullPath, value, options, result, file, resolved);
            } else {
                coverage.check(path, fullPath, value, options, result);
            }
            Iterator it3 = result.iterator();
            while (it3.hasNext()) {
                CheckCLDR.CheckStatus status = (CheckCLDR.CheckStatus)it3.next();
                String statusType = status.getType();
                if (!statusType.equals("Error")) continue;
                fw.write(fullPath + " : Untranslated. " + status.getMessage());
                fw.write("\n");
                ret = -1;
            }
        }
        return ret;
    }
}

