/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.tool.UOption;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LDMLNodesDeleter {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int XPATH = 4;
    private static final int UOPTION_LIMIT = 5;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR(), UOption.DESTDIR(), UOption.create((String)"xpath", (char)'x', (int)1)};
    private String xpath = null;
    private String sourcedir = null;
    private String destdir = null;
    private static final String copyright = "<!--\n Copyright (c) 2002-2005 International Business Machines Corporation and others. All rights reserved.\n-->\n";
    private static final String docType = "<!DOCTYPE ldml SYSTEM \"http://www.unicode.org/cldr/dtd/1.3/ldml.dtd\"\n[\n   <!ENTITY % icu SYSTEM \" http://www.unicode.org/cldr/dtd/1.3/ldmlICU.dtd\">\n   %icu;\n]\n>\n";

    public static void main(String[] args) {
        LDMLNodesDeleter del = new LDMLNodesDeleter();
        del.processArgs(args);
    }

    private void usage() {
        System.out.println("\nUsage: LDMLNodesDeleter [OPTIONS] [XPATH1] [XPATH2]\n\nThis program is used to delete nodes from the given LDML file.\nPlease refer to the following options. Options are not case sensitive.\nOptions:\n-s or --sourcedir          source directory, followed by the path, default is current directory.\n-d or --destdir            destination directory, followed by the path, default is current directory.\n-x or --xpath              XPath of the nodes to be deleted. You can pass in multiple XPaths seperated by a colon.\n-h or -? or --help         this usage text.\nexample: com.ibm.icu.dev.tool.cldr.LDMLNodesDeleter -s locale/common/main -d locale/common/main/modified -x //ldml/dates/calendars/calendar[@type='chinese']://ldml/characters en.xml");
        System.exit(-1);
    }

    private void processArgs(String[] args) {
        int remainingArgc = 0;
        try {
            remainingArgc = UOption.parseArgs((String[])args, (UOption[])options);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.toString());
            e.printStackTrace();
            this.usage();
        }
        if (args.length == 0 || LDMLNodesDeleter.options[0].doesOccur || LDMLNodesDeleter.options[1].doesOccur) {
            this.usage();
        }
        if (LDMLNodesDeleter.options[2].doesOccur) {
            this.sourcedir = LDMLNodesDeleter.options[2].value;
        }
        if (LDMLNodesDeleter.options[3].doesOccur) {
            this.destdir = LDMLNodesDeleter.options[3].value;
        }
        if (LDMLNodesDeleter.options[4].doesOccur) {
            this.xpath = LDMLNodesDeleter.options[4].value;
        }
        if (this.destdir == null) {
            throw new RuntimeException("Destination not specified");
        }
        if (remainingArgc < 1) {
            this.usage();
            System.exit(-1);
        }
        for (int i = 0; i < remainingArgc; ++i) {
            String fn = args[i];
            String sourceFN = LDMLUtilities.getFullPath(0, fn, this.sourcedir);
            String destFN = LDMLUtilities.getFullPath(0, fn, this.destdir);
            try {
                Document source = LDMLUtilities.parse(sourceFN, false);
                Node src = LDMLUtilities.getNode(source, "//ldml");
                String[] list = this.xpath.split(":");
                for (int j = 0; j < list.length; ++j) {
                    System.out.println("INFO: Deleting nodes with xpath: " + list[j]);
                    this.deleteNodes(source, list[j]);
                }
                this.modifyIdentity(source);
                source.normalize();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(destFN), "UTF-8");
                PrintWriter pw = new PrintWriter(writer);
                LDMLUtilities.printDOMTree(src, pw, docType, copyright);
                writer.flush();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void modifyIdentity(Document doc) {
        Node version = LDMLUtilities.getNode(doc, "//ldml/identity/version");
        NamedNodeMap al = version.getAttributes();
        Node number = al.getNamedItem("number");
        number.setNodeValue("$Revision: 1.3 $");
        Node gen = LDMLUtilities.getNode(doc, "//ldml/identity/generation");
        al = gen.getAttributes();
        Node date = al.getNamedItem("date");
        date.setNodeValue("$Date: 2005/07/19 00:32:12 $");
    }

    private void deleteNodes(Document doc, String xpath) {
        NodeList list = LDMLUtilities.getNodeList(doc, xpath);
        if (list != null && list.getLength() > 0) {
            int i;
            Node[] nodes = new Node[list.getLength()];
            for (i = 0; i < list.getLength(); ++i) {
                nodes[i] = list.item(i);
            }
            for (i = 0; i < nodes.length; ++i) {
                Node parent = nodes[i].getParentNode();
                parent.removeChild(nodes[i]);
            }
        }
    }
}

