/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LanguageTagParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestCldr
extends TestFmwk {
    static final boolean DEBUG = false;
    SAXParser SAX;
    static String MATCH;
    String directory;
    Set allLocales = new TreeSet();
    static Transliterator toUnicode;
    Map RegisteredHandlers = new HashMap();
    static TimeZone utc;
    static DateFormat iso;
    static int[] DateFormatValues;
    static String[] DateFormatNames;
    static String[] NumberNames;
    static UnicodeSet controlsAndSpace;
    DefaultHandler DEFAULT_HANDLER;

    public TestCldr() {
        iso.setTimeZone(utc);
        this.addHandler("collation", new Handler(){

            public void handleResult(ULocale currentLocale, String value) {
                Collator col = Collator.getInstance((ULocale)currentLocale);
                String lastLine = "";
                int count = 0;
                int pos = 0;
                while (pos < value.length()) {
                    int nextPos = value.indexOf(10, pos);
                    if (nextPos < 0) {
                        nextPos = value.length();
                    }
                    String line = value.substring(pos, nextPos);
                    if ((line = TestCldr.remove(line, controlsAndSpace)).trim().length() != 0) {
                        int comp = col.compare(lastLine, line);
                        if (comp > 0) {
                            ++this.failures;
                            TestCldr.this.errln("\tLine " + (count + 1) + "\tFailure: " + TestCldr.showString(lastLine) + " should be leq " + TestCldr.showString(line));
                        }
                        lastLine = line;
                    }
                    pos = nextPos + 1;
                    ++count;
                }
            }
        });
        this.addHandler("number", new Handler(){

            public void handleResult(ULocale locale, String result) {
                NumberFormat nf = null;
                double v = Double.NaN;
                Iterator it = this.settings.keySet().iterator();
                while (it.hasNext()) {
                    String temp;
                    String attributeName = (String)it.next();
                    String attributeValue = (String)this.settings.get(attributeName);
                    if (attributeName.equals("input")) {
                        v = Double.parseDouble(attributeValue);
                        continue;
                    }
                    int index = this.lookupValue(attributeValue, NumberNames);
                    switch (index) {
                        case 0: {
                            nf = NumberFormat.getInstance((ULocale)locale);
                            break;
                        }
                        case 1: {
                            nf = NumberFormat.getIntegerInstance((ULocale)locale);
                            break;
                        }
                        case 2: {
                            nf = NumberFormat.getNumberInstance((ULocale)locale);
                            break;
                        }
                        case 3: {
                            nf = NumberFormat.getPercentInstance((ULocale)locale);
                            break;
                        }
                        case 4: {
                            nf = NumberFormat.getScientificInstance((ULocale)locale);
                            break;
                        }
                        default: {
                            nf = NumberFormat.getCurrencyInstance((ULocale)locale);
                            nf.setCurrency(Currency.getInstance((String)attributeValue));
                        }
                    }
                    if ((temp = nf.format(v).trim()).equals(result = result.trim())) continue;
                    TestCldr.this.errln("Number: Locale: " + locale + ",\tType: " + attributeValue + ",\tCLDR: <" + result + ">, ICU: <" + temp + ">");
                }
            }
        });
        this.addHandler("date", new Handler(){

            public void handleResult(ULocale locale, String result) throws ParseException {
                int dateFormat = 0;
                int timeFormat = 0;
                Date date = new Date();
                Iterator it = this.settings.keySet().iterator();
                while (it.hasNext()) {
                    String attributeName = (String)it.next();
                    String attributeValue = (String)this.settings.get(attributeName);
                    if (attributeName.equals("input")) {
                        date = iso.parse(attributeValue);
                        continue;
                    }
                    int index = this.lookupValue(attributeValue, DateFormatNames);
                    if (attributeName.equals("dateType")) {
                        dateFormat = index;
                        continue;
                    }
                    timeFormat = index;
                }
                SimpleDateFormat dt = this.getDateFormat(locale, dateFormat, timeFormat);
                dt.setTimeZone(utc);
                String temp = dt.format(date).trim();
                result = result.trim();
                if (!temp.equals(result)) {
                    TestCldr.this.errln("DateTime: Locale: " + locale + ",\tDate: " + DateFormatNames[dateFormat] + ",\tTime: " + DateFormatNames[timeFormat] + ",\tCLDR: <" + result + ">, ICU: <" + temp + ">");
                }
            }

            private SimpleDateFormat getDateFormat(ULocale locale, int dateFormat, int timeFormat) {
                DateFormat dt = dateFormat == 0 ? DateFormat.getTimeInstance((int)DateFormatValues[timeFormat], (ULocale)locale) : (timeFormat == 0 ? DateFormat.getDateInstance((int)DateFormatValues[dateFormat], (ULocale)locale) : DateFormat.getDateTimeInstance((int)DateFormatValues[dateFormat], (int)DateFormatValues[timeFormat], (ULocale)locale));
                return (SimpleDateFormat)dt;
            }
        });
        this.addHandler("zoneFields", new Handler(){
            String date = "";
            String zone = "";
            String parse = "";
            String pattern = "";

            public void handleResult(ULocale locale, String result) throws ParseException {
                Iterator it = this.settings.keySet().iterator();
                while (it.hasNext()) {
                    String attributeName = (String)it.next();
                    String attributeValue = (String)this.settings.get(attributeName);
                    if (attributeName.equals("date")) {
                        this.date = attributeValue;
                        continue;
                    }
                    if (attributeName.equals("field")) {
                        this.pattern = attributeValue;
                        continue;
                    }
                    if (attributeName.equals("zone")) {
                        this.zone = attributeValue;
                        continue;
                    }
                    if (!attributeName.equals("parse")) continue;
                    this.parse = attributeValue;
                }
                Date dateValue = iso.parse(this.date);
                SimpleDateFormat field = new SimpleDateFormat(this.pattern, locale);
                field.setTimeZone(TimeZone.getTimeZone((String)this.zone));
                String temp = field.format(dateValue).trim();
                result = result.trim();
                if (!temp.equals(result)) {
                    TestCldr.this.errln("Zone Format: Locale: " + locale + ", \tZone: " + this.zone + ", \tDate: " + this.date + ", \tField: " + this.pattern + ", \tCLDR: <" + result + ">, \tICU: <" + temp + ">");
                }
            }
        });
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            this.SAX = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't start");
        }
        this.DEFAULT_HANDLER = new DefaultHandler(){
            static final boolean DEBUG = false;
            StringBuffer lastChars = new StringBuffer();
            boolean justPopped = false;
            Handler handler;

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                try {
                    if (!qName.equals("cldrTest")) {
                        if (qName.equals("result")) {
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                this.handler.set(attributes.getQName(i), attributes.getValue(i));
                            }
                        } else {
                            this.handler = TestCldr.this.getHandler(qName, attributes);
                        }
                    }
                    this.justPopped = false;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                try {
                    if (qName.equals("result")) {
                        this.handler.checkResult(this.lastChars.toString());
                    } else if (qName.length() != 0) {
                        // empty if block
                    }
                    this.lastChars.setLength(0);
                    this.justPopped = true;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                try {
                    String value = new String(ch, start, length);
                    this.lastChars.append(value);
                    this.justPopped = false;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            public void notationDecl(String name, String publicId, String systemId) throws SAXException {
                TestCldr.this.logln("notationDecl: " + name + ", " + publicId + ", " + systemId);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                TestCldr.this.logln("processingInstruction: " + target + ", " + data);
            }

            public void skippedEntity(String name) throws SAXException {
                TestCldr.this.logln("skippedEntity: " + name);
            }

            public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
                TestCldr.this.logln("unparsedEntityDecl: " + name + ", " + publicId + ", " + systemId + ", " + notationName);
            }
        };
    }

    public static void main(String[] args) throws Exception {
        MATCH = System.getProperty("XML_MATCH");
        if (MATCH == null) {
            MATCH = ".*";
        } else {
            System.out.println("Resetting MATCH:" + MATCH);
        }
        new TestCldr().run(args);
    }

    public void TestScripts() {
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", MATCH);
        ULocale[] locales = ULocale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            ULocale locale = locales[i];
            this.logln(locale.toString());
            int[] scriptNumbers = UScript.getCode((ULocale)locale);
            TreeSet<String> ICUScripts = new TreeSet<String>();
            for (int j = 0; j < scriptNumbers.length; ++j) {
                ICUScripts.add(UScript.getShortName((int)scriptNumbers[j]));
            }
            CLDRFile cfile = cldrFactory.make(locale.toString(), true, true);
            UnicodeSet exemplars = this.getExemplarSet(cfile, "").addAll(this.getExemplarSet(cfile, "auxiliary"));
            Set CLDRScripts = this.getScriptsFromUnicodeSet(exemplars);
            if (!((Object)CLDRScripts).equals(ICUScripts)) {
                this.errln(locale + "\tscripts not equals.\tCLDR: " + CLDRScripts + ",\tICU: " + ICUScripts);
                continue;
            }
            this.logln("\tCLDR:\t" + CLDRScripts + ",\tICU: " + ICUScripts);
        }
    }

    private Set getScriptsFromUnicodeSet(UnicodeSet exemplars) {
        BitSet scriptBits = new BitSet();
        boolean show = false;
        UnicodeSetIterator it = new UnicodeSetIterator(exemplars);
        while (it.next()) {
            int cp;
            if (show) {
                System.out.println(Integer.toHexString(it.codepoint));
            }
            if (it.codepoint != UnicodeSetIterator.IS_STRING) {
                scriptBits.set(UScript.getScript((int)it.codepoint));
                continue;
            }
            for (int i = 0; i < it.string.length(); i += UTF16.getCharCount((int)cp)) {
                cp = UTF16.charAt((String)it.string, (int)i);
                scriptBits.set(UScript.getScript((int)cp));
            }
        }
        scriptBits.clear(0);
        scriptBits.clear(1);
        TreeSet<String> scripts = new TreeSet<String>();
        for (int j = 0; j < scriptBits.size(); ++j) {
            if (!scriptBits.get(j)) continue;
            scripts.add(UScript.getShortName((int)j));
        }
        return scripts;
    }

    public UnicodeSet getExemplarSet(CLDRFile cldrfile, String type) {
        String v;
        if (type.length() != 0) {
            type = "[@type=\"" + type + "\"]";
        }
        if ((v = cldrfile.getStringValue("//ldml/characters/exemplarCharacters" + type)) == null) {
            return new UnicodeSet();
        }
        return new UnicodeSet(v);
    }

    public void TestFiles() throws SAXException, IOException {
        this.directory = "../../common/test/";
        TreeSet s = new TreeSet();
        this.addLocales(NumberFormat.getAvailableULocales(), s);
        this.addLocales(DateFormat.getAvailableULocales(), s);
        this.addLocales(Collator.getAvailableULocales(), s);
        Matcher m = Pattern.compile(MATCH).matcher("");
        Iterator it = s.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            if (!m.reset(locale).matches()) continue;
            this._test(locale);
        }
    }

    public void addLocales(ULocale[] list, Collection s) {
        LanguageTagParser lsp = new LanguageTagParser();
        for (int i = 0; i < list.length; ++i) {
            this.allLocales.add(list[i].toString());
            String loc = list[i].toString();
            s.add(lsp.set(loc).getLanguage());
        }
    }

    public void _test(String localeName) throws SAXException, IOException {
        File f = new File(this.directory + localeName + ".xml");
        this.logln("Testing " + f.getCanonicalPath());
        this.SAX.parse(f, this.DEFAULT_HANDLER);
    }

    public static String showString(String in) {
        return "\u00ab" + in + "\u00bb (" + toUnicode.transliterate(in) + ")";
    }

    public Handler getHandler(String name, Attributes attributes) {
        Handler result = (Handler)this.RegisteredHandlers.get(name);
        if (result == null) {
            this.logln("Unexpected test type: " + name);
        } else {
            result.setAttributes(attributes);
        }
        return result;
    }

    public void addHandler(String name, Handler handler) {
        handler.setName(name);
        this.RegisteredHandlers.put(name, handler);
    }

    static String remove(String in, UnicodeSet toRemove) {
        int cp;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < in.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)in, (int)i);
            if (toRemove.contains(cp)) continue;
            UTF16.append((StringBuffer)result, (int)cp);
        }
        return result.toString();
    }

    static {
        toUnicode = Transliterator.getInstance((String)"any-hex");
        utc = TimeZone.getTimeZone((String)"GMT");
        iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        DateFormatValues = new int[]{-1, 3, 2, 1, 0};
        DateFormatNames = new String[]{"none", "short", "medium", "long", "full"};
        NumberNames = new String[]{"standard", "integer", "decimal", "percent", "scientific", "GBP"};
        controlsAndSpace = new UnicodeSet("[:cc:]");
    }

    public abstract class Handler {
        Map settings = new TreeMap();
        String name;
        List currentLocales = new ArrayList();
        int failures = 0;

        void setName(String name) {
            this.name = name;
        }

        void set(String attributeName, String attributeValue) {
            this.settings.put(attributeName, attributeValue);
        }

        void checkResult(String value) {
            ULocale ul = new ULocale("xx");
            try {
                for (int i = 0; i < this.currentLocales.size(); ++i) {
                    ul = (ULocale)this.currentLocales.get(i);
                    this.handleResult(ul, value);
                    if (this.failures == 0) continue;
                    TestCldr.this.errln("\tTotal Failures: " + this.failures + "\t" + ul + "(" + ul.getDisplayName(ULocale.ENGLISH) + ")");
                    this.failures = 0;
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                TestCldr.this.errln("Exception: Locale: " + ul + ",\tValue: <" + value + ">\r\n" + sw.toString());
            }
        }

        public void loglnSAX(String message) {
            String temp = message + "\t[" + this.name;
            Iterator it = this.settings.keySet().iterator();
            while (it.hasNext()) {
                String attributeName = (String)it.next();
                String attributeValue = (String)this.settings.get(attributeName);
                temp = temp + " " + attributeName + "=<" + attributeValue + ">";
            }
            TestCldr.this.logln(temp + "]");
        }

        int lookupValue(Object x, Object[] list) {
            for (int i = 0; i < list.length; ++i) {
                if (!x.equals(list[i])) continue;
                return i;
            }
            this.loglnSAX("Unknown String: " + x);
            return -1;
        }

        abstract void handleResult(ULocale var1, String var2) throws Exception;

        public void setAttributes(Attributes attributes) {
            String localeList = attributes.getValue("locales");
            String[] currentLocaleString = new String[50];
            Utility.split((String)localeList, (char)' ', (String[])currentLocaleString);
            this.currentLocales.clear();
            for (int i = 0; i < currentLocaleString.length; ++i) {
                if (currentLocaleString[i].length() == 0) continue;
                if (TestCldr.this.allLocales.contains("")) {
                    TestCldr.this.logln("Skipping locale, not in ICU4J: " + currentLocaleString[i]);
                    continue;
                }
                this.currentLocales.add(new ULocale(currentLocaleString[i]));
            }
        }
    }
}

