/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.ooo;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.unicode.cldr.ooo.OOLocales;
import org.unicode.cldr.ooo.supplementalData;

public class LDMLToOOMapper {
    public static void MapFormatElements(Hashtable inFormatElements, Hashtable inFormatPattern, Hashtable inFormatOO, Hashtable inFormatDefaultNames, Hashtable outFormatElements, Hashtable outFormatCodes, Hashtable outFormatDefaultNames) {
        if (inFormatElements == null || inFormatPattern == null || inFormatOO == null) {
            return;
        }
        String defaultKey = null;
        String type = null;
        String usage = null;
        String formatIndex = null;
        Hashtable OOData_outer = new Hashtable();
        Enumeration data = inFormatElements.elements();
        Enumeration keys = inFormatElements.keys();
        while (keys.hasMoreElements()) {
            String defaultName;
            String key = (String)keys.nextElement();
            Hashtable innerLDML = (Hashtable)inFormatOO.get(key);
            if (inFormatOO == null || inFormatOO.size() <= 0) continue;
            Hashtable<String, String> formatElementAttribs = new Hashtable<String, String>();
            formatElementAttribs.put("msgid", key);
            defaultKey = (String)innerLDML.get("openOffice:default");
            if (defaultKey != null && defaultKey.length() > 0) {
                formatElementAttribs.put("default", defaultKey);
            }
            defaultKey = null;
            type = (String)innerLDML.get("openOffice:type");
            if (type != null && type.length() > 0) {
                formatElementAttribs.put("type", type);
            }
            type = null;
            usage = (String)innerLDML.get("openOffice:usage");
            if (usage != null && usage.length() > 0) {
                formatElementAttribs.put("usage", usage);
            }
            type = null;
            formatIndex = (String)innerLDML.get("openOffice:formatindex");
            if (formatIndex != null && formatIndex.length() > 0) {
                formatElementAttribs.put("formatindex", formatIndex);
            }
            formatIndex = null;
            outFormatElements.put(key, formatElementAttribs);
            String formatCode = (String)inFormatPattern.get(key);
            if (formatCode != null && formatCode.length() > 0) {
                outFormatCodes.put(key, formatCode);
            }
            if ((defaultName = (String)inFormatDefaultNames.get(key)) == null || defaultName.length() <= 0) continue;
            outFormatDefaultNames.put(key, defaultName);
        }
    }

    public static String MapMeasurementSystem(String ms) {
        String ms_out = "";
        if (ms == null) {
            return null;
        }
        if (ms.compareTo("metric") == 0) {
            ms_out = "metric";
        } else if (ms.compareTo("US") == 0) {
            ms_out = "US";
        }
        return ms_out;
    }

    public static void MapCollators(Vector inCollators) {
        Enumeration collations = inCollators.elements();
        while (collations.hasMoreElements()) {
            String def;
            Hashtable collationElement = (Hashtable)collations.nextElement();
            if (collationElement == null || collationElement.size() <= 0) continue;
            String unoid = (String)collationElement.get("openOffice:unoid");
            if (unoid != null) {
                collationElement.remove("openOffice:unoid");
                collationElement.put("unoid", unoid);
            }
            if ((def = (String)collationElement.get("openOffice:default")) == null) continue;
            collationElement.remove("openOffice:default");
            collationElement.put("default", def);
        }
    }

    public static void MapIndexKeys(Vector inIndexKeys) {
        Enumeration indexkeyTables = inIndexKeys.elements();
        while (indexkeyTables.hasMoreElements()) {
            String def;
            String module;
            String phonetic;
            Hashtable attribs;
            Hashtable indexkeyTable = (Hashtable)indexkeyTables.nextElement();
            if (indexkeyTable == null || indexkeyTable.size() <= 0 || (attribs = (Hashtable)indexkeyTable.get("attributes")) == null || attribs.size() <= 0) continue;
            String unoid = (String)attribs.get("openOffice:unoid");
            if (unoid != null && unoid.length() > 0) {
                attribs.remove("openOffice:unoid");
                attribs.put("unoid", unoid);
            }
            if ((phonetic = (String)attribs.get("openOffice:phonetic")) != null && phonetic.length() > 0) {
                attribs.remove("openOffice:phonetic");
                attribs.put("phonetic", phonetic);
            }
            if ((module = (String)attribs.get("openOffice:module")) != null && module.length() > 0) {
                attribs.remove("openOffice:module");
                attribs.put("module", module);
            }
            if ((def = (String)attribs.get("openOffice:default")) == null) continue;
            attribs.remove("openOffice:default");
            attribs.put("default", def);
        }
    }

    public static void MapCalendar(Vector inCalendarTypes, Vector outCalendarTypes, String localeStr) {
        if (inCalendarTypes != null && outCalendarTypes != null || localeStr == null) {
            Enumeration calEnum = inCalendarTypes.elements();
            while (calEnum.hasMoreElements()) {
                String ooUnoid;
                Hashtable ldmlCal = (Hashtable)calEnum.nextElement();
                String calType = (String)ldmlCal.get("type");
                if (calType == null || !OOLocales.needCalendar(ooUnoid = LDMLToOOMapper.MapCalendarType(calType), localeStr)) continue;
                Hashtable<String, String> ooCal = new Hashtable<String, String>();
                ooCal.put("unoid", ooUnoid);
                outCalendarTypes.add(ooCal);
            }
        }
    }

    private static String MapCalendarType(String LDMLCalendar) {
        if (LDMLCalendar == null) {
            return null;
        }
        Object OOCalendar = null;
        if (LDMLCalendar.compareTo("gregorian") == 0) {
            LDMLCalendar = "gregorian";
        } else if (LDMLCalendar.compareTo("chinese") == 0) {
            LDMLCalendar = "ROC";
        } else if (LDMLCalendar.compareTo("islamic-civil") == 0) {
            LDMLCalendar = "hijri";
        } else if (LDMLCalendar.compareTo("hebrew") == 0) {
            LDMLCalendar = "jewish";
        } else if (LDMLCalendar.compareTo("buddhist") == 0) {
            LDMLCalendar = "buddhist";
        } else if (LDMLCalendar.compareTo("hanja") == 0) {
            LDMLCalendar = "hanja";
        } else if (LDMLCalendar.compareTo("japanese") == 0) {
            LDMLCalendar = "gengou";
        }
        return LDMLCalendar;
    }

    public static String MapDefaultCalendar(Vector calAttribs) {
        Hashtable attribs;
        String defaultCal = null;
        if (calAttribs == null) {
            return null;
        }
        Enumeration calEnum = calAttribs.elements();
        if (calEnum.hasMoreElements() && (attribs = (Hashtable)calEnum.nextElement()) != null) {
            defaultCal = (String)attribs.get("type");
        }
        return defaultCal;
    }

    public static Hashtable MapDays(Hashtable LDMLData, String localeStr) {
        if (LDMLData == null || LDMLData.size() == 0 || localeStr == null) {
            return null;
        }
        Hashtable OOData = new Hashtable();
        Enumeration enDays = LDMLData.elements();
        Enumeration enCalType = LDMLData.keys();
        while (enDays.hasMoreElements()) {
            Hashtable<String, String> innerOOData = new Hashtable<String, String>();
            Hashtable LDMLDataI = (Hashtable)enDays.nextElement();
            String calTypeI = (String)enCalType.nextElement();
            String calTypeOO = LDMLToOOMapper.MapCalendarType(calTypeI);
            if (!OOLocales.needCalendar(calTypeOO, localeStr)) continue;
            String day = (String)LDMLDataI.get("sun");
            if (day != null) {
                innerOOData.put("sun", day);
            } else {
                Enumeration en = LDMLDataI.keys();
                Enumeration enumVal = LDMLDataI.elements();
                String key = (String)en.nextElement();
                String value = (String)enumVal.nextElement();
            }
            day = (String)LDMLDataI.get("mon");
            if (day != null) {
                innerOOData.put("mon", day);
            }
            if ((day = (String)LDMLDataI.get("tue")) != null) {
                innerOOData.put("tue", day);
            }
            if ((day = (String)LDMLDataI.get("wed")) != null) {
                innerOOData.put("wed", day);
            }
            if ((day = (String)LDMLDataI.get("thu")) != null) {
                innerOOData.put("thu", day);
            }
            if ((day = (String)LDMLDataI.get("fri")) != null) {
                innerOOData.put("fri", day);
            }
            if ((day = (String)LDMLDataI.get("sat")) != null) {
                innerOOData.put("sat", day);
            }
            if (calTypeOO == null || innerOOData.size() <= 0) continue;
            OOData.put(calTypeOO, innerOOData);
        }
        return OOData;
    }

    public static Hashtable MapMonths(Hashtable LDMLData, String localeStr) {
        if (LDMLData == null || LDMLData.size() == 0 || localeStr == null) {
            return null;
        }
        Hashtable OOData = new Hashtable();
        Enumeration enMonths = LDMLData.elements();
        Enumeration enCalType = LDMLData.keys();
        while (enMonths.hasMoreElements()) {
            String month;
            Hashtable<String, String> innerOOData = new Hashtable<String, String>();
            Hashtable LDMLDataI = (Hashtable)enMonths.nextElement();
            String calTypeI = (String)enCalType.nextElement();
            String calTypeOO = LDMLToOOMapper.MapCalendarType(calTypeI);
            if (!OOLocales.needCalendar(calTypeOO, localeStr)) continue;
            String m1 = "jan";
            String m2 = "feb";
            String m3 = "mar";
            String m4 = "apr";
            String m5 = "may";
            String m6 = "jun";
            String m7 = "jul";
            String m8 = "aug";
            String m9 = "sep";
            String m10 = "oct";
            String m11 = "nov";
            String m12 = "dec";
            String m13 = "";
            if (calTypeOO.compareTo("jewish") == 0) {
                m1 = "Nissan";
                m2 = "Iyar";
                m3 = "Sivan";
                m4 = "Tammuz";
                m5 = "Av";
                m6 = "Elul";
                m7 = "Tishri";
                m8 = "Heshvan";
                m9 = "Kislev";
                m10 = "Tevet";
                m11 = "Shevat";
                m12 = "Adar";
                m13 = "ve-Adar";
            }
            if ((month = (String)LDMLDataI.get("1")) != null) {
                innerOOData.put(m1, month);
            }
            if ((month = (String)LDMLDataI.get("2")) != null) {
                innerOOData.put(m2, month);
            }
            if ((month = (String)LDMLDataI.get("3")) != null) {
                innerOOData.put(m3, month);
            }
            if ((month = (String)LDMLDataI.get("4")) != null) {
                innerOOData.put(m4, month);
            }
            if ((month = (String)LDMLDataI.get("5")) != null) {
                innerOOData.put(m5, month);
            }
            if ((month = (String)LDMLDataI.get("6")) != null) {
                innerOOData.put(m6, month);
            }
            if ((month = (String)LDMLDataI.get("7")) != null) {
                innerOOData.put(m7, month);
            }
            if ((month = (String)LDMLDataI.get("8")) != null) {
                innerOOData.put(m8, month);
            }
            if ((month = (String)LDMLDataI.get("9")) != null) {
                innerOOData.put(m9, month);
            }
            if ((month = (String)LDMLDataI.get("10")) != null) {
                innerOOData.put(m10, month);
            }
            if ((month = (String)LDMLDataI.get("11")) != null) {
                innerOOData.put(m11, month);
            }
            if ((month = (String)LDMLDataI.get("12")) != null) {
                innerOOData.put(m12, month);
            }
            if (calTypeOO.compareTo("jewish") == 0 && (month = (String)LDMLDataI.get("13")) != null) {
                innerOOData.put(m13, month);
            }
            if (calTypeOO == null || innerOOData.size() <= 0) continue;
            OOData.put(calTypeOO, innerOOData);
        }
        return OOData;
    }

    public static Hashtable MapEras(Hashtable LDMLEraNames, Hashtable LDMLAbbrEras, String localeStr) {
        if (LDMLEraNames == null && LDMLEraNames.size() == 0 || LDMLAbbrEras == null && LDMLAbbrEras.size() == 0 || localeStr == null) {
            return null;
        }
        Hashtable OOData = new Hashtable();
        Enumeration enMonths = LDMLAbbrEras.elements();
        Enumeration enCalType = LDMLAbbrEras.keys();
        while (enMonths.hasMoreElements()) {
            Hashtable innerOOData = new Hashtable();
            Hashtable ooEraNames_Era0 = new Hashtable();
            Hashtable ooEraNames_Era1 = new Hashtable();
            Hashtable ooAbbrEraNames_Era0 = new Hashtable();
            Hashtable ooAbbrEraNames_Era1 = new Hashtable();
            Hashtable LDMLabbrDataI = (Hashtable)enMonths.nextElement();
            String calTypeI = (String)enCalType.nextElement();
            String calTypeOO = LDMLToOOMapper.MapCalendarType(calTypeI);
            if (!OOLocales.needCalendar(calTypeOO, localeStr)) continue;
            Hashtable LDMLDataI = (Hashtable)LDMLEraNames.get(calTypeI);
            if (calTypeOO.compareTo("gregorian") == 0 || calTypeOO.compareTo("hanja") == 0) {
                LDMLToOOMapper.mapEra(LDMLDataI, LDMLabbrDataI, ooEraNames_Era0, ooEraNames_Era1, innerOOData, "bc", "ad");
            } else if (calTypeOO.compareTo("hijri") == 0) {
                LDMLToOOMapper.mapEra(LDMLDataI, LDMLabbrDataI, ooEraNames_Era0, ooEraNames_Era1, innerOOData, "BeforeHijra", "AfterHijra");
            } else if (calTypeOO.compareTo("jewish") == 0) {
                LDMLToOOMapper.mapEra(LDMLDataI, LDMLabbrDataI, ooEraNames_Era0, ooEraNames_Era1, innerOOData, "before", "after");
            } else if (calTypeOO.compareTo("buddhist") == 0) {
                LDMLToOOMapper.mapEra(LDMLDataI, LDMLabbrDataI, ooEraNames_Era0, ooEraNames_Era1, innerOOData, "before", "after");
            } else if (calTypeOO.compareTo("ROC") == 0) {
                LDMLToOOMapper.mapEra(LDMLDataI, LDMLabbrDataI, ooEraNames_Era0, ooEraNames_Era1, innerOOData, "before", "MINGUO");
            } else if (calTypeOO.compareTo("hanja") == 0) {
                LDMLToOOMapper.mapEra(LDMLDataI, LDMLabbrDataI, ooEraNames_Era0, ooEraNames_Era1, innerOOData, "bc", "ad");
            } else if (calTypeOO.compareTo("gengou") == 0) {
                Hashtable ooEraNames_1 = new Hashtable();
                LDMLToOOMapper.mapOneEra(LDMLDataI, LDMLabbrDataI, ooEraNames_1, innerOOData, "Dummy", "-1");
                Hashtable ooEraNames232 = new Hashtable();
                LDMLToOOMapper.mapOneEra(LDMLDataI, LDMLabbrDataI, ooEraNames232, innerOOData, "Meiji", "232");
                Hashtable ooEraNames233 = new Hashtable();
                LDMLToOOMapper.mapOneEra(LDMLDataI, LDMLabbrDataI, ooEraNames233, innerOOData, "Taisho", "233");
                Hashtable ooEraNames234 = new Hashtable();
                LDMLToOOMapper.mapOneEra(LDMLDataI, LDMLabbrDataI, ooEraNames234, innerOOData, "Showa", "234");
                Hashtable ooEraNames235 = new Hashtable();
                LDMLToOOMapper.mapOneEra(LDMLDataI, LDMLabbrDataI, ooEraNames235, innerOOData, "Heisei", "235");
            }
            if (calTypeOO == null || innerOOData.size() <= 0) continue;
            OOData.put(calTypeOO, innerOOData);
        }
        return OOData;
    }

    private static void mapEra(Hashtable LDMLDataI, Hashtable LDMLabbrDataI, Hashtable ooEraNames_Era0, Hashtable ooEraNames_Era1, Hashtable innerOOData, String era0, String era1) {
        LDMLToOOMapper.mapOneEra(LDMLDataI, LDMLabbrDataI, ooEraNames_Era0, innerOOData, era0, "0");
        LDMLToOOMapper.mapOneEra(LDMLDataI, LDMLabbrDataI, ooEraNames_Era1, innerOOData, era1, "1");
    }

    private static void mapOneEra(Hashtable LDMLDataI, Hashtable LDMLabbrDataI, Hashtable ooEraNames_Era, Hashtable innerOOData, String eraOO, String ldmlEraConstant) {
        String era;
        if (LDMLDataI != null && LDMLDataI.size() > 0 && (era = (String)LDMLDataI.get(ldmlEraConstant)) != null) {
            ooEraNames_Era.put("DefaultFullName", era);
        }
        if (LDMLabbrDataI != null && LDMLabbrDataI.size() > 0 && (era = (String)LDMLabbrDataI.get(ldmlEraConstant)) != null) {
            ooEraNames_Era.put("DefaultAbbrvName", era);
        }
        if (ooEraNames_Era.size() > 0) {
            innerOOData.put(eraOO, ooEraNames_Era);
        }
    }

    public static Hashtable MapStartOfWeeks(Hashtable startOfWeeks, String localeStr) {
        if (startOfWeeks == null || localeStr == null) {
            return null;
        }
        Hashtable<String, String> ooStartOfWeeks = new Hashtable<String, String>();
        Enumeration keys = startOfWeeks.keys();
        while (keys.hasMoreElements()) {
            String calendar = (String)keys.nextElement();
            String calendarOO = LDMLToOOMapper.MapCalendarType(calendar);
            if (!OOLocales.needCalendar(calendarOO, localeStr) || calendarOO == null || calendarOO.length() <= 0) continue;
            String dayLDML = (String)startOfWeeks.get(calendar);
            String sow = null;
            if (dayLDML.compareTo("mon") == 0) {
                sow = "mon";
            } else if (dayLDML.compareTo("tue") == 0) {
                sow = "tue";
            } else if (dayLDML.compareTo("wed") == 0) {
                sow = "wed";
            } else if (dayLDML.compareTo("thu") == 0) {
                sow = "thu";
            } else if (dayLDML.compareTo("fri") == 0) {
                sow = "fri";
            } else if (dayLDML.compareTo("sat") == 0) {
                sow = "sat";
            } else if (dayLDML.compareTo("sun") == 0) {
                sow = "sun";
            }
            if (sow == null) continue;
            ooStartOfWeeks.put(calendarOO, sow);
        }
        return ooStartOfWeeks;
    }

    public static Hashtable MapMinDays(Hashtable minDaysLDML, String localeStr) {
        if (minDaysLDML == null || localeStr == null) {
            return null;
        }
        Hashtable<String, String> ooMinDays = new Hashtable<String, String>();
        Enumeration keys = minDaysLDML.keys();
        while (keys.hasMoreElements()) {
            String calendar = (String)keys.nextElement();
            String calendarOO = LDMLToOOMapper.MapCalendarType(calendar);
            if (!OOLocales.needCalendar(calendarOO, localeStr)) continue;
            String minDays = null;
            minDays = (String)minDaysLDML.get(calendar);
            if (minDays == null) continue;
            ooMinDays.put(calendarOO, minDays);
        }
        return ooMinDays;
    }

    public static Vector MapToCurrencyID(Vector currencies) {
        if (currencies == null) {
            return null;
        }
        Vector<String> currencyIDs = new Vector<String>();
        Enumeration currEnum = currencies.elements();
        while (currEnum.hasMoreElements()) {
            String currID;
            Hashtable currency = (Hashtable)currEnum.nextElement();
            if (currency == null || (currID = (String)currency.get("type")) == null || currID.length() <= 0) continue;
            currencyIDs.add(currID);
        }
        return currencyIDs;
    }

    public static Vector ExtractLDMLCurrencyTypes(Vector ldmlCurrencies, supplementalData suppData, String localeStr, boolean bRoundTrip) {
        if (ldmlCurrencies == null || ldmlCurrencies.size() == 0 || suppData == null) {
            return null;
        }
        Object ldmlCurrencyTypes = null;
        String region = LDMLToOOMapper.getRegion(localeStr);
        if (!bRoundTrip) {
            Vector all = suppData.getCurrencies(region);
            Vector v = new Vector();
            if (all.size() > 0) {
                v.add(all.elementAt(0));
            }
            if (all.size() > 1) {
                v.add(all.elementAt(1));
            }
            return v;
        }
        return ldmlCurrencies;
    }

    public static Vector MapTransliterations(Vector ldmlTransliterationsAtts) {
        Vector<String> trans = new Vector<String>();
        if (ldmlTransliterationsAtts == null || ldmlTransliterationsAtts.size() == 0) {
            return null;
        }
        Enumeration transEnum = ldmlTransliterationsAtts.elements();
        while (transEnum.hasMoreElements()) {
            String unoid;
            Hashtable attribs = (Hashtable)transEnum.nextElement();
            if (attribs == null || (unoid = (String)attribs.get("openOffice:unoid")) == null || unoid.length() <= 0) continue;
            trans.add(unoid);
        }
        return trans;
    }

    public static Hashtable MapReservedWords(Hashtable reservedWords) {
        if (reservedWords == null || reservedWords.size() == 0) {
            return null;
        }
        Hashtable mappedWords = new Hashtable();
        LDMLToOOMapper.addReservedWord(mappedWords, reservedWords, "trueWord", "trueWord");
        LDMLToOOMapper.addReservedWord(mappedWords, reservedWords, "falseWord", "falseWord");
        LDMLToOOMapper.addReservedWord(mappedWords, reservedWords, "aboveWord", "aboveWord");
        LDMLToOOMapper.addReservedWord(mappedWords, reservedWords, "belowWord", "belowWord");
        return mappedWords;
    }

    public static void MapQuarters(Hashtable mappedWords, Hashtable abbrQuarters, Hashtable wideQuarters) {
        if (mappedWords == null || abbrQuarters == null || wideQuarters == null) {
            return;
        }
        Hashtable abQ = (Hashtable)abbrQuarters.get("gregorian");
        LDMLToOOMapper.addReservedWord(mappedWords, abQ, "1", "quarter1Abbreviation");
        LDMLToOOMapper.addReservedWord(mappedWords, abQ, "2", "quarter2Abbreviation");
        LDMLToOOMapper.addReservedWord(mappedWords, abQ, "3", "quarter3Abbreviation");
        LDMLToOOMapper.addReservedWord(mappedWords, abQ, "4", "quarter4Abbreviation");
        Hashtable wideQ = (Hashtable)wideQuarters.get("gregorian");
        LDMLToOOMapper.addReservedWord(mappedWords, wideQ, "1", "quarter1Word");
        LDMLToOOMapper.addReservedWord(mappedWords, wideQ, "2", "quarter2Word");
        LDMLToOOMapper.addReservedWord(mappedWords, wideQ, "3", "quarter3Word");
        LDMLToOOMapper.addReservedWord(mappedWords, wideQ, "4", "quarter4Word");
    }

    private static void addReservedWord(Hashtable mappedWords, Hashtable ldmlWords, String ldmlKey, String ooKey) {
        String word = (String)ldmlWords.get(ldmlKey);
        if (word != null && word.length() > 0) {
            mappedWords.put(ooKey, word);
        }
    }

    public static Vector MapNumberingLevels(Vector ldmlNumberingLevelAtts) {
        if (ldmlNumberingLevelAtts == null || ldmlNumberingLevelAtts.size() == 0) {
            return null;
        }
        Vector levels = new Vector();
        Enumeration numEnum = ldmlNumberingLevelAtts.elements();
        while (numEnum.hasMoreElements()) {
            Hashtable atts = (Hashtable)numEnum.nextElement();
            Hashtable<String, String> ooAtts = new Hashtable<String, String>();
            if (atts != null && atts.size() > 0) {
                String value = (String)atts.get("openOffice:prefix");
                if (value != null && value.length() > 0) {
                    ooAtts.put("Prefix", value);
                }
                if ((value = (String)atts.get("openOffice:numType")) != null && value.length() > 0) {
                    ooAtts.put("NumType", value);
                }
                if ((value = (String)atts.get("openOffice:suffix")) != null && value.length() > 0) {
                    ooAtts.put("Suffix", value);
                }
                if ((value = (String)atts.get("openOffice:transliteration")) != null && value.length() > 0) {
                    ooAtts.put("Transliteration", value);
                }
                if ((value = (String)atts.get("openOffice:natNum")) != null && value.length() > 0) {
                    ooAtts.put("NatNum", value);
                }
            }
            if (ooAtts.size() <= 0) continue;
            levels.add(ooAtts);
        }
        return levels;
    }

    public static Vector MapOutlineNumberingLevels(Vector ldmlOutlineNumberingLevels) {
        if (ldmlOutlineNumberingLevels == null || ldmlOutlineNumberingLevels.size() == 0) {
            return null;
        }
        Vector outlineNumberingLevels = new Vector();
        Enumeration levelsEnum = ldmlOutlineNumberingLevels.elements();
        while (levelsEnum.hasMoreElements()) {
            Vector parentGroup = (Vector)levelsEnum.nextElement();
            Vector parentGroupOO = new Vector();
            if (parentGroup == null || parentGroup.size() <= 0) continue;
            Enumeration elemEnum = parentGroup.elements();
            while (elemEnum.hasMoreElements()) {
                Hashtable atts = (Hashtable)elemEnum.nextElement();
                Hashtable<String, String> attsOO = new Hashtable<String, String>();
                if (atts != null && atts.size() > 0) {
                    String value = (String)atts.get("openOffice:prefix");
                    if (value != null) {
                        attsOO.put("Prefix", value);
                    }
                    if ((value = (String)atts.get("openOffice:numType")) != null) {
                        attsOO.put("NumType", value);
                    }
                    if ((value = (String)atts.get("openOffice:suffix")) != null) {
                        attsOO.put("Suffix", value);
                    }
                    if ((value = (String)atts.get("openOffice:bulletChar")) != null) {
                        attsOO.put("BulletChar", value);
                    }
                    if ((value = (String)atts.get("openOffice:bulletFontName")) != null) {
                        attsOO.put("BulletFontName", value);
                    }
                    if ((value = (String)atts.get("openOffice:parentNumbering")) != null) {
                        attsOO.put("ParentNumbering", value);
                    }
                    if ((value = (String)atts.get("openOffice:leftMargin")) != null) {
                        attsOO.put("LeftMargin", value);
                    }
                    if ((value = (String)atts.get("openOffice:symbolTextDistance")) != null) {
                        attsOO.put("SymbolTextDistance", value);
                    }
                    if ((value = (String)atts.get("openOffice:firstLineOffset")) != null) {
                        attsOO.put("FirstLineOffset", value);
                    }
                    if ((value = (String)atts.get("openOffice:transliteration")) != null) {
                        attsOO.put("Transliteration", value);
                    }
                    if ((value = (String)atts.get("openOffice:natNum")) != null) {
                        attsOO.put("NatNum", value);
                    }
                }
                if (attsOO.size() <= 0) continue;
                parentGroupOO.add(attsOO);
            }
            if (parentGroupOO.size() <= 0) continue;
            outlineNumberingLevels.add(parentGroupOO);
        }
        return outlineNumberingLevels;
    }

    private static String getRegion(String localeStr) {
        String region = null;
        String[] str = localeStr.split("_");
        if (str.length > 1) {
            region = str[1];
            if (region.compareTo("CB") == 0) {
                region = "US";
            }
            if (region.compareTo("YU") == 0) {
                region = "CS";
            }
        } else if (str.length == 1 && str[0].compareTo("eu") == 0) {
            region = "ES";
        }
        return region;
    }

    public static Hashtable mapLocaleInfo(Hashtable localeInfo) {
        Hashtable<String, String> info = new Hashtable<String, String>();
        String data = (String)localeInfo.get("versionDTD");
        if (data != null) {
            info.put("versionDTD", data);
        }
        if ((data = (String)localeInfo.get("allowUpdateFromCLDR")) != null) {
            info.put("allowUpdateFromCLDR", data);
        }
        if ((data = (String)localeInfo.get("version")) != null) {
            info.put("version", data);
        }
        return info;
    }
}

