/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.XPathParts;

public class CheckAlt
extends CheckCLDR {
    XPathParts parts = new XPathParts();
    CLDRFile.Status status = new CLDRFile.Status();
    Set seenSoFar = new HashSet();

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        if (path.indexOf("proposed") <= 0) {
            return this;
        }
        String localeID = this.getCldrFileToCheck().getSourceLocaleID(path, this.status);
        if (!localeID.equals(this.getCldrFileToCheck().getLocaleID())) {
            return this;
        }
        String strippedPath = this.removeProposed(path);
        if (strippedPath.equals(path)) {
            return this;
        }
        localeID = this.getCldrFileToCheck().getSourceLocaleID(strippedPath, this.status);
        if (localeID == null || localeID.equals("code-fallback")) {
            String message = strippedPath;
            if (this.seenSoFar.contains(strippedPath)) {
                message = message + "MULTIPLE! ";
            }
            result.add(new CheckCLDR.CheckStatus().setCause(this).setType(CheckCLDR.finalErrorType).setMessage("Proposed item but no unproposed variant", new Object[0]));
            this.seenSoFar.add(strippedPath);
        }
        return this;
    }

    public String removeProposed(String path) {
        this.parts.set(path);
        for (int i = 0; i < this.parts.size(); ++i) {
            Map attributes = this.parts.getAttributes(i);
            Iterator it = attributes.keySet().iterator();
            while (it.hasNext()) {
                String attributeValue;
                int pos;
                String attribute = (String)it.next();
                if (!attribute.equals("alt") || (pos = (attributeValue = (String)attributes.get(attribute)).indexOf("proposed")) < 0) continue;
                if (pos > 0 && attributeValue.charAt(pos - 1) == '-') {
                    --pos;
                }
                if (pos == 0) {
                    attributes.remove(attribute);
                    continue;
                }
                attributeValue = attributeValue.substring(0, pos);
                attributes.put(attribute, attributeValue);
            }
        }
        String strippedPath = this.parts.toString();
        return strippedPath;
    }

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.seenSoFar.clear();
        return this;
    }
}

