/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;

public class CheckNumbers
extends CheckCLDR {
    private ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    private static NumberFormat english = NumberFormat.getNumberInstance((ULocale)ULocale.ENGLISH);
    private static Random random;
    static String SampleList;
    boolean isPOSIX;
    private ParsePosition parsePosition = new ParsePosition(0);
    static String pattern1;
    static String pattern2;
    static String pattern3;
    static String pattern4;
    private static int[][] DIGIT_COUNT;
    private static int[][] POSIX_DIGIT_COUNT;
    public static final byte NOT_NUMERIC_TYPE = -1;
    public static final byte CURRENCY_TYPE = 0;
    public static final byte DECIMAL_TYPE = 1;
    public static final byte PERCENT_TYPE = 2;
    public static final byte SCIENTIFIC_TYPE = 3;
    public static final String[] TYPE_NAME;

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, Map options, List possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.icuServiceBuilder.setCldrFile(this.getResolvedCldrFileToCheck());
        this.isPOSIX = cldrFileToCheck.getLocaleID().indexOf("POSIX") >= 0;
        return this;
    }

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        if (path.indexOf("/currencyMatch") >= 0) {
            try {
                UnicodeSet s = new UnicodeSet(value);
            }
            catch (Exception e) {
                CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Error in creating UnicodeSet {0}; {1}; {2}", new Object[]{value, e.getClass().getName(), e});
                result.add(item);
            }
            return this;
        }
        if (path.indexOf("/numbers") < 0) {
            return this;
        }
        try {
            String pattern;
            byte type;
            if (path.indexOf("/pattern") >= 0 && path.indexOf("/patternDigit") < 0) {
                this.checkPattern(path, fullPath, value, result, false);
            }
            if ((type = CheckNumbers.getNumericType(path)) != -1 && !(pattern = CheckNumbers.getCanonicalPattern(value, type, this.isPOSIX)).equals(value)) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Value should be \u200e{0}\u200e", new Object[]{pattern}));
            }
        }
        catch (Exception e) {
            CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Error in creating number format {0}; {1}", new Object[]{e.getClass().getName(), e});
            result.add(item);
        }
        return this;
    }

    public CheckCLDR handleGetExamples(String path, String fullPath, String value, Map options, List result) {
        if (path.indexOf("/numbers") < 0) {
            return this;
        }
        try {
            if (path.indexOf("/pattern") >= 0 && path.indexOf("/patternDigit") < 0) {
                this.checkPattern(path, fullPath, value, result, true);
            }
            if (path.indexOf("/currencies") >= 0 && path.endsWith("/symbol")) {
                this.checkCurrencyFormats(path, fullPath, value, result, true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return this;
    }

    private void checkPattern(String path, String fullPath, String value, List result, boolean generateExamples) throws ParseException {
        if (value.indexOf(164) >= 0) {
            DecimalFormat x = this.icuServiceBuilder.getCurrencyFormat("XXX");
            this.addSamples(x, x.toPattern(), value, result, generateExamples);
        } else {
            DecimalFormat x = this.icuServiceBuilder.getNumberFormat(value);
            this.addSamples(x, value, "", result, generateExamples);
        }
    }

    private void checkCurrencyFormats(String path, String fullPath, String value, List result, boolean generateExamples) throws ParseException {
        DecimalFormat x = this.icuServiceBuilder.getCurrencyFormat(CLDRFile.getCode(path));
        this.addSamples(x, x.toPattern(), value, result, generateExamples);
    }

    private void addSamples(DecimalFormat x, String pattern, String context, List result, boolean generateExamples) throws ParseException {
        Object[] arguments = new Object[3];
        double sample = CheckNumbers.getRandomNumber();
        arguments[0] = String.valueOf(sample);
        String formatted = x.format(sample);
        arguments[1] = formatted;
        boolean gotFailure = false;
        try {
            this.parsePosition.setIndex(0);
            double parsed = x.parse(formatted, this.parsePosition).doubleValue();
            if (this.parsePosition.getIndex() != formatted.length()) {
                arguments[2] = "Couldn't parse past: \u200e" + formatted.substring(0, this.parsePosition.getIndex()) + "\u200e";
                gotFailure = true;
            } else {
                arguments[2] = String.valueOf(parsed);
            }
        }
        catch (Exception e) {
            arguments[2] = e.getMessage();
            gotFailure = true;
        }
        if (generateExamples || gotFailure) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Example").setMessage(SampleList, arguments));
        }
        if (generateExamples) {
            result.add(new MyCheckStatus().setFormat(x, context).setCause(this).setType("Demo"));
        }
    }

    private static double getRandomNumber() {
        double rand = random.nextDouble();
        double sample = (double)Math.round(rand * 100000.0 * 1000.0) / 1000.0 + 10000.0;
        if (random.nextBoolean()) {
            sample = -sample;
        }
        return sample;
    }

    public static String getCanonicalPattern(String inpattern, byte type, boolean isPOSIX) {
        DecimalFormat df = new DecimalFormat(inpattern);
        int[] digits = isPOSIX ? POSIX_DIGIT_COUNT[type] : DIGIT_COUNT[type];
        df.setMinimumIntegerDigits(digits[0]);
        df.setMinimumFractionDigits(digits[1]);
        df.setMaximumFractionDigits(digits[2]);
        String pattern = df.toPattern();
        return pattern;
    }

    public static byte getNumericType(String xpath) {
        if (xpath.indexOf("/pattern") < 0) {
            return -1;
        }
        if (xpath.startsWith("//ldml/numbers/currencyFormats/")) {
            return 0;
        }
        if (xpath.startsWith("//ldml/numbers/decimalFormats/")) {
            return 1;
        }
        if (xpath.startsWith("//ldml/numbers/percentFormats/")) {
            return 2;
        }
        if (xpath.startsWith("//ldml/numbers/scientificFormats/")) {
            return 3;
        }
        if (xpath.startsWith("//ldml/numbers/currencies/currency/")) {
            return 0;
        }
        return -1;
    }

    static {
        english.setMaximumFractionDigits(5);
        random = new Random();
        SampleList = "{0} \u2192 \u201c\u200e{1}\u200e\u201d \u2192 {2}";
        pattern1 = "<table border='1' cellpadding='2' cellspacing='0' style='border-collapse: collapse' style='width: 100%'><tr><td nowrap width='1%'>Input:</td><td><input type='text' name='T1' size='50' style='width: 100%' value='";
        pattern2 = "'></td><td nowrap width='1%'><input type='submit' value='Test' name='B1'></td><td nowrap width='1%'>Formatted:</td><td><input type='text' name='T2' size='50' style='width: 100%' value='";
        pattern3 = "'></td><td nowrap width='1%'>Parsed:</td><td><input type='text' name='T3' size='50' style='width: 100%' value='";
        pattern4 = "'></td></tr></table>";
        DIGIT_COUNT = new int[][]{{1, 2, 2}, {1, 0, 3}, {1, 0, 0}, {0, 0, 0}};
        POSIX_DIGIT_COUNT = new int[][]{{1, 2, 2}, {1, 0, 6}, {1, 0, 0}, {1, 6, 6}};
        TYPE_NAME = new String[]{"currency", "decimal", "percent", "scientific"};
    }

    static class MyDemo
    extends CheckCLDR.FormatDemo {
        private DecimalFormat df;

        MyDemo() {
        }

        protected String getPattern() {
            return this.df.toPattern();
        }

        protected String getRandomInput() {
            return String.valueOf(CheckNumbers.getRandomNumber());
        }

        public MyDemo setFormat(DecimalFormat df, String context) {
            this.df = df;
            this.currentContext = context;
            return this;
        }

        protected void getArguments(Map inout) {
            double d;
            this.currentReparsed = "?";
            this.currentFormatted = "?";
            this.currentInput = "?";
            this.currentPattern = "?";
            try {
                this.currentPattern = (String)inout.get("pattern");
                if (this.currentPattern != null) {
                    this.df.applyPattern(this.currentPattern);
                } else {
                    this.currentPattern = this.getPattern();
                }
            }
            catch (Exception e) {
                this.currentPattern = "Use format like: ##,###.##";
                return;
            }
            try {
                this.currentInput = (String)inout.get("input");
                if (this.currentInput == null) {
                    this.currentInput = this.getRandomInput();
                }
                d = Double.parseDouble(this.currentInput);
            }
            catch (Exception e) {
                this.currentInput = "Use English format: 1234.56";
                return;
            }
            try {
                this.currentFormatted = this.df.format(d);
            }
            catch (Exception e) {
                this.currentFormatted = "Can't format: " + e.getMessage();
                return;
            }
            try {
                this.parsePosition.setIndex(0);
                Number n = this.df.parse(this.currentFormatted, this.parsePosition);
                this.currentReparsed = this.parsePosition.getIndex() != this.currentFormatted.length() ? "Couldn't parse past: \u200e" + this.currentFormatted.substring(0, this.parsePosition.getIndex()) + "\u200e" : n.toString();
            }
            catch (Exception e) {
                this.currentReparsed = "Can't parse: " + e.getMessage();
            }
        }
    }

    public static class MyCheckStatus
    extends CheckCLDR.CheckStatus {
        private DecimalFormat df;
        String context;

        public MyCheckStatus setFormat(DecimalFormat df, String context) {
            this.df = df;
            this.context = context;
            return this;
        }

        public CheckCLDR.SimpleDemo getDemo() {
            return new MyDemo().setFormat(this.df, this.context);
        }
    }
}

