/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.util.TimeZone;
import java.util.List;
import java.util.Map;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.XPathParts;

public class CheckZones
extends CheckCLDR {
    static String[] EXEMPLAR_SKIPS = new String[]{"/currencySpacing", "/hourFormat", "/exemplarCharacters", "/pattern", "/localizedPatternChars", "/segmentations", "/dateFormatItem", "/references"};
    private TimezoneFormatter timezoneFormatter;
    XPathParts parts = new XPathParts(null, null);

    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFile, Map options, List possibleErrors) {
        if (cldrFile == null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFile, options, possibleErrors);
        try {
            this.timezoneFormatter = new TimezoneFormatter(this.getResolvedCldrFileToCheck(), true);
        }
        catch (RuntimeException e) {
            possibleErrors.add(new CheckCLDR.CheckStatus().setCause(this).setType("Error").setMessage("Checking zones: " + e.getMessage()));
        }
        return this;
    }

    public CheckCLDR handleCheck(String path, String fullPath, String value, Map options, List result) {
        if (path.indexOf("timeZoneNames") < 0) {
            return this;
        }
        if (this.timezoneFormatter == null) {
            throw new InternalError("This should not occur: setCldrFileToCheck must create a TimezoneFormatter.");
        }
        this.parts.set(path);
        if (this.parts.containsElement("zone")) {
            String id = this.parts.getAttributeValue(3, "type");
            TimeZone tz = TimeZone.getTimeZone((String)id);
            if (!this.parts.containsElement("exemplarCity")) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Warning").setMessage("Remove this field unless always understood in the language."));
            }
        }
        return this;
    }

    public CheckCLDR handleGetExamples(String path, String fullPath, String value, Map options, List result) {
        if (path.indexOf("timeZoneNames") < 0) {
            return this;
        }
        if (this.timezoneFormatter == null) {
            throw new InternalError("This should not occur: setCldrFileToCheck must create a TimezoneFormatter.");
        }
        this.parts.set(path);
        if (this.parts.containsElement("zone")) {
            String id = this.parts.getAttributeValue(3, "type");
            TimeZone tz = TimeZone.getTimeZone((String)id);
            String pat = "vvvv";
            if (this.parts.containsElement("short")) {
                pat = "v";
            }
            if (this.parts.containsElement("exemplarCity")) {
                String formatted = this.timezoneFormatter.getFormattedZone(id, pat, false, tz.getRawOffset(), false);
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Example").setMessage("Formatted value: \"{0}\"", new Object[]{formatted}));
            } else {
                pat = "vvvv";
                if (this.parts.containsElement("short")) {
                    pat = "v";
                }
                String formatted = this.timezoneFormatter.getFormattedZone(id, pat, false, tz.getRawOffset(), true);
                result.add(new CheckCLDR.CheckStatus().setCause(this).setType("Example").setMessage("Formatted value (if removed!): \"{0}\"", new Object[]{formatted}));
            }
        }
        return this;
    }
}

