/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;

public class CoverageLevel {
    public static final String EUROPEAN_UNION = "QU";
    private static Object sync = new Object();
    private static Map coverageData = new TreeMap();
    private static Map base_language_level = new TreeMap();
    private static Map base_script_level = new TreeMap();
    private static Map base_territory_level = new TreeMap();
    private static Set minimalTimezones;
    private static Set euroCountries;
    private static Set territoryContainment;
    private static Set euroLanguages;
    private static Map language_scripts;
    private static Map language_territories;
    private static Map territory_languages;
    private static Set modernLanguages;
    private static Set modernScripts;
    private static Set modernTerritories;
    private static Map locale_requiredLevel;
    private static Map territory_currency;
    private static Map territory_timezone;
    private static Map territory_calendar;
    private static Set modernCurrencies;
    private static Map posixCoverage;
    private boolean initialized = false;
    private transient LocaleIDParser parser = new LocaleIDParser();
    private transient XPathParts parts = new XPathParts(null, null);
    private Map language_level = new TreeMap();
    private Map script_level = new TreeMap();
    private Map zone_level = new TreeMap();
    private Map territory_level = new TreeMap();
    private Map currency_level = new TreeMap();
    private Map calendar_level = new TreeMap();
    StandardCodes sc = StandardCodes.make();
    boolean latinScript = false;
    private static boolean euroCountriesMissing;
    Set multizoneTerritories = null;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$ArrayList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(CLDRFile file, Map options, CheckCLDR cause, List possibleErrors) {
        Object object = sync;
        synchronized (object) {
            if (!this.initialized) {
                CLDRFile supplementalMetadata2 = file.make("supplementalMetadata", false);
                CLDRFile supplementalData2 = file.make("supplementalData", false);
                this.init(supplementalData2, supplementalMetadata2, options);
                this.initPosixCoverage(file.getLocaleID(), supplementalData2);
                this.initialized = true;
            }
        }
        boolean exemplarsContainA_Z = false;
        UnicodeSet exemplars = file.getExemplarSet("");
        if (exemplars != null) {
            UnicodeSet auxexemplars = file.getExemplarSet("auxiliary");
            if (auxexemplars != null) {
                exemplars.addAll(auxexemplars);
            }
            exemplarsContainA_Z = exemplars.contains(65, 90);
        }
        this.setFile(file.getLocaleID(), exemplarsContainA_Z, options, cause, possibleErrors);
    }

    public Level getRequiredLevel(String localeID, Map options) {
        this.parser.set(localeID);
        String language = this.parser.getLanguage();
        Level requiredLevel = (Level)locale_requiredLevel.get(this.parser.getLanguageScript());
        if (requiredLevel == null) {
            requiredLevel = (Level)locale_requiredLevel.get(language);
        }
        if (requiredLevel == null) {
            requiredLevel = Level.BASIC;
        }
        return requiredLevel;
    }

    public void setFile(String localeID, boolean exemplarsContainA_Z, Map options, CheckCLDR cause, List possibleErrors) {
        String territory;
        this.latinScript = exemplarsContainA_Z;
        this.parser.set(localeID);
        String language = this.parser.getLanguage();
        this.language_level.clear();
        this.script_level.clear();
        this.currency_level.clear();
        this.zone_level.clear();
        this.calendar_level.clear();
        this.language_level.putAll(base_language_level);
        this.script_level.putAll(base_script_level);
        try {
            Set scriptsForLanguage = (Set)language_scripts.get(language);
            if (scriptsForLanguage != null && scriptsForLanguage.size() > 1) {
                this.putAll(this.script_level, scriptsForLanguage, Level.MINIMAL);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        this.territory_level.putAll(base_territory_level);
        this.putAll(this.territory_level, (Set)language_territories.get(language), Level.MINIMAL);
        this.language_level.put(language, Level.MINIMAL);
        String script = this.parser.getScript();
        if (script != null) {
            this.script_level.put(script, Level.MINIMAL);
        }
        if ((territory = this.parser.getRegion()) != null) {
            this.territory_level.put(territory, Level.MINIMAL);
        }
        if (euroLanguages.contains(language)) {
            this.setIfBetter(this.language_level, euroLanguages, Level.MODERATE, true);
            this.setIfBetter(this.territory_level, euroCountries, Level.MODERATE, true);
        }
        this.setIfBetter(this.territory_level, territoryContainment, Level.MODERATE, true);
        this.putAll(this.currency_level, modernCurrencies, Level.MODERN);
        Iterator it = this.territory_level.keySet().iterator();
        while (it.hasNext()) {
            territory = (String)it.next();
            Level level = (Level)this.territory_level.get(territory);
            if (level.compareTo(Level.BASIC) < 0) {
                level = Level.BASIC;
            }
            Set currencies = (Set)territory_currency.get(territory);
            this.setIfBetter(this.currency_level, currencies, level, false);
            Set timezones = (Set)territory_timezone.get(territory);
            if (timezones == null) continue;
            timezones.retainAll(minimalTimezones);
            this.setIfBetter(this.zone_level, timezones, level, false);
        }
        this.calendar_level.put("gregorian", Level.BASIC);
        Set territories = (Set)language_territories.get(language);
        if (territories == null) {
            possibleErrors.add(new CheckCLDR.CheckStatus().setCause(cause).setType(CheckCLDR.finalErrorType).setMessage("Missing language->territory information in supplemental data!"));
        } else {
            Iterator it2 = territories.iterator();
            while (it2.hasNext()) {
                String territory2 = (String)it2.next();
                this.setIfBetter(this.calendar_level, (Collection)territory_calendar.get(territory2), Level.BASIC, true);
            }
        }
        if (euroCountriesMissing) {
            possibleErrors.add(new CheckCLDR.CheckStatus().setCause(cause).setType("Error").setMessage("Missing euro country information- 'QU' missing in territory codes?"));
        }
    }

    private void putAll(Map targetMap, Collection keyset, Object value) {
        if (keyset == null) {
            return;
        }
        Iterator it2 = keyset.iterator();
        while (it2.hasNext()) {
            targetMap.put(it2.next(), value);
        }
    }

    private void addAllToCollectionValue(Map targetMap, Collection keyset, Object value, Class classForNew) {
        if (keyset == null) {
            return;
        }
        Iterator it2 = keyset.iterator();
        while (it2.hasNext()) {
            this.addToValueSet(targetMap, it2.next(), value, classForNew);
        }
    }

    private void addToValueSet(Map targetMap, Object key, Object value, Class classForNew) {
        Collection valueSet = (Collection)targetMap.get(key);
        if (valueSet == null) {
            try {
                valueSet = (Collection)classForNew.newInstance();
                targetMap.put(key, valueSet);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot create collection with " + classForNew.getName());
            }
        }
        valueSet.add(value);
    }

    private void setIfBetter(Map targetMap, Collection keyCollection, Level level, boolean show) {
        if (keyCollection == null) {
            return;
        }
        Iterator it2 = keyCollection.iterator();
        while (it2.hasNext()) {
            Object script = it2.next();
            Level old = (Level)targetMap.get(script);
            if (old != null && level.compareTo(old) >= 0) continue;
            targetMap.put(script, level);
        }
    }

    public Level getCoverageLevel(String fullPath) {
        this.parts.set(fullPath);
        String lastElement = this.parts.getElement(-1);
        String type = this.parts.getAttributeValue(-1, "type");
        Level result = null;
        String part1 = this.parts.getElement(1);
        if (lastElement.equals("exemplarCity")) {
            if (this.latinScript) {
                result = Level.UNDETERMINED;
            } else {
                type = this.parts.getAttributeValue(-2, "type");
                result = (Level)this.zone_level.get(type);
            }
        } else if (part1.equals("localeDisplayNames")) {
            String key;
            if (lastElement.equals("language")) {
                result = (Level)this.language_level.get(type);
            } else if (lastElement.equals("territory")) {
                result = (Level)this.territory_level.get(type);
            } else if (lastElement.equals("script")) {
                result = (Level)this.script_level.get(type);
            } else if (lastElement.equals("type") && (key = this.parts.getAttributeValue(-1, "key")).equals("calendar")) {
                result = (Level)this.calendar_level.get(type);
            }
        } else if (part1.equals("numbers")) {
            if (this.latinScript && lastElement.equals("symbol")) {
                result = Level.UNDETERMINED;
            } else if (lastElement.equals("displayName") || lastElement.equals("symbol")) {
                String currency = this.parts.getAttributeValue(-2, "type");
                result = (Level)this.currency_level.get(currency);
            }
        }
        if (result == null) {
            result = Level.COMPREHENSIVE;
        }
        return result;
    }

    public void init(CLDRFile supplementalData2, CLDRFile supplementalMetadata2, Map options) {
        this.getMetadata(supplementalMetadata2);
        this.getData(supplementalData2);
        Map type_languages = (Map)coverageData.get("languageCoverage");
        Utility.putAllTransposed(type_languages, base_language_level);
        Map type_scripts = (Map)coverageData.get("scriptCoverage");
        Utility.putAllTransposed(type_scripts, base_script_level);
        Map type_territories = (Map)coverageData.get("territoryCoverage");
        Utility.putAllTransposed(type_territories, base_territory_level);
        Map type_timezones = (Map)coverageData.get("timezoneCoverage");
        minimalTimezones = (Set)type_timezones.get(Level.MODERATE);
        modernLanguages.removeAll(base_language_level.keySet());
        this.putAll(base_language_level, modernLanguages, Level.MODERN);
        modernScripts.removeAll(base_script_level.keySet());
        this.putAll(base_script_level, modernScripts, Level.MODERN);
        modernTerritories.removeAll(base_territory_level.keySet());
        this.putAll(base_territory_level, modernTerritories, Level.MODERN);
        try {
            Iterator<Object> it;
            Map platform_local_level = this.sc.getLocaleTypes();
            Map locale_level = null;
            String localeType = (String)options.get("CoverageLevel.localeType");
            if (localeType != null) {
                locale_level = (Map)platform_local_level.get(localeType);
            }
            if (locale_level != null) {
                it = locale_level.keySet().iterator();
                while (it.hasNext()) {
                    String key;
                    Level old;
                    String locale = (String)it.next();
                    this.parser.set(locale);
                    String level = (String)locale_level.get(locale);
                    Level requiredLevel = Level.get(level);
                    if (requiredLevel == Level.UNDETERMINED) {
                        requiredLevel = Level.BASIC;
                    }
                    if ((old = (Level)locale_requiredLevel.get(key = this.parser.getLanguage())) == null || old.compareTo(requiredLevel) > 0) {
                        locale_requiredLevel.put(key, requiredLevel);
                    }
                    String oldKey = key;
                    key = this.parser.getLanguageScript();
                    if (key.equals(oldKey) || (old = (Level)locale_requiredLevel.get(key)) != null && old.compareTo(requiredLevel) <= 0) continue;
                    locale_requiredLevel.put(key, requiredLevel);
                }
            }
            it = euroCountries.iterator();
            while (it.hasNext()) {
                String territory = (String)it.next();
                Collection languages = (Collection)territory_languages.get(territory);
                euroLanguages.addAll(languages);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initPosixCoverage(String localeID, CLDRFile supplementalData2) {
        this.parser.set(localeID);
        String territory = this.parser.getRegion();
        String language = this.parser.getLanguage();
        String script = this.parser.getScript();
        String currencySymbol = supplementalData2.getStringValue("//supplementalData[@version=\"1.4\"]/currencyData/region[@iso3166=\"" + territory + "\"]/currency");
        posixCoverage.put("//ldml/posix/messages/yesstr", Level.POSIX);
        posixCoverage.put("//ldml/posix/messages/nostr", Level.POSIX);
        posixCoverage.put("//ldml/characters/exemplarCharacters", Level.POSIX);
        posixCoverage.put("//ldml/numbers/currencyFormats/currencyFormatLength/currencyFormat/pattern", Level.POSIX);
        posixCoverage.put("//ldml/numbers/currencies/currency[@type=\"" + currencySymbol + "\"]/symbol", Level.POSIX);
        posixCoverage.put("//ldml/numbers/currencies/currency[@type=\"" + currencySymbol + "\"]/decimal", Level.POSIX);
        posixCoverage.put("//ldml/numbers/currencies/currency[@type=\"" + currencySymbol + "\"]/group", Level.POSIX);
        posixCoverage.put("//ldml/numbers/symbols/decimal", Level.POSIX);
        posixCoverage.put("//ldml/numbers/symbols/group", Level.POSIX);
        posixCoverage.put("//ldml/numbers/symbols/plusSign", Level.POSIX);
        posixCoverage.put("//ldml/numbers/symbols/minusSign", Level.POSIX);
        posixCoverage.put("//ldml/numbers/symbols/decimal", Level.POSIX);
        posixCoverage.put("//ldml/numbers/symbols/group", Level.POSIX);
        posixCoverage.put("//ldml/numbers/decimalFormats/decimalFormatLength/decimalFormat/pattern", Level.POSIX);
        posixCoverage.put("//ldml/numbers/symbols/nativeZeroDigit", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"medium\"]/timeFormat/pattern", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateFormats/dateFormatLength[@type=\"short\"]/dateFormat/pattern", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/dateTimeFormatLength/dateTimeFormat/pattern", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"long\"]/timeFormat/pattern", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateFormats/dateFormatLength[@type=\"long\"]/dateFormat/pattern", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/am", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/pm", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"abbreviated\"]/day[@type=\"sun\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"abbreviated\"]/day[@type=\"mon\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"abbreviated\"]/day[@type=\"tue\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"abbreviated\"]/day[@type=\"wed\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"abbreviated\"]/day[@type=\"thu\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"abbreviated\"]/day[@type=\"fri\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"abbreviated\"]/day[@type=\"sat\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"wide\"]/day[@type=\"sun\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"wide\"]/day[@type=\"mon\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"wide\"]/day[@type=\"tue\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"wide\"]/day[@type=\"wed\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"wide\"]/day[@type=\"thu\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"wide\"]/day[@type=\"fri\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"wide\"]/day[@type=\"sat\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"1\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"2\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"3\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"4\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"5\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"6\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"7\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"8\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"9\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"10\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"11\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"12\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"1\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"2\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"3\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"4\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"5\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"6\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"7\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"8\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"9\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"10\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"11\"]", Level.POSIX);
        posixCoverage.put("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"12\"]", Level.POSIX);
    }

    private void getMetadata(CLDRFile metadata) {
        Iterator it = metadata.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            path = metadata.getFullXPath(path);
            this.parts.set(path);
            String lastElement = this.parts.getElement(-1);
            String type = this.parts.getAttributeValue(-1, "type");
            if (!this.parts.containsElement("coverageAdditions")) continue;
            Level level = Level.get(type);
            String values = this.parts.getAttributeValue(-1, "values");
            Utility.addTreeMapChain(coverageData, new Object[]{lastElement, level, new TreeSet<String>(Arrays.asList(values.split("\\s+")))});
        }
    }

    private void getData(CLDRFile data) {
        Iterator it = data.iterator(null, CLDRFile.ldmlComparator);
        while (it.hasNext()) {
            String path = (String)it.next();
            path = data.getFullXPath(path);
            this.parts.set(path);
            String lastElement = this.parts.getElement(-1);
            String type = this.parts.getAttributeValue(-1, "type");
            if (lastElement.equals("zoneItem")) {
                String territory;
                if (this.multizoneTerritories == null) {
                    String multizone = this.parts.getAttributeValue(-2, "multizone");
                    this.multizoneTerritories = new TreeSet<String>(Arrays.asList(multizone.split("\\s+")));
                }
                if (!this.multizoneTerritories.contains(territory = this.parts.getAttributeValue(-1, "territory"))) continue;
                TreeSet<String> territories = (TreeSet<String>)territory_timezone.get(territory);
                if (territories == null) {
                    territories = new TreeSet<String>();
                    territory_timezone.put(territory, territories);
                }
                territories.add(type);
                continue;
            }
            if (this.parts.containsElement("calendarData")) {
                TreeSet<String> values = new TreeSet<String>(Arrays.asList(this.parts.getAttributeValue(-1, "territories").split("\\s+")));
                Utility.addTreeMapChain(coverageData, new Object[]{lastElement, type, values});
                this.addAllToCollectionValue(territory_calendar, values, type, class$java$util$TreeSet == null ? CoverageLevel.class$("java.util.TreeSet") : class$java$util$TreeSet);
                continue;
            }
            if (this.parts.containsElement("languageData")) {
                String territories;
                String alt = this.parts.getAttributeValue(-1, "alt");
                if (alt != null) continue;
                modernLanguages.add(type);
                String scripts = this.parts.getAttributeValue(-1, "scripts");
                if (scripts != null) {
                    TreeSet<String> scriptSet = new TreeSet<String>(Arrays.asList(scripts.split("\\s+")));
                    modernScripts.addAll(scriptSet);
                    Utility.addTreeMapChain(language_scripts, new Object[]{type, scriptSet});
                }
                if ((territories = this.parts.getAttributeValue(-1, "territories")) == null) continue;
                TreeSet<String> territorySet = new TreeSet<String>(Arrays.asList(territories.split("\\s+")));
                modernTerritories.addAll(territorySet);
                Utility.addTreeMapChain(language_territories, new Object[]{type, territorySet});
                this.addAllToCollectionValue(territory_languages, territorySet, type, class$java$util$ArrayList == null ? CoverageLevel.class$("java.util.ArrayList") : class$java$util$ArrayList);
                continue;
            }
            if (this.parts.containsElement("currencyData") && lastElement.equals("currency")) {
                String to = this.parts.getAttributeValue(-1, "to");
                String currency = this.parts.getAttributeValue(-1, "iso4217");
                if (to != null && to.compareTo("1995") < 0) continue;
                modernCurrencies.add(currency);
                if (to != null) continue;
                String region = (String)this.parts.getAttributes(-2).get("iso3166");
                TreeSet<String> currencies = (TreeSet<String>)territory_currency.get(region);
                if (currencies == null) {
                    currencies = new TreeSet<String>();
                    territory_currency.put(region, currencies);
                }
                currencies.add(currency);
                continue;
            }
            if (!this.parts.containsElement("territoryContainment")) continue;
            if (!type.equals("172")) {
                territoryContainment.add(type);
            }
            if (!type.equals(EUROPEAN_UNION)) continue;
            euroCountries = new TreeSet<String>(Arrays.asList(this.parts.getAttributeValue(-1, "contains").split("\\s+")));
        }
        if (euroCountries == null) {
            euroCountries = new TreeSet();
            euroCountriesMissing = true;
        }
    }

    public void checkPosixCoverage(String path, String fullPath, String value, Map options, List result, CLDRFile file, CLDRFile resolved) {
        if (options.get("submission") == null) {
            return;
        }
        String source = resolved.getSourceLocaleID(path, null);
        if (!(source.equals("code-fallback") || source.equals("root") && this.isValueCode(fullPath, value))) {
            return;
        }
        if (path == null) {
            throw new InternalError("Empty path!");
        }
        if (file == null) {
            throw new InternalError("no file to check!");
        }
        Level level = (Level)posixCoverage.get(fullPath);
        if (level == null || level == Level.UNDETERMINED) {
            return;
        }
        if (Level.POSIX.compareTo(level) >= 0) {
            result.add(new CheckCLDR.CheckStatus().setType("Error").setMessage("Needed to meet {0} coverage level.", new Object[]{level}));
        }
    }

    private boolean isValueCode(String xpath, String value) {
        try {
            Integer.parseInt(value);
            return xpath.indexOf("nativeZeroDigit") <= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static {
        territoryContainment = new TreeSet();
        euroLanguages = new TreeSet();
        language_scripts = new TreeMap();
        language_territories = new TreeMap();
        territory_languages = new TreeMap();
        modernLanguages = new TreeSet();
        modernScripts = new TreeSet();
        modernTerritories = new TreeSet();
        locale_requiredLevel = new TreeMap();
        territory_currency = new TreeMap();
        territory_timezone = new TreeMap();
        territory_calendar = new TreeMap();
        modernCurrencies = new TreeSet();
        posixCoverage = new TreeMap();
        euroCountriesMissing = false;
    }

    public static class Level
    implements Comparable {
        private static List all = new ArrayList();
        private byte level;
        private String name;
        private String altName;
        public static final Level UNDETERMINED = new Level(0, "none", "none");
        public static final Level POSIX = new Level(20, "posix", "G4");
        public static final Level MINIMAL = new Level(30, "minimal", "G3.5");
        public static final Level BASIC = new Level(40, "basic", "G3");
        public static final Level MODERATE = new Level(60, "moderate", "G2");
        public static final Level MODERN = new Level(80, "modern", "G1");
        public static final Level COMPREHENSIVE = new Level(100, "comprehensive", "G0");

        private Level(int i, String name, String altName) {
            this.level = (byte)i;
            this.name = name;
            this.altName = altName;
            all.add(this);
        }

        public static Level get(String name) {
            for (int i = 0; i < all.size(); ++i) {
                Level item = (Level)all.get(i);
                if (item.name.equalsIgnoreCase(name)) {
                    return item;
                }
                if (!item.altName.equalsIgnoreCase(name)) continue;
                return item;
            }
            return UNDETERMINED;
        }

        public String toString() {
            return this.name;
        }

        public int compareTo(Object o) {
            byte otherLevel = ((Level)o).level;
            return this.level < otherLevel ? -1 : (this.level > otherLevel ? 1 : 0);
        }
    }
}

