/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.GenerateCldrTests;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Log;

class GenerateCldrDateTimeTests {
    Map ulocale_exemplars = new TreeMap(GenerateCldrTests.ULocaleComparator);
    Map uniqueExemplars = new HashMap();
    Set locales = new TreeSet(GenerateCldrTests.ULocaleComparator);
    static final ULocale ROOT = new ULocale("root");
    private CLDRFile.Factory cldrFactory;
    ICUServiceBuilder icuServiceBuilder;

    UnicodeSet getExemplarSet(ULocale locale) {
        return (UnicodeSet)this.ulocale_exemplars.get(locale);
    }

    void show() {
        Log.logln("Showing Locales");
        Log.logln("Unique Exemplars: " + this.uniqueExemplars.size());
        Iterator it2 = this.ulocale_exemplars.keySet().iterator();
        while (it2.hasNext()) {
            ULocale locale = (ULocale)it2.next();
            UnicodeSet us = this.getExemplarSet(locale);
            Log.logln("\t" + locale + ", " + us);
        }
    }

    GenerateCldrDateTimeTests(String sourceDir, String localeRegex, boolean doResolved) {
        this.cldrFactory = CLDRFile.Factory.make(sourceDir, ".*");
        this.icuServiceBuilder = new ICUServiceBuilder();
        Set s = GenerateCldrTests.getMatchingXMLFiles(sourceDir, localeRegex);
        Iterator it = s.iterator();
        while (it.hasNext()) {
            this.getInfo((String)it.next(), doResolved);
        }
        it = this.locales.iterator();
        block1: while (it.hasNext()) {
            ULocale locale = (ULocale)it.next();
            UnicodeSet ex = (UnicodeSet)this.ulocale_exemplars.get(locale);
            if (ex != null) continue;
            for (ULocale parent = locale.getFallback(); parent != null; parent = parent.getFallback()) {
                ULocale fixedParent = parent.getLanguage().length() == 0 ? ROOT : parent;
                ex = (UnicodeSet)this.ulocale_exemplars.get(fixedParent);
                if (ex == null) continue;
                this.ulocale_exemplars.put(locale, ex);
                continue block1;
            }
        }
    }

    void getInfo(String locale, boolean doResolved) {
        System.out.println("Getting info for: " + locale);
        this.locales.add(new ULocale(locale));
        CLDRFile cldrFile = this.cldrFactory.make(locale, doResolved);
        String cpath = "//ldml/characters/exemplarCharacters";
        String path = cldrFile.getFullXPath(cpath);
        if (path == null) {
            return;
        }
        String exemplars = cldrFile.getStringValue(cpath);
        UnicodeSet exemplarSet = new UnicodeSet(exemplars);
        UnicodeSet fixed = (UnicodeSet)this.uniqueExemplars.get(exemplarSet);
        if (fixed == null) {
            this.uniqueExemplars.put(exemplarSet, exemplarSet);
            fixed = exemplarSet;
        }
        this.ulocale_exemplars.put(new ULocale(locale), fixed);
    }

    public ICUServiceBuilder getICUServiceBuilder() {
        return this.icuServiceBuilder;
    }
}

