/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.util.CLDRTransforms;
import org.unicode.cldr.util.SimpleEquivalenceClass;

public class GenerateTransformCharts {
    static int[] indicScripts = new int[]{25, 0, 10, 4, 16, 15, 31, 35, 36, 21, 26};
    static String[] names = new String[indicScripts.length];
    static UnicodeSet[] sets = new UnicodeSet[indicScripts.length];
    static Transliterator[] fallbacks = new Transliterator[indicScripts.length];
    static UnicodeSet lengthMarks = new UnicodeSet("[\u09d7\u0b56-\u0b57\u0bd7\u0c56\u0cd5-\u0cd6\u0d57\u0c55\u0cd5]");
    static String testString = "\u0946\u093e";
    private static boolean useICU = true;
    static Map scriptExtras = new HashMap();
    static PrintWriter index;
    static UnicodeSet stuffToSkip;
    static RuleBasedCollator UCA;
    private static UnicodeSet BIDI_R;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.out.println("Start");
        try {
            GenerateTransformCharts.showAllLatin();
            return;
        }
        finally {
            System.out.println("Done");
        }
    }

    private static void printChart(SimpleEquivalenceClass equivalenceClass, Transliterator anyToLatin, UnicodeSet failNorm, Set latinFail) throws IOException {
        PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/gen/charts/transforms/", (String)"transChart.html");
        pw.println("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>");
        pw.println("<title>Indic Transliteration Chart</title><style>");
        pw.println("td { text-align: Center; font-size: 200% }");
        pw.println("tt { font-size: 50% }");
        pw.println("td.miss { background-color: #CCCCFF }");
        pw.println("td.none { background-color: #FFCCCC }");
        pw.println("</style></head><body bgcolor='#FFFFFF'>");
        pw.println("<table border='1' cellspacing='0'><tr>");
        for (int i = 0; i < indicScripts.length; ++i) {
            pw.print("<th width='10%'>" + names[i].substring(0, 3) + "</th>");
        }
        pw.println("</tr>");
        CollectionOfComparablesComparator mySetComparator = new CollectionOfComparablesComparator();
        Iterator rit = equivalenceClass.getSetIterator(mySetComparator);
        Set last = null;
        while (rit.hasNext()) {
            Set equivs = (Set)rit.next();
            mySetComparator.compare(last, equivs);
            last = equivs;
            pw.print("<tr>");
            Iterator sit = equivs.iterator();
            String source = (String)sit.next();
            String item = anyToLatin.transliterate(source);
            if (source.equals(item)) {
                item = "";
            }
            GenerateTransformCharts.showCell(pw, item, "");
            for (int i = 1; i < indicScripts.length; ++i) {
                item = GenerateTransformCharts.findItemInScript(equivs, sets[i]);
                String classString = "";
                if (item.equals("")) {
                    classString = " class='miss'";
                    String temp = fallbacks[i].transliterate(source);
                    if (!temp.equals("") && !temp.equals(source)) {
                        item = temp;
                    }
                }
                GenerateTransformCharts.showCell(pw, item, classString);
            }
            pw.println("</tr>");
        }
        pw.println("</table>");
        pw.println("<h2>Failed Round-Trip</h2>");
        pw.println("<table border='1' cellspacing='0'>");
        pw.println("<tr><th width='33%'>Indic</th><th width='33%'>Latin</th<th width='33%'>Indic</th></tr>");
        Iterator cit = latinFail.iterator();
        while (cit.hasNext()) {
            pw.println("<tr>");
            String[] badItems = (String[])cit.next();
            for (int i = 0; i < badItems.length; ++i) {
                GenerateTransformCharts.showCell(pw, badItems[i], " class='miss'");
            }
            pw.println("</tr>");
        }
        pw.println("</table>");
        pw.println("</table></body></html>");
        pw.close();
    }

    private static void getEquivalentCharacters(SimpleEquivalenceClass equivalenceClass, Set latinFail) {
        UnicodeSet failures = new UnicodeSet();
        for (int i = 0; i < indicScripts.length; ++i) {
            if (indicScripts[i] == 25) continue;
            String source = names[i];
            System.out.println(source);
            UnicodeSet sourceChars = sets[i];
            for (int j = 0; j < indicScripts.length; ++j) {
                if (i == j) continue;
                String target = names[j];
                Transliterator forward = GenerateTransformCharts.getTransliterator(source, target, null);
                Transliterator backward = GenerateTransformCharts.getTransliterator(target, source, null);
                UnicodeSetIterator it = new UnicodeSetIterator(sourceChars);
                while (it.next()) {
                    String r;
                    if (lengthMarks.contains(it.codepoint)) continue;
                    String s = it.getString();
                    String t = forward.transliterate(s = Normalizer.normalize((String)s, (Normalizer.Mode)Normalizer.NFC, (int)0));
                    if (t.equals(testString)) {
                        System.out.println("debug");
                    }
                    if (Normalizer.compare((String)s, (String)(r = backward.transliterate(t)), (int)0) == 0 && Normalizer.compare((String)s, (String)t, (int)0) != 0) {
                        if (indicScripts[j] == 25) continue;
                        equivalenceClass.add(s, t);
                        continue;
                    }
                    failures.add(it.codepoint);
                    if (indicScripts[j] != 25) continue;
                    latinFail.add(new String[]{s, t, r});
                }
            }
        }
        UnicodeSetIterator it = new UnicodeSetIterator(failures);
        while (it.next()) {
            String v = it.getString();
            equivalenceClass.add(v, v);
        }
    }

    private static void populateScriptInfo() {
        int i;
        for (i = 0; i < indicScripts.length; ++i) {
            if (indicScripts[i] == 0) {
                GenerateTransformCharts.names[i] = "InterIndic";
                GenerateTransformCharts.sets[i] = new UnicodeSet();
                GenerateTransformCharts.fallbacks[i] = Transliterator.getInstance((String)"null");
                continue;
            }
            GenerateTransformCharts.names[i] = UScript.getName((int)indicScripts[i]);
            GenerateTransformCharts.sets[i] = new UnicodeSet("[[:" + names[i] + ":]&[[:L:][:M:][:Nd:]]]");
            GenerateTransformCharts.fallbacks[i] = Transliterator.getInstance((String)("any-" + names[i]));
        }
        for (i = 2; i < indicScripts.length; ++i) {
            Transliterator forward = GenerateTransformCharts.getTransliterator(names[i], "InterIndic", null);
            UnicodeSetIterator it = new UnicodeSetIterator(sets[i]);
            while (it.next()) {
                String resultFromInterindic = it.getString();
                if (lengthMarks.containsAll(resultFromInterindic)) continue;
                sets[1].addAll(forward.transliterate(resultFromInterindic));
            }
        }
        sets[0].retainAll(new UnicodeSet("[:Co:]"));
        System.out.println("InterIndic: " + sets[1]);
    }

    private static String findItemInScript(Set equivs, UnicodeSet scriptSet) {
        Iterator sit = equivs.iterator();
        String item = "";
        while (sit.hasNext()) {
            String trial = (String)sit.next();
            if (!scriptSet.containsAll(trial)) continue;
            item = trial;
            break;
        }
        return item;
    }

    private static Transliterator getTransliterator(String source, String target, String variant) {
        String id = source + '-' + target;
        if (variant != null) {
            id = id + "/" + variant;
        }
        if (id.indexOf("InterIndic") >= 0) {
            id = "NFD; " + id + "; NFC";
        }
        if (useICU) {
            return Transliterator.getInstance((String)id);
        }
        return CLDRTransforms.getInstance(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showAllLatin() throws IOException {
        String[] headerAndFooter = new String[2];
        ShowData.getChartTemplate("Transliteration Charts", "1.4", "", headerAndFooter);
        index = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/gen/charts/transforms/", (String)"index.html");
        index.println(headerAndFooter[0]);
        index.println("<p>The following illustrates some of the transliterations available in CLDR. <b>Note:</b> these charts are preliminary; for more information, see below.</p.>");
        index.flush();
        index.println("<ul>");
        try {
            ParsedTransformID parsedID = new ParsedTransformID();
            SimpleEquivalenceClass ec = new SimpleEquivalenceClass((Comparator)UCA);
            Set s = GenerateTransformCharts.getAvailableTransliterators();
            TreeSet<String> scripts = new TreeSet<String>();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                String id = (String)i.next();
                parsedID.set(id);
                if (!GenerateTransformCharts.isScript(parsedID.source) || !GenerateTransformCharts.isScript(parsedID.target) || parsedID.source.equals("Han") || parsedID.target.equals("Han")) continue;
                if (!parsedID.target.equals("Latin")) {
                    if (parsedID.source.equals("Latin")) continue;
                    ec.add(parsedID.source, parsedID.getTargetVariant());
                    ec.add(parsedID.target, parsedID.getSourceVariant());
                    continue;
                }
                scripts.add(parsedID.getTargetVariant());
                ec.add(parsedID.getSourceVariant(), parsedID.getSourceVariant());
            }
            HashSet alreadySeen = new HashSet();
            Iterator it = ec.getSetIterator(null);
            while (it.hasNext()) {
                TreeSet scriptSet = new TreeSet(UCA);
                scriptSet.addAll((Set)it.next());
                scriptSet.removeAll(alreadySeen);
                if (scriptSet.size() <= 0) continue;
                GenerateTransformCharts.showLatin(GenerateTransformCharts.getName(scriptSet), scriptSet);
                alreadySeen.addAll(scriptSet);
            }
            Object var9_8 = null;
            index.println("</ul>");
            index.println("<h2>Key</h2><ul>");
            index.println("<li>A cell with a blue background indicates a case that doesn't roundtrip.</li>");
            index.println("<li>A cell with a red background indicates a missing case.</li>");
            index.println("</ul>");
            index.println("<h2>Known Data Issues</h2><ul>");
            index.println("<li>The data currently does not contain many language-specific transliterations. So, for example, the Cyrillic transliteration is not very natural for English speakers.</li>");
            index.println("<li>The script transliterations are generally designed to be lossless to Latin, thus some of the transliterations use extra accents to provide for a round-trip. (Implementations like ICU allows those to be easily stripped.)</li>");
            index.println("<li>Less common characters may be missing; as may be some characters that don't appear in isolation.</li>");
            index.println("</ul>");
            index.println("<h2>Known Chart Issues</h2><ul>");
            index.println("<li>Some browsers will not show combinations of accents correctly.</li>");
            index.println("<li>Because the context is not taken into account, significant combinations will not show in the charts. For example: For greek, \u03a8 shows as 'PH', when the transliteration rules will change it to 'Ph' in front of lowercase letters. Characters that are not normally used in isolation, such as \u3041, will show as an odd format (eg with extra punctuations marks or accents).</li>");
            index.println("<li>Only the script-script charts are shown, and there is a bug in the Greek/UNGEGN charts.</li>");
            index.println("<li>The Hangul charts are only showing syllables, so the format isn't very useful.</li>");
            index.println("<li>Some items show up as {missing}.</li>");
            index.println("</ul>");
            index.println(headerAndFooter[1]);
            index.close();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            index.println("</ul>");
            index.println("<h2>Key</h2><ul>");
            index.println("<li>A cell with a blue background indicates a case that doesn't roundtrip.</li>");
            index.println("<li>A cell with a red background indicates a missing case.</li>");
            index.println("</ul>");
            index.println("<h2>Known Data Issues</h2><ul>");
            index.println("<li>The data currently does not contain many language-specific transliterations. So, for example, the Cyrillic transliteration is not very natural for English speakers.</li>");
            index.println("<li>The script transliterations are generally designed to be lossless to Latin, thus some of the transliterations use extra accents to provide for a round-trip. (Implementations like ICU allows those to be easily stripped.)</li>");
            index.println("<li>Less common characters may be missing; as may be some characters that don't appear in isolation.</li>");
            index.println("</ul>");
            index.println("<h2>Known Chart Issues</h2><ul>");
            index.println("<li>Some browsers will not show combinations of accents correctly.</li>");
            index.println("<li>Because the context is not taken into account, significant combinations will not show in the charts. For example: For greek, \u03a8 shows as 'PH', when the transliteration rules will change it to 'Ph' in front of lowercase letters. Characters that are not normally used in isolation, such as \u3041, will show as an odd format (eg with extra punctuations marks or accents).</li>");
            index.println("<li>Only the script-script charts are shown, and there is a bug in the Greek/UNGEGN charts.</li>");
            index.println("<li>The Hangul charts are only showing syllables, so the format isn't very useful.</li>");
            index.println("<li>Some items show up as {missing}.</li>");
            index.println("</ul>");
            index.println(headerAndFooter[1]);
            index.close();
            throw throwable;
        }
    }

    private static String getName(Set scriptSet) {
        if (scriptSet.size() == 1) {
            return scriptSet.iterator().next().toString();
        }
        if (scriptSet.contains("Bengali")) {
            return "Indic";
        }
        if (scriptSet.contains("Katakana")) {
            return "Kana";
        }
        return scriptSet.toString();
    }

    private static void showLatin(String scriptChoice, Set targetVariant) throws IOException {
        String source;
        Object it;
        String id;
        Map<String, String> noRoundTrip;
        ParsedTransformID parsedID = new ParsedTransformID();
        TreeSet<String> ids = new TreeSet<String>();
        HashMap<String, UnicodeSet> id_unmapped = new HashMap<String, UnicodeSet>();
        HashMap id_noRoundTrip = new HashMap();
        TreeSet<String> latinItems = new TreeSet<String>((Comparator<String>)UCA);
        TreeMap<String, String> otherOrdering = new TreeMap<String, String>((Comparator<String>)UCA);
        TreeSet<String> gotLatin = new TreeSet<String>();
        Iterator i = targetVariant.iterator();
        while (i.hasNext()) {
            String s;
            int c;
            String id2 = "Latin-" + i.next().toString();
            parsedID.set(id2);
            id2 = parsedID.reverse().toString();
            String script = parsedID.source;
            int scriptCode = UScript.getCodeFromName((String)script);
            UnicodeSet unmapped = new UnicodeSet();
            id_unmapped.put(id2, unmapped);
            noRoundTrip = new TreeMap(UCA);
            id_noRoundTrip.put(id2, noRoundTrip);
            ids.add(parsedID.toString());
            String scriptName = UScript.getShortName((int)scriptCode);
            UnicodeSet targetSet = new UnicodeSet("[:script=" + scriptName + ":]");
            UnicodeSet extras = (UnicodeSet)scriptExtras.get(scriptName);
            if (extras != null) {
                System.out.println(script + "\tAdding1: " + extras);
                targetSet.addAll(extras);
            }
            extras = new UnicodeSet();
            UnicodeSetIterator usi = new UnicodeSetIterator(targetSet);
            while (usi.next()) {
                String d = Normalizer.normalize((String)usi.getString(), (Normalizer.Mode)Normalizer.NFD, (int)0);
                extras.addAll(d);
            }
            extras.removeAll(targetSet);
            if (extras.size() != 0) {
                System.out.println(script + "\tAdding2: " + extras);
                targetSet.addAll(extras);
            }
            targetSet.removeAll(stuffToSkip);
            Transliterator native_latin = GenerateTransformCharts.getTransliterator(parsedID.source, parsedID.target, parsedID.variant);
            Transliterator latin_native = GenerateTransformCharts.getTransliterator(parsedID.target, parsedID.source, parsedID.variant);
            boolean sourceIsCased = false;
            UnicodeSetIterator it2 = new UnicodeSetIterator(targetSet);
            while (it2.next()) {
                String back;
                String target;
                String source2 = it2.getString();
                if (source2.equals(target = native_latin.transliterate(source2))) {
                    unmapped.add(source2);
                    continue;
                }
                if (target.length() != 0) {
                    latinItems.add(target);
                }
                if (!source2.equals(back = latin_native.transliterate(target))) {
                    noRoundTrip.put(source2, target);
                } else if (!sourceIsCased && !UCharacter.foldCase((String)source2, (boolean)true).equals(source2)) {
                    sourceIsCased = true;
                }
                if (gotLatin.contains(target) || target.length() <= 0) continue;
                otherOrdering.put(source2, target);
                gotLatin.add(target);
            }
            for (c = 97; c <= 122; ++c) {
                s = UTF16.valueOf((int)c);
                latinItems.add(s);
            }
            if (!sourceIsCased) continue;
            for (c = 65; c <= 90; ++c) {
                s = UTF16.valueOf((int)c);
                latinItems.add(s);
            }
        }
        String filename = "Latin-" + scriptChoice + ".html";
        filename = filename.replace('/', '_');
        index.println("<li><a href='" + filename + "'>" + scriptChoice + "</a></li>");
        PrintWriter pw = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/gen/charts/transforms/", (String)filename);
        String[] headerAndFooter = new String[2];
        ShowData.getChartTemplate("Latin-" + scriptChoice + " Transliteration Chart", "1.4", "", headerAndFooter);
        pw.println(headerAndFooter[0]);
        pw.println("<p1>This chart illustrates one or more of the transliterations in CLDR. <b>Note:</b> This chart is preliminary; for known issues and more information, see the <a href='index.html'>index</a>. Hovering over each cell should show the character name, if enabled on your browser.</p>");
        pw.println("<table border='1' cellspacing='0' cellpadding='8'>");
        pw.println("<tr>");
        pw.println("<th>Other-Latin</th>");
        pw.println("<th>Latin-Other</th>");
        pw.println("<th>Unmapped</th>");
        pw.println("<th>No Round Trip</th>");
        pw.println("</tr><tr><td class='main'>");
        GenerateTransformCharts.doMainTable(parsedID, ids, pw, otherOrdering.values().iterator(), true);
        pw.println("</td><td class='main'>");
        GenerateTransformCharts.doMainTable(parsedID, ids, pw, latinItems.iterator(), false);
        pw.println("</td><td class='main'>");
        pw.println("<table border='1' cellspacing='0'>");
        Iterator it2 = ids.iterator();
        while (it2.hasNext()) {
            id = (String)it2.next();
            UnicodeSet unmapped = (UnicodeSet)id_unmapped.get(id);
            if (unmapped.size() == 0) continue;
            parsedID.set(id);
            pw.println("<tr><th>" + parsedID.source + (parsedID.variant == null ? "" : "/" + parsedID.variant) + "</th></tr>");
            it = new UnicodeSetIterator(unmapped);
            while (it.next()) {
                pw.println("<tr>");
                source = it.getString();
                GenerateTransformCharts.showCell(pw, source, " class='miss'");
                pw.println("</tr>");
            }
        }
        pw.println("</table>");
        pw.println("</td><td class='main'>");
        pw.println("<table border='1' cellspacing='0'>");
        it2 = ids.iterator();
        while (it2.hasNext()) {
            id = (String)it2.next();
            noRoundTrip = (Map)id_noRoundTrip.get(id);
            if (noRoundTrip.size() == 0) continue;
            parsedID.set(id);
            pw.println("<tr><th>" + parsedID.source + (parsedID.variant == null ? "" : "/" + parsedID.variant) + "</th><th>Latin</th></tr>");
            it = noRoundTrip.keySet().iterator();
            while (it.hasNext()) {
                pw.println("<tr>");
                source = (String)it.next();
                String target = (String)noRoundTrip.get(source);
                GenerateTransformCharts.showCell(pw, source, "");
                GenerateTransformCharts.showCell(pw, target, " class='miss'");
                pw.println("</tr>");
            }
        }
        pw.println("</table>");
        pw.println("</td></tr></table>");
        pw.println(headerAndFooter[1]);
        pw.close();
    }

    private static void doMainTable(ParsedTransformID parsedID, Set ids, PrintWriter pw, Iterator it, boolean latinAtEnd) {
        pw.println("<table border='1' cellspacing='0'><tr>");
        if (!latinAtEnd) {
            pw.println("<th>Latin</th>");
        }
        Iterator it2 = ids.iterator();
        while (it2.hasNext()) {
            parsedID.set((String)it2.next());
            pw.println("<th>" + parsedID.source + (parsedID.variant == null ? "" : "/" + parsedID.variant) + "</th>");
        }
        if (latinAtEnd) {
            pw.println("<th>Latin</th>");
        }
        pw.println("</tr>");
        UnicodeSet sourceSet = new UnicodeSet();
        UnicodeSet targetSet = new UnicodeSet();
        while (it.hasNext()) {
            String target = (String)it.next();
            pw.println("<tr>");
            if (!latinAtEnd) {
                GenerateTransformCharts.showCell(pw, target, "");
            }
            Iterator it22 = ids.iterator();
            while (it22.hasNext()) {
                String id = (String)it22.next();
                parsedID.set(id);
                Transliterator native_latin = GenerateTransformCharts.getTransliterator(parsedID.source, parsedID.target, parsedID.variant);
                Transliterator latin_native = GenerateTransformCharts.getTransliterator(parsedID.target, parsedID.source, parsedID.variant);
                String source = latin_native.transliterate(target);
                if (sourceSet.clear().addAll(source).containsSome(targetSet.clear().addAll(target))) {
                    GenerateTransformCharts.showCell(pw, "", "");
                    continue;
                }
                String back = native_latin.transliterate(source);
                String classString = target.equals(back) ? "" : " class='miss'";
                GenerateTransformCharts.showCell(pw, source, classString);
            }
            if (latinAtEnd) {
                GenerateTransformCharts.showCell(pw, target, "");
            }
            pw.println("</tr>");
        }
        pw.println("</table>");
    }

    public static boolean isScript(String string) {
        return UScript.getCodeFromName((String)string) >= 0;
    }

    private static Set getAvailableTransliterators() {
        if (useICU) {
            HashSet results = new HashSet();
            Enumeration e = Transliterator.getAvailableIDs();
            while (e.hasMoreElements()) {
                results.add(e.nextElement());
            }
            return results;
        }
        return CLDRTransforms.getAvailableTransforms();
    }

    private static void showCell(PrintWriter pw, String item, String classString) {
        String backup = item;
        String name = GenerateTransformCharts.getName(item, "; ");
        if (item.equals("")) {
            backup = "\u00a0";
            classString = " class='none'";
            name = "{missing}";
        } else if (item.charAt(0) >= '\ue000') {
            backup = "\u00a0";
        }
        name = TransliteratorUtilities.toXML.transliterate(name);
        backup = TransliteratorUtilities.toHTML.transliterate(backup);
        String dir = BIDI_R.containsSome(backup) ? " style='direction:rtl'" : "";
        pw.print("<td" + classString + dir + " title='" + name + "'>\u00a0\u00a0" + backup + "\u00a0\u00a0<br><tt>" + Utility.hex((String)item) + "</tt></td>");
    }

    public static String fix(String s) {
        if (s.equals("\u0946\u093e")) {
            return "\u094a";
        }
        if (s.equals("\u0c46\u0c3e")) {
            return "\u0c4a";
        }
        if (s.equals("\u0cc6\u0cbe")) {
            return "\u0cca";
        }
        if (s.equals("\u0947\u093e")) {
            return "\u094b";
        }
        if (s.equals("\u0a47\u0a3e")) {
            return "\u0a4b";
        }
        if (s.equals("\u0ac7\u0abe")) {
            return "\u0acb";
        }
        if (s.equals("\u0c47\u0c3e")) {
            return "\u0c4b";
        }
        if (s.equals("\u0cc7\u0cbe")) {
            return "\u0ccb";
        }
        return s;
    }

    public static String getName(String s, String separator) {
        int cp;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)cp)) {
            cp = UTF16.charAt((String)s, (int)i);
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(UCharacter.getName((int)cp));
        }
        return sb.toString();
    }

    static {
        scriptExtras.put("Arab", new UnicodeSet("[\u0660-\u0669]"));
        stuffToSkip = (UnicodeSet)new UnicodeSet("[[:block=Hangul Syllables:][:NFKC_QuickCheck=No:][\\U00010000-\\U0010FFFF]]").freeze();
        UCA = (RuleBasedCollator)Collator.getInstance((ULocale)ULocale.ROOT);
        UCA.setNumericCollation(true);
        BIDI_R = (UnicodeSet)new UnicodeSet("[[:Bidi_Class=R:][:Bidi_Class=AL:]]").freeze();
    }

    static class ReverseComparator
    implements Comparator {
        ReverseComparator() {
        }

        public int compare(Object o1, Object o2) {
            String a = o1.toString();
            char a1 = a.charAt(0);
            String b = o2.toString();
            char b1 = b.charAt(0);
            if (a1 < '\u0900' && b1 > '\u0900') {
                return -1;
            }
            if (a1 > '\u0900' && b1 < '\u0900') {
                return 1;
            }
            return a.compareTo(b);
        }
    }

    static class CollectionOfComparablesComparator
    implements Comparator {
        CollectionOfComparablesComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Iterator i1 = ((Collection)o1).iterator();
            Iterator i2 = ((Collection)o2).iterator();
            while (i1.hasNext() && i2.hasNext()) {
                Comparable b;
                Comparable a = (Comparable)i1.next();
                int result = a.compareTo(b = (Comparable)i2.next());
                if (result == 0) continue;
                return result;
            }
            if (i1.hasNext()) {
                return 1;
            }
            if (i2.hasNext()) {
                return -1;
            }
            return 0;
        }
    }

    public static class ParsedTransformID {
        public String source;
        public String target;
        public String variant;

        public void set(String id) {
            this.variant = null;
            int pos = id.indexOf(45);
            if (pos < 0) {
                this.source = "Any";
                this.target = id;
                return;
            }
            this.source = id.substring(0, pos);
            int pos2 = id.indexOf(47, pos);
            if (pos2 < 0) {
                this.target = id.substring(pos + 1);
                return;
            }
            this.target = id.substring(pos + 1, pos2);
            this.variant = id.substring(pos2 + 1);
        }

        public ParsedTransformID reverse() {
            String temp = this.source;
            this.source = this.target;
            this.target = temp;
            return this;
        }

        public String getTargetVariant() {
            return this.target + (this.variant == null ? "" : "/" + this.variant);
        }

        public String getSourceVariant() {
            return this.source + (this.variant == null ? "" : "/" + this.variant);
        }

        public String toString() {
            return this.source + "-" + this.getTargetVariant();
        }
    }

    private static class TranslitStatus {
        String source;
        String back;

        public TranslitStatus(String source, String back) {
            this.source = source;
            this.back = back;
        }
    }
}

