/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.dev.tool.UOption;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ExtractCollationRules;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PrettyPath;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XPathParts;

public class ShowData {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int GET_SCRIPTS = 5;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault("../../common/main/"), UOption.DESTDIR().setDefault("../../dropbox/gen/charts/summary/"), UOption.create((String)"match", (char)'m', (int)1).setDefault(".*"), UOption.create((String)"getscript", (char)'g', (int)0)};
    static RuleBasedCollator uca = (RuleBasedCollator)Collator.getInstance((ULocale)ULocale.ROOT);
    static PrettyPath prettyPathMaker = new PrettyPath();
    static CLDRFile english;
    static Set locales;
    static CLDRFile.Factory cldrFactory;
    static Set UnicodeScripts;
    static DataShower dataShower;
    static SimpleDateFormat isoDateFormat;

    public ShowData() {
        uca.setNumericCollation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        double deltaTime;
        block24: {
            block23: {
                deltaTime = System.currentTimeMillis();
                try {
                    UOption.parseArgs((String[])args, (UOption[])options);
                    String sourceDir = ShowData.options[2].value;
                    String targetDir = ShowData.options[3].value;
                    cldrFactory = CLDRFile.Factory.make(sourceDir, ".*");
                    english = cldrFactory.make("en", true);
                    if (ShowData.options[5].doesOccur) {
                        ShowData.getScripts();
                        Object var50_4 = null;
                        break block23;
                    }
                    Utility.registerExtraTransliterators();
                    CLDRFile.Factory collationFactory = CLDRFile.Factory.make(sourceDir + "../collation/", ".*");
                    ExtractCollationRules collationRules = new ExtractCollationRules();
                    locales = new TreeSet(cldrFactory.getAvailable());
                    new Utility.MatcherFilter(ShowData.options[4].value).retainAll(locales);
                    TreeSet<String> prettySet = new TreeSet<String>((Comparator<String>)uca);
                    HashSet<String> skipList = new HashSet<String>(Arrays.asList("id"));
                    CLDRFile.Status status = new CLDRFile.Status();
                    LocaleIDParser localeIDParser = new LocaleIDParser();
                    LinkedHashMap nonDistinguishingAttributes = new LinkedHashMap();
                    CLDRFile parent = null;
                    Iterator it = locales.iterator();
                    while (it.hasNext()) {
                        boolean showParent;
                        String locale = (String)it.next();
                        if (locale.startsWith("supplem") || locale.startsWith("character")) continue;
                        boolean doResolved = localeIDParser.set(locale).getRegion().length() == 0;
                        String languageSubtag = localeIDParser.getLanguage();
                        boolean isLanguageLocale = locale.equals(languageSubtag);
                        CLDRFile file = cldrFactory.make(locale, doResolved);
                        if (file.isNonInheriting()) continue;
                        boolean bl = showParent = !isLanguageLocale;
                        if (showParent) {
                            parent = cldrFactory.make(LocaleIDParser.getParent(locale), true);
                        }
                        boolean showEnglish = !languageSubtag.equals("en");
                        int skippedCount = 0;
                        int aliasedCount = 0;
                        int inheritedCount = 0;
                        prettySet.clear();
                        Iterator it2 = file.iterator();
                        while (it2.hasNext()) {
                            String path = (String)it2.next();
                            if (path.indexOf("[@alt=\"proposed") >= 0) {
                                ++skippedCount;
                                continue;
                            }
                            if (path.indexOf("/identity") >= 0) {
                                ++skippedCount;
                                continue;
                            }
                            String prettyString = prettyPathMaker.getPrettyPath(path);
                            prettySet.add(prettyString);
                        }
                        PrintWriter pw = BagFormatter.openUTF8Writer((String)targetDir, (String)(locale + ".html"));
                        String[] headerAndFooter = new String[2];
                        ShowData.getChartTemplate("Locale Data Summary for " + ShowData.getName(locale), file.getDtdVersion(), "<script>\r\nif (location.href.split('?')[1].split(',')[0]=='hide') {\r\ndocument.write('<style>');\r\ndocument.write('.xx {display:none}');\r\ndocument.write('</style>');\r\n}\r\n</script>", headerAndFooter);
                        pw.println(headerAndFooter[0]);
                        ShowData.showLinks(pw, locale);
                        ShowData.showChildren(pw, locale);
                        if (doResolved) {
                            pw.println("<p><b>Aliased/Inherited: </b><a href='" + locale + ".html?hide'>Hide</a> <a href='" + locale + ".html'>Show </a></p>");
                        }
                        pw.println("<table border=\"1\" cellpadding=\"2\" cellspacing=\"0\">");
                        pw.println("<tr><th>No</th><th colSpan=3>Path</th>" + (showEnglish ? "<th>English</th>" : "") + (showParent ? "<th>Parent</th>" : "") + "<th>Native</th>" + "<th>D?</th>" + "<tr>");
                        int count = 0;
                        String[] oldParts = new String[4];
                        Iterator it22 = prettySet.iterator();
                        while (it22.hasNext()) {
                            boolean isInherited;
                            boolean isAliased;
                            String prettyPath = (String)it22.next();
                            String path = prettyPathMaker.getOriginal(prettyPath);
                            boolean zeroOutEnglish = path.indexOf("/references") < 0;
                            String source = file.getSourceLocaleID(path, status);
                            boolean bl2 = isAliased = !status.pathWhereFound.equals(path);
                            if (isAliased) {
                                ++aliasedCount;
                                continue;
                            }
                            boolean bl3 = isInherited = !source.equals(locale);
                            if (isInherited) {
                                ++inheritedCount;
                            }
                            StringBuffer tempDraftRef = new StringBuffer();
                            String value = file.getStringValue(path);
                            String fullPath = file.getFullXPath(path);
                            String nda = ShowData.getNda(skipList, nonDistinguishingAttributes, file, path, fullPath, tempDraftRef);
                            String draftRef = tempDraftRef.toString();
                            if (nda.length() != 0) {
                                if (value.length() != 0) {
                                    value = value + "; ";
                                }
                                value = value + nda;
                            }
                            String englishValue = null;
                            String englishFullPath = null;
                            String englishNda = null;
                            if (zeroOutEnglish) {
                                englishNda = "";
                                englishFullPath = "";
                                englishValue = "";
                            }
                            if (showEnglish && null != (englishValue = english.getStringValue(path)) && (englishNda = ShowData.getNda(skipList, nonDistinguishingAttributes, file, path, englishFullPath = english.getFullXPath(path), tempDraftRef)).length() != 0) {
                                if (englishValue.length() != 0) {
                                    englishValue = englishValue + "; ";
                                }
                                englishValue = englishValue + englishNda;
                            }
                            String parentFullPath = null;
                            String parentNda = null;
                            String parentValue = null;
                            if (showParent && null != (parentValue = parent.getStringValue(path)) && (parentNda = ShowData.getNda(skipList, nonDistinguishingAttributes, parent, path, parentFullPath = parent.getFullXPath(path), tempDraftRef)).length() != 0) {
                                if (parentValue.length() != 0) {
                                    parentValue = parentValue + "; ";
                                }
                                parentValue = parentValue + parentNda;
                            }
                            prettyPath = TransliteratorUtilities.toHTML.transliterate(prettyPathMaker.getOutputForm(prettyPath));
                            String[] pathParts = prettyPath.split("[|]");
                            prettyPath = "";
                            for (int i = 0; i < 3; ++i) {
                                String newPart;
                                String string = newPart = i < pathParts.length ? pathParts[i] : "";
                                if (newPart.equals(oldParts[i])) {
                                    prettyPath = prettyPath + "</td><td class='n'>";
                                } else {
                                    prettyPath = newPart.length() == 0 ? prettyPath + "</td><td>" : prettyPath + "</td><td class='g'>";
                                    oldParts[i] = newPart;
                                }
                                prettyPath = prettyPath + newPart;
                            }
                            String statusClass = isAliased ? (isInherited ? " class='ah'" : " class='a'") : (isInherited ? " class='h'" : "");
                            pw.println((isAliased || isInherited ? "<tr class='xx'><td" : "<tr><td") + statusClass + ">" + ++count + prettyPath + ShowData.showValue(showEnglish, englishValue, value) + ShowData.showValue(showParent, parentValue, value) + (value == null ? "</td><td>n/a" : "</td><td class='v'" + DataShower.getBidiStyle(value) + ">" + DataShower.getPrettyValue(value)) + (draftRef.length() == 0 ? "</td><td>&nbsp;" : "</td><td class='v'>" + DataShower.getPrettyValue(draftRef)) + "</td></tr>");
                        }
                        pw.println("</table><br><table>");
                        pw.println("<tr><td class='a'>Aliased items: </td><td>" + aliasedCount + "</td></tr>");
                        pw.println("<tr><td class='h'>Inherited items:</td><td>" + inheritedCount + "</td></tr>");
                        if (skippedCount != 0) {
                            pw.println("<tr><td>Omitted items:</td><td>" + skippedCount + "</td></tr>");
                        }
                        pw.println("</table>");
                        pw.println(headerAndFooter[1]);
                        pw.close();
                    }
                    break block24;
                }
                catch (Throwable throwable) {
                    Object var50_6 = null;
                    deltaTime = (double)System.currentTimeMillis() - deltaTime;
                    System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
                    System.out.println("Done");
                    throw throwable;
                }
            }
            deltaTime = (double)System.currentTimeMillis() - deltaTime;
            System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
            System.out.println("Done");
            return;
        }
        Object var50_5 = null;
        deltaTime = (double)System.currentTimeMillis() - deltaTime;
        System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
        System.out.println("Done");
    }

    private static void getScripts() throws IOException {
        Set locales = cldrFactory.getAvailableLanguages();
        TreeSet scripts = new TreeSet();
        XPathParts parts = new XPathParts();
        TreeMap script_name_locales = new TreeMap();
        PrintWriter out = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/", (String)"scriptNames.txt");
        Iterator it = locales.iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            System.out.println(locale);
            CLDRFile file = cldrFactory.make(locale, false);
            if (file.isNonInheriting()) continue;
            String localeName = file.getName(locale, false);
            ShowData.getScripts(localeName, scripts);
            if (!scripts.contains("Latn")) {
                out.println(locale + "\t" + english.getName(locale, false) + "\t" + localeName);
            }
            Iterator it2 = UnicodeScripts.iterator();
            while (it2.hasNext()) {
                TreeSet<String> localeSet;
                String name;
                String script = (String)it2.next();
                if (script.equals("Latn") || !ShowData.getScripts(name = file.getName(1, script, false), scripts).contains(script)) continue;
                TreeMap<String, TreeSet<String>> names_locales = (TreeMap<String, TreeSet<String>>)script_name_locales.get(script);
                if (names_locales == null) {
                    names_locales = new TreeMap<String, TreeSet<String>>();
                    script_name_locales.put(script, names_locales);
                }
                if ((localeSet = (TreeSet<String>)names_locales.get(name)) == null) {
                    localeSet = new TreeSet<String>();
                    names_locales.put(name, localeSet);
                }
                localeSet.add(ShowData.getName(locale));
            }
        }
        Iterator it2 = UnicodeScripts.iterator();
        while (it2.hasNext()) {
            String script = (String)it2.next();
            Object names = script_name_locales.get(script);
            out.println(script + "\t(" + english.getName(1, script, false) + ")\t" + names);
        }
        out.close();
    }

    private static Set getScripts(String exemplars, Set results) {
        results.clear();
        if (exemplars == null) {
            return results;
        }
        UnicodeSetIterator it = new UnicodeSetIterator(new UnicodeSet().addAll(exemplars));
        while (it.next()) {
            int cp = it.codepoint;
            int script = UScript.getScript((int)cp);
            results.add(UScript.getShortName((int)script));
        }
        return results;
    }

    private static void showCollation(CLDRFile.Factory collationFactory, String locale, ExtractCollationRules collationRules) {
        CLDRFile collationFile;
        try {
            collationFile = collationFactory.make(locale, false);
        }
        catch (RuntimeException e) {
            return;
        }
        collationRules.set(collationFile);
        Iterator it = collationRules.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            System.out.println(key + ": ");
            String rules = collationRules.getRules(key);
            System.out.println(rules);
        }
    }

    private static String showValue(boolean showEnglish, String comparisonValue, String mainValue) {
        return !showEnglish ? "" : (comparisonValue == null ? "</td><td>n/a" : (comparisonValue.length() == 0 ? "</td><td>&nbsp;" : (comparisonValue.equals(mainValue) ? "</td><td>=" : "</td><td class='e'" + DataShower.getBidiStyle(comparisonValue) + ">" + DataShower.getPrettyValue(comparisonValue))));
    }

    private static String getNda(Set skipList, Map nonDistinguishingAttributes, CLDRFile file, String path, String parentFullPath, StringBuffer draftRef) {
        draftRef.setLength(0);
        if (parentFullPath != null && !parentFullPath.equals(path)) {
            file.getNonDistinguishingAttributes(parentFullPath, nonDistinguishingAttributes, skipList);
            if (nonDistinguishingAttributes.size() != 0) {
                String parentNda = "";
                Iterator it = nonDistinguishingAttributes.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (key.equals("draft")) {
                        if (draftRef.length() != 0) {
                            draftRef.append(",");
                        }
                        draftRef.append("d");
                        continue;
                    }
                    if (key.equals("alt")) {
                        if (draftRef.length() != 0) {
                            draftRef.append(",");
                        }
                        draftRef.append("a");
                        continue;
                    }
                    if (key.equals("references")) {
                        if (draftRef.length() != 0) {
                            draftRef.append(",");
                        }
                        draftRef.append(nonDistinguishingAttributes.get(key));
                        continue;
                    }
                    if (parentNda.length() != 0) {
                        parentNda = parentNda + ", ";
                    }
                    parentNda = parentNda + key + "=" + nonDistinguishingAttributes.get(key);
                }
                if (parentNda.length() != 0) {
                    parentNda = parentNda.replaceAll("[/]", "/\u200b");
                    parentNda = "[" + parentNda + "]";
                }
                return parentNda;
            }
        }
        return "";
    }

    private static void showLinks(PrintWriter pw, String locale) {
        pw.print("<p>");
        ShowData.showLinks2(pw, locale);
        pw.println("</p>");
    }

    private static void showLinks2(PrintWriter pw, String locale) {
        String parent = LocaleIDParser.getParent(locale);
        if (parent != null) {
            ShowData.showLinks2(pw, parent);
            pw.print(" &gt; ");
        }
        ShowData.showLocale(pw, locale);
    }

    private static void showChildren(PrintWriter pw, String locale) {
        boolean first = true;
        Iterator it = cldrFactory.getAvailableWithParent(locale, true).iterator();
        while (it.hasNext()) {
            String possible = (String)it.next();
            if (possible.startsWith("supplem") || possible.startsWith("character") || !LocaleIDParser.getParent(possible).equals(locale)) continue;
            if (first) {
                first = false;
                pw.println("<p style='margin-left:5em'>&gt; ");
            } else {
                pw.print(" | ");
            }
            ShowData.showLocale(pw, possible);
        }
        if (!first) {
            pw.println("</p>");
        }
    }

    private static void showLocale(PrintWriter pw, String locale) {
        pw.println("<a href='" + locale + ".html'>" + ShowData.getName(locale) + "</a>");
    }

    private static String getName(String locale) {
        String name = english.getName(locale, false);
        return locale + " [" + name + "]";
    }

    public static void getChartTemplate(String title, String version, String header, String[] headerAndFooter) throws IOException {
        String line;
        Utility.VariableReplacer langTag = new Utility.VariableReplacer().add("%title%", title).add("%header%", header).add("%version%", version).add("%date%", isoDateFormat.format(new Date()));
        BufferedReader input = Utility.getUTF8Data("../../tool/chart-template.html");
        StringBuffer result = new StringBuffer();
        while ((line = input.readLine()) != null) {
            String langTagPattern = langTag.replace(line);
            if (line.indexOf("%body%") >= 0) {
                headerAndFooter[0] = result.toString();
                result.setLength(0);
                continue;
            }
            result.append(langTagPattern).append("\r\n");
        }
        headerAndFooter[1] = result.toString();
    }

    static {
        UnicodeScripts = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("Arab", "Armn", "Bali", "Beng", "Bopo", "Brai", "Bugi", "Buhd", "Cans", "Cher", "Copt", "Cprt", "Cyrl", "Deva", "Dsrt", "Ethi", "Geor", "Glag", "Goth", "Grek", "Gujr", "Guru", "Hang", "Hani", "Hano", "Hebr", "Hira", "Hrkt", "Ital", "Kana", "Khar", "Khmr", "Knda", "Laoo", "Latn", "Limb", "Linb", "Mlym", "Mong", "Mymr", "Nkoo", "Ogam", "Orya", "Osma", "Phag", "Phnx", "Qaai", "Runr", "Shaw", "Sinh", "Sylo", "Syrc", "Tagb", "Tale", "Talu", "Taml", "Telu", "Tfng", "Tglg", "Thaa", "Thai", "Tibt", "Ugar", "Xpeo", "Xsux", "Yiii")));
        dataShower = new DataShower();
        isoDateFormat = new SimpleDateFormat("yyyy-MM-dd", ULocale.ENGLISH);
    }

    public static class DataShower {
        static Transliterator toLatin = Transliterator.getInstance((String)"any-latin");
        static UnicodeSet BIDI_R = new UnicodeSet("[[:Bidi_Class=R:][:Bidi_Class=AL:]]");

        static String getBidiStyle(String cellValue) {
            return BIDI_R.containsSome(cellValue) ? " style='direction:rtl'" : "";
        }

        public static String getPrettyValue(String textToInsert) {
            String outValue = TransliteratorUtilities.toHTML.transliterate(textToInsert);
            String transValue = textToInsert;
            String span = "";
            try {
                transValue = toLatin.transliterate(textToInsert);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (!transValue.equals(textToInsert)) {
                outValue = "<span title='" + TransliteratorUtilities.toXML.transliterate(transValue) + "'>" + outValue + "</span>";
            }
            return outValue;
        }
    }
}

