/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.dev.test.util.XEquivalenceClass;
import com.ibm.icu.lang.UCharacter;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.Utility;

public class StandardCodes {
    public static final String NO_COUNTRY = "001";
    private static StandardCodes singleton;
    private Map type_code_data = new TreeMap();
    private Map type_name_codes = new TreeMap();
    private Map type_code_preferred = new TreeMap();
    private Map country_modernCurrency = new TreeMap();
    private Map goodCodes = new TreeMap();
    private String date;
    private static final boolean DEBUG = false;
    private Map platform_locale_status = null;
    static Comparator caseless;
    private Map zone_to_country;
    private Map country_to_zoneSet;
    Map zoneData;
    Set skippedAliases = new TreeSet();
    Map ruleID_rules = new TreeMap();
    Map zone_rules = new TreeMap();
    Map linkold_new = new TreeMap();
    Map linkNew_oldSet = new TreeMap();
    private static List errorData;
    private Comparator TZIDComparator = new Comparator(){
        Map data;
        {
            this.data = StandardCodes.this.getZoneData();
        }

        public int compare(Object o1, Object o2) {
            Double d2;
            String country2;
            String country1;
            int result;
            List data2;
            String s1 = (String)o1;
            String s2 = (String)o2;
            List data1 = (List)this.data.get(s1);
            if (data1 == null) {
                data1 = errorData;
            }
            if ((data2 = (List)this.data.get(s2)) == null) {
                data2 = errorData;
            }
            if ((result = (country1 = (String)data1.get(2)).compareTo(country2 = (String)data2.get(2))) != 0) {
                return result;
            }
            Double d1 = (Double)data1.get(1);
            result = d1.compareTo(d2 = (Double)data2.get(1));
            if (result != 0) {
                return result;
            }
            d1 = (Double)data1.get(0);
            result = d1.compareTo(d2 = (Double)data2.get(0));
            if (result != 0) {
                return result;
            }
            return s1.compareTo(s2);
        }
    };
    private static MapComparator regionalCompare;
    private static String[] TZFiles;
    private static Map FIX_UNSTABLE_TZIDS;
    private static Map RESTORE_UNSTABLE_TZIDS;
    private static Set SKIP_LINKS;
    private static String[][] ADD_ZONE_ALIASES_DATA;
    static String[] FIX_DEPRECATED_ZONE_DATA;
    private List DELETED3166 = Collections.unmodifiableList(Arrays.asList("BQ", "BU", "CT", "DD", "DY", "FQ", "FX", "HV", "JT", "MI", "NH", "NQ", "NT", "PC", "PU", "PZ", "RH", "SU", "TP", "VD", "WK", "YD", "YU", "ZR"));
    private Map WorldBankInfo;
    Set MainTimeZones;
    static String[][] extras;
    static Counter languageCount;

    public static synchronized StandardCodes make() {
        if (singleton == null) {
            singleton = new StandardCodes();
        }
        return singleton;
    }

    public String getData(String type, String code) {
        Map code_data = (Map)this.type_code_data.get(type);
        if (code_data == null) {
            return null;
        }
        List list = (List)code_data.get(code);
        if (list == null) {
            return null;
        }
        return (String)list.get(0);
    }

    public List getFullData(String type, String code) {
        Map code_data = (Map)this.type_code_data.get(type);
        if (code_data == null) {
            return null;
        }
        return (List)code_data.get(code);
    }

    public String getReplacement(String type, String code) {
        if (type.equals("currency")) {
            return null;
        }
        List data = this.getFullData(type, code);
        if (data == null) {
            return null;
        }
        if (data.size() < 3) {
            return null;
        }
        String replacement = (String)data.get(2);
        if (!replacement.equals("") && !replacement.equals("--")) {
            return replacement;
        }
        return null;
    }

    public List getCodes(String type, String data) {
        Map data_codes = (Map)this.type_name_codes.get(type);
        if (data_codes == null) {
            return null;
        }
        return Collections.unmodifiableList((List)data_codes.get(data));
    }

    public String getPreferred(String type, String code) {
        Map code_preferred = (Map)this.type_code_preferred.get(type);
        if (code_preferred == null) {
            return code;
        }
        String newCode = (String)code_preferred.get(code);
        if (newCode == null) {
            return code;
        }
        return newCode;
    }

    public Set getAvailableTypes() {
        return Collections.unmodifiableSet(this.type_code_data.keySet());
    }

    public Set getAvailableCodes(String type) {
        Map code_name = (Map)this.type_code_data.get(type);
        if (code_name == null) {
            return null;
        }
        return Collections.unmodifiableSet(code_name.keySet());
    }

    public Set getGoodAvailableCodes(String type) {
        Set result = (TreeSet)this.goodCodes.get(type);
        if (result == null) {
            Map code_name = (Map)this.type_code_data.get(type);
            if (code_name == null) {
                return null;
            }
            result = new TreeSet(code_name.keySet());
            if (type.equals("currency")) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    String code = (String)it.next();
                    List data = this.getFullData(type, code);
                    if (!"X".equals(data.get(3))) continue;
                    it.remove();
                }
            } else if (!type.equals("tzid")) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    String code = (String)it.next();
                    if (code.equals("root") || code.equals("QO")) continue;
                    List data = this.getFullData(type, code);
                    if (data.size() < 3) {
                        // empty if block
                    }
                    if (!data.get(0).equals("PRIVATE USE") && (data.get(2).equals("") || data.get(2).equals("--"))) continue;
                    it.remove();
                }
            }
            result = Collections.unmodifiableSet(result);
            this.goodCodes.put(type, result);
        }
        return result;
    }

    public Set getMainCurrencies(String countryCode) {
        return (Set)this.country_modernCurrency.get(countryCode);
    }

    public String getEffectiveLocaleType(String type) throws IOException {
        Map m = this.getLocaleTypes();
        if (type != null && m.get(type) != null) {
            return type;
        }
        return "IBM";
    }

    public Map getLocaleTypes() throws IOException {
        if (this.platform_locale_status == null) {
            String line;
            LocaleIDParser parser = new LocaleIDParser();
            this.platform_locale_status = new TreeMap(caseless);
            BufferedReader lstreg = Utility.getUTF8Data("Locales.txt");
            while ((line = lstreg.readLine()) != null) {
                String lang;
                int commentPos = line.indexOf(35);
                if (commentPos >= 0) {
                    line = line.substring(0, commentPos);
                }
                if (line.length() == 0) continue;
                List stuff = Utility.splitList(line, ';', true);
                String organization = (String)stuff.get(0);
                String locale = (String)stuff.get(1);
                String status = (String)stuff.get(2);
                TreeMap<String, String> locale_status = (TreeMap<String, String>)this.platform_locale_status.get(organization);
                if (locale_status == null) {
                    locale_status = new TreeMap<String, String>();
                    this.platform_locale_status.put(organization, locale_status);
                }
                parser.set(locale);
                locale = parser.toString();
                locale_status.put(locale, status);
                String scriptLoc = parser.getLanguageScript();
                if (locale_status.get(scriptLoc) == null) {
                    locale_status.put(scriptLoc, status);
                }
                if (locale_status.get(lang = parser.getLanguage()) != null) continue;
                locale_status.put(lang, status);
            }
            Utility.protectCollection(this.platform_locale_status);
        }
        return this.platform_locale_status;
    }

    public boolean isLocaleInGroup(String locale, String group, String org) {
        try {
            String gp;
            Map map = this.getLocaleTypes();
            Map locMap = (Map)map.get(org);
            return locMap != null && (gp = (String)locMap.get(locale)) != null && gp.equals(group);
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String getGroup(String locale, String org) {
        try {
            Map map = this.getLocaleTypes();
            Map locMap = (Map)map.get(org);
            if (locMap != null) {
                String gp = (String)locMap.get(locale);
                return gp;
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private StandardCodes() {
        String[] files = new String[]{"ISO4217.txt"};
        this.type_code_preferred.put("tzid", new TreeMap());
        this.add("language", "root", "Root");
        String originalLine = null;
        for (int fileIndex = 0; fileIndex < files.length; ++fileIndex) {
            try {
                String line;
                BufferedReader lstreg = Utility.getUTF8Data(files[fileIndex]);
                while ((line = (originalLine = lstreg.readLine())) != null) {
                    line = line.trim();
                    int commentPos = line.indexOf(35);
                    String comment = "";
                    if (commentPos >= 0) {
                        comment = line.substring(commentPos + 1).trim();
                        line = line.substring(0, commentPos);
                    }
                    if (line.length() == 0) continue;
                    List pieces = Utility.splitList(line, '|', true, new ArrayList());
                    String type = (String)pieces.get(0);
                    pieces.remove(0);
                    if (type.equals("region")) {
                        type = "territory";
                    }
                    String code = (String)pieces.get(0);
                    pieces.remove(0);
                    if (type.equals("date")) {
                        this.date = code;
                        continue;
                    }
                    String oldName = (String)pieces.get(0);
                    int pos = oldName.indexOf(59);
                    if (pos >= 0) {
                        oldName = oldName.substring(0, pos).trim();
                        pieces.set(0, oldName);
                    }
                    List data = pieces;
                    if (comment.indexOf("deprecated") >= 0 && data.get(2).toString().length() == 0) {
                        data.set(2, "--");
                    }
                    if (oldName.equalsIgnoreCase("PRIVATE USE")) {
                        int separatorPos = code.indexOf("..");
                        if (separatorPos < 0) {
                            this.add(type, code, data);
                            continue;
                        }
                        String current = code.substring(0, separatorPos);
                        String end = code.substring(separatorPos + 2);
                        while (current.compareTo(end) <= 0) {
                            this.add(type, current, data);
                            current = StandardCodes.nextAlpha(current);
                        }
                        continue;
                    }
                    if (!type.equals("tzid")) {
                        this.add(type, code, data);
                        if (!type.equals("currency") || !data.get(3).equals("C")) continue;
                        String country = (String)data.get(1);
                        TreeSet<String> codes = (TreeSet<String>)this.country_modernCurrency.get(country);
                        if (codes == null) {
                            codes = new TreeSet<String>();
                            this.country_modernCurrency.put(country, codes);
                        }
                        codes.add(code);
                        continue;
                    }
                    String preferred = null;
                    for (int i = 0; i < pieces.size(); ++i) {
                        code = (String)pieces.get(i);
                        this.add(type, code, data);
                        if (preferred == null) {
                            preferred = code;
                            continue;
                        }
                        Map code_preferred = (Map)this.type_code_preferred.get(type);
                        code_preferred.put(code, preferred);
                    }
                }
                lstreg.close();
            }
            catch (Exception e) {
                System.err.println("WARNING: " + files[fileIndex] + " may be a corrupted UTF-8 file. Please check.");
                throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + files[fileIndex] + "\t" + originalLine).initCause(e);
            }
            Utility.protectCollection(this.country_modernCurrency);
        }
        Map lmap = StandardCodes.getLStreg();
        Iterator it = lmap.keySet().iterator();
        while (it.hasNext()) {
            String type = (String)it.next();
            String type2 = type.equals("region") ? "territory" : type;
            Map m = (Map)lmap.get(type);
            Iterator it2 = m.keySet().iterator();
            while (it2.hasNext()) {
                String code = (String)it2.next();
                Map mm = (Map)m.get(code);
                ArrayList<Object> data = new ArrayList<Object>(0);
                data.add(mm.get("Description"));
                data.add(mm.get("Added"));
                String pref = (String)mm.get("Preferred-Value");
                if (pref == null) {
                    pref = (String)mm.get("Deprecated");
                    pref = pref == null ? "" : "deprecated";
                }
                data.add(pref);
                if (type.equals("variant")) {
                    code = code.toUpperCase();
                }
                this.add(type2, code, data);
            }
        }
        Map m = this.getZoneData();
        Iterator it2 = m.keySet().iterator();
        while (it2.hasNext()) {
            String code = (String)it2.next();
            this.add("tzid", code, m.get(code).toString());
        }
    }

    private static String nextAlpha(String current) {
        int value = 0;
        for (int i = 0; i < current.length(); ++i) {
            char c;
            c = (char)(c - ((c = current.charAt(i)) < 'a' ? 65 : 97));
            value = value * 26 + c;
        }
        ++value;
        String result = "";
        for (int i = 0; i < current.length(); ++i) {
            result = (char)(value % 26 + 65) + result;
            value /= 26;
        }
        if (UCharacter.toLowerCase((String)current).equals(current)) {
            result = UCharacter.toLowerCase((String)result);
        } else if (!UCharacter.toUpperCase((String)current).equals(current)) {
            result = UCharacter.toTitleCase((String)result, null);
        }
        return result;
    }

    private void add(String string, String string2, String string3) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(string3);
        this.add(string, string2, l);
    }

    private void add(String type, String code, List otherData) {
        ArrayList<String> codes;
        List lastData;
        if (type.equals("script")) {
            if (code.equals("Qaai")) {
                otherData = new ArrayList<String>(otherData);
                otherData.set(0, "Inherited");
            } else if (code.equals("Zyyy")) {
                otherData = new ArrayList(otherData);
                otherData.set(0, "Common");
            }
        }
        String name = (String)otherData.get(0);
        TreeMap<String, ArrayList<String>> code_data = (TreeMap<String, ArrayList<String>>)this.type_code_data.get(type);
        if (code_data == null) {
            code_data = new TreeMap<String, ArrayList<String>>();
            this.type_code_data.put(type, code_data);
        }
        if ((lastData = (List)code_data.get(code)) != null) {
            lastData.addAll(otherData);
        } else {
            code_data.put(code, otherData);
        }
        TreeMap<String, ArrayList<String>> name_codes = (TreeMap<String, ArrayList<String>>)this.type_name_codes.get(type);
        if (name_codes == null) {
            name_codes = new TreeMap<String, ArrayList<String>>();
            this.type_name_codes.put(type, name_codes);
        }
        if ((codes = (ArrayList<String>)name_codes.get(name)) == null) {
            codes = new ArrayList<String>();
            name_codes.put(name, codes);
        }
        codes.add(code);
    }

    public Map getZoneToCounty() {
        if (this.zone_to_country == null) {
            this.make_zone_to_country();
        }
        return this.zone_to_country;
    }

    public Map getCountryToZoneSet() {
        if (this.country_to_zoneSet == null) {
            this.make_zone_to_country();
        }
        return this.country_to_zoneSet;
    }

    private void make_zone_to_country() {
        this.zone_to_country = new TreeMap(this.TZIDComparator);
        this.country_to_zoneSet = new TreeMap();
        Map zoneData = this.getZoneData();
        Iterator it = zoneData.keySet().iterator();
        while (it.hasNext()) {
            String zone = (String)it.next();
            String country = (String)((List)zoneData.get(zone)).get(2);
            this.zone_to_country.put(zone, country);
            TreeSet<String> s = (TreeSet<String>)this.country_to_zoneSet.get(country);
            if (s == null) {
                s = new TreeSet<String>();
                this.country_to_zoneSet.put(country, s);
            }
            s.add(zone);
        }
        this.zone_to_country = Collections.unmodifiableMap(this.zone_to_country);
        this.country_to_zoneSet = (Map)Utility.protectCollection(this.country_to_zoneSet);
    }

    public Map getZoneData() {
        if (this.zoneData == null) {
            this.makeZoneData();
        }
        return this.zoneData;
    }

    private void makeZoneData() {
        try {
            Object newOne;
            int i;
            String line;
            String deg = "([+-])([0-9][0-9][0-9]?)([0-9][0-9])([0-9][0-9])?";
            Matcher m = Pattern.compile(deg + deg).matcher("");
            this.zoneData = new TreeMap();
            BufferedReader in = Utility.getUTF8Data("zone.tab");
            while ((line = in.readLine()) != null) {
                int pos = (line = line.trim()).indexOf(35);
                if (pos >= 0) {
                    this.skippedAliases.add(line);
                    line = line.substring(0, pos).trim();
                }
                if (line.length() == 0) continue;
                List pieces = Utility.splitList(line, '\t', true);
                String country = (String)pieces.get(0);
                String latLong = (String)pieces.get(1);
                String tzid = (String)pieces.get(2);
                String ntzid = (String)FIX_UNSTABLE_TZIDS.get(tzid);
                if (ntzid != null) {
                    tzid = ntzid;
                }
                String comment = pieces.size() < 4 ? null : (String)pieces.get(3);
                pieces.clear();
                if (!m.reset(latLong).matches()) {
                    throw new IllegalArgumentException("Bad zone.tab, lat/long format: " + line);
                }
                pieces.add(this.getDegrees(m, true));
                pieces.add(this.getDegrees(m, false));
                pieces.add(country);
                if (comment != null) {
                    pieces.add(comment);
                }
                if (this.zoneData.containsKey(tzid)) {
                    throw new IllegalArgumentException("Bad zone.tab, duplicate entry: " + line);
                }
                this.zoneData.put(tzid, pieces);
            }
            in.close();
            for (int i2 = -14; i2 <= 12; ++i2) {
                ArrayList<Object> pieces = new ArrayList<Object>();
                boolean latitude = false;
                int longitude = i2 * 15;
                if (longitude <= -180) {
                    longitude += 360;
                }
                pieces.add(new Double((double)latitude));
                pieces.add(new Double(-longitude));
                pieces.add(NO_COUNTRY);
                this.zoneData.put("Etc/GMT" + (i2 == 0 ? "" : (i2 < 0 ? "" + i2 : "+" + i2)), pieces);
            }
            ArrayList<Object> pieces = new ArrayList<Object>();
            pieces.add(new Double(0.0));
            pieces.add(new Double(0.0));
            pieces.add(NO_COUNTRY);
            this.zoneData.put("Etc/Unknown", pieces);
            this.zoneData = (Map)Utility.protectCollection(this.zoneData);
            String lastZone = "";
            Pattern whitespace = Pattern.compile("\\s+");
            XEquivalenceClass linkedItems = new XEquivalenceClass((Object)"None");
            for (i = 0; i < TZFiles.length; ++i) {
                String line2;
                in = Utility.getUTF8Data(TZFiles[i]);
                while ((line2 = in.readLine()) != null) {
                    ArrayList<String> l;
                    if (line2.startsWith("#") || line2.trim().length() == 0) continue;
                    String[] items = whitespace.split(line2);
                    if (items[0].equals("Rule")) {
                        String ruleID = items[1];
                        ArrayList ruleList = (ArrayList)this.ruleID_rules.get(ruleID);
                        if (ruleList == null) {
                            ruleList = new ArrayList();
                            this.ruleID_rules.put(ruleID, ruleList);
                        }
                        l = new ArrayList<String>();
                        l.addAll(Arrays.asList(items));
                        l.remove(0);
                        l.remove(0);
                        ruleList.add(l);
                        continue;
                    }
                    if (items[0].equals("Zone") || line2.startsWith("\t")) {
                        String zoneID;
                        if (line2.startsWith("\t")) {
                            zoneID = lastZone;
                        } else {
                            zoneID = items[1];
                            String ntzid = (String)FIX_UNSTABLE_TZIDS.get(zoneID);
                            if (ntzid != null) {
                                zoneID = ntzid;
                            }
                        }
                        ArrayList<ArrayList<String>> zoneRules = (ArrayList<ArrayList<String>>)this.zone_rules.get(zoneID);
                        if (zoneRules == null) {
                            zoneRules = new ArrayList<ArrayList<String>>();
                            this.zone_rules.put(zoneID, zoneRules);
                        }
                        l = new ArrayList();
                        l.addAll(Arrays.asList(items));
                        l.remove(0);
                        l.remove(0);
                        zoneRules.add(l);
                        lastZone = zoneID;
                        continue;
                    }
                    if (!items[0].equals("Link")) continue;
                    String old = items[2];
                    newOne = items[1];
                    if (SKIP_LINKS.contains(old) || SKIP_LINKS.contains(newOne)) continue;
                    linkedItems.add((Object)old, newOne);
                }
                in.close();
            }
            for (i = 0; i < ADD_ZONE_ALIASES_DATA.length; ++i) {
                linkedItems.add((Object)ADD_ZONE_ALIASES_DATA[i][0], (Object)ADD_ZONE_ALIASES_DATA[i][1]);
            }
            Set isCanonical = this.zoneData.keySet();
            Iterator<Object> it = linkedItems.getEquivalenceSets().iterator();
            while (it.hasNext()) {
                Set equivalents = (Set)it.next();
                TreeSet canonicals = new TreeSet(equivalents);
                canonicals.retainAll(isCanonical);
                if (canonicals.size() == 0) {
                    throw new IllegalArgumentException("No canonicals in: " + equivalents);
                }
                newOne = canonicals.iterator().next();
                Iterator it2 = equivalents.iterator();
                while (it2.hasNext()) {
                    Object oldOne = it2.next();
                    if (canonicals.contains(oldOne)) continue;
                    this.linkold_new.put(oldOne, newOne);
                }
            }
            it = this.linkold_new.keySet().iterator();
            while (it.hasNext()) {
                String oldZone = (String)it.next();
                String newZone = (String)this.linkold_new.get(oldZone);
                HashSet<String> s = (HashSet<String>)this.linkNew_oldSet.get(newZone);
                if (s == null) {
                    s = new HashSet<String>();
                    this.linkNew_oldSet.put(newZone, s);
                }
                s.add(oldZone);
            }
            this.linkNew_oldSet = (Map)Utility.protectCollection(this.linkNew_oldSet);
            this.linkold_new = (Map)Utility.protectCollection(this.linkold_new);
            this.ruleID_rules = (Map)Utility.protectCollection(this.ruleID_rules);
            this.zone_rules = (Map)Utility.protectCollection(this.zone_rules);
        }
        catch (IOException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't find timezone aliases: " + e.toString()).initCause(e);
        }
    }

    public Comparator getTZIDComparator() {
        return this.TZIDComparator;
    }

    public List getDeprecatedZoneIDs() {
        return Arrays.asList(FIX_DEPRECATED_ZONE_DATA);
    }

    public List getOld3166() {
        return this.DELETED3166;
    }

    private Double getDegrees(Matcher m, boolean lat) {
        int startIndex = lat ? 1 : 5;
        double amount = (double)Integer.parseInt(m.group(startIndex + 1)) + (double)Integer.parseInt(m.group(startIndex + 2)) / 60.0;
        if (m.group(startIndex + 3) != null) {
            amount += (double)Integer.parseInt(m.group(startIndex + 3)) / 3600.0;
        }
        if (m.group(startIndex).equals("-")) {
            amount = -amount;
        }
        return new Double(amount);
    }

    public Map getZoneLinkold_new() {
        this.getZoneData();
        return this.linkold_new;
    }

    public Map getZoneLinkNew_OldSet() {
        this.getZoneData();
        return this.linkNew_oldSet;
    }

    public Map getZoneRuleID_rules() {
        this.getZoneData();
        return this.ruleID_rules;
    }

    public Map getZone_rules() {
        this.getZoneData();
        return this.zone_rules;
    }

    public Map getWorldBankInfo() {
        if (this.WorldBankInfo == null) {
            List temp = this.fillFromCommaFile("./org/unicode/cldr/util/data/", "WorldBankInfo.txt");
            this.WorldBankInfo = new HashMap();
            Iterator it = temp.iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                List row = Utility.splitList(line, ';', true);
                String key = (String)row.get(0);
                row.remove(0);
                this.WorldBankInfo.put(key, row);
            }
            Utility.protectCollection(this.WorldBankInfo);
        }
        return this.WorldBankInfo;
    }

    public Set getMainTimeZones() {
        if (this.MainTimeZones == null) {
            List temp = this.fillFromCommaFile("./org/unicode/cldr/util/data/", "MainTimeZones.txt");
            this.MainTimeZones = new TreeSet();
            this.MainTimeZones.addAll(temp);
            Utility.protectCollection(this.MainTimeZones);
        }
        return this.MainTimeZones;
    }

    private List fillFromCommaFile(String dir, String filename) {
        try {
            String line;
            ArrayList<String> result = new ArrayList<String>();
            BufferedReader lstreg = BagFormatter.openUTF8Reader((String)dir, (String)filename);
            while ((line = lstreg.readLine()) != null) {
                int commentPos = line.indexOf(35);
                if (commentPos >= 0) {
                    line = line.substring(0, commentPos);
                }
                if (line.length() == 0) continue;
                result.add(line);
            }
            return result;
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException("Can't process file: " + dir + filename).initCause(e);
        }
    }

    public static Map getLStreg() {
        TreeMap result = new TreeMap();
        for (int i = 0; i < extras.length; ++i) {
            TreeMap<String, TreeMap<String, String>> subtagData = (TreeMap<String, TreeMap<String, String>>)result.get(extras[i][0]);
            if (subtagData == null) {
                subtagData = new TreeMap<String, TreeMap<String, String>>();
                result.put(extras[i][0], subtagData);
            }
            TreeMap<String, String> labelData = new TreeMap<String, String>();
            for (int j = 2; j < extras[i].length; j += 2) {
                labelData.put(extras[i][j], extras[i][j + 1]);
            }
            subtagData.put(extras[i][1], labelData);
        }
        TreeSet funnyTags = new TreeSet();
        try {
            String line;
            BufferedReader lstreg = Utility.getUTF8Data("language-subtag-registry");
            boolean started = false;
            String lastType = null;
            String lastTag = null;
            TreeMap<String, TreeMap<String, String>> subtagData = null;
            TreeMap<String, String> currentData = null;
            String lastLabel = null;
            String lastRest = null;
            block7: while ((line = lstreg.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("File-Date: ") || line.startsWith("%%")) continue;
                if (line.startsWith(" ")) {
                    currentData.put(lastLabel, lastRest + " " + line.trim());
                    continue;
                }
                int pos2 = line.indexOf(58);
                String label = line.substring(0, pos2).trim();
                String rest = line.substring(pos2 + 1).trim();
                if (label.equalsIgnoreCase("Type")) {
                    lastType = rest;
                    subtagData = (TreeMap<String, TreeMap<String, String>>)result.get(lastType);
                    if (subtagData != null) continue;
                    subtagData = new TreeMap<String, TreeMap<String, String>>();
                    result.put(rest, subtagData);
                    continue;
                }
                if (label.equalsIgnoreCase("Subtag") || label.equalsIgnoreCase("Tag")) {
                    lastTag = rest;
                    String endTag = null;
                    int pos = lastTag.indexOf("..");
                    if (pos >= 0) {
                        endTag = lastTag.substring(pos + 2);
                        lastTag = lastTag.substring(0, pos);
                    }
                    if ((currentData = (Map)subtagData.get(lastTag)) != null) {
                        throw new IllegalArgumentException("Duplicate tag: " + lastTag);
                    }
                    currentData = new TreeMap<String, String>();
                    if (endTag == null) {
                        subtagData.put(lastTag, currentData);
                        languageCount.add(lastType, 1L);
                        continue;
                    }
                    while (true) {
                        if (lastTag.compareTo(endTag) > 0) continue block7;
                        subtagData.put(lastTag, currentData);
                        languageCount.add(lastType, 1L);
                        lastTag = StandardCodes.nextAlpha(lastTag);
                    }
                }
                lastLabel = label;
                lastRest = TransliteratorUtilities.fromXML.transliterate(rest);
                currentData.put(lastLabel, lastRest);
            }
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException("Can't process file: ./org/unicode/cldr/util/data/draft-ietf-ltru-initial-06.txt").initCause(e);
        }
        finally {
            if (!funnyTags.isEmpty()) {
                // empty if block
            }
        }
        return result;
    }

    public static Counter getLanguageCount() {
        return languageCount;
    }

    static {
        caseless = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String s1 = (String)arg0;
                String s2 = (String)arg1;
                return s1.compareToIgnoreCase(s2);
            }
        };
        errorData = Arrays.asList(new Double(Double.MIN_VALUE), new Double(Double.MIN_VALUE), "");
        regionalCompare = new MapComparator();
        regionalCompare.add("America");
        regionalCompare.add("Atlantic");
        regionalCompare.add("Europe");
        regionalCompare.add("Africa");
        regionalCompare.add("Asia");
        regionalCompare.add("Indian");
        regionalCompare.add("Australia");
        regionalCompare.add("Pacific");
        regionalCompare.add("Arctic");
        regionalCompare.add("Antarctica");
        regionalCompare.add("Etc");
        TZFiles = new String[]{"africa", "antarctica", "asia", "australasia", "backward", "etcetera", "europe", "northamerica", "pacificnew", "southamerica", "systemv"};
        SKIP_LINKS = new HashSet<String>(Arrays.asList("Navajo", "America/Shiprock"));
        ADD_ZONE_ALIASES_DATA = new String[][]{{"Etc/UTC", "Etc/GMT"}, {"Etc/UCT", "Etc/GMT"}, {"Navajo", "America/Shiprock"}, {"SystemV/AST4ADT", "America/Halifax"}, {"SystemV/EST5EDT", "America/New_York"}, {"EST5EDT", "America/New_York"}, {"SystemV/CST6CDT", "America/Chicago"}, {"CST6CDT", "America/Chicago"}, {"SystemV/MST7MDT", "America/Denver"}, {"MST7MDT", "America/Denver"}, {"SystemV/PST8PDT", "America/Los_Angeles"}, {"PST8PDT", "America/Los_Angeles"}, {"SystemV/YST9YDT", "America/Anchorage"}, {"SystemV/AST4", "America/Puerto_Rico"}, {"SystemV/EST5", "America/Indianapolis"}, {"EST", "America/Indianapolis"}, {"SystemV/CST6", "America/Regina"}, {"SystemV/MST7", "America/Phoenix"}, {"MST", "America/Phoenix"}, {"SystemV/PST8", "Pacific/Pitcairn"}, {"SystemV/YST9", "Pacific/Gambier"}, {"SystemV/HST10", "Pacific/Honolulu"}, {"HST", "Pacific/Honolulu"}};
        FIX_DEPRECATED_ZONE_DATA = new String[]{"Africa/Timbuktu", "America/Argentina/ComodRivadavia", "Europe/Belfast", "Pacific/Yap"};
        Object[][] FIX_UNSTABLE_TZID_DATA = new String[][]{{"America/Argentina/Buenos_Aires", "America/Buenos_Aires"}, {"America/Argentina/Catamarca", "America/Catamarca"}, {"America/Argentina/Cordoba", "America/Cordoba"}, {"America/Argentina/Jujuy", "America/Jujuy"}, {"America/Argentina/Mendoza", "America/Mendoza"}, {"America/Kentucky/Louisville", "America/Louisville"}, {"America/Indiana/Indianapolis", "America/Indianapolis"}};
        FIX_UNSTABLE_TZIDS = Utility.asMap(FIX_UNSTABLE_TZID_DATA);
        RESTORE_UNSTABLE_TZIDS = Utility.asMap(FIX_UNSTABLE_TZID_DATA, new HashMap(), true);
        extras = new String[][]{{"language", "root", "Description", "Root", "CLDR", "True"}, {"variant", "POLYTONI", "Description", "Polytonic Greek", "CLDR", "True"}, {"variant", "REVISED", "Description", "Revised Orthography", "CLDR", "True"}, {"variant", "SAAHO", "Description", "Dialect", "CLDR", "True"}, {"region", "QU", "Description", "European Union", "CLDR", "True"}};
        languageCount = new Counter();
    }
}

