/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.dev.test.util.BagFormatter;
import com.ibm.icu.dev.test.util.TransliteratorUtilities;
import com.ibm.icu.impl.CollectionUtilities;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.GenerateAttributeList;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.Utility;
import org.unicode.cldr.util.XMLFileReader;

public class TestUtilities {
    private static final String[][] language_territory_hack = new String[][]{{"af", "ZA"}, {"am", "ET"}, {"ar", "SA"}, {"as", "IN"}, {"ay", "PE"}, {"az", "AZ"}, {"bal", "PK"}, {"be", "BY"}, {"bg", "BG"}, {"bn", "IN"}, {"bs", "BA"}, {"ca", "ES"}, {"ch", "MP"}, {"cpe", "SL"}, {"cs", "CZ"}, {"cy", "GB"}, {"da", "DK"}, {"de", "DE"}, {"dv", "MV"}, {"dz", "BT"}, {"el", "GR"}, {"en", "US"}, {"es", "ES"}, {"et", "EE"}, {"eu", "ES"}, {"fa", "IR"}, {"fi", "FI"}, {"fil", "PH"}, {"fj", "FJ"}, {"fo", "FO"}, {"fr", "FR"}, {"ga", "IE"}, {"gd", "GB"}, {"gl", "ES"}, {"gn", "PY"}, {"gu", "IN"}, {"gv", "GB"}, {"ha", "NG"}, {"he", "IL"}, {"hi", "IN"}, {"ho", "PG"}, {"hr", "HR"}, {"ht", "HT"}, {"hu", "HU"}, {"hy", "AM"}, {"id", "ID"}, {"is", "IS"}, {"it", "IT"}, {"ja", "JP"}, {"ka", "GE"}, {"kk", "KZ"}, {"kl", "GL"}, {"km", "KH"}, {"kn", "IN"}, {"ko", "KR"}, {"kok", "IN"}, {"ks", "IN"}, {"ku", "TR"}, {"ky", "KG"}, {"la", "VA"}, {"lb", "LU"}, {"ln", "CG"}, {"lo", "LA"}, {"lt", "LT"}, {"lv", "LV"}, {"mai", "IN"}, {"men", "GN"}, {"mg", "MG"}, {"mh", "MH"}, {"mk", "MK"}, {"ml", "IN"}, {"mn", "MN"}, {"mni", "IN"}, {"mo", "MD"}, {"mr", "IN"}, {"ms", "MY"}, {"mt", "MT"}, {"my", "MM"}, {"na", "NR"}, {"nb", "NO"}, {"nd", "ZA"}, {"ne", "NP"}, {"niu", "NU"}, {"nl", "NL"}, {"nn", "NO"}, {"no", "NO"}, {"nr", "ZA"}, {"nso", "ZA"}, {"ny", "MW"}, {"om", "KE"}, {"or", "IN"}, {"pa", "IN"}, {"pau", "PW"}, {"pl", "PL"}, {"ps", "PK"}, {"pt", "BR"}, {"qu", "PE"}, {"rn", "BI"}, {"ro", "RO"}, {"ru", "RU"}, {"rw", "RW"}, {"sd", "IN"}, {"sg", "CF"}, {"si", "LK"}, {"sk", "SK"}, {"sl", "SI"}, {"sm", "WS"}, {"so", "DJ"}, {"sq", "CS"}, {"sr", "CS"}, {"ss", "ZA"}, {"st", "ZA"}, {"sv", "SE"}, {"sw", "KE"}, {"ta", "IN"}, {"te", "IN"}, {"tem", "SL"}, {"tet", "TL"}, {"th", "TH"}, {"ti", "ET"}, {"tg", "TJ"}, {"tk", "TM"}, {"tkl", "TK"}, {"tvl", "TV"}, {"tl", "PH"}, {"tn", "ZA"}, {"to", "TO"}, {"tpi", "PG"}, {"tr", "TR"}, {"ts", "ZA"}, {"uk", "UA"}, {"ur", "IN"}, {"uz", "UZ"}, {"ve", "ZA"}, {"vi", "VN"}, {"wo", "SN"}, {"xh", "ZA"}, {"zh", "CN"}, {"zh_Hant", "TW"}, {"zu", "ZA"}, {"aa", "ET"}, {"byn", "ER"}, {"eo", "DE"}, {"gez", "ET"}, {"haw", "US"}, {"iu", "CA"}, {"kw", "GB"}, {"sa", "IN"}, {"sh", "HR"}, {"sid", "ET"}, {"syr", "SY"}, {"tig", "ER"}, {"tt", "RU"}, {"wal", "ET"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            TestUtilities.checkNumericTimezone();
            return;
        }
        finally {
            System.out.println("Done");
        }
    }

    private static void checkNumericTimezone() throws IOException {
        String line;
        String[] map_integer_zones = new String[1000];
        StandardCodes sc = StandardCodes.make();
        TreeSet timezones = new TreeSet(sc.getGoodAvailableCodes("tzid"));
        TreeMap<String, Integer> map_timezone_integer = new TreeMap<String, Integer>();
        BufferedReader input = Utility.getUTF8Data("timezone_numeric.txt");
        int maxNumeric = -1;
        Map fixOld = sc.getZoneLinkold_new();
        while ((line = input.readLine()) != null) {
            String[] parts = line.split(";\\s*");
            int numeric = Integer.parseInt(parts[0]);
            String originalTzid = parts[1].trim();
            String fixedID = (String)fixOld.get(originalTzid);
            if (fixedID == null) {
                if (!timezones.contains(originalTzid)) {
                    System.out.println(numeric + "\t" + originalTzid + "\tStrange ID: " + fixedID);
                }
                fixedID = originalTzid;
            } else {
                System.out.println("Replacing " + originalTzid + " with " + fixedID);
            }
            if (map_integer_zones[numeric] != null) {
                System.out.println("Duplicate number:" + numeric + ",\t" + fixedID + ",\t" + originalTzid + ",\t" + map_integer_zones[numeric]);
                fixedID = "{" + originalTzid + "}";
            }
            if (map_timezone_integer.get(fixedID) != null) {
                System.out.println("Duplicate zone:" + numeric + ",\t" + fixedID + ",\t" + originalTzid + ",\t" + map_timezone_integer.get(fixedID));
                fixedID = "{" + originalTzid + "}";
            }
            map_integer_zones[numeric] = fixedID;
            map_timezone_integer.put(fixedID, new Integer(numeric));
            if (maxNumeric >= numeric) continue;
            maxNumeric = numeric;
        }
        RuleBasedCollator eng = (RuleBasedCollator)Collator.getInstance();
        eng.setNumericCollation(true);
        TreeSet extra = new TreeSet(eng);
        extra.addAll(map_timezone_integer.keySet());
        extra.removeAll(timezones);
        System.out.println("Extra: " + extra);
        TreeSet needed = new TreeSet(eng);
        needed.addAll(timezones);
        needed.removeAll(map_timezone_integer.keySet());
        System.out.println("Needed: " + needed);
        int numeric = 1;
        ArrayList ordered = new ArrayList(needed);
        Iterator it = ordered.iterator();
        while (it.hasNext()) {
            String tzid = (String)it.next();
            while (map_integer_zones[numeric] != null) {
                ++numeric;
            }
            if (maxNumeric < numeric) {
                maxNumeric = numeric;
            }
            map_integer_zones[numeric] = tzid;
            map_timezone_integer.put(tzid, new Integer(numeric));
        }
        Map equiv = sc.getZoneLinkNew_OldSet();
        TreeSet old = new TreeSet();
        for (int i = 1; i <= maxNumeric; ++i) {
            Set s = (Set)equiv.get(map_integer_zones[i]);
            String oString = "";
            if (s != null) {
                old.clear();
                old.addAll(s);
                oString = "\t" + old;
            }
            System.out.println("\t\"" + map_integer_zones[i] + "\",");
        }
    }

    private static void checkTranslit() {
        HashSet<String> unicodeProps = new HashSet<String>(Arrays.asList("Numeric_Value", "Bidi_Mirroring_Glyph", "Case_Folding", "Decomposition_Mapping", "FC_NFKC_Closure", "Lowercase_Mapping", "Special_Case_Condition", "Simple_Case_Folding", "Simple_Lowercase_Mapping", "Simple_Titlecase_Mapping", "Simple_Uppercase_Mapping", "Titlecase_Mapping", "Uppercase_Mapping", "ISO_Comment", "Name", "Unicode_1_Name", "Unicode_Radical_Stroke", "Age", "Block", "Script", "Bidi_Class", "Canonical_Combining_Class", "Decomposition_Type", "East_Asian_Width", "General_Category", "Grapheme_Cluster_Break", "Hangul_Syllable_Type", "Joining_Group", "Joining_Type", "Line_Break", "NFC_Quick_Check", "NFD_Quick_Check", "NFKC_Quick_Check", "NFKD_Quick_Check", "Numeric_Type", "Sentence_Break", "Word_Break", "ASCII_Hex_Digit", "Alphabetic", "Bidi_Control", "Bidi_Mirrored", "Composition_Exclusion", "Full_Composition_Exclusion", "Dash", "Deprecated", "Default_Ignorable_Code_Point", "Diacritic", "Extender", "Grapheme_Base", "Grapheme_Extend", "Grapheme_Link", "Hex_Digit", "Hyphen", "ID_Continue", "Ideographic", "ID_Start", "IDS_Binary_Operator", "IDS_Trinary_Operator", "Join_Control", "Logical_Order_Exception", "Lowercase", "Math", "Noncharacter_Code_Point", "Other_Alphabetic", "Other_Default_Ignorable_Code_Point", "Other_Grapheme_Extend", "Other_ID_Continue", "Other_ID_Start", "Other_Lowercase", "Other_Math", "Other_Uppercase", "Pattern_Syntax", "Pattern_White_Space", "Quotation_Mark", "Radical", "Soft_Dotted", "STerm", "Terminal_Punctuation", "Unified_Ideograph", "Uppercase", "Variation_Selector", "space", "XID_Continue", "XID_Start", "Expands_On_NFC", "Expands_On_NFD", "Expands_On_NFKC", "Expands_On_NFKD"));
        for (int i = 0; i < 65535; ++i) {
            TestUtilities.checkTranslit(UTF16.valueOf((int)i));
        }
        PrintStream out = System.out;
        Transliterator toHTML = TransliteratorUtilities.toHTML;
        UnicodeSet a_out = new UnicodeSet("[:whitespace:]");
        UnicodeSetIterator it = new UnicodeSetIterator(a_out);
        while (it.next()) {
            int s = it.codepoint;
            String literal = toHTML.transliterate(UTF16.valueOf((int)s));
            out.println(com.ibm.icu.impl.Utility.hex((int)s, (int)4) + " (" + literal + ") " + UCharacter.getName((int)s));
        }
    }

    private static void checkTranslit(String string) {
        String htmlAscii;
        String reverseAscii;
        String html = TransliteratorUtilities.toHTML.transliterate(string);
        String reverse = TransliteratorUtilities.fromHTML.transliterate(html);
        if (!reverse.equals(string)) {
            System.out.println(string + "\t=>\t" + html + "\t=>\t" + reverse + (!reverse.equals(string) ? " FAIL" : ""));
        }
        if (!(reverseAscii = TransliteratorUtilities.fromHTML.transliterate(htmlAscii = TransliteratorUtilities.toHTMLAscii.transliterate(string))).equals(string)) {
            System.out.println(string + "\t=>\t" + htmlAscii + "\t=>\t" + reverseAscii + (!reverseAscii.equals(string) ? " FAIL" : ""));
        }
    }

    private static void writeMetaData() throws IOException {
        int i;
        CLDRFile meta = CLDRFile.make("metaData").setNonInheriting(true);
        Object[] elements = new String[]{"ldml", "identity", "alias", "localeDisplayNames", "layout", "characters", "delimiters", "measurement", "dates", "numbers", "collations", "posix", "segmentations", "references", "version", "generation", "language", "script", "territory", "variant", "languages", "scripts", "territories", "variants", "keys", "types", "measurementSystemNames", "key", "type", "measurementSystemName", "orientation", "inList", "exemplarCharacters", "mapping", "quotationStart", "quotationEnd", "alternateQuotationStart", "alternateQuotationEnd", "measurementSystem", "paperSize", "height", "width", "localizedPatternChars", "calendars", "timeZoneNames", "months", "monthNames", "monthAbbr", "days", "dayNames", "dayAbbr", "quarters", "week", "am", "pm", "eras", "dateFormats", "timeFormats", "dateTimeFormats", "fields", "month", "day", "quarter", "minDays", "firstDay", "weekendStart", "weekendEnd", "eraNames", "eraAbbr", "era", "pattern", "displayName", "dateFormatItem", "appendItem", "hourFormat", "hoursFormat", "gmtFormat", "regionFormat", "fallbackFormat", "abbreviationFallback", "preferenceOrdering", "singleCountries", "default", "calendar", "monthContext", "monthWidth", "dayContext", "dayWidth", "quarterContext", "quarterWidth", "dateFormatLength", "dateFormat", "timeFormatLength", "timeFormat", "dateTimeFormatLength", "availableFormats", "appendItems", "dateTimeFormat", "zone", "long", "short", "exemplarCity", "generic", "standard", "daylight", "field", "relative", "symbols", "decimalFormats", "scientificFormats", "percentFormats", "currencyFormats", "currencies", "decimalFormatLength", "decimalFormat", "scientificFormatLength", "scientificFormat", "percentFormatLength", "percentFormat", "currencySpacing", "currencyFormatLength", "beforeCurrency", "afterCurrency", "currencyMatch", "surroundingMatch", "insertBetween", "currencyFormat", "currency", "symbol", "decimal", "group", "list", "percentSign", "nativeZeroDigit", "patternDigit", "plusSign", "minusSign", "exponential", "perMille", "infinity", "nan", "collation", "messages", "yesstr", "nostr", "yesexpr", "noexpr", "segmentation", "variables", "segmentRules", "special", "variable", "rule", "comment", "base", "settings", "suppress_contractions", "optimize", "rules"};
        String list = CollectionUtilities.join((Object[])elements, (String)" ");
        String prefix = "//supplementalData[@version=\"1.4\"]/metaData/";
        meta.add(prefix + "elementOrder", list);
        Object[] attOrder = new String[]{"_q", "type", "key", "registry", "source", "target", "path", "day", "date", "version", "count", "lines", "characters", "before", "from", "to", "number", "time", "casing", "list", "uri", "iso4217", "digits", "rounding", "iso3166", "hex", "id", "request", "direction", "alternate", "backwards", "caseFirst", "caseLevel", "hiraganaQuarternary", "hiraganaQuaternary", "normalization", "numeric", "strength", "validSubLocales", "standard", "references", "elements", "element", "attributes", "attribute", "alt", "draft"};
        meta.add(prefix + "attributeOrder", CollectionUtilities.join((Object[])attOrder, (String)" "));
        Object[] serialElements = new String[]{"variable", "comment", "tRule", "reset", "p", "pc", "s", "sc", "t", "tc", "q", "qc", "i", "ic", "x", "extend", "first_variable", "last_variable", "first_tertiary_ignorable", "last_tertiary_ignorable", "first_secondary_ignorable", "last_secondary_ignorable", "first_primary_ignorable", "last_primary_ignorable", "first_non_ignorable", "last_non_ignorable", "first_trailing", "last_trailing"};
        meta.add(prefix + "serialElements", CollectionUtilities.join((Object[])serialElements, (String)" "));
        CLDRFile.Factory cldrFactory = CLDRFile.Factory.make("../../common/main/", ".*");
        GenerateAttributeList attributes = new GenerateAttributeList(cldrFactory);
        Map element_attribute_valueSet = attributes.getElement_attribute_valueSet();
        Iterator it = element_attribute_valueSet.keySet().iterator();
        while (it.hasNext()) {
            String element = (String)it.next();
            Map attribute_valueSet = (Map)element_attribute_valueSet.get(element);
            int size = attribute_valueSet.size();
            if (size == 0) continue;
            Iterator it2 = attribute_valueSet.keySet().iterator();
            while (it2.hasNext()) {
                String attribute = (String)it2.next();
                Set[] valueSets = (Set[])attribute_valueSet.get(attribute);
                for (i = 0; i < 2; ++i) {
                    meta.add(prefix + "valid/attributeValues" + "[@elements=\"" + element + "\"]" + "[@attributes=\"" + attribute + "\"]" + (i == 1 ? "[@x=\"true\"]" : ""), CollectionUtilities.join((Collection)valueSets[i], (String)" "));
                }
            }
        }
        Object[] dayValueOrder = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"type\"][@elements=\"" + "day" + "\"]", CollectionUtilities.join((Object[])dayValueOrder, (String)" "));
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"" + "day" + "\"][@elements=\"" + "firstDay weekendEnd weekendStart" + "\"]", CollectionUtilities.join((Object[])dayValueOrder, (String)" "));
        Object[] widths = new String[]{"monthWidth", "dayWidth", "quarterWidth"};
        Object[] widthOrder = new String[]{"abbreviated", "narrow", "wide"};
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"type\"][@elements=\"" + CollectionUtilities.join((Object[])widths, (String)" ") + "\"]", CollectionUtilities.join((Object[])widthOrder, (String)" "));
        Object[] formatLengths = new String[]{"dateFormatLength", "timeFormatLength", "dateTimeFormatLength", "decimalFormatLength", "scientificFormatLength", "percentFormatLength", "currencyFormatLength"};
        Object[] lengthOrder = new String[]{"full", "long", "medium", "short"};
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"type\"][@elements=\"" + CollectionUtilities.join((Object[])formatLengths, (String)" ") + "\"]", CollectionUtilities.join((Object[])lengthOrder, (String)" "));
        Object[] dateFieldOrder = new String[]{"era", "year", "month", "week", "day", "weekday", "dayperiod", "hour", "minute", "second", "zone"};
        meta.add(prefix + "valid/attributeValues[@order=\"given\"][@attributes=\"type\"][@elements=\"field\"]", CollectionUtilities.join((Object[])dateFieldOrder, (String)" "));
        String[][] suppressData = new String[][]{{"ldml", "version", "*"}, {"orientation", "characters", "left-to-right"}, {"orientation", "lines", "top-to-bottom"}, {"weekendStart", "time", "00:00"}, {"weekendEnd", "time", "24:00"}, {"dateFormat", "type", "standard"}, {"timeFormat", "type", "standard"}, {"dateTimeFormat", "type", "standard"}, {"decimalFormat", "type", "standard"}, {"scientificFormat", "type", "standard"}, {"percentFormat", "type", "standard"}, {"currencyFormat", "type", "standard"}, {"pattern", "type", "standard"}, {"currency", "type", "standard"}, {"collation", "type", "standard"}, {"*", "_q", "*"}};
        for (i = 0; i < suppressData.length; ++i) {
            meta.add(prefix + "suppress/attributes" + "[@element=\"" + suppressData[i][0] + "\"][@attribute=\"" + suppressData[i][1] + "\"][@attributeValue=\"" + suppressData[i][2] + "\"]", "");
        }
        PrintWriter out = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/meta/", (String)"metaData.xml");
        meta.write(out);
        out.close();
        XMLFileReader xfr = new XMLFileReader().setHandler(new MyHandler());
        xfr.read("../../dropbox/gen/meta/metaData.xml", XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
    }

    private static void testXMLFileReader() {
        XMLFileReader xfr = new XMLFileReader().setHandler(new MyHandler());
        xfr.read("../../common/main/root.xml", -1, true);
    }

    public static void testBreakIterator(String text) {
        System.out.println(text);
        String choice = "Line";
        String BASE_RULES = "'<' > '&lt;' ;'<' < '&'[lL][Tt]';' ;'&' > '&amp;' ;'&' < '&'[aA][mM][pP]';' ;'>' < '&'[gG][tT]';' ;'\"' < '&'[qQ][uU][oO][tT]';' ; '' < '&'[aA][pP][oO][sS]';' ; ";
        String CONTENT_RULES = "'>' > '&gt;' ;";
        String HTML_RULES = BASE_RULES + CONTENT_RULES + "'\"' > '&quot;' ; ";
        String HTML_RULES_CONTROLS = HTML_RULES + "([[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:][\\u0080-\\U0010FFFF]]) > &hex/xml($1) ; ";
        Transliterator toHTML = Transliterator.createFromRules((String)"any-xml", (String)HTML_RULES_CONTROLS, (int)0);
        RuleBasedBreakIterator b = choice.equals("Word") ? (RuleBasedBreakIterator)BreakIterator.getWordInstance() : (choice.equals("Line") ? (RuleBasedBreakIterator)BreakIterator.getLineInstance() : (choice.equals("Sentence") ? (RuleBasedBreakIterator)BreakIterator.getSentenceInstance() : (RuleBasedBreakIterator)BreakIterator.getCharacterInstance()));
        Matcher decimalEscapes = Pattern.compile("&#(x?)([0-9]+);").matcher(text);
        int start = 0;
        StringBuffer result2 = new StringBuffer();
        while (decimalEscapes.find(start)) {
            int radix = decimalEscapes.group(2).length() == 0 ? 10 : 16;
            int code = Integer.parseInt(decimalEscapes.group(2), radix);
            result2.append(text.substring(start, decimalEscapes.start()) + UTF16.valueOf((int)code));
            start = decimalEscapes.end();
        }
        result2.append(text.substring(start));
        text = result2.toString();
        int lastBreak = 0;
        StringBuffer result = new StringBuffer();
        b.setText(text);
        b.first();
        int nextBreak = b.next();
        while (true) {
            if (nextBreak == -1) break;
            int status = b.getRuleStatus();
            String piece = text.substring(lastBreak, nextBreak);
            piece = toHTML.transliterate(piece);
            piece = piece.replaceAll("&#xA;", "<br>");
            result.append("<span class='break'>").append(piece).append("</span>");
            lastBreak = nextBreak;
            nextBreak = b.next();
        }
        System.out.println(result);
    }

    private static void checkStandardCodes() {
        String oldType;
        Map subtagData;
        String type;
        StandardCodes sc = StandardCodes.make();
        Set zones = sc.getGoodAvailableCodes("tzid");
        System.out.println(CollectionUtilities.join((Collection)zones, (String)" "));
        Set currencies = sc.getGoodAvailableCodes("currency");
        System.out.println(CollectionUtilities.join((Collection)currencies, (String)" "));
        Map m = StandardCodes.getLStreg();
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            type = (String)it.next();
            subtagData = (Map)m.get(type);
            oldType = type.equals("region") ? "territory" : type;
            Set allCodes = sc.getAvailableCodes(oldType);
            TreeSet<Object> temp = new TreeSet(subtagData.keySet());
            temp.removeAll(allCodes);
            System.out.println(type + "\t in new but not old\t" + temp);
            temp = new TreeSet(allCodes);
            temp.removeAll(subtagData.keySet());
            System.out.println(type + "\t in old but not new\t" + temp);
        }
        it = m.keySet().iterator();
        while (it.hasNext()) {
            type = (String)it.next();
            subtagData = (Map)m.get(type);
            oldType = type.equals("region") ? "territory" : type;
            Set goodCodes = sc.getGoodAvailableCodes(oldType);
            Iterator it2 = subtagData.keySet().iterator();
            while (it2.hasNext()) {
                boolean newDeprecated;
                boolean deprecated;
                String tag = (String)it2.next();
                Map data = (Map)subtagData.get(tag);
                List sdata = sc.getFullData(oldType, tag);
                if (sdata == null) continue;
                String description = (String)sdata.get(0);
                boolean bl = deprecated = !goodCodes.contains(tag);
                if (description.equals("PRIVATE USE")) {
                    deprecated = false;
                }
                String newDescription = (String)data.get("Description");
                boolean bl2 = newDeprecated = data.get("Deprecated") != null;
                if (!description.equals(newDescription)) {
                    System.out.println(type + "\t" + tag + "\tDescriptions differ: {" + description + "} ### {" + newDescription + "}");
                }
                if (deprecated == newDeprecated) continue;
                System.out.println(type + "\t" + tag + "\tDeprecated differs: {" + deprecated + "} ### {" + newDeprecated + "}");
            }
        }
        it = m.keySet().iterator();
        while (it.hasNext()) {
            type = (String)it.next();
            subtagData = (Map)m.get(type);
            oldType = type.equals("region") ? "territory" : type;
            String aliasType = oldType.equals("grandfathered") ? "language" : oldType;
            TreeSet<String> allCodes = new TreeSet<String>();
            TreeSet<String> deprecatedCodes = new TreeSet<String>();
            Iterator it2 = subtagData.keySet().iterator();
            while (it2.hasNext()) {
                String tag = (String)it2.next();
                Map data = (Map)subtagData.get(tag);
                if (data.get("Deprecated") != null) {
                    String preferred = (String)data.get("Preferred-Value");
                    String cldr = null != data.get("CLDR") ? "CLDR: " : "";
                    System.out.println("\t\t\t<" + aliasType + "Alias type=\"" + tag + "\"" + (preferred == null || preferred.length() == 0 ? "" : " replacement=\"" + preferred + "\"") + "/> <!-- " + cldr + data.get("Description") + " -->");
                    deprecatedCodes.add(tag);
                    continue;
                }
                allCodes.add(tag);
            }
            Set goodCodes = sc.getAvailableCodes(oldType);
            TreeSet oldAndNotNew = new TreeSet(goodCodes);
            oldAndNotNew.removeAll(allCodes);
            oldAndNotNew.removeAll(deprecatedCodes);
            Iterator it22 = oldAndNotNew.iterator();
            while (it22.hasNext()) {
                String tag = (String)it22.next();
                List sdata = sc.getFullData(oldType, tag);
                String preferred = (String)sdata.get(2);
                System.out.println("\t\t\t<" + aliasType + "Alias type=\"" + tag + "\" replacement=\"" + preferred + "\"/> <!-- CLDR:" + sdata.get(0) + " -->");
            }
            String allCodeString = CollectionUtilities.join(allCodes, (String)" ");
            System.out.println("\t\t\t<variable id=\"$" + oldType + "\" type=\"list\">" + allCodeString + "</variable>");
        }
    }

    private static void checkLanguages() {
        CLDRFile.Factory mainCldrFactory = CLDRFile.Factory.make("../../common/main" + File.separator, ".*");
        Set availableLocales = mainCldrFactory.getAvailable();
        TreeSet<String> available = new TreeSet<String>();
        LocaleIDParser lip = new LocaleIDParser();
        Iterator it = availableLocales.iterator();
        while (it.hasNext()) {
            available.add(lip.set((String)it.next()).getLanguage());
        }
        TreeSet<String> langHack = new TreeSet<String>();
        for (int i = 0; i < language_territory_hack.length; ++i) {
            String lang = language_territory_hack[i][0];
            langHack.add(lang);
        }
        if (langHack.containsAll(available)) {
            System.out.println("All ok");
        } else {
            available.removeAll(langHack);
            Iterator it2 = available.iterator();
            while (it2.hasNext()) {
                String item = (String)it2.next();
                System.out.println("{\"" + item + "\", \"XXX\"},/t//" + ULocale.getDisplayLanguage((String)item, (ULocale)ULocale.ENGLISH));
            }
        }
    }

    private static void printCountries() throws IOException {
        String code;
        CLDRFile.Factory mainCldrFactory = CLDRFile.Factory.make("../../common/main" + File.separator, ".*");
        CLDRFile english = mainCldrFactory.make("en", true);
        PrintWriter out = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/", (String)"country_language_names.txt");
        StandardCodes sc = StandardCodes.make();
        Iterator it = sc.getGoodAvailableCodes("language").iterator();
        while (it.hasNext()) {
            code = (String)it.next();
            out.println(code + "\t" + english.getName(0, code, false));
        }
        out.println("****");
        it = sc.getGoodAvailableCodes("territory").iterator();
        while (it.hasNext()) {
            code = (String)it.next();
            out.println(code + "\t" + english.getName(2, code, false));
        }
        out.println("****");
        it = sc.getGoodAvailableCodes("script").iterator();
        while (it.hasNext()) {
            code = (String)it.next();
            out.println(code + "\t" + english.getName(1, code, false));
        }
        out.close();
    }

    private static void printCurrencies() {
        StandardCodes sc = StandardCodes.make();
        Set s = sc.getAvailableCodes("currency");
        Iterator it = s.iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            String name = sc.getData("currency", code);
            List data = sc.getFullData("currency", code);
            System.out.println(code + "\t" + name + "\t" + data);
        }
    }

    private static void printZoneSamples() throws Exception {
        String[] locales = new String[]{"en", "en_GB", "de", "zh", "hi", "bg", "ru", "ja", "as"};
        String[] zones = new String[]{"America/Los_Angeles", "America/Argentina/Buenos_Aires", "America/Buenos_Aires", "America/Havana", "Australia/ACT", "Australia/Sydney", "Europe/London", "Europe/Moscow", "Etc/GMT+3"};
        String[][] fields = new String[][]{{"2004-01-15T00:00:00Z", "Z", "ZZZZ", "z", "zzzz"}, {"2004-07-15T00:00:00Z", "Z", "ZZZZ", "z", "zzzz", "v", "vvvv"}};
        CLDRFile.Factory mainCldrFactory = CLDRFile.Factory.make("../../common/main" + File.separator, ".*");
        PrintWriter out = BagFormatter.openUTF8Writer((String)"../../dropbox/gen/", (String)"timezone_samples.txt");
        long[] offsetMillis = new long[1];
        ParsePosition parsePosition = new ParsePosition(0);
        for (int i = 0; i < locales.length; ++i) {
            String locale = locales[i];
            TimezoneFormatter tzf = new TimezoneFormatter(mainCldrFactory, locale, false).setSkipDraft(true);
            for (int j = 0; j < zones.length; ++j) {
                String zone = zones[j];
                for (int k = 0; k < fields.length; ++k) {
                    String type = fields[k][0];
                    Date datetime = ICUServiceBuilder.isoDateParse(type);
                    for (int m = 1; m < fields[k].length; ++m) {
                        String field = fields[k][m];
                        String formatted = tzf.getFormattedZone(zone, field, datetime.getTime(), false);
                        parsePosition.setIndex(0);
                        String parsed = tzf.parse(formatted, parsePosition, offsetMillis);
                        if (parsed == null) {
                            parsed = "FAILED PARSE";
                        } else if (parsed.length() == 0) {
                            parsed = TestUtilities.format(offsetMillis[0]);
                        }
                        out.println("{\"" + locale + "\",\t\"" + zone + "\",\t\"" + type + "\",\t\"" + field + "\",\t\"" + formatted + "\",\t\"" + parsed + "\"},");
                    }
                }
                out.println();
            }
            out.println("==========");
            out.println();
        }
        out.close();
    }

    private static String format(long offsetMillis) {
        String sign = "+";
        if ((offsetMillis /= 60000L) < 0L) {
            offsetMillis = -offsetMillis;
            sign = "-";
        }
        return sign + String.valueOf(offsetMillis / 60L) + ":" + String.valueOf(100L + offsetMillis % 60L).substring(1, 3);
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        MyHandler() {
        }

        public void handleAttributeDecl(String eName, String aName, String type, String mode, String value) {
            System.out.println("eName: " + eName + ",\t aName: " + aName + ",\t type: " + type + ",\t mode: " + mode + ",\t value: " + value);
        }

        public void handleElementDecl(String name, String model) {
            System.out.println("name: " + name + ",\t model: " + model);
        }

        public void handlePathValue(String path, String value) {
            System.out.println("path: " + path + ",\t value: " + value);
        }

        public void handleComment(String path, String comment) {
            System.out.println("path: " + path + ",\t comment: " + comment);
        }
    }
}

