/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Stack;
import org.unicode.cldr.util.CachingEntityResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLFileReader {
    static final boolean SHOW_ALL = false;
    public static int CONTENT_HANDLER = 1;
    public static int ERROR_HANDLER = 2;
    public static int LEXICAL_HANDLER = 4;
    public static int DECLARATION_HANDLER = 8;
    private MyContentHandler DEFAULT_DECLHANDLER = new MyContentHandler();
    private SimpleHandler simpleHandler;

    public XMLFileReader setHandler(SimpleHandler simpleHandler) {
        this.simpleHandler = simpleHandler;
        return this;
    }

    public XMLFileReader read(String fileName, int handlers, boolean validating) {
        try {
            XMLReader xmlReader = XMLFileReader.createXMLReader(validating);
            this.DEFAULT_DECLHANDLER.reset();
            if ((handlers & CONTENT_HANDLER) != 0) {
                xmlReader.setContentHandler(this.DEFAULT_DECLHANDLER);
            }
            if ((handlers & ERROR_HANDLER) != 0) {
                xmlReader.setErrorHandler(this.DEFAULT_DECLHANDLER);
            }
            if ((handlers & LEXICAL_HANDLER) != 0) {
                xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.DEFAULT_DECLHANDLER);
            }
            if ((handlers & DECLARATION_HANDLER) != 0) {
                xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", this.DEFAULT_DECLHANDLER);
            }
            FileInputStream fis = new FileInputStream(fileName);
            InputSource is = new InputSource(fis);
            is.setSystemId(fileName);
            xmlReader.parse(is);
            fis.close();
            return this;
        }
        catch (SAXParseException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + fileName).initCause(e);
        }
        catch (SAXException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + fileName).initCause(e);
        }
        catch (IOException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + fileName).initCause(e);
        }
    }

    public static String showSAX(SAXParseException exception) {
        return exception.getMessage() + ";\t SystemID: " + exception.getSystemId() + ";\t PublicID: " + exception.getPublicId() + ";\t LineNumber: " + exception.getLineNumber() + ";\t ColumnNumber: " + exception.getColumnNumber();
    }

    public static XMLReader createXMLReader(boolean validating) {
        String[] testList = new String[]{"org.apache.xerces.parsers.SAXParser", "org.apache.crimson.parser.XMLReaderImpl", "gnu.xml.aelfred2.XmlReader", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", ""};
        XMLReader result = null;
        for (int i = 0; i < testList.length; ++i) {
            try {
                result = testList[i].length() != 0 ? XMLReaderFactory.createXMLReader(testList[i]) : XMLReaderFactory.createXMLReader();
                result.setFeature("http://xml.org/sax/features/validation", validating);
                break;
            }
            catch (SAXException e1) {
                continue;
            }
        }
        if (result == null) {
            throw new NoClassDefFoundError("No SAX parser is available, or unable to set validation correctly");
        }
        try {
            result.setEntityResolver(new CachingEntityResolver());
        }
        catch (Throwable e) {
            System.err.println("WARNING: Can't set caching entity resolver  -  error " + e.toString());
            e.printStackTrace();
        }
        return result;
    }

    private class MyContentHandler
    implements ContentHandler,
    ErrorHandler,
    LexicalHandler,
    DeclHandler {
        StringBuffer chars = new StringBuffer();
        StringBuffer commentChars = new StringBuffer();
        Stack startElements = new Stack();
        StringBuffer tempPath = new StringBuffer();
        boolean lastIsStart = false;

        private MyContentHandler() {
        }

        public void reset() {
            this.chars.setLength(0);
            this.tempPath = new StringBuffer("/");
            this.startElements.clear();
            this.startElements.push("/");
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.lastIsStart) {
                this.chars.append(ch, start, length);
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.tempPath.setLength(0);
            this.tempPath.append(this.startElements.peek()).append('/').append(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.tempPath.append("[@").append(atts.getQName(i)).append("=\"").append(atts.getValue(i)).append("\"]");
            }
            this.startElements.push(this.tempPath.toString());
            this.chars.setLength(0);
            this.lastIsStart = true;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String startElement = (String)this.startElements.pop();
            if (this.lastIsStart) {
                XMLFileReader.this.simpleHandler.handlePathValue(startElement, this.chars.toString());
            }
            this.chars.setLength(0);
            this.lastIsStart = false;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.commentChars.append(ch, start, length);
            XMLFileReader.this.simpleHandler.handleComment((String)this.startElements.peek(), this.commentChars.toString());
            this.commentChars.setLength(0);
        }

        public void elementDecl(String name, String model) throws SAXException {
            XMLFileReader.this.simpleHandler.handleElementDecl(name, model);
        }

        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
            XMLFileReader.this.simpleHandler.handleAttributeDecl(eName, aName, type, mode, value);
        }

        public void startDocument() throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public void notationDecl(String name, String publicId, String systemId) {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
        }

        public void endEntity(String name) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    public static class SimpleHandler {
        public void handlePathValue(String path, String value) {
        }

        public void handleComment(String path, String comment) {
        }

        public void handleElementDecl(String name, String model) {
        }

        public void handleAttributeDecl(String eName, String aName, String type, String mode, String value) {
        }
    }
}

