/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.api.AttributeKey;
import org.unicode.cldr.api.CldrDataType;
import org.unicode.cldr.api.CldrPath;

public final class PathMatcher {
    private static final Pattern ROOT_PATH_SPEC = Pattern.compile("//(\\w+)(/|$)");
    private final Optional<PathMatcher> parent;
    private final ImmutableList<Predicate<CldrPath>> elementMatchers;
    private final int totalElementCount;
    private static final String WILDCARD = new String("*");
    private static final Pattern ELEMENT_START_REGEX = Pattern.compile("(\\*|[-:\\w]+)(?:/|\\[|$)");
    private static final Pattern ATTRIBUTE_REGEX = Pattern.compile("\\[@([-:\\w]+)=(?:\\*|\"([^\"]*)\")]");

    public static PathMatcher of(String pattern) {
        Matcher m3 = ROOT_PATH_SPEC.matcher(pattern);
        Preconditions.checkArgument(m3.lookingAt(), "invalid path pattern: %s", (Object)pattern);
        CldrDataType.forXmlName(m3.group(1));
        return new PathMatcher(null, PathMatcher.parse(pattern.substring(2)));
    }

    private PathMatcher(PathMatcher parent, List<Predicate<CldrPath>> elementMatchers) {
        this.parent = Optional.ofNullable(parent);
        this.elementMatchers = ImmutableList.copyOf(elementMatchers);
        this.totalElementCount = elementMatchers.size() + (parent != null ? parent.totalElementCount : 0);
    }

    public PathMatcher withSuffix(String pattern) {
        return new PathMatcher(this, PathMatcher.parse(pattern));
    }

    public boolean matches(CldrPath path) {
        if (!this.locallyMatches(path)) {
            return false;
        }
        if (!this.parent.isPresent()) {
            return true;
        }
        while (path.getLength() > this.totalElementCount - this.elementMatchers.size()) {
            path = path.getParent();
        }
        return this.parent.get().locallyMatches(path);
    }

    public boolean matchesPrefixOf(CldrPath path) {
        if (path.getLength() < this.totalElementCount) {
            return false;
        }
        while (path.getLength() > this.totalElementCount) {
            path = path.getParent();
        }
        return this.matches(path);
    }

    public boolean locallyMatches(CldrPath path) {
        return path.getLength() == this.totalElementCount && this.matchRegion(path, this.totalElementCount - this.elementMatchers.size());
    }

    private boolean matchRegion(CldrPath path, int offset) {
        Preconditions.checkPositionIndex(offset, path.getLength() - this.elementMatchers.size());
        int matchPathLength = offset + this.elementMatchers.size();
        while (path.getLength() > matchPathLength) {
            path = path.getParent();
        }
        return this.matchForward(path, this.elementMatchers.size() - 1);
    }

    private boolean matchForward(CldrPath path, int matcherIndex) {
        if (matcherIndex < 0) {
            return true;
        }
        return this.matchForward(path.getParent(), matcherIndex - 1) && ((Predicate)this.elementMatchers.get(matcherIndex)).test(path);
    }

    private static List<Predicate<CldrPath>> parse(String pattern) {
        ArrayList<Predicate<CldrPath>> specs = new ArrayList<Predicate<CldrPath>>();
        int pos = 0;
        while ((pos = PathMatcher.parse(pattern, pos, specs)) >= 0) {
        }
        return specs;
    }

    private static int parse(String pattern, int pos, List<Predicate<CldrPath>> specs) {
        Matcher m3 = ELEMENT_START_REGEX.matcher(pattern).region(pos, pattern.length());
        Preconditions.checkArgument(m3.lookingAt(), "invalid path pattern (index=%s): %s", pos, (Object)pattern);
        String name = m3.group(1);
        Map<String, String> attributes = ImmutableMap.of();
        pos = m3.end(1);
        if (pos < pattern.length() && pattern.charAt(pos) == '[') {
            attributes = new LinkedHashMap();
            do {
                m3 = ATTRIBUTE_REGEX.matcher(pattern).region(pos, pattern.length());
                Preconditions.checkArgument(m3.lookingAt(), "invalid path pattern (index=%s): %s", pos, (Object)pattern);
                String value = m3.group(2);
                attributes.put(m3.group(1), value != null ? value : WILDCARD);
            } while ((pos = m3.end()) < pattern.length() && pattern.charAt(pos) == '[');
        }
        Predicate<CldrPath> matcher = name.equals(WILDCARD) ? arg_0 -> PathMatcher.lambda$parse$0(new WildcardElementMatcher(attributes), arg_0) : new ElementMatcher(name, attributes)::match;
        specs.add(matcher);
        if (pos == pattern.length()) {
            return -1;
        }
        Preconditions.checkState(pattern.charAt(pos) == '/', "invalid path pattern (index=%s): %s", pos, (Object)pattern);
        return pos + 1;
    }

    private static /* synthetic */ boolean lambda$parse$0(WildcardElementMatcher rec$, CldrPath x$0) {
        return rec$.match(x$0);
    }

    private static final class WildcardElementMatcher {
        private final ImmutableMap<String, String> attributes;

        private WildcardElementMatcher(Map<String, String> attributes) {
            this.attributes = ImmutableMap.copyOf(attributes);
        }

        private boolean match(CldrPath path) {
            for (Map.Entry attribute : this.attributes.entrySet()) {
                String actual = path.get(AttributeKey.keyOf(path.getName(), (String)attribute.getKey()));
                if (actual == null) {
                    return false;
                }
                String expected = (String)attribute.getValue();
                if (expected == WILDCARD || expected.equals(actual)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class ElementMatcher {
        private final String name;
        private final ImmutableMap<AttributeKey, String> attributes;

        private ElementMatcher(String name, Map<String, String> attributes) {
            this.name = Preconditions.checkNotNull(name);
            this.attributes = attributes.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> AttributeKey.keyOf(name, (String)e.getKey()), Map.Entry::getValue));
        }

        boolean match(CldrPath path) {
            if (!path.getName().equals(this.name)) {
                return false;
            }
            for (Map.Entry e : this.attributes.entrySet()) {
                String actual = path.get((AttributeKey)e.getKey());
                if (actual == null) {
                    return false;
                }
                String expected = (String)e.getValue();
                if (expected == WILDCARD || expected.equals(actual)) continue;
                return false;
            }
            return true;
        }
    }
}

