/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.XLikelySubtags;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.SupplementalDataInfo;

public class XLocaleDistance {
    static final boolean PRINT_OVERRIDES = true;
    public static final int ABOVE_THRESHOLD = 100;
    @Deprecated
    public static final String ANY = "\ufffd";
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final CLDRFile english = CONFIG.getEnglish();
    static final SupplementalDataInfo SDI = CONFIG.getSupplementalDataInfo();
    static final Multimap<String, String> CONTAINER_TO_CONTAINED;
    static final Multimap<String, String> CONTAINER_TO_CONTAINED_FINAL;
    private static final Set<String> ALL_FINAL_REGIONS;
    private final DistanceTable languageDesired2Supported;
    private final RegionMapper regionMapper;
    private final int defaultLanguageDistance;
    private final int defaultScriptDistance;
    private final int defaultRegionDistance;
    private static final XLocaleDistance DEFAULT;

    private static String fixAny(String string) {
        return "*".equals(string) ? ANY : string;
    }

    private static List<Row.R4<String, String, Integer, Boolean>> xGetLanguageMatcherData() {
        return SDI.getLanguageMatcherData("written_new");
    }

    private static Collection<String> fill(String region, Multimap<String, String> toAddTo) {
        Set<String> contained = SDI.getContained(region);
        if (contained != null) {
            toAddTo.putAll(region, contained);
            for (String subregion : contained) {
                toAddTo.putAll(region, XLocaleDistance.fill(subregion, toAddTo));
            }
            return toAddTo.get(region);
        }
        return Collections.emptySet();
    }

    public XLocaleDistance(DistanceTable datadistancetable2, RegionMapper regionMapper) {
        this.languageDesired2Supported = datadistancetable2;
        this.regionMapper = regionMapper;
        StringDistanceNode languageNode = (StringDistanceNode)((StringDistanceTable)this.languageDesired2Supported).subtables.get(ANY).get(ANY);
        this.defaultLanguageDistance = languageNode.distance;
        StringDistanceNode scriptNode = (StringDistanceNode)((StringDistanceTable)languageNode.distanceTable).subtables.get(ANY).get(ANY);
        this.defaultScriptDistance = scriptNode.distance;
        DistanceNode regionNode = ((StringDistanceTable)scriptNode.distanceTable).subtables.get(ANY).get(ANY);
        this.defaultRegionDistance = regionNode.distance;
    }

    private static Map newMap() {
        return new TreeMap();
    }

    public int distance(ULocale desired, ULocale supported, int threshold, DistanceOption distanceOption) {
        XLikelySubtags.LSR supportedLSR = XLikelySubtags.LSR.fromMaximalized(supported);
        XLikelySubtags.LSR desiredLSR = XLikelySubtags.LSR.fromMaximalized(desired);
        return this.distanceRaw(desiredLSR, supportedLSR, threshold, distanceOption);
    }

    public int distanceRaw(XLikelySubtags.LSR desired, XLikelySubtags.LSR supported, int threshold, DistanceOption distanceOption) {
        return this.distanceRaw(desired.language, supported.language, desired.script, supported.script, desired.region, supported.region, threshold, distanceOption);
    }

    public int distanceRaw(String desiredLang, String supportedlang, String desiredScript, String supportedScript, String desiredRegion, String supportedRegion, int threshold, DistanceOption distanceOption) {
        int subdistance;
        Collection<String> supportedPartitions;
        boolean scriptFirst;
        Output<DistanceTable> subtable = new Output<DistanceTable>();
        int distance = this.languageDesired2Supported.getDistance(desiredLang, supportedlang, subtable, true);
        boolean bl = scriptFirst = distanceOption == DistanceOption.SCRIPT_FIRST;
        if (scriptFirst) {
            distance >>= 2;
        }
        if (distance < 0) {
            distance = 0;
        } else if (distance >= threshold) {
            return 100;
        }
        int scriptDistance = ((DistanceTable)subtable.value).getDistance(desiredScript, supportedScript, subtable, true);
        if (scriptFirst) {
            scriptDistance >>= 1;
        }
        if ((distance += scriptDistance) >= threshold) {
            return 100;
        }
        if (desiredRegion.equals(supportedRegion)) {
            return distance;
        }
        String desiredPartition = this.regionMapper.toId(desiredRegion);
        String supportedPartition = this.regionMapper.toId(supportedRegion);
        Collection<String> desiredPartitions = desiredPartition.isEmpty() ? this.regionMapper.macroToPartitions.get(desiredRegion) : null;
        Collection<String> collection = supportedPartitions = supportedPartition.isEmpty() ? this.regionMapper.macroToPartitions.get(supportedRegion) : null;
        if (desiredPartitions != null || supportedPartitions != null) {
            subdistance = 0;
            if (desiredPartitions == null) {
                desiredPartitions = Collections.singleton(desiredPartition);
            }
            if (supportedPartitions == null) {
                supportedPartitions = Collections.singleton(supportedPartition);
            }
            for (String desiredPartition2 : desiredPartitions) {
                for (String supportedPartition2 : supportedPartitions) {
                    int tempSubdistance = ((DistanceTable)subtable.value).getDistance(desiredPartition2, supportedPartition2, null, false);
                    if (subdistance >= tempSubdistance) continue;
                    subdistance = tempSubdistance;
                }
            }
        } else {
            subdistance = ((DistanceTable)subtable.value).getDistance(desiredPartition, supportedPartition, null, false);
        }
        return (distance += subdistance) >= threshold ? 100 : distance;
    }

    public static XLocaleDistance getDefault() {
        return DEFAULT;
    }

    private static void printMatchXml(List<String> desired, List<String> supported, Integer distance, Boolean oneway) {
        String desiredStr = Joiner.on("_").join(desired);
        String supportedStr = Joiner.on("_").join(supported);
        String desiredName = XLocaleDistance.fixedName(desired);
        String supportedName = XLocaleDistance.fixedName(supported);
        System.out.println("\t\t\t<languageMatch desired=\"" + desiredStr + "\"\tsupported=\"" + supportedStr + "\"\tdistance=\"" + distance + (oneway == false ? "" : "\"\toneway=\"true") + "\"/>\t<!-- " + desiredName + " \u21d2 " + supportedName + " -->");
    }

    private static String fixedName(List<String> match) {
        ArrayList<String> alt = new ArrayList<String>(match);
        StringBuilder result = new StringBuilder();
        switch (alt.size()) {
            case 3: {
                String region = (String)alt.get(2);
                if (region.equals("*") || region.startsWith("$")) {
                    result.append(region);
                } else {
                    result.append(english.getName(2, region));
                }
            }
            case 2: {
                String script = (String)alt.get(1);
                if (script.equals("*")) {
                    result.insert(0, script);
                } else {
                    result.insert(0, english.getName(2, script));
                }
            }
            case 1: {
                String language = (String)alt.get(0);
                if (language.equals("*")) {
                    result.insert(0, language);
                    break;
                }
                result.insert(0, english.getName(2, language));
            }
        }
        return Joiner.on("; ").join(alt);
    }

    public static void add(StringDistanceTable languageDesired2Supported, List<String> desired, List<String> supported, int percentage) {
        int size = desired.size();
        if (size != supported.size() || size < 1 || size > 3) {
            throw new IllegalArgumentException();
        }
        String desiredLang = XLocaleDistance.fixAny(desired.get(0));
        String supportedLang = XLocaleDistance.fixAny(supported.get(0));
        if (size == 1) {
            languageDesired2Supported.addSubtable(desiredLang, supportedLang, percentage);
        } else {
            String desiredScript = XLocaleDistance.fixAny(desired.get(1));
            String supportedScript = XLocaleDistance.fixAny(supported.get(1));
            if (size == 2) {
                languageDesired2Supported.addSubtables(desiredLang, supportedLang, desiredScript, supportedScript, percentage);
            } else {
                String desiredRegion = XLocaleDistance.fixAny(desired.get(2));
                String supportedRegion = XLocaleDistance.fixAny(supported.get(2));
                languageDesired2Supported.addSubtables(desiredLang, supportedLang, desiredScript, supportedScript, desiredRegion, supportedRegion, percentage);
            }
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean abbreviate) {
        return this.regionMapper + "\n" + this.languageDesired2Supported.toString(abbreviate);
    }

    static Set<String> getContainingMacrosFor(Collection<String> input, Set<String> output) {
        output.clear();
        for (Map.Entry<String, Collection<String>> entry : CONTAINER_TO_CONTAINED.asMap().entrySet()) {
            if (!input.containsAll(entry.getValue())) continue;
            output.add(entry.getKey());
        }
        return output;
    }

    public static <K, V> Multimap<K, V> invertMap(Map<V, K> map) {
        return Multimaps.invertFrom(Multimaps.forMap(map), ArrayListMultimap.create());
    }

    public Set<ULocale> getParadigms() {
        return this.regionMapper.paradigms;
    }

    public int getDefaultLanguageDistance() {
        return this.defaultLanguageDistance;
    }

    public int getDefaultScriptDistance() {
        return this.defaultScriptDistance;
    }

    public int getDefaultRegionDistance() {
        return this.defaultRegionDistance;
    }

    @Deprecated
    public StringDistanceTable internalGetDistanceTable() {
        return (StringDistanceTable)this.languageDesired2Supported;
    }

    public static void main(String[] args) {
        System.out.println(XLocaleDistance.getDefault().toString(true));
        DistanceTable table = XLocaleDistance.getDefault().languageDesired2Supported;
        DistanceTable compactedTable = table.compact();
        if (!table.equals(compactedTable)) {
            throw new IllegalArgumentException("Compaction isn't equal");
        }
    }

    static {
        TreeMultimap<String, String> containerToContainedTemp = TreeMultimap.create();
        XLocaleDistance.fill("001", containerToContainedTemp);
        CONTAINER_TO_CONTAINED = ImmutableMultimap.copyOf(containerToContainedTemp);
        for (String string : SDI.getContainers()) {
            Set<String> set = SDI.getContained(string);
            System.out.println(".putAll(\"" + string + "\", \"" + Joiner.on("\", \"").join(set) + "\")");
        }
        ImmutableMultimap.Builder<String[][], String> containerToFinalContainedBuilder = new ImmutableMultimap.Builder<String[][], String>();
        for (Map.Entry<String, Collection<String>> entry : CONTAINER_TO_CONTAINED.asMap().entrySet()) {
            String[][] container = entry.getKey();
            for (String contained : entry.getValue()) {
                if (SDI.getContained(contained) != null) continue;
                containerToFinalContainedBuilder.put(container, contained);
            }
        }
        CONTAINER_TO_CONTAINED_FINAL = containerToFinalContainedBuilder.build();
        ALL_FINAL_REGIONS = ImmutableSet.copyOf(CONTAINER_TO_CONTAINED_FINAL.get("001"));
        String[][] variableOverrides = new String[][]{{"$enUS", "AS+GU+MH+MP+PR+UM+US+VI"}, {"$cnsar", "HK+MO"}, {"$americas", "019"}, {"$maghreb", "MA+DZ+TN+LY+MR+EH"}};
        CharSequence[] paradigmRegions = new String[]{"en", "en-GB", "es", "es-419", "pt-BR", "pt-PT"};
        String[][] stringArrayArray = new String[][]{{"ar_*_$maghreb", "ar_*_$maghreb", "96"}, {"ar_*_$!maghreb", "ar_*_$!maghreb", "96"}, {"ar_*_*", "ar_*_*", "95"}, {"en_*_$enUS", "en_*_$enUS", "96"}, {"en_*_$!enUS", "en_*_$!enUS", "96"}, {"en_*_*", "en_*_*", "95"}, {"es_*_$americas", "es_*_$americas", "96"}, {"es_*_$!americas", "es_*_$!americas", "96"}, {"es_*_*", "es_*_*", "95"}, {"pt_*_$americas", "pt_*_$americas", "96"}, {"pt_*_$!americas", "pt_*_$!americas", "96"}, {"pt_*_*", "pt_*_*", "95"}, {"zh_Hant_$cnsar", "zh_Hant_$cnsar", "96"}, {"zh_Hant_$!cnsar", "zh_Hant_$!cnsar", "96"}, {"zh_Hant_*", "zh_Hant_*", "95"}, {"*_*_*", "*_*_*", "96"}};
        RegionMapper.Builder builder = new RegionMapper.Builder().addParadigms((String[])paradigmRegions);
        for (String[] variableRule : variableOverrides) {
            builder.add(variableRule[0], variableRule[1]);
        }
        System.out.println("\t\t<languageMatches type=\"written\" alt=\"enhanced\">");
        System.out.println("\t\t\t<paradigmLocales locales=\"" + String.join((CharSequence)" ", paradigmRegions) + "\"/>");
        for (String[] variableRule : variableOverrides) {
            System.out.println("\t\t\t<matchVariable id=\"" + variableRule[0] + "\" value=\"" + variableRule[1] + "\"/>");
        }
        StringDistanceTable defaultDistanceTable = new StringDistanceTable();
        RegionMapper defaultRegionMapper = builder.build();
        Splitter bar = Splitter.on('_');
        ArrayList[] sorted = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        for (Row.R4<String, String, Integer, Boolean> info : XLocaleDistance.xGetLanguageMatcherData()) {
            String desiredRaw = (String)info.get0();
            String string = (String)info.get1();
            List<String> desired = bar.splitToList(desiredRaw);
            List<String> supported = bar.splitToList(string);
            Boolean oneway = (Boolean)info.get3();
            Integer percentRaw = desiredRaw.equals("*_*") ? 50 : (Integer)info.get2();
            int distance = 100 - percentRaw;
            int size = desired.size();
            if (size == 3) continue;
            sorted[size - 1].add(Row.of(desired, supported, distance, oneway));
        }
        for (ArrayList arrayList : sorted) {
            boolean debug = false;
            for (Row.R4 item2 : arrayList) {
                List desired = (List)item2.get0();
                List supported = (List)item2.get1();
                Integer distance = (Integer)item2.get2();
                Boolean oneway = (Boolean)item2.get3();
                XLocaleDistance.add(defaultDistanceTable, desired, supported, distance);
                if (oneway != Boolean.TRUE && !desired.equals(supported)) {
                    XLocaleDistance.add(defaultDistanceTable, supported, desired, distance);
                }
                XLocaleDistance.printMatchXml(desired, supported, distance, oneway);
            }
        }
        for (ArrayList arrayList : stringArrayArray) {
            if (((String)((Object)arrayList[0])).equals("en_*_*") || ((String)((Object)arrayList[1])).equals("*_*_*")) {
                boolean debug = false;
            }
            ArrayList<String> desiredBase = new ArrayList<String>(bar.splitToList((CharSequence)((Object)arrayList[0])));
            ArrayList<String> supportedBase = new ArrayList<String>(bar.splitToList((CharSequence)((Object)arrayList[1])));
            Integer distance = 100 - Integer.parseInt((String)((Object)arrayList[2]));
            XLocaleDistance.printMatchXml(desiredBase, supportedBase, distance, false);
            Collection<String> desiredRegions = defaultRegionMapper.getIdsFromVariable((String)desiredBase.get(2));
            if (desiredRegions.isEmpty()) {
                throw new IllegalArgumentException("Bad region variable: " + (String)desiredBase.get(2));
            }
            Collection<String> supportedRegions = defaultRegionMapper.getIdsFromVariable((String)supportedBase.get(2));
            if (supportedRegions.isEmpty()) {
                throw new IllegalArgumentException("Bad region variable: " + (String)supportedBase.get(2));
            }
            for (String desiredRegion2 : desiredRegions) {
                desiredBase.set(2, desiredRegion2.toString());
                for (String supportedRegion2 : supportedRegions) {
                    supportedBase.set(2, supportedRegion2.toString());
                    XLocaleDistance.add(defaultDistanceTable, desiredBase, supportedBase, distance);
                    XLocaleDistance.add(defaultDistanceTable, supportedBase, desiredBase, distance);
                }
            }
        }
        System.out.println("\t\t</languageMatches>");
        DEFAULT = new XLocaleDistance(defaultDistanceTable.compact(), defaultRegionMapper);
    }

    @Deprecated
    public static abstract class DistanceTable {
        abstract int getDistance(String var1, String var2, Output<DistanceTable> var3, boolean var4);

        abstract Set<String> getCloser(int var1);

        abstract String toString(boolean var1);

        public DistanceTable compact() {
            return this;
        }

        public DistanceNode getInternalNode(String any, String any2) {
            return null;
        }

        public Map<String, Set<String>> getInternalMatches() {
            return null;
        }

        public boolean isEmpty() {
            return true;
        }
    }

    static class RegionMapper
    implements IdMapper<String, String> {
        final Multimap<String, String> variableToPartition;
        final Map<String, String> regionToPartition;
        final Multimap<String, String> macroToPartitions;
        final ImmutableSet<ULocale> paradigms;

        private RegionMapper(Multimap<String, String> variableToPartitionIn, Map<String, String> regionToPartitionIn, Multimap<String, String> macroToPartitionsIn, Set<ULocale> paradigmsIn) {
            this.variableToPartition = ImmutableMultimap.copyOf(variableToPartitionIn);
            this.regionToPartition = ImmutableMap.copyOf(regionToPartitionIn);
            this.macroToPartitions = ImmutableMultimap.copyOf(macroToPartitionsIn);
            this.paradigms = ImmutableSet.copyOf(paradigmsIn);
        }

        @Override
        public String toId(String region) {
            String result = this.regionToPartition.get(region);
            return result == null ? "" : result;
        }

        public Collection<String> getIdsFromVariable(String variable) {
            if (variable.equals("*")) {
                return Collections.singleton("*");
            }
            Collection<String> result = this.variableToPartition.get(variable);
            if (result == null || result.isEmpty()) {
                throw new IllegalArgumentException("Variable not defined: " + variable);
            }
            return result;
        }

        public Set<String> regions() {
            return this.regionToPartition.keySet();
        }

        public Set<String> variables() {
            return this.variableToPartition.keySet();
        }

        public String toString() {
            TreeMultimap partitionToVariables = Multimaps.invertFrom(this.variableToPartition, TreeMultimap.create());
            TreeMultimap partitionToRegions = TreeMultimap.create();
            for (Map.Entry<String, String> e : this.regionToPartition.entrySet()) {
                partitionToRegions.put(e.getValue(), e.getKey());
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("Partition \u27a0 Variables \u27a0 Regions (final)");
            for (Map.Entry entry : partitionToVariables.asMap().entrySet()) {
                buffer.append('\n');
                buffer.append((String)entry.getKey() + "\t" + entry.getValue() + "\t" + partitionToRegions.get((String)entry.getKey()));
            }
            buffer.append("\nMacro \u27a0 Partitions");
            for (Map.Entry<Object, Object> entry : this.macroToPartitions.asMap().entrySet()) {
                buffer.append('\n');
                buffer.append((String)entry.getKey() + "\t" + entry.getValue());
            }
            return buffer.toString();
        }

        static class Builder {
            private final Multimap<String, String> regionToRawPartition = TreeMultimap.create();
            private final RegionSet regionSet = new RegionSet();
            private final Set<ULocale> paradigms = new LinkedHashSet<ULocale>();

            Builder() {
            }

            void add(String variable, String barString) {
                Set tempRegions = this.regionSet.parseSet(barString);
                for (String region : tempRegions) {
                    this.regionToRawPartition.put(region, variable);
                }
                Set inverse = this.regionSet.inverse();
                String inverseVariable = "$!" + variable.substring(1);
                for (String region : inverse) {
                    this.regionToRawPartition.put(region, inverseVariable);
                }
            }

            public Builder addParadigms(String ... paradigmRegions) {
                for (String paradigm : paradigmRegions) {
                    this.paradigms.add(new ULocale(paradigm));
                }
                return this;
            }

            RegionMapper build() {
                IdMakerFull<Collection<String>> id = new IdMakerFull<Collection<String>>("partition");
                TreeMultimap<String, String> variableToPartitions = TreeMultimap.create();
                TreeMap<String, String> regionToPartition = new TreeMap<String, String>();
                TreeMultimap<String, String> partitionToRegions = TreeMultimap.create();
                for (Map.Entry<String, Collection<String>> e : this.regionToRawPartition.asMap().entrySet()) {
                    String region = e.getKey();
                    Collection<String> rawPartition = e.getValue();
                    String partition = String.valueOf((char)(945 + id.add(rawPartition)));
                    regionToPartition.put(region, partition);
                    partitionToRegions.put(partition, region);
                    for (String variable : rawPartition) {
                        variableToPartitions.put(variable, partition);
                    }
                }
                TreeMultimap<String, String> macroToPartitions = TreeMultimap.create();
                for (Map.Entry<String, Collection<String>> e : CONTAINER_TO_CONTAINED.asMap().entrySet()) {
                    String macro = e.getKey();
                    for (Map.Entry e2 : partitionToRegions.asMap().entrySet()) {
                        String partition = (String)e2.getKey();
                        if (Collections.disjoint(e.getValue(), e2.getValue())) continue;
                        macroToPartitions.put(macro, partition);
                    }
                }
                return new RegionMapper(variableToPartitions, regionToPartition, macroToPartitions, this.paradigms);
            }
        }
    }

    @Deprecated
    public static class StringDistanceTable
    extends DistanceTable {
        final Map<String, Map<String, DistanceNode>> subtables;

        StringDistanceTable(Map<String, Map<String, DistanceNode>> tables) {
            this.subtables = tables;
        }

        StringDistanceTable() {
            this(XLocaleDistance.newMap());
        }

        @Override
        public boolean isEmpty() {
            return this.subtables.isEmpty();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringDistanceTable)) {
                return false;
            }
            StringDistanceTable other = (StringDistanceTable)obj;
            return this.subtables.equals(other.subtables);
        }

        public int hashCode() {
            return this.subtables.hashCode();
        }

        @Override
        public int getDistance(String desired, String supported, Output<DistanceTable> distanceTable, boolean starEquals) {
            DistanceNode value;
            boolean star = false;
            Map<String, DistanceNode> sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                sub2 = this.subtables.get(XLocaleDistance.ANY);
                star = true;
            }
            if ((value = sub2.get(supported)) == null) {
                value = sub2.get(XLocaleDistance.ANY);
                if (value == null && !star && (value = (sub2 = this.subtables.get(XLocaleDistance.ANY)).get(supported)) == null) {
                    value = sub2.get(XLocaleDistance.ANY);
                }
                star = true;
            }
            if (distanceTable != null) {
                distanceTable.value = ((StringDistanceNode)value).distanceTable;
            }
            return starEquals && star && desired.equals(supported) ? 0 : value.distance;
        }

        public void copy(StringDistanceTable other) {
            for (Map.Entry<String, Map<String, DistanceNode>> e1 : other.subtables.entrySet()) {
                for (Map.Entry<String, DistanceNode> e2 : e1.getValue().entrySet()) {
                    DistanceNode value = e2.getValue();
                    DistanceNode distanceNode = this.addSubtable(e1.getKey(), e2.getKey(), value.distance);
                }
            }
        }

        DistanceNode addSubtable(String desired, String supported, int distance) {
            DistanceNode oldNode;
            Map sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                sub2 = XLocaleDistance.newMap();
                this.subtables.put(desired, sub2);
            }
            if ((oldNode = sub2.get(supported)) != null) {
                return oldNode;
            }
            StringDistanceNode newNode = new StringDistanceNode(distance);
            sub2.put(supported, newNode);
            return newNode;
        }

        private DistanceNode getNode(String desired, String supported) {
            Map<String, DistanceNode> sub2 = this.subtables.get(desired);
            if (sub2 == null) {
                return null;
            }
            return sub2.get(supported);
        }

        public void addSubtables(String desired, String supported, Predicate<DistanceNode> action) {
            boolean count = false;
            DistanceNode node = this.getNode(desired, supported);
            if (node == null) {
                Output<DistanceTable> node2 = new Output<DistanceTable>();
                int distance = this.getDistance(desired, supported, node2, true);
                node = this.addSubtable(desired, supported, distance);
                if (node2.value != null) {
                    ((StringDistanceNode)node).copyTables((StringDistanceTable)node2.value);
                }
            }
            action.apply(node);
        }

        public void addSubtables(String desiredLang, String supportedLang, String desiredScript, String supportedScript, int percentage) {
            boolean haveKeys = false;
            for (Map.Entry<String, Map<String, DistanceNode>> e1 : this.subtables.entrySet()) {
                String key1 = e1.getKey();
                boolean desiredIsKey = desiredLang.equals(key1);
                if (!desiredIsKey && !desiredLang.equals(XLocaleDistance.ANY)) continue;
                for (Map.Entry<String, DistanceNode> e2 : e1.getValue().entrySet()) {
                    String key2 = e2.getKey();
                    boolean supportedIsKey = supportedLang.equals(key2);
                    haveKeys |= desiredIsKey && supportedIsKey;
                    if (!supportedIsKey && !supportedLang.equals(XLocaleDistance.ANY)) continue;
                    DistanceNode value = e2.getValue();
                    ((StringDistanceTable)value.getDistanceTable()).addSubtable(desiredScript, supportedScript, percentage);
                }
            }
            StringDistanceTable dt = new StringDistanceTable();
            dt.addSubtable(desiredScript, supportedScript, percentage);
            CopyIfEmpty r = new CopyIfEmpty(dt);
            this.addSubtables(desiredLang, supportedLang, r);
        }

        public void addSubtables(String desiredLang, String supportedLang, String desiredScript, String supportedScript, String desiredRegion, String supportedRegion, int percentage) {
            boolean haveKeys = false;
            for (Map.Entry<String, Map<String, DistanceNode>> e1 : this.subtables.entrySet()) {
                String key1 = e1.getKey();
                boolean desiredIsKey = desiredLang.equals(key1);
                if (!desiredIsKey && !desiredLang.equals(XLocaleDistance.ANY)) continue;
                for (Map.Entry<String, DistanceNode> e2 : e1.getValue().entrySet()) {
                    String key2 = e2.getKey();
                    boolean supportedIsKey = supportedLang.equals(key2);
                    haveKeys |= desiredIsKey && supportedIsKey;
                    if (!supportedIsKey && !supportedLang.equals(XLocaleDistance.ANY)) continue;
                    StringDistanceNode value = (StringDistanceNode)e2.getValue();
                    ((StringDistanceTable)value.distanceTable).addSubtables(desiredScript, supportedScript, desiredRegion, supportedRegion, percentage);
                }
            }
            StringDistanceTable dt = new StringDistanceTable();
            dt.addSubtable(desiredRegion, supportedRegion, percentage);
            AddSub r = new AddSub(desiredScript, supportedScript, dt);
            this.addSubtables(desiredLang, supportedLang, r);
        }

        public String toString() {
            return this.toString(false);
        }

        @Override
        public String toString(boolean abbreviate) {
            return this.toString(abbreviate, "", new IdMakerFull<Object>("interner"), new StringBuilder()).toString();
        }

        public StringBuilder toString(boolean abbreviate, String indent, IdMakerFull<Object> intern, StringBuilder buffer) {
            Integer id;
            String indent2 = indent.isEmpty() ? "" : "\t";
            Integer n = id = abbreviate ? intern.getOldAndAdd(this.subtables) : null;
            if (id != null) {
                buffer.append(indent2).append('#').append(id).append('\n');
            } else {
                for (Map.Entry<String, Map<String, DistanceNode>> e1 : this.subtables.entrySet()) {
                    Map<String, DistanceNode> subsubtable = e1.getValue();
                    buffer.append(indent2).append(e1.getKey());
                    String indent3 = "\t";
                    Integer n2 = id = abbreviate ? intern.getOldAndAdd(subsubtable) : null;
                    if (id != null) {
                        buffer.append(indent3).append('#').append(id).append('\n');
                    } else {
                        for (Map.Entry<String, DistanceNode> e2 : subsubtable.entrySet()) {
                            DistanceNode value = e2.getValue();
                            buffer.append(indent3).append(e2.getKey());
                            Integer n3 = id = abbreviate ? intern.getOldAndAdd(value) : null;
                            if (id != null) {
                                buffer.append('\t').append('#').append(id).append('\n');
                            } else {
                                buffer.append('\t').append(value.distance);
                                DistanceTable distanceTable = value.getDistanceTable();
                                if (distanceTable != null) {
                                    Integer n4 = id = abbreviate ? intern.getOldAndAdd(distanceTable) : null;
                                    if (id != null) {
                                        buffer.append('\t').append('#').append(id).append('\n');
                                    } else {
                                        ((StringDistanceTable)distanceTable).toString(abbreviate, indent + "\t\t\t", intern, buffer);
                                    }
                                } else {
                                    buffer.append('\n');
                                }
                            }
                            indent3 = indent + '\t';
                        }
                    }
                    indent2 = indent;
                }
            }
            return buffer;
        }

        @Override
        public StringDistanceTable compact() {
            return new CompactAndImmutablizer().compact(this);
        }

        @Override
        public Set<String> getCloser(int threshold) {
            HashSet<String> result = new HashSet<String>();
            block0: for (Map.Entry<String, Map<String, DistanceNode>> e1 : this.subtables.entrySet()) {
                String desired = e1.getKey();
                for (Map.Entry<String, DistanceNode> e2 : e1.getValue().entrySet()) {
                    if (e2.getValue().distance >= threshold) continue;
                    result.add(desired);
                    continue block0;
                }
            }
            return result;
        }

        public Integer getInternalDistance(String a, String b) {
            Map<String, DistanceNode> subsub = this.subtables.get(a);
            if (subsub == null) {
                return null;
            }
            DistanceNode dnode = subsub.get(b);
            return dnode == null ? null : Integer.valueOf(dnode.distance);
        }

        @Override
        public DistanceNode getInternalNode(String a, String b) {
            Map<String, DistanceNode> subsub = this.subtables.get(a);
            if (subsub == null) {
                return null;
            }
            return subsub.get(b);
        }

        @Override
        public Map<String, Set<String>> getInternalMatches() {
            LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
            for (Map.Entry<String, Map<String, DistanceNode>> entry : this.subtables.entrySet()) {
                result.put(entry.getKey(), new LinkedHashSet<String>(entry.getValue().keySet()));
            }
            return result;
        }
    }

    static class StringDistanceNode
    extends DistanceNode {
        final DistanceTable distanceTable;

        public StringDistanceNode(int distance, DistanceTable distanceTable) {
            super(distance);
            this.distanceTable = distanceTable;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof StringDistanceNode)) {
                return false;
            }
            StringDistanceNode other = (StringDistanceNode)obj;
            return this.distance == other.distance && Objects.equal(this.distanceTable, other.distanceTable);
        }

        @Override
        public int hashCode() {
            return this.distance ^ Objects.hashCode(this.distanceTable);
        }

        StringDistanceNode(int distance) {
            this(distance, new StringDistanceTable());
        }

        public void addSubtables(String desiredSub, String supportedSub, CopyIfEmpty r) {
            ((StringDistanceTable)this.distanceTable).addSubtables(desiredSub, supportedSub, r);
        }

        @Override
        public String toString() {
            return "distance: " + this.distance + "\n" + this.distanceTable;
        }

        public void copyTables(StringDistanceTable value) {
            if (value != null) {
                ((StringDistanceTable)this.distanceTable).copy(value);
            }
        }

        @Override
        public DistanceTable getDistanceTable() {
            return this.distanceTable;
        }
    }

    @Deprecated
    public static class DistanceNode {
        final int distance;

        public DistanceNode(int distance) {
            this.distance = distance;
        }

        public DistanceTable getDistanceTable() {
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DistanceNode)) {
                return false;
            }
            DistanceNode other = (DistanceNode)obj;
            return this.distance == other.distance;
        }

        public int hashCode() {
            return this.distance;
        }

        public String toString() {
            return "\ndistance: " + this.distance;
        }
    }

    public static enum DistanceOption {
        NORMAL,
        SCRIPT_FIRST;

    }

    static class CompactAndImmutablizer
    extends IdMakerFull<Object> {
        CompactAndImmutablizer() {
        }

        StringDistanceTable compact(StringDistanceTable item) {
            if (this.toId(item) != null) {
                return this.intern(item);
            }
            return new StringDistanceTable(this.compact(item.subtables, 0));
        }

        <K, T> Map<K, T> compact(Map<K, T> item, int level) {
            if (this.toId(item) != null) {
                return this.intern(item);
            }
            LinkedHashMap<K, Object> copy = new LinkedHashMap<K, Object>();
            for (Map.Entry<K, T> entry : item.entrySet()) {
                T value = entry.getValue();
                if (value instanceof Map) {
                    copy.put(entry.getKey(), this.compact((Map)value, level + 1));
                    continue;
                }
                copy.put(entry.getKey(), this.compact((DistanceNode)value));
            }
            return ImmutableMap.copyOf(copy);
        }

        DistanceNode compact(DistanceNode item) {
            if (this.toId(item) != null) {
                return this.intern(item);
            }
            DistanceTable distanceTable = item.getDistanceTable();
            if (distanceTable == null || distanceTable.isEmpty()) {
                return new DistanceNode(item.distance);
            }
            return new StringDistanceNode(item.distance, this.compact((StringDistanceTable)((StringDistanceNode)item).distanceTable));
        }
    }

    private static class RegionSet {
        private final Set<String> tempRegions = new TreeSet<String>();
        private Operation operation = null;

        private RegionSet() {
        }

        private Set<String> parseSet(String barString) {
            int i;
            this.operation = Operation.add;
            int last = 0;
            this.tempRegions.clear();
            block4: for (i = 0; i < barString.length(); ++i) {
                char c = barString.charAt(i);
                switch (c) {
                    case '+': {
                        this.add(barString, last, i);
                        last = i + 1;
                        this.operation = Operation.add;
                        continue block4;
                    }
                    case '-': {
                        this.add(barString, last, i);
                        last = i + 1;
                        this.operation = Operation.remove;
                    }
                }
            }
            this.add(barString, last, i);
            return this.tempRegions;
        }

        private Set<String> inverse() {
            TreeSet<String> result = new TreeSet<String>(ALL_FINAL_REGIONS);
            result.removeAll(this.tempRegions);
            return result;
        }

        private void add(String barString, int last, int i) {
            if (i > last) {
                String region = barString.substring(last, i);
                this.changeSet(this.operation, region);
            }
        }

        private void changeSet(Operation operation, String region) {
            Collection<String> contained = CONTAINER_TO_CONTAINED_FINAL.get(region);
            if (contained != null && !contained.isEmpty()) {
                if (Operation.add == operation) {
                    this.tempRegions.addAll(contained);
                } else {
                    this.tempRegions.removeAll(contained);
                }
            } else if (Operation.add == operation) {
                this.tempRegions.add(region);
            } else {
                this.tempRegions.remove(region);
            }
        }

        private static enum Operation {
            add,
            remove;

        }
    }

    static class AddSub
    implements Predicate<DistanceNode> {
        private final String desiredSub;
        private final String supportedSub;
        private final CopyIfEmpty r;

        AddSub(String desiredSub, String supportedSub, StringDistanceTable distanceTableToCopy) {
            this.r = new CopyIfEmpty(distanceTableToCopy);
            this.desiredSub = desiredSub;
            this.supportedSub = supportedSub;
        }

        @Override
        public boolean apply(DistanceNode node) {
            if (node == null) {
                throw new IllegalArgumentException("bad structure");
            }
            ((StringDistanceNode)node).addSubtables(this.desiredSub, this.supportedSub, this.r);
            return true;
        }
    }

    static class CopyIfEmpty
    implements Predicate<DistanceNode> {
        private final StringDistanceTable toCopy;

        CopyIfEmpty(StringDistanceTable resetIfNotNull) {
            this.toCopy = resetIfNotNull;
        }

        @Override
        public boolean apply(DistanceNode node) {
            StringDistanceTable subtables = (StringDistanceTable)node.getDistanceTable();
            if (subtables.subtables.isEmpty()) {
                subtables.copy(this.toCopy);
            }
            return true;
        }
    }

    static class IdMakerFull<T>
    implements IdMapper<T, Integer> {
        private final Map<T, Integer> objectToInt = new HashMap<T, Integer>();
        private final List<T> intToObject = new ArrayList<T>();
        final String name;

        IdMakerFull(String name) {
            this.name = name;
        }

        IdMakerFull() {
            this("unnamed");
        }

        IdMakerFull(String name, T zeroValue) {
            this(name);
            this.add(zeroValue);
        }

        public Integer add(T source) {
            Integer result = this.objectToInt.get(source);
            if (result == null) {
                Integer newResult = this.intToObject.size();
                this.objectToInt.put(source, newResult);
                this.intToObject.add(source);
                return newResult;
            }
            return result;
        }

        @Override
        public Integer toId(T source) {
            return this.objectToInt.get(source);
        }

        public T fromId(int id) {
            return this.intToObject.get(id);
        }

        public T intern(T source) {
            return this.fromId(this.add(source));
        }

        public int size() {
            return this.intToObject.size();
        }

        public Integer getOldAndAdd(T source) {
            Integer result = this.objectToInt.get(source);
            if (result == null) {
                Integer newResult = this.intToObject.size();
                this.objectToInt.put(source, newResult);
                this.intToObject.add(source);
            }
            return result;
        }

        public String toString() {
            return this.size() + ": " + this.intToObject;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IdMakerFull)) {
                return false;
            }
            IdMakerFull other = (IdMakerFull)obj;
            return this.intToObject.equals(other.intToObject);
        }

        public int hashCode() {
            return this.intToObject.hashCode();
        }
    }

    private static interface IdMapper<K, V> {
        public V toId(K var1);
    }
}

