/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

public enum ModifierKey {
    COMMAND(Variant.NONE, "cmd"),
    CONTROL(Variant.PARENT, "ctrl"),
    CONTROL_LEFT(Variant.LEFT, "ctrl"),
    CONTROL_RIGHT(Variant.RIGHT, "ctrl"),
    ALT(Variant.PARENT, "alt"),
    ALT_LEFT(Variant.LEFT, "alt"),
    ALT_RIGHT(Variant.RIGHT, "alt"),
    OPTION(Variant.PARENT, "opt"),
    OPTION_LEFT(Variant.LEFT, "opt"),
    OPTION_RIGHT(Variant.RIGHT, "opt"),
    CAPSLOCK(Variant.NONE, "caps"),
    SHIFT(Variant.PARENT, "shift"),
    SHIFT_LEFT(Variant.LEFT, "shift"),
    SHIFT_RIGHT(Variant.RIGHT, "shift");

    private static final ImmutableMap<String, ModifierKey> STRING_TO_MODIFIER_KEY;
    private static final ImmutableSet<ModifierKey> PARENTS;
    private static final ImmutableSet<ModifierKey> SINGLES;
    private final Variant variant;
    private final String keyType;

    private ModifierKey(Variant variant, String keyType) {
        this.variant = Preconditions.checkNotNull(variant);
        this.keyType = Preconditions.checkNotNull(keyType);
    }

    public static ModifierKey fromString(String string) {
        ModifierKey key = STRING_TO_MODIFIER_KEY.get(Preconditions.checkNotNull(string));
        Preconditions.checkArgument(key != null, string);
        return key;
    }

    public static ImmutableSet<ModifierKey> parents() {
        return PARENTS;
    }

    public static ImmutableSet<ModifierKey> singles() {
        return SINGLES;
    }

    public ModifierKey sibling() {
        if (this.variant == Variant.PARENT) {
            return this;
        }
        return ModifierKey.fromString(this.keyType + (Object)((Object)this.variant.opposite()));
    }

    public ModifierKey parent() {
        if (this.variant == Variant.PARENT) {
            return this;
        }
        return ModifierKey.fromString(this.keyType);
    }

    public ImmutableList<ModifierKey> children() {
        if (this.variant != Variant.PARENT) {
            return ImmutableList.of();
        }
        return ImmutableList.of(ModifierKey.fromString(this.keyType + (Object)((Object)Variant.LEFT)), ModifierKey.fromString(this.keyType + (Object)((Object)Variant.RIGHT)));
    }

    public String toString() {
        return this.keyType + this.variant.value;
    }

    static {
        STRING_TO_MODIFIER_KEY = Maps.uniqueIndex(Lists.newArrayList(ModifierKey.values()), Functions.toStringFunction());
        PARENTS = ImmutableSet.of(CONTROL, ALT, OPTION, SHIFT);
        SINGLES = ImmutableSet.of(COMMAND, CAPSLOCK);
    }

    private static enum Variant {
        PARENT(""),
        LEFT("L"),
        RIGHT("R"),
        NONE("");

        final String value;

        private Variant(String value) {
            this.value = Preconditions.checkNotNull(value);
        }

        Variant opposite() {
            return this == LEFT ? RIGHT : (this == RIGHT ? LEFT : this);
        }

        public String toString() {
            return this.value;
        }
    }
}

