/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;

public class CheckChildren
extends FactoryCheckCLDR {
    CLDRFile[] immediateChildren;
    Map<String, String> tempSet = new HashMap<String, String>();

    public CheckChildren(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (this.immediateChildren == null) {
            return this;
        }
        if (this.isSkipTest()) {
            return this;
        }
        if (fullPath == null) {
            return this;
        }
        if (value == null) {
            return this;
        }
        String winningValue = this.getCldrFileToCheck().getWinningValue(fullPath);
        if (!value.equals(winningValue)) {
            return this;
        }
        this.tempSet.clear();
        for (int i = 0; i < this.immediateChildren.length; ++i) {
            String otherValue = this.immediateChildren[i].getWinningValue(path);
            if (!otherValue.equals(CldrUtility.NO_INHERITANCE_MARKER)) {
                this.tempSet.put(this.immediateChildren[i].getLocaleID(), otherValue);
                continue;
            }
            this.tempSet.put(this.immediateChildren[i].getLocaleID(), value);
        }
        if (this.tempSet.values().contains(value)) {
            return this;
        }
        CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.valueAlwaysOverridden).setCheckOnSubmit(false).setMessage("Value always overridden in children: {0}", this.tempSet.keySet().toString());
        result.add(item);
        this.tempSet.clear();
        return this;
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        if (cldrFileToCheck.getLocaleID().equals("root")) {
            return this;
        }
        if (CheckCLDR.Phase.FINAL_TESTING != this.getPhase() && CheckCLDR.Phase.BUILD != this.getPhase()) {
            this.setSkipTest(true);
            return this;
        }
        this.setSkipTest(false);
        ArrayList<CLDRFile> iChildren = new ArrayList<CLDRFile>();
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        CLDRLocale myLocale = CLDRLocale.getInstance(cldrFileToCheck.getLocaleID());
        if (myLocale.getCountry() != null && myLocale.getCountry().length() == 2) {
            this.immediateChildren = null;
            return this;
        }
        Set<CLDRLocale> subLocales = this.getFactory().subLocalesOf(myLocale);
        if (subLocales == null) {
            return this;
        }
        for (CLDRLocale locale : subLocales) {
            CLDRFile child = this.getFactory().make(locale.getBaseName(), true);
            if (child == null) {
                CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.nullChildFile).setMessage("Null file from: {0}", locale);
                possibleErrors.add(item);
                continue;
            }
            iChildren.add(child);
        }
        if (iChildren.size() == 0) {
            this.immediateChildren = null;
        } else {
            this.immediateChildren = new CLDRFile[iChildren.size()];
            this.immediateChildren = iChildren.toArray(this.immediateChildren);
        }
        return this;
    }
}

