/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.XMLSource;

public class CLDRFilePseudolocalizer {
    private static final Pattern NUMERIC_PLACEHOLDER = Pattern.compile("\\{\\d+\\}");
    private static final Pattern QUOTED_TEXT = Pattern.compile("'.*?'");
    private static final String PSEUDOLOCALES_DIRECTORY = "pseudolocales";
    private static final String ORIGINAL_LOCALE = "en";
    private static final String EXEMPLARS_PATH = "/exemplarCharactersx";
    private static final String EXEMPLAR_PATH = "//ldml/characters/exemplarCharacters";
    private static final String EXEMPLAR_AUX_PATH = "//ldml/characters/exemplarCharacters[@type=\"auxiliary\"]";
    private static final String TERRITORY_PATTERN = "//ldml/localeDisplayNames/territories/territory[@type=\"%s\"]";
    private static final String[] EXCLUDE_LIST = new String[]{"/exemplarCharacters", "/delimiters", "/contextTransforms", "/numbers", "/units", "narrow", "localeDisplayPattern", "timeZoneNames/fallbackFormat"};
    private static final String[] PATTERN_LIST = new String[]{"/pattern", "FormatItem", "hourFormat"};
    private String outputLocale;
    private Pseudolocalizer pseudolocalizer;

    public CLDRFilePseudolocalizer(String outputLocale, Pseudolocalizer pseudolocalizer) {
        this.outputLocale = outputLocale;
        this.pseudolocalizer = pseudolocalizer;
    }

    public static CLDRFilePseudolocalizer createInstanceXA() {
        return new CLDRFilePseudolocalizer("en_XA", new PseudolocalizerXA());
    }

    public static CLDRFilePseudolocalizer createInstanceXB() {
        return new CLDRFilePseudolocalizer("ar_XB", new PseudolocalizerXB());
    }

    private String transformValue(String path, String value) {
        if (this.containsOneOf(path, EXCLUDE_LIST)) {
            return value;
        }
        if (this.containsOneOf(path, PATTERN_LIST)) {
            return this.createMessage(value, QUOTED_TEXT, true);
        }
        return this.createMessage(value, NUMERIC_PLACEHOLDER, false);
    }

    private boolean containsOneOf(String string, String[] substrings) {
        for (String substring : substrings) {
            if (!string.contains(substring)) continue;
            return true;
        }
        return false;
    }

    private String pseudolocalizeFragment(String text, boolean localizable) {
        return localizable ? this.pseudolocalizer.fragment(text) : text;
    }

    private String createMessage(String text, Pattern pattern, boolean matchIsLocalizable) {
        StringBuffer buffer = new StringBuffer(this.pseudolocalizer.start());
        Matcher match = pattern.matcher(text);
        int start = 0;
        this.pseudolocalizer.setPattern(matchIsLocalizable);
        while (match.find()) {
            if (match.start() > start) {
                buffer.append(this.pseudolocalizeFragment(text.substring(start, match.start()), !matchIsLocalizable));
            }
            buffer.append(this.pseudolocalizeFragment(match.group(), matchIsLocalizable));
            start = match.end();
        }
        if (start < text.length()) {
            buffer.append(this.pseudolocalizeFragment(text.substring(start), !matchIsLocalizable));
        }
        buffer.append(this.pseudolocalizer.end());
        return buffer.toString();
    }

    private String mergeExemplars(String value) {
        String pseudolocalized = this.createMessage(value, NUMERIC_PLACEHOLDER, false);
        StringBuffer result = new StringBuffer(value.substring(0, value.length() - 1));
        int CLOSING_BRACKET = 93;
        for (int i = 0; i < pseudolocalized.length(); ++i) {
            String chunk;
            char c = pseudolocalized.charAt(i);
            if (c == ']' || result.indexOf(chunk = Character.isAlphabetic(c) ? String.valueOf(c) : String.format("\\u%04X", c)) != -1 || result.indexOf(String.valueOf(c)) != -1) continue;
            result.append(' ');
            result.append(chunk);
        }
        result.append(']');
        return result.toString();
    }

    public CLDRFile generate() {
        Factory factory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile input = factory.make(ORIGINAL_LOCALE, false);
        SimpleXMLSource outputSource = new SimpleXMLSource(this.outputLocale);
        for (String xpath : input) {
            String newValue;
            String fullPath = input.getFullXPath(xpath);
            String value = input.getStringValue(xpath);
            if (value.isEmpty() || (newValue = this.transformValue(xpath, value)).equals(value)) continue;
            outputSource.putValueAtPath(fullPath, newValue);
        }
        outputSource.putValueAtPath(EXEMPLAR_AUX_PATH, this.mergeExemplars(input.getStringValue(EXEMPLAR_PATH)));
        this.addTerritory(outputSource, "XA");
        this.addTerritory(outputSource, "XB");
        return new CLDRFile(outputSource);
    }

    private void addTerritory(XMLSource outputSource, String territory) {
        String territoryPath = String.format(TERRITORY_PATTERN, territory);
        outputSource.putValueAtPath(territoryPath, String.format("[%s]", territory));
    }

    public String generateAndSave() throws Exception {
        CLDRFile output = this.generate();
        String outputDir = CLDRPaths.GEN_DIRECTORY + "main" + File.separator + PSEUDOLOCALES_DIRECTORY + File.separator;
        String outputFile = output.getLocaleID() + ".xml";
        PrintWriter out = FileUtilities.openUTF8Writer(outputDir, outputFile);
        output.write(out);
        out.close();
        return outputDir + outputFile;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(CLDRFilePseudolocalizer.createInstanceXA().generateAndSave());
        System.out.println(CLDRFilePseudolocalizer.createInstanceXB().generateAndSave());
    }

    private static class Pseudolocalizer {
        private boolean pattern = false;

        public boolean getPattern() {
            return this.pattern;
        }

        public String start() {
            return "";
        }

        public String end() {
            return "";
        }

        public String fragment(String text) {
            return text;
        }

        protected void setPattern(boolean pattern) {
            this.pattern = pattern;
        }
    }

    private static class PseudolocalizerXA
    extends Pseudolocalizer {
        private static final String[] NUMBERS = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty", "twentyone", "twentytwo", "twentythree", "twentyfour", "twentyfive", "twentysix", "twentyseven", "twentyeight", "twentynine", "thirty", "thirtyone", "thirtytwo", "thirtythree", "thirtyfour", "thirtyfive", "thirtysix", "thirtyseven", "thirtyeight", "thirtynine", "forty"};
        private static final Map<Integer, String> REPLACEMENTS = PseudolocalizerXA.buildReplacementsTable();
        private int charCount = 0;

        private PseudolocalizerXA() {
        }

        private static Map<Integer, String> buildReplacementsTable() {
            HashMap<Integer, String> table = new HashMap<Integer, String>();
            table.put(32, "\u2003");
            table.put(33, "\u00a1");
            table.put(34, "\u2033");
            table.put(35, "\u266f");
            table.put(36, "\u20ac");
            table.put(37, "\u2030");
            table.put(38, "\u214b");
            table.put(42, "\u204e");
            table.put(43, "\u207a");
            table.put(44, "\u060c");
            table.put(45, "\u2010");
            table.put(46, "\u00b7");
            table.put(47, "\u2044");
            table.put(48, "\u24ea");
            table.put(49, "\u2460");
            table.put(50, "\u2461");
            table.put(51, "\u2462");
            table.put(52, "\u2463");
            table.put(53, "\u2464");
            table.put(54, "\u2465");
            table.put(55, "\u2466");
            table.put(56, "\u2467");
            table.put(57, "\u2468");
            table.put(58, "\u2236");
            table.put(59, "\u204f");
            table.put(60, "\u2264");
            table.put(61, "\u2242");
            table.put(62, "\u2265");
            table.put(63, "\u00bf");
            table.put(64, "\u055e");
            table.put(65, "\u00c5");
            table.put(66, "\u0181");
            table.put(67, "\u00c7");
            table.put(68, "\u00d0");
            table.put(69, "\u00c9");
            table.put(70, "\u0191");
            table.put(71, "\u011c");
            table.put(72, "\u0124");
            table.put(73, "\u00ce");
            table.put(74, "\u0134");
            table.put(75, "\u0136");
            table.put(76, "\u013b");
            table.put(77, "\u1e40");
            table.put(78, "\u00d1");
            table.put(79, "\u00d6");
            table.put(80, "\u00de");
            table.put(81, "\u01ea");
            table.put(82, "\u0154");
            table.put(83, "\u0160");
            table.put(84, "\u0162");
            table.put(85, "\u00db");
            table.put(86, "\u1e7c");
            table.put(87, "\u0174");
            table.put(88, "\u1e8a");
            table.put(89, "\u00dd");
            table.put(90, "\u017d");
            table.put(91, "\u2045");
            table.put(92, "\u2216");
            table.put(93, "\u2046");
            table.put(94, "\u02c4");
            table.put(95, "\u203f");
            table.put(96, "\u2035");
            table.put(97, "\u00e5");
            table.put(98, "\u0180");
            table.put(99, "\u00e7");
            table.put(100, "\u00f0");
            table.put(101, "\u00e9");
            table.put(102, "\u0192");
            table.put(103, "\u011d");
            table.put(104, "\u0125");
            table.put(105, "\u00ee");
            table.put(106, "\u0135");
            table.put(107, "\u0137");
            table.put(108, "\u013c");
            table.put(109, "\u0271");
            table.put(110, "\u00f1");
            table.put(111, "\u00f6");
            table.put(112, "\u00fe");
            table.put(113, "\u01eb");
            table.put(114, "\u0155");
            table.put(115, "\u0161");
            table.put(116, "\u0163");
            table.put(117, "\u00fb");
            table.put(118, "\u1e7d");
            table.put(119, "\u0175");
            table.put(120, "\u1e8b");
            table.put(121, "\u00fd");
            table.put(122, "\u017e");
            table.put(124, "\u00a6");
            table.put(126, "\u02de");
            return table;
        }

        @Override
        public String start() {
            this.charCount = 0;
            return "[";
        }

        @Override
        public String end() {
            String word;
            StringBuilder expansionText = new StringBuilder();
            int wordIndex = 0;
            for (int expansion = (this.charCount + 1) / 2; expansion > 0; expansion -= word.length() + 1) {
                word = NUMBERS[wordIndex++ % NUMBERS.length];
                expansionText.append(' ');
                if (this.getPattern()) {
                    expansionText.append('\'');
                }
                expansionText.append(word);
                if (!this.getPattern()) continue;
                expansionText.append('\'');
            }
            expansionText.append(']');
            return expansionText.toString();
        }

        @Override
        public String fragment(String text) {
            int codePoint;
            StringBuilder buf = new StringBuilder();
            for (int index = 0; index < text.length(); index += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(index);
                ++this.charCount;
                String replacement = REPLACEMENTS.get(codePoint);
                if (replacement != null) {
                    buf.append(replacement);
                    continue;
                }
                buf.appendCodePoint(codePoint);
            }
            return buf.toString();
        }
    }

    private static class PseudolocalizerXB
    extends Pseudolocalizer {
        private static final String RLO = "\u202e";
        private static final String RLM = "\u200f";
        private static final String PDF = "\u202c";
        private static final String BIDI_PREFIX = "\u200f\u202e";
        private static final String BIDI_POSTFIX = "\u202c\u200f";

        private PseudolocalizerXB() {
        }

        @Override
        public String fragment(String text) {
            StringBuilder output = new StringBuilder();
            boolean wrapping = false;
            int index = 0;
            while (index < text.length()) {
                boolean needsWrap;
                int codePoint = text.codePointAt(index);
                index += Character.charCount(codePoint);
                byte directionality = Character.getDirectionality(codePoint);
                boolean bl = needsWrap = directionality == 0;
                if (needsWrap != wrapping) {
                    wrapping = needsWrap;
                    output.append(wrapping ? BIDI_PREFIX : BIDI_POSTFIX);
                }
                output.appendCodePoint(codePoint);
            }
            if (wrapping) {
                output.append(BIDI_POSTFIX);
            }
            return output.toString();
        }
    }
}

