/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.LocaleData;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.HashSet;

public class CollectExemplars {
    public static void main(String[] args) {
        String stock = "en|ar|de|es|fr|it|ja|ko|nl|pl|ru|th|tr|pt|zh|zh_Hant|bg|ca|cs|da|el|fa|fi|fil|hi|hr|hu|id|lt|lv|ro|sk|sl|sr|sv|uk|vi|he|nb|et|ms|am|bn|gu|is|kn|ml|mr|sw|ta|te|ur|eu|gl|af|zu|en_GB|es_419|pt_PT|fr_CA|zh_HK";
        HashSet<String> REGION_LOCALES = new HashSet<String>(Arrays.asList("en|ar|de|es|fr|it|ja|ko|nl|pl|ru|th|tr|pt|zh|zh_Hant|bg|ca|cs|da|el|fa|fi|fil|hi|hr|hu|id|lt|lv|ro|sk|sl|sr|sv|uk|vi|he|nb|et|ms|am|bn|gu|is|kn|ml|mr|sw|ta|te|ur|eu|gl|af|zu|en_GB|es_419|pt_PT|fr_CA|zh_HK".split("\\|")));
        UnicodeSet target = new UnicodeSet();
        CollectExemplars.add("special", null, new UnicodeSet("[\u3400-\u4db5\u4e00-\u9fcc\ufa0e\ufa0f\ufa11\ufa13\ufa14\ufa1f\ufa21\ufa23\ufa24\ufa27-\ufa29\ud840\udc00-\ud869\uded6 \ud869\udf00-\ud86d\udf34\ud86d\udf40-\ud86e\udc1d]"), target);
        for (ULocale locale : ULocale.getAvailableLocales()) {
            if (!REGION_LOCALES.contains(locale.toString())) continue;
            UnicodeSet mainExemplars = LocaleData.getExemplarSet(locale, 2);
            CollectExemplars.add("main", locale, mainExemplars, target);
        }
        for (ULocale locale : ULocale.getAvailableLocales()) {
            if (!REGION_LOCALES.contains(locale.toString())) continue;
            UnicodeSet auxExemplars = LocaleData.getExemplarSet(locale, 2, 1);
            CollectExemplars.add("aux", locale, auxExemplars, target);
        }
        System.out.println("Added\t" + target.toPattern(false));
        UnicodeSet toRemove = new UnicodeSet();
        block2: for (String s2 : target) {
            int cp;
            int len = s2.codePointCount(0, s2.length());
            if (len <= 1) continue;
            for (int i = 0; i < s2.length(); i += Character.charCount(cp)) {
                cp = s2.codePointAt(0);
                if (!target.contains(cp)) continue block2;
            }
            toRemove.add(s2);
        }
        CollectExemplars.removing("Collapsing", target, toRemove);
        CollectExemplars.removing("whitespace, controls, symbol, punct", target, new UnicodeSet("[[:z:][:c:][:s:][:p:]]"));
        CollectExemplars.removing("numbers", target, new UnicodeSet("[:n:]"));
        CollectExemplars.add("ASCII numbers", null, new UnicodeSet("[0-9]"), target);
        CollectExemplars.add("joiners", null, new UnicodeSet("[:join_controls:]"), target);
        UnicodeSet exclude = new UnicodeSet("[[:sc=common:][:sc=hebr:][:sc=zinh:]&[:mn:]]");
        CollectExemplars.removing("certain non-spacing", target, exclude);
        System.out.println("Result\t" + target.toPattern(false));
    }

    public static void removing(String title, UnicodeSet target, UnicodeSet toRemove) {
        UnicodeSet diff = new UnicodeSet(toRemove).retainAll(target);
        System.out.println(title + "\t" + diff.toPattern(false));
        target.removeAll(diff);
    }

    private static void add(String title, ULocale locale, UnicodeSet mainExemplars, UnicodeSet target) {
        if (!target.containsAll(mainExemplars)) {
            UnicodeSet diff = new UnicodeSet(mainExemplars).removeAll(target);
            System.out.println(locale + "\t" + title + "\tadding\t" + diff.toPattern(false));
            target.addAll(diff);
        }
    }
}

