/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateBcp47Text {
    static final boolean SHOW_ONLY_WITHOUT_DESCRIPTION = false;
    static SupplementalDataInfo info = SupplementalDataInfo.getInstance();
    static Map<Row.R2<String, String>, String> deprecatedMap = info.getBcp47Deprecated();
    Relation<String, String> extension2Keys = info.getBcp47Extension2Keys();
    Relation<String, String> keys2subtypes = info.getBcp47Keys();
    Relation<Row.R2<String, String>, String> keySubtype2Aliases = info.getBcp47Aliases();
    Map<Row.R2<String, String>, String> keySubtype2Description = info.getBcp47Descriptions();
    Map<Row.R2<String, String>, String> keySubtype2Since = info.getBcp47Since();
    Row.R2<String, String> probe = Row.of("", "");

    public static void main(String[] args) throws IOException {
        new GenerateBcp47Text().run();
    }

    private void run() throws IOException {
        for (Map.Entry<String, Set<String>> extensionAndKeys : this.extension2Keys.keyValuesSet()) {
            String extension = extensionAndKeys.getKey();
            PrintWriter out = FileUtilities.openUTF8Writer(FormattedFileWriter.CHART_TARGET_DIR, "bcp47-" + extension + ".txt");
            this.showField(out, "Version", ToolConstants.CHART_DISPLAY_VERSION);
            this.showField(out, "Extension", extension);
            Set<String> keys = extensionAndKeys.getValue();
            for (String string : keys) {
                this.showRecord(out, extension, string, "");
            }
            for (Map.Entry entry : this.keys2subtypes.keyValuesSet()) {
                String key = (String)entry.getKey();
                if (!keys.contains(key)) continue;
                Set subtypes = (Set)entry.getValue();
                for (String subtype : subtypes) {
                    this.showRecord(out, extension, key, subtype);
                }
            }
            out.close();
        }
    }

    private void showRecord(PrintWriter out, String extension, String key, String subtype) {
        this.probe.set0(key).set1(subtype);
        String description = this.keySubtype2Description.get(this.probe);
        String since = this.keySubtype2Since.get(this.probe);
        out.println("%%");
        this.showField(out, "Key", key);
        this.showField(out, "Subtype", subtype);
        this.showField(out, "Aliases", this.keySubtype2Aliases.get(this.probe));
        this.showField(out, "Description", description);
        this.showField(out, "Since", since);
        String deprecatedValue = deprecatedMap.get(Row.of(key, subtype));
        if (!"false".equals(deprecatedValue)) {
            this.showField(out, "Deprecated", deprecatedValue);
        }
    }

    private void showField(PrintWriter out, String title, Collection<String> set) {
        this.showField(out, title, set == null || set.isEmpty() ? null : Joiner.on(", ").join(set));
    }

    private void showField(PrintWriter out, String title, String item) {
        out.write(item == null || item.isEmpty() ? "" : title + ": " + item + System.lineSeparator());
    }
}

