/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.util.Map;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LsrvCanonicalizer;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TempPrintWriter;

public class GenerateLocaleIDTestData {
    static final LsrvCanonicalizer rrs = LsrvCanonicalizer.getInstance();

    public static void main(String[] args) throws IOException {
        try (TempPrintWriter pw = TempPrintWriter.openUTF8Writer(CLDRPaths.TEST_DATA + "localeIdentifiers", "localeCanonicalization.txt");){
            pw.println("# Test data for locale identifier canonicalization");
            pw.println(CldrUtility.getCopyrightString("#  "));
            pw.println("#\n# Format:\n# <source locale identifier>\t;\t<expected canonicalized locale identifier>\n#\n# The data lines are divided into 4 sets:\n#   " + (Object)((Object)LsrvCanonicalizer.TestDataTypes.explicit) + ":    a short list of explicit test cases.\n#   " + (Object)((Object)LsrvCanonicalizer.TestDataTypes.fromAliases) + ": test cases generated from the alias data.\n#   " + (Object)((Object)LsrvCanonicalizer.TestDataTypes.decanonicalized) + ": test cases generated by reversing the normalization process.\n#   " + (Object)((Object)LsrvCanonicalizer.TestDataTypes.withIrrelevants) + ": test cases generated from the others by adding irrelevant fields where possible,\n#                           to ensure that the canonicalization implementation is not sensitive to irrelevant fields. These include:\n#     Language: " + rrs.getIrrelevantField(StandardCodes.LstrType.language) + "\n#     Script:   " + rrs.getIrrelevantField(StandardCodes.LstrType.script) + "\n#     Region:   " + rrs.getIrrelevantField(StandardCodes.LstrType.region) + "\n#     Variant:  " + rrs.getIrrelevantField(StandardCodes.LstrType.variant) + "\n######\n\n");
            for (Map.Entry<LsrvCanonicalizer.TestDataTypes, Map<String, String>> mainEntry : rrs.getTestData(null).entrySet()) {
                LsrvCanonicalizer.TestDataTypes type = mainEntry.getKey();
                pw.println("\n# " + (Object)((Object)type) + "\n");
                for (Map.Entry<String, String> entry : mainEntry.getValue().entrySet()) {
                    String toTest = entry.getKey();
                    String expected = entry.getValue();
                    pw.println(toTest + "\t;\t" + expected);
                }
            }
        }
    }
}

