/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ShowPlurals;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRInfo;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRURLS;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CoreCoverageInfo;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Counter2;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringId;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VettingViewer;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.XPathParts;

public class ShowLocaleCoverage {
    private static final String VXML_CONSTANT = CLDRPaths.AUX_DIRECTORY + "voting/" + "38.1" + "/vxml/common/";
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final String TSV_MISSING_SUMMARY_HEADER = "#Path Level\t#Locales\tLocales\tSection\tPage\tHeader\tCode";
    private static final String TSV_LOCALE_COVERAGE_HEADER = "#Dir\tCode\tEnglish Name\tNative Name\tScript\tCLDR Target\tSublocales\tFields\tUC\tMissing\tModern\tMiss +UC\tModerate\tMiss +UC\tBasic\tMiss +UC\tCore\tMiss +UC\tCore-Missing";
    private static final String TSV_MISSING_HEADER = "#LCode\tEnglish Name\tScript\tLocale Level\tPath Level\tSTStatus\tBailey\tVxml\tVStatus\tSection\tPage\tHeader\tCode\tST Link\tConfig Action";
    private static final String TSV_MISSING_BASIC_HEADER = "";
    private static final boolean DEBUG = true;
    private static final char DEBUG_FILTER = '\u0000';
    private static final String LATEST = ToolConstants.CHART_VERSION;
    private static final double CORE_SIZE = CoreCoverageInfo.CoreItems.values().length - CoreCoverageInfo.CoreItems.ONLY_RECOMMENDED.size();
    public static CLDRConfig testInfo = ToolConfig.getToolInstance();
    private static final StandardCodes SC = testInfo.getStandardCodes();
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = testInfo.getSupplementalDataInfo();
    private static final StandardCodes STANDARD_CODES = SC;
    static Factory factory = testInfo.getCommonAndSeedAndMainAndAnnotationsFactory();
    private static final CLDRFile ENGLISH = factory.make("en", true);
    private static UnicodeSet ENG_ANN = Annotations.getData("en").keySet();
    static final RegexLookup<Boolean> HACK = RegexLookup.of(RegexLookup.LookupType.STANDARD, RegexLookup.RegexFinderTransformPath).add("//ldml/localeDisplayNames/keys/key[@type=\"(d0|em|fw|i0|k0|lw|m0|rg|s0|ss|t0|x0)\"]", Boolean.valueOf(true)).add("//ldml/localeDisplayNames/types/type[@key=\"(em|fw|kr|lw|ss)\"].*", (Boolean)true).add("//ldml/localeDisplayNames/languages/language[@type=\".*_.*\"]", (Boolean)true).add("//ldml/localeDisplayNames/languages/language[@type=\".*\"][@alt=\".*\"]", (Boolean)true).add("//ldml/localeDisplayNames/territories/territory[@type=\".*\"][@alt=\".*\"]", (Boolean)true).add("//ldml/localeDisplayNames/territories/territory[@type=\"EZ\"]", (Boolean)true);
    static final Option.Options myOptions = new Option.Options();
    static final RegexLookup<Boolean> SUPPRESS_PATHS_CAN_BE_EMPTY = new RegexLookup<Boolean>().add("\\[@alt=\"accounting\"]", Boolean.valueOf(true)).add("\\[@alt=\"variant\"]", (Boolean)true).add("^//ldml/localeDisplayNames/territories/territory.*@alt=\"short", (Boolean)true).add("^//ldml/localeDisplayNames/languages/language.*_", (Boolean)true).add("^//ldml/numbers/currencies/currency.*/symbol", (Boolean)true).add("^//ldml/characters/exemplarCharacters", (Boolean)true);
    static CLDRFile.DraftStatus minimumDraftStatus = CLDRFile.DraftStatus.unconfirmed;
    static final PathHeader.Factory pathHeaderFactory = PathHeader.getFactory(ENGLISH);
    static boolean RAW_DATA = true;
    private static Set<String> COMMON_LOCALES;
    static final List<ReleaseInfo> versionToYear;
    static final CoverageInfo coverageInfo;
    static final VoteResolver.VoterInfo dummyVoterInfo;
    static final CLDRInfo.UserInfo dummyUserInfo;
    static final CLDRInfo.PathValueInfo dummyPathValueInfo;
    static CLDRFile vxmlCldrFile;
    static final Set<ULocale> ICU_Locales;
    private static CLDRURLS URLS;

    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.filter, args, true);
        Matcher matcher = PatternCache.get(MyOptions.filter.option.getValue()).matcher(TSV_MISSING_BASIC_HEADER);
        if (MyOptions.chart.option.doesOccur()) {
            ShowLocaleCoverage.showCoverage(null, matcher);
            return;
        }
        if (MyOptions.growth.option.doesOccur()) {
            try (PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-growth.tsv");){
                ShowLocaleCoverage.doGrowth(matcher, out);
                return;
            }
        }
        Set<String> locales = null;
        String organization = MyOptions.organization.option.getValue();
        boolean useOrgLevel = MyOptions.organization.option.doesOccur();
        if (useOrgLevel) {
            locales = STANDARD_CODES.getLocaleCoverageLocales(organization);
        }
        if (MyOptions.version.option.doesOccur()) {
            String number = MyOptions.version.option.getValue().trim();
            if (!number.contains(".")) {
                number = number + ".0";
            }
            factory = Factory.make(CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + number + "/common/main/", ".*");
        } else if (MyOptions.directories.option.doesOccur()) {
            String directories = MyOptions.directories.option.getValue().trim();
            CLDRConfig cldrConfig = CONFIG;
            String base = null;
            int colonPos = directories.indexOf(58);
            if (colonPos >= 0) {
                base = directories.substring(0, colonPos).trim();
                directories = directories.substring(colonPos + 1).trim();
            } else {
                base = cldrConfig.getCldrBaseDirectory().toString();
            }
            String[] items = directories.split(",\\s*");
            File[] fullDirectories = new File[items.length];
            int i = 0;
            for (String item : items) {
                fullDirectories[i++] = new File(base + "/" + item + "/main");
            }
            factory = SimpleFactory.make(fullDirectories, ".*");
            COMMON_LOCALES = SimpleFactory.make(base + "/common/main", ".*").getAvailableLanguages();
        }
        ShowLocaleCoverage.fixCommonLocales();
        RAW_DATA = MyOptions.rawData.option.doesOccur();
        ShowLocaleCoverage.showCoverage(null, matcher, locales, useOrgLevel);
    }

    public static void fixCommonLocales() {
        if (COMMON_LOCALES == null) {
            COMMON_LOCALES = factory.getAvailableLanguages();
        }
    }

    private static void doGrowth(Matcher matcher, PrintWriter out) {
        TreeMap<String, List<Double>> growthData = new TreeMap<String, List<Double>>(Ordering.natural().reverse());
        Map<String, FoundAndTotal> latestData = null;
        for (ReleaseInfo versionNormalizedVersionAndYear : versionToYear) {
            VersionInfo version = versionNormalizedVersionAndYear.version;
            int year = versionNormalizedVersionAndYear.year;
            String dir = ToolConstants.getBaseDirectory(version.getVersionString(2, 3));
            Map<String, FoundAndTotal> currentData = ShowLocaleCoverage.addGrowth(factory, dir, matcher, false);
            System.out.println("year: " + year + "; version: " + version + "; size: " + currentData);
            if (latestData == null) {
                latestData = currentData;
            }
            Counter2<String> completionData = ShowLocaleCoverage.getCompletion(latestData, currentData);
            ShowLocaleCoverage.addCompletionList(year + TSV_MISSING_BASIC_HEADER, completionData, growthData);
            System.out.println(currentData);
        }
        boolean first = true;
        for (Map.Entry entry : growthData.entrySet()) {
            if (first) {
                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                    out.print("\t" + i);
                }
                out.println();
                first = false;
            }
            out.println((String)entry.getKey() + "\t" + Joiner.on("\t").join((Iterable)entry.getValue()));
        }
    }

    public static void addCompletionList(String version, Counter2<String> completionData, TreeMap<String, List<Double>> growthData) {
        ArrayList<Double> x = new ArrayList<Double>();
        for (String key : completionData.getKeysetSortedByCount(false)) {
            x.add(completionData.getCount(key));
        }
        growthData.put(version, x);
        System.out.println(version + "\t" + x.size());
    }

    public static Counter2<String> getCompletion(Map<String, FoundAndTotal> latestData, Map<String, FoundAndTotal> currentData) {
        Counter2<String> completionData = new Counter2<String>();
        for (Map.Entry<String, FoundAndTotal> entry : latestData.entrySet()) {
            double total;
            String locale = entry.getKey();
            FoundAndTotal currentRecord = currentData.get(locale);
            if (currentRecord == null || (total = (double)entry.getValue().total) == 0.0) continue;
            double completion = (double)currentRecord.found / total;
            completionData.add(locale, completion);
        }
        return completionData;
    }

    private static Map<String, FoundAndTotal> addGrowth(Factory latestFactory, String dir, Matcher matcher, boolean showMissing) {
        File[] fileArray;
        File mainDir = new File(dir + "/common/main/");
        File annotationDir = new File(dir + "/common/annotations/");
        if (annotationDir.exists()) {
            File[] fileArray2 = new File[2];
            fileArray2[0] = mainDir;
            fileArray = fileArray2;
            fileArray2[1] = annotationDir;
        } else {
            File[] fileArray3 = new File[1];
            fileArray = fileArray3;
            fileArray3[0] = mainDir;
        }
        File[] paths = fileArray;
        Factory newFactory = SimpleFactory.make(paths, ".*");
        HashMap<String, FoundAndTotal> data = new HashMap<String, FoundAndTotal>();
        char c = '\u0000';
        Set<String> latestAvailable = newFactory.getAvailableLanguages();
        for (String locale : newFactory.getAvailableLanguages()) {
            if (!matcher.reset(locale).matches() || !latestAvailable.contains(locale) || SUPPLEMENTAL_DATA_INFO.getDefaultContentLocales().contains(locale) || locale.equals("root") || locale.equals("supplementalData")) continue;
            char nc = locale.charAt(0);
            if (nc != c) {
                System.out.println("\t" + locale);
                c = nc;
            }
            CLDRFile latestFile = null;
            try {
                latestFile = latestFactory.make(locale, true);
            }
            catch (Exception e2) {
                continue;
            }
            CLDRFile file = newFactory.make(locale, true);
            Counter<Level> foundCounter = new Counter<Level>();
            Counter<Level> unconfirmedCounter = new Counter<Level>();
            Counter<Level> missingCounter = new Counter<Level>();
            LinkedHashSet<String> unconfirmedPaths = null;
            Relation<VettingViewer.MissingStatus, String> missingPaths = null;
            unconfirmedPaths = new LinkedHashSet<String>();
            missingPaths = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
            VettingViewer.getStatus(latestFile.fullIterable(), file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmedPaths);
            HashSet<Map.Entry<VettingViewer.MissingStatus, String>> missingRemovals = new HashSet<Map.Entry<VettingViewer.MissingStatus, String>>();
            for (Map.Entry<VettingViewer.MissingStatus, String> e : missingPaths.keyValueSet()) {
                if (e.getKey() != VettingViewer.MissingStatus.ABSENT) continue;
                String string = e.getValue();
                if (HACK.get(string) != null) {
                    missingRemovals.add(e);
                    missingCounter.add(Level.MODERN, -1L);
                    foundCounter.add(Level.MODERN, 1L);
                    continue;
                }
                CLDRFile.Status status = new CLDRFile.Status();
                String loc = file.getSourceLocaleID(string, status);
                boolean bl = false;
            }
            for (Map.Entry<VettingViewer.MissingStatus, String> e : missingRemovals) {
                missingPaths.remove(e.getKey(), e.getValue());
            }
            if (showMissing) {
                int count = 0;
                for (String string : unconfirmedPaths) {
                    System.out.println(++count + "\t" + locale + "\tunconfirmed\t" + string);
                }
                for (Map.Entry entry : missingPaths.keyValueSet()) {
                    String path = (String)entry.getValue();
                    CLDRFile.Status status = new CLDRFile.Status();
                    String loc = file.getSourceLocaleID(path, status);
                    boolean debug = false;
                    System.out.println(++count + "\t" + locale + "\t" + CldrUtility.toString(entry));
                }
                boolean bl = false;
            }
            data.put(locale, new FoundAndTotal(foundCounter, unconfirmedCounter, missingCounter));
        }
        return Collections.unmodifiableMap(data);
    }

    public static void showCoverage(FormattedFileWriter.Anchors anchors, Matcher matcher) throws IOException {
        ShowLocaleCoverage.showCoverage(anchors, matcher, null, false);
    }

    /*
     * Could not resolve type clashes
     */
    public static void showCoverage(FormattedFileWriter.Anchors anchors, Matcher matcher, Set<String> locales, boolean useOrgLevel) throws IOException {
        String title = "Locale Coverage";
        try (PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Locale Coverage", null, anchors));
             PrintWriter tsv_summary = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-coverage.tsv");
             PrintWriter tsv_missing = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing.tsv");
             PrintWriter tsv_missing_summary = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing-summary.tsv");
             PrintWriter tsv_missing_basic = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing-basic.tsv");){
            tsv_summary.println(TSV_LOCALE_COVERAGE_HEADER);
            tsv_missing_summary.println(TSV_MISSING_SUMMARY_HEADER);
            tsv_missing.println(TSV_MISSING_HEADER);
            tsv_missing_basic.println(TSV_MISSING_BASIC_HEADER);
            Set<String> checkModernLocales = STANDARD_CODES.getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
            TreeSet<String> availableLanguages = new TreeSet<String>(factory.getAvailableLanguages());
            availableLanguages.addAll(checkModernLocales);
            Relation<String, String> languageToRegion = Relation.of(new TreeMap(), TreeSet.class);
            LanguageTagParser ltp = new LanguageTagParser();
            LanguageTagCanonicalizer ltc = new LanguageTagCanonicalizer(true);
            for (String locale : factory.getAvailable()) {
                String country = ltp.set(locale).getRegion();
                if (country.isEmpty()) continue;
                languageToRegion.put(ltc.transform(ltp.getLanguageScript()), country);
            }
            ShowLocaleCoverage.fixCommonLocales();
            System.out.println(Joiner.on("\n").join(languageToRegion.keyValuesSet()));
            System.out.println("# Checking: " + availableLanguages);
            pw.println("<p style='text-align: left'>This chart shows the coverage levels for this release. </p><ol><li>Fields = fields found at a modern level</li><li>UC = unconfirmed values: typically treated as missing by implementations</li><li>Miss = missing values</li><li>Modern%, etc = fields/(fields + missing + unconfirmed) \u2014 at that level</li><li>Core Missing = missing core fields \u2014 optionals marked with *</li></ol><p>A high-level summary of the meaning of the coverage values are at <a target='_blank' href='http://www.unicode.org/reports/tr35/tr35-info.html#Coverage_Levels'>Coverage Levels</a>. The Core values are described on <a target='_blank' href='http://cldr.unicode.org/index/cldr-spec/minimaldata'>Core Data</a>.</p>");
            Relation<VettingViewer.MissingStatus, String> missingPaths = Relation.of(new EnumMap(VettingViewer.MissingStatus.class), TreeSet.class, CLDRFile.getComparator(DtdType.ldml));
            TreeSet<String> unconfirmed = new TreeSet<String>(CLDRFile.getComparator(DtdType.ldml));
            Set<String> defaultContents = SUPPLEMENTAL_DATA_INFO.getDefaultContentLocales();
            Counter<Level> foundCounter = new Counter<Level>();
            Counter<Level> unconfirmedCounter = new Counter<Level>();
            Counter<Level> missingCounter = new Counter<Level>();
            AbstractCollection levelsToShow = new ArrayList<Level>(EnumSet.allOf(Level.class));
            levelsToShow.remove((Object)Level.COMPREHENSIVE);
            levelsToShow.remove((Object)Level.UNDETERMINED);
            levelsToShow = ImmutableList.copyOf(levelsToShow);
            AbstractCollection reversedLevels = new ArrayList<Level>(levelsToShow);
            Collections.reverse(reversedLevels);
            reversedLevels = ImmutableList.copyOf(reversedLevels);
            int localeCount = 0;
            TablePrinter tablePrinter = new TablePrinter().addColumn("Direct.", "class='source'", null, "class='source'", true).setBreakSpans(true).setSpanRows(false).addColumn("Code", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setBreakSpans(true).addColumn("English Name", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("Native Name", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("Script", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("CLDR target", "class='source'", null, "class='source'", true).setBreakSpans(true).setSortPriority(0).setSortAscending(false).addColumn("ICU", "class='source'", null, "class='source'", true).setBreakSpans(true).setSortPriority(1).setSortAscending(false).addColumn("Sublocales", "class='target'", null, "class='targetRight'", true).setBreakSpans(true).setCellPattern("{0,number}").addColumn("Fields", "class='target'", null, "class='targetRight'", true).setBreakSpans(true).setCellPattern("{0,number}").addColumn("UC", "class='target'", null, "class='targetRight'", true).setBreakSpans(true).setCellPattern("{0,number}").addColumn("Miss", "class='target'", null, "class='targetRight'", true).setBreakSpans(true).setCellPattern("{0,number}");
            NumberFormat tsvPercent = NumberFormat.getPercentInstance(Locale.ENGLISH);
            tsvPercent.setMaximumFractionDigits(2);
            for (Level level : reversedLevels) {
                String titleLevel = level.toString();
                tablePrinter.addColumn(UCharacter.toTitleCase(titleLevel, null) + "%", "class='target'", null, "class='targetRight'", true).setCellPattern("{0,number,0.0%}").setBreakSpans(true);
                switch (level) {
                    case CORE: {
                        tablePrinter.setSortPriority(5).setSortAscending(false);
                        break;
                    }
                    case BASIC: {
                        tablePrinter.setSortPriority(4).setSortAscending(false);
                        break;
                    }
                    case MODERATE: {
                        tablePrinter.setSortPriority(3).setSortAscending(false);
                        break;
                    }
                    case MODERN: {
                        tablePrinter.setSortPriority(2).setSortAscending(false);
                    }
                }
            }
            tablePrinter.addColumn("Core Missing", "class='target'", null, "class='targetRight'", true).setBreakSpans(true);
            long start = System.currentTimeMillis();
            LikelySubtags likelySubtags = new LikelySubtags();
            EnumMap<Level, Double> targetLevel = new EnumMap<Level, Double>(Level.class);
            targetLevel.put(Level.CORE, 0.02);
            targetLevel.put(Level.BASIC, 0.16);
            targetLevel.put(Level.MODERATE, 0.33);
            targetLevel.put(Level.MODERN, 1.0);
            TreeMultimap<String, String> pathToLocale = TreeMultimap.create();
            boolean counter = false;
            for (Object locale : availableLanguages) {
                try {
                    Level foundLevel;
                    Level foundLevel2;
                    String status;
                    String path;
                    Iterator<Row.R2<Long, String>> goalLevel;
                    Set sublocales;
                    String base;
                    if (((String)locale).contains("supplemental") || ((String)locale).startsWith("sr_Latn") || locales != null && !locales.contains(locale) && !locales.contains(base = CLDRLocale.getInstance((String)locale).getLanguage()) || matcher != null && !matcher.reset((CharSequence)locale).matches() || defaultContents.contains(locale) || "root".equals(locale) || "und".equals(locale)) continue;
                    CLDRFile vxmlCldrFile2 = null;
                    tsv_summary.flush();
                    tsv_missing_summary.flush();
                    tsv_missing.flush();
                    tsv_missing_basic.flush();
                    boolean isSeed = new File(CLDRPaths.SEED_DIRECTORY, (String)locale + ".xml").exists();
                    String region = ltp.set((String)locale).getRegion();
                    if (!region.isEmpty()) continue;
                    Level cldrLocaleLevelGoal = SC.getLocaleCoverageLevel(Organization.cldr.toString(), (String)locale);
                    boolean cldrLevelGoalBasicToModern = Level.CORE_TO_MODERN.contains((Object)cldrLocaleLevelGoal);
                    String isCommonLocale = Level.MODERN == cldrLocaleLevelGoal ? "C*" : (COMMON_LOCALES.contains(locale) ? "C" : TSV_MISSING_BASIC_HEADER);
                    String max = likelySubtags.maximize((String)locale);
                    String script = ltp.set(max).getScript();
                    String language = likelySubtags.minimize((String)locale);
                    missingPaths.clear();
                    unconfirmed.clear();
                    CLDRFile file = factory.make((String)locale, true, minimumDraftStatus);
                    if (((String)locale).equals("af")) {
                        boolean bl = false;
                    }
                    IterableFilter pathSource = new IterableFilter(file.fullIterable());
                    VettingViewer.getStatus(pathSource, file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmed);
                    if (vxmlCldrFile != null) {
                        HashMultimap<VettingViewer.MissingStatus, String> toRemove = HashMultimap.create();
                        for (Map.Entry<VettingViewer.MissingStatus, String> entry : missingPaths.entrySet()) {
                            String fullPath;
                            String bailey;
                            String mPath = entry.getValue();
                            String vxmlValue = vxmlCldrFile.getStringValue(mPath);
                            if (vxmlValue == null) continue;
                            if (vxmlValue.equals(CldrUtility.INHERITANCE_MARKER)) {
                                vxmlValue = vxmlCldrFile.getBaileyValue(mPath, null, null);
                            }
                            if (vxmlValue == null || !vxmlValue.equals(bailey = file.getStringValue(mPath)) || (fullPath = vxmlCldrFile.getFullXPath(mPath)).contains("provisional") || fullPath.contains("unconfirmed")) continue;
                            toRemove.put(entry.getKey(), mPath);
                            Level level = coverageInfo.getCoverageLevel(mPath, (String)locale);
                            missingCounter.add(level, -1L);
                        }
                        for (Map.Entry<VettingViewer.MissingStatus, String> entry : toRemove.entries()) {
                            missingPaths.remove(entry.getKey(), entry.getValue());
                        }
                    }
                    if ((sublocales = languageToRegion.get(language)) == null) {
                        sublocales = Collections.EMPTY_SET;
                    }
                    String seedString = isSeed ? "seed" : "common";
                    tablePrinter.addRow().addCell((Comparable)((Object)seedString)).addCell((Comparable)((Object)language)).addCell((Comparable)((Object)ENGLISH.getName(language))).addCell((Comparable)((Object)file.getName(language))).addCell((Comparable)((Object)script)).addCell((Comparable)((Object)(cldrLocaleLevelGoal == Level.UNDETERMINED ? TSV_MISSING_BASIC_HEADER : cldrLocaleLevelGoal.toString()))).addCell((Comparable)((Object)ShowLocaleCoverage.getIcuValue(language))).addCell(Integer.valueOf(sublocales.size()));
                    String s2 = TSV_LOCALE_COVERAGE_HEADER;
                    if (cldrLevelGoalBasicToModern) {
                        tsv_summary.append(seedString).append('\t').append(language).append('\t').append(ENGLISH.getName(language)).append('\t').append(file.getName(language)).append('\t').append(script).append('\t').append(cldrLocaleLevelGoal.toString()).append('\t').append(sublocales.size() + TSV_MISSING_BASIC_HEADER);
                    }
                    int sumFound = 0;
                    int sumMissing = 0;
                    int sumUnconfirmed = 0;
                    EnumMap<Level, Integer> totals = new EnumMap<Level, Integer>(Level.class);
                    EnumMap<Level, Integer> confirmed = new EnumMap<Level, Integer>(Level.class);
                    LinkedHashSet<String> coreMissing = new LinkedHashSet<String>();
                    if (((String)locale).equals("af")) {
                        boolean bl = false;
                    }
                    Counter<String> starredCounter = new Counter<String>();
                    long missingExemplarCount = missingCounter.get(Level.CORE);
                    if (missingExemplarCount > 0L) {
                        for (Map.Entry<VettingViewer.MissingStatus, String> statusAndPath : missingPaths.entrySet()) {
                            String path2 = statusAndPath.getValue();
                            if (!path2.startsWith("//ldml/characters/exemplarCharacters")) continue;
                            PathHeader ph = pathHeaderFactory.fromPath(path2);
                            String problem = ph.getCode().replaceAll("Others: ", TSV_MISSING_BASIC_HEADER).replaceAll("Main Letters", "main-letters");
                            coreMissing.add(problem);
                            if (cldrLevelGoalBasicToModern) {
                                String line = ShowLocaleCoverage.spreadsheetLine((String)locale, language, script, "\u00abNo " + problem + "\u00bb", cldrLocaleLevelGoal, Level.CORE, "ABSENT", path2, file, vxmlCldrFile2, pathToLocale);
                                tsv_missing.println(line);
                                continue;
                            }
                            ShowLocaleCoverage.gatherStarred(path2, starredCounter);
                        }
                    }
                    LinkedHashMultimap<CoreCoverageInfo.CoreItems, String> detailedErrors = LinkedHashMultimap.create();
                    TreeSet<CoreCoverageInfo.CoreItems> coverage = new TreeSet<CoreCoverageInfo.CoreItems>(CoreCoverageInfo.getCoreCoverageInfo(file, detailedErrors));
                    EnumSet<CoreCoverageInfo.CoreItems> missing = EnumSet.allOf(CoreCoverageInfo.CoreItems.class);
                    missing.removeAll(coverage);
                    for (Map.Entry entry : detailedErrors.entries()) {
                        CoreCoverageInfo.CoreItems coreItem = (CoreCoverageInfo.CoreItems)((Object)entry.getKey());
                        String path3 = (String)entry.getValue();
                        coreMissing.add(coreItem.toString());
                        if (cldrLevelGoalBasicToModern) {
                            String line = ShowLocaleCoverage.spreadsheetLine((String)locale, language, script, "\u00abNo " + (Object)((Object)coreItem) + "\u00bb", cldrLocaleLevelGoal, coreItem.desiredLevel, "ABSENT", path3, null, vxmlCldrFile2, pathToLocale);
                            tsv_missing.println(line);
                            continue;
                        }
                        ShowLocaleCoverage.gatherStarred(path3, starredCounter);
                    }
                    missing.removeAll(CoreCoverageInfo.CoreItems.ONLY_RECOMMENDED);
                    foundCounter.add(Level.CORE, coverage.size());
                    missingCounter.add(Level.CORE, missing.size());
                    if (cldrLevelGoalBasicToModern) {
                        goalLevel = cldrLocaleLevelGoal;
                        for (Map.Entry<VettingViewer.MissingStatus, String> entry : missingPaths.entrySet()) {
                            path = entry.getValue();
                            status = entry.getKey().toString();
                            foundLevel2 = coverageInfo.getCoverageLevel(path, (String)locale);
                            if (((Enum)((Object)goalLevel)).compareTo((Row.R2<Long, String>)((Object)foundLevel2)) < 0) continue;
                            String line = ShowLocaleCoverage.spreadsheetLine((String)locale, language, script, file.getStringValue(path), goalLevel, foundLevel2, status, path, file, vxmlCldrFile2, pathToLocale);
                            tsv_missing.println(line);
                        }
                        for (String path4 : unconfirmed) {
                            foundLevel = coverageInfo.getCoverageLevel(path4, (String)locale);
                            if (((Enum)((Object)goalLevel)).compareTo((Row.R2<Long, String>)((Object)foundLevel)) < 0) continue;
                            String line = ShowLocaleCoverage.spreadsheetLine((String)locale, language, script, file.getStringValue(path4), goalLevel, foundLevel, "n/a", path4, file, vxmlCldrFile2, pathToLocale);
                            tsv_missing.println(line);
                        }
                    } else {
                        goalLevel = Level.BASIC;
                        for (Map.Entry<VettingViewer.MissingStatus, String> entry : missingPaths.entrySet()) {
                            path = entry.getValue();
                            status = entry.getKey().toString();
                            foundLevel2 = coverageInfo.getCoverageLevel(path, (String)locale);
                            if (((Enum)((Object)goalLevel)).compareTo((Row.R2<Long, String>)((Object)foundLevel2)) < 0) continue;
                            ShowLocaleCoverage.gatherStarred(path, starredCounter);
                        }
                        for (String path4 : unconfirmed) {
                            foundLevel = coverageInfo.getCoverageLevel(path4, (String)locale);
                            if (((Enum)((Object)goalLevel)).compareTo((Row.R2<Long, String>)((Object)foundLevel)) < 0) continue;
                            ShowLocaleCoverage.gatherStarred(path4, starredCounter);
                        }
                    }
                    tsv_missing_basic.println(TSV_MISSING_BASIC_HEADER);
                    for (Row.R2<Long, String> starred : starredCounter.getEntrySetSortedByCount(false, null)) {
                        tsv_missing_basic.println((String)locale + "\t" + starred.get0() + "\t" + ((String)starred.get1()).replace("\"*\"", "'*'"));
                    }
                    for (Level level : levelsToShow) {
                        long foundCount = foundCounter.get(level);
                        long unconfirmedCount = unconfirmedCounter.get(level);
                        long missingCount = missingCounter.get(level);
                        sumFound = (int)((long)sumFound + foundCount);
                        sumUnconfirmed = (int)((long)sumUnconfirmed + unconfirmedCount);
                        sumMissing = (int)((long)sumMissing + missingCount);
                        confirmed.put(level, sumFound);
                        totals.put(level, sumFound + sumUnconfirmed + sumMissing);
                    }
                    double modernTotal = ((Integer)totals.get((Object)Level.MODERN)).intValue();
                    tablePrinter.addCell(Integer.valueOf(sumFound)).addCell(Integer.valueOf(sumUnconfirmed)).addCell(Integer.valueOf(sumMissing));
                    if (cldrLevelGoalBasicToModern) {
                        tsv_summary.append('\t').append(sumFound + TSV_MISSING_BASIC_HEADER).append('\t').append(sumUnconfirmed + TSV_MISSING_BASIC_HEADER).append('\t').append(sumMissing + TSV_MISSING_BASIC_HEADER);
                    }
                    for (Level level : reversedLevels) {
                        if (useOrgLevel && cldrLocaleLevelGoal != level) continue;
                        int confirmedCoverage = (Integer)confirmed.get((Object)level);
                        double total = ((Integer)totals.get((Object)level)).intValue();
                        tablePrinter.addCell(Double.valueOf((double)confirmedCoverage / total));
                        if (!cldrLevelGoalBasicToModern) continue;
                        tsv_summary.append('\t').append(String.valueOf(confirmedCoverage)).append('\t').append(String.valueOf((int)total - confirmedCoverage));
                    }
                    String coreMissingString = Joiner.on(", ").join(coreMissing);
                    tablePrinter.addCell((Comparable)((Object)coreMissingString)).finishRow();
                    if (cldrLevelGoalBasicToModern) {
                        tsv_summary.append('\t').append(coreMissingString).append('\n');
                    }
                    ++localeCount;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            pw.println(tablePrinter.toTable());
            TreeMultimap<Level, String> levelToLocales = TreeMultimap.create();
            for (Map.Entry entry : pathToLocale.asMap().entrySet()) {
                String path = (String)entry.getKey();
                Collection localeSet = (Collection)entry.getValue();
                levelToLocales.clear();
                for (String locale : localeSet) {
                    Level foundLevel = coverageInfo.getCoverageLevel(path, locale);
                    levelToLocales.put(foundLevel, locale);
                }
                String phString = "n/a\tn/a\tn/a\tn/a";
                try {
                    PathHeader ph = pathHeaderFactory.fromPath(path);
                    phString = ph.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Map.Entry entry2 : levelToLocales.asMap().entrySet()) {
                    Level level = (Level)((Object)entry2.getKey());
                    localeSet = entry2.getValue();
                    String s3 = TSV_MISSING_SUMMARY_HEADER;
                    tsv_missing_summary.println((Object)((Object)level) + "\t" + localeSet.size() + "\t" + Joiner.on(" ").join(localeSet) + "\t" + phString);
                }
            }
            long end = System.currentTimeMillis();
            System.out.println(end - start + " millis = " + (end - start) / (long)localeCount + " millis/locale");
            ShowPlurals.appendBlanksForScrolling(pw);
        }
    }

    public static void gatherStarred(String path, Counter<String> starredCounter) {
        starredCounter.add(new PathStarrer().setSubstitutionPattern("*").set(path), 1L);
    }

    public static String spreadsheetLine(String locale, String language, String script, String nativeValue, Level cldrLocaleLevelGoal, Level itemLevel, String status, String path, CLDRFile resolvedFile, CLDRFile vxmlCldrFile, Multimap<String, String> pathToLocale) {
        if (pathToLocale != null) {
            pathToLocale.put(path, locale);
        }
        String stLink = "n/a";
        String englishValue = "n/a";
        CheckCLDR.StatusAction action = null;
        PathHeader.SurveyToolStatus surveyToolStatus = null;
        String icuValue = ShowLocaleCoverage.getIcuValue(locale);
        String bailey = resolvedFile == null ? TSV_MISSING_BASIC_HEADER : resolvedFile.getStringValue(path);
        String vxmlValue = TSV_MISSING_BASIC_HEADER;
        String vxmlDraftStatus = TSV_MISSING_BASIC_HEADER;
        if (vxmlCldrFile != null) {
            try {
                vxmlValue = vxmlCldrFile.getStringValue(path);
                if (vxmlValue == null) {
                    vxmlValue = TSV_MISSING_BASIC_HEADER;
                } else {
                    String fullXPath = vxmlCldrFile.getFullXPath(path);
                    XPathParts parts = XPathParts.getFrozenInstance(fullXPath);
                    vxmlDraftStatus = parts.getAttributeValue(-1, "draft");
                    if (vxmlDraftStatus == null) {
                        vxmlDraftStatus = TSV_MISSING_BASIC_HEADER;
                    }
                }
            }
            catch (Exception fullXPath) {
                // empty catch block
            }
        }
        String phString = "na\tn/a\tn/a\t" + path;
        try {
            PathHeader ph = pathHeaderFactory.fromPath(path);
            phString = ph.toString();
            surveyToolStatus = ph.getSurveyToolStatus();
            stLink = URLS.forXpath(locale, path);
            englishValue = ENGLISH.getStringValue(path);
            action = CheckCLDR.Phase.SUBMISSION.getShowRowAction(dummyPathValueInfo, CheckCLDR.InputMethod.DIRECT, surveyToolStatus, dummyUserInfo);
        }
        catch (Exception e) {
            boolean bl = false;
        }
        String config_text = vxmlValue.isEmpty() ? TSV_MISSING_BASIC_HEADER : "locale=" + locale + " ; action=add ; new_path=" + StringId.getHexId(path) + " ; new_value=" + vxmlValue;
        String s2 = TSV_MISSING_HEADER;
        String line = language + "\t" + ENGLISH.getName(language) + "\t" + ENGLISH.getName("script", script) + "\t" + (Object)((Object)cldrLocaleLevelGoal) + "\t" + (Object)((Object)itemLevel) + "\t" + (surveyToolStatus == null ? "?" : surveyToolStatus.toString()) + "\t" + bailey + "\t" + vxmlValue + "\t" + vxmlDraftStatus + "\t" + phString + "\t" + PathHeader.getUrlForLocalePath(locale, path) + "\t" + config_text;
        return line;
    }

    private static String getIcuValue(String locale) {
        return ICU_Locales.contains(new ULocale(locale)) ? "ICU" : TSV_MISSING_BASIC_HEADER;
    }

    static /* synthetic */ String access$000() {
        return LATEST;
    }

    static {
        Object[][] mapping = new Object[][]{{VersionInfo.getInstance(37), 2020}, {VersionInfo.getInstance(36), 2019}, {VersionInfo.getInstance(34), 2018}, {VersionInfo.getInstance(32), 2017}, {VersionInfo.getInstance(30), 2016}, {VersionInfo.getInstance(28), 2015}, {VersionInfo.getInstance(26), 2014}, {VersionInfo.getInstance(24), 2013}, {VersionInfo.getInstance(22, 1), 2012}, {VersionInfo.getInstance(2, 0, 1), 2011}, {VersionInfo.getInstance(1, 9, 1), 2010}, {VersionInfo.getInstance(1, 7, 2), 2009}, {VersionInfo.getInstance(1, 6, 1), 2008}, {VersionInfo.getInstance(1, 5, 1), 2007}, {VersionInfo.getInstance(1, 4, 1), 2006}, {VersionInfo.getInstance(1, 3), 2005}, {VersionInfo.getInstance(1, 2), 2004}, {VersionInfo.getInstance(1, 1, 1), 2003}};
        ArrayList<ReleaseInfo> _versionToYear = new ArrayList<ReleaseInfo>();
        for (Object[] row : mapping) {
            _versionToYear.add(new ReleaseInfo((VersionInfo)row[0], (Integer)row[1]));
        }
        versionToYear = ImmutableList.copyOf(_versionToYear);
        coverageInfo = new CoverageInfo(SUPPLEMENTAL_DATA_INFO);
        dummyVoterInfo = new VoteResolver.VoterInfo(Organization.cldr, VoteResolver.Level.vetter, "somename");
        dummyUserInfo = new CLDRInfo.UserInfo(){

            @Override
            public VoteResolver.VoterInfo getVoterInfo() {
                return dummyVoterInfo;
            }
        };
        dummyPathValueInfo = new CLDRInfo.PathValueInfo(){

            @Override
            public Collection<? extends CLDRInfo.CandidateInfo> getValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CLDRInfo.CandidateInfo getCurrentItem() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getBaselineValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Level getCoverageLevel() {
                return Level.MODERN;
            }

            @Override
            public boolean hadVotesSometimeThisRelease() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CLDRLocale getLocale() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getXpath() {
                throw new UnsupportedOperationException();
            }
        };
        vxmlCldrFile = null;
        ICU_Locales = ImmutableSet.copyOf(ULocale.getAvailableLocales());
        URLS = CONFIG.urls();
    }

    static enum MyOptions {
        filter(".+", ".*", "Filter the information based on id, using a regex argument."),
        chart(null, null, "chart only"),
        growth("true", "true", "Compute growth data"),
        organization(".+", null, "Only locales for organization"),
        version(".+", ShowLocaleCoverage.access$000(), "To get different versions"),
        rawData(null, null, "Output the raw data from all coverage levels"),
        targetDir(".*", CLDRPaths.GEN_DIRECTORY + "/statistics/", "target output file."),
        directories("(.*:)?[a-z]+(,[a-z]+)*", "common", "Space-delimited list of main source directories: common,seed,exemplar.\nOptional, <baseDir>:common,seed");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }

    static final class ReleaseInfo {
        VersionInfo version;
        int year;

        public ReleaseInfo(VersionInfo versionInfo, int year) {
            this.version = versionInfo;
            this.year = year;
        }
    }

    static class FoundAndTotal {
        final int found;
        final int total;

        public FoundAndTotal(Counter<Level> ... counters) {
            int[] count = new int[]{0, 0, 0};
            for (Level level : Level.values()) {
                if (level == Level.COMPREHENSIVE || level == Level.OPTIONAL) continue;
                int i = 0;
                for (Counter<Level> counter : counters) {
                    int n = i++;
                    count[n] = (int)((long)count[n] + counter.get(level));
                }
            }
            this.found = count[0];
            this.total = this.found + count[1] + count[2];
        }

        public String toString() {
            return this.found + "/" + this.total;
        }
    }

    static class IterableFilter
    implements Iterable<String> {
        private Iterable<String> source;
        static final Set<String> SUPPRESS_PATHS_AFTER_SUBMISSION = ImmutableSet.of("//ldml/localeDisplayNames/languages/language[@type=\"ccp\"]", "//ldml/localeDisplayNames/territories/territory[@type=\"XA\"]", "//ldml/localeDisplayNames/territories/territory[@type=\"XB\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"Gy\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"Gy\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyM\"]/greatestDifference[@id=\"G\"]", new String[]{"//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyM\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyM\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMd\"]/greatestDifference[@id=\"d\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMd\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMd\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMd\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMEd\"]/greatestDifference[@id=\"d\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMEd\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMEd\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMEd\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMM\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMM\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMM\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMd\"]/greatestDifference[@id=\"d\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMd\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMd\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMd\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMEd\"]/greatestDifference[@id=\"d\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMEd\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMEd\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMEd\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"Gy\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"Gy\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyM\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyM\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyM\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMd\"]/greatestDifference[@id=\"d\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMd\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMd\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMd\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMEd\"]/greatestDifference[@id=\"d\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMEd\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMEd\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMEd\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMM\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMM\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMM\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMd\"]/greatestDifference[@id=\"d\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMd\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMd\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMd\"]/greatestDifference[@id=\"y\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMEd\"]/greatestDifference[@id=\"d\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMEd\"]/greatestDifference[@id=\"G\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMEd\"]/greatestDifference[@id=\"M\"]", "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"GyMMMEd\"]/greatestDifference[@id=\"y\"]"});

        IterableFilter(Iterable<String> source) {
            this.source = source;
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorFilter(this.source.iterator());
        }

        static class IteratorFilter
        implements Iterator<String> {
            Iterator<String> source;
            String peek;

            public IteratorFilter(Iterator<String> source) {
                this.source = source;
                this.fillPeek();
            }

            @Override
            public boolean hasNext() {
                return this.peek != null;
            }

            @Override
            public String next() {
                String result = this.peek;
                this.fillPeek();
                return result;
            }

            private void fillPeek() {
                this.peek = null;
                while (this.source.hasNext()) {
                    this.peek = this.source.next();
                    if (!SUPPRESS_PATHS_AFTER_SUBMISSION.contains(this.peek) && SUPPRESS_PATHS_CAN_BE_EMPTY.get(this.peek) != Boolean.TRUE) break;
                    this.peek = null;
                }
            }
        }
    }
}

