/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transform;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.unicode.cldr.util.Transformer;

public final class Builder {
    public static <E, C extends Collection<E>> CBuilder<E, C> with(C collection, EqualAction ea) {
        return new CBuilder(collection, ea, null);
    }

    public static <E, C extends Collection<E>> CBuilder<E, C> with(C collection) {
        return new CBuilder(collection, EqualAction.NATIVE, null);
    }

    public static <K, V, M extends Map<K, V>> MBuilder<K, V, M> with(M map, EqualAction ea) {
        return new MBuilder(map, ea, null);
    }

    public static <K, V, M extends Map<K, V>> MBuilder<K, V, M> with(M map) {
        return new MBuilder(map, EqualAction.NATIVE, null);
    }

    public static <E> Collection<E> getMatchingItems(Transform<E, Boolean> predicate, Collection<E> collection, Collection<E> matchingItems) {
        for (E item : collection) {
            if (!predicate.transform(item).booleanValue()) continue;
            matchingItems.add(item);
        }
        return matchingItems;
    }

    public static final class CBuilder<E, U extends Collection<E>> {
        private U collection;
        private EqualAction equalAction;

        public EqualAction getEqualAction() {
            return this.equalAction;
        }

        public CBuilder<E, U> setEqualAction(EqualAction equalAction) {
            this.equalAction = equalAction;
            return this;
        }

        public CBuilder<E, U> clear() {
            this.collection.clear();
            return this;
        }

        public CBuilder<E, U> add(E e) {
            switch (this.equalAction) {
                case NATIVE: {
                    break;
                }
                case REPLACE: {
                    this.collection.remove(e);
                    break;
                }
                case RETAIN: {
                    if (!this.collection.contains(e)) break;
                    return this;
                }
                case THROW: {
                    if (!this.collection.contains(e)) break;
                    throw new IllegalArgumentException("Map already contains " + e);
                }
            }
            this.collection.add(e);
            return this;
        }

        public CBuilder<E, U> addAll(Iterable<? extends E> c) {
            if (this.equalAction == EqualAction.REPLACE && c instanceof Collection) {
                this.collection.addAll((Collection)c);
            } else {
                for (E item : c) {
                    this.add(item);
                }
            }
            return this;
        }

        public CBuilder<E, U> addAll(E ... items) {
            for (E item : items) {
                this.collection.add(item);
            }
            return this;
        }

        public CBuilder<E, U> addAll(Iterator<E> items) {
            while (items.hasNext()) {
                this.collection.add(items.next());
            }
            return this;
        }

        public <T> CBuilder<E, U> addAll(Transform<T, E> transform, Iterable<? extends T> c) {
            return this.addAll((Iterator<E>)Transformer.iterator(transform, c));
        }

        public <T> CBuilder<E, U> addAll(Transform<T, E> transform, T ... items) {
            return this.addAll((Iterator<E>)Transformer.iterator(transform, items));
        }

        public <T> CBuilder<E, U> addAll(Transform<T, E> transform, Iterator<T> items) {
            return this.addAll((Iterator<E>)Transformer.iterator(transform, items));
        }

        public CBuilder<E, U> remove(E o) {
            this.collection.remove(o);
            return this;
        }

        public CBuilder<E, U> removeAll(Collection<? extends E> c) {
            this.collection.removeAll(c);
            return this;
        }

        public CBuilder<E, U> removeAll(Transform<E, Boolean> predicate) {
            this.collection.removeAll(Builder.getMatchingItems(predicate, this.collection, new HashSet()));
            return this;
        }

        public CBuilder<E, U> removeAll(E ... items) {
            for (E item : items) {
                this.collection.remove(item);
            }
            return this;
        }

        public CBuilder<E, U> removeAll(Iterator<E> items) {
            while (items.hasNext()) {
                this.collection.remove(items.next());
            }
            return this;
        }

        public CBuilder<E, U> retainAll(Collection<? extends E> c) {
            this.collection.retainAll(c);
            return this;
        }

        public CBuilder<E, U> retainAll(E ... items) {
            this.collection.retainAll(Arrays.asList(items));
            return this;
        }

        public CBuilder<E, U> retainAll(Iterator<E> items) {
            HashSet temp = Builder.with(new HashSet()).addAll(items).get();
            this.collection.retainAll(temp);
            return this;
        }

        public CBuilder<E, U> retainAll(Transform<E, Boolean> predicate) {
            this.collection.retainAll(Builder.getMatchingItems(predicate, this.collection, new HashSet()));
            return this;
        }

        public CBuilder<E, U> xor(Collection<? extends E> c) {
            for (E item : c) {
                boolean changed = this.collection.remove(item);
                if (changed) continue;
                this.collection.add(item);
            }
            return this;
        }

        public CBuilder<E, U> xor(E ... items) {
            return this.xor((Collection<? extends E>)Arrays.asList(items));
        }

        public CBuilder<E, U> xor(Iterator<E> items) {
            HashSet temp = Builder.with(new HashSet()).addAll(items).get();
            return this.xor(temp);
        }

        public CBuilder<E, U> keepNew(Collection<? extends E> c) {
            HashSet<E> extras = new HashSet<E>(c);
            extras.removeAll((Collection<?>)this.collection);
            this.collection.clear();
            this.collection.addAll(extras);
            return this;
        }

        public CBuilder<E, U> keepNew(E ... items) {
            return this.keepNew((Collection<? extends E>)Arrays.asList(items));
        }

        public CBuilder<E, U> keepNew(Iterator<E> items) {
            HashSet temp = Builder.with(new HashSet()).addAll(items).get();
            return this.keepNew(temp);
        }

        public CBuilder<E, U> filter(Transform<E, Boolean> filter) {
            HashSet temp = new HashSet();
            for (Object item : this.collection) {
                if (filter.transform(item) != Boolean.FALSE) continue;
                temp.add(item);
            }
            this.collection.removeAll(temp);
            return this;
        }

        public U get() {
            U temp = this.collection;
            this.collection = null;
            return temp;
        }

        public U freeze() {
            Collection temp = this.collection instanceof SortedSet ? Collections.unmodifiableSortedSet((SortedSet)this.collection) : (this.collection instanceof Set ? Collections.unmodifiableSet((Set)this.collection) : (this.collection instanceof List ? Collections.unmodifiableList((List)this.collection) : Collections.unmodifiableCollection(this.collection)));
            this.collection = null;
            return (U)temp;
        }

        public String toString() {
            return this.collection.toString();
        }

        private CBuilder(U set2, EqualAction ea) {
            this.collection = set2;
            this.equalAction = ea;
        }

        /* synthetic */ CBuilder(Collection x0, EqualAction x1, 1 x2) {
            this(x0, x1);
        }
    }

    static enum EqualAction {
        NATIVE,
        REPLACE,
        RETAIN,
        THROW;

    }

    public static final class MBuilder<K, V, M extends Map<K, V>> {
        private Collection<? extends K> keys;
        private M map;
        private EqualAction equalAction;

        public EqualAction getEqualAction() {
            return this.equalAction;
        }

        public MBuilder<K, V, M> setEqualAction(EqualAction equalAction) {
            this.equalAction = equalAction;
            return this;
        }

        public MBuilder<K, V, M> clear() {
            this.map.clear();
            return this;
        }

        public MBuilder<K, V, M> put(K key, V value) {
            switch (this.equalAction) {
                case NATIVE: {
                    break;
                }
                case REPLACE: {
                    this.map.remove(key);
                    break;
                }
                case RETAIN: {
                    if (!this.map.containsKey(key)) break;
                    return this;
                }
                case THROW: {
                    if (!this.map.containsKey(key)) break;
                    throw new IllegalArgumentException("Map already contains " + key);
                }
            }
            this.map.put(key, value);
            return this;
        }

        public MBuilder<K, V, M> on(K ... keys) {
            this.keys = Arrays.asList(keys);
            return this;
        }

        public MBuilder<K, V, M> on(Collection<? extends K> keys) {
            this.keys = keys;
            return this;
        }

        public MBuilder<K, V, M> put(V value) {
            for (K key : this.keys) {
                this.put(key, value);
            }
            this.keys = null;
            return this;
        }

        public MBuilder<K, V, M> put(V ... values) {
            int v = 0;
            for (K key : this.keys) {
                this.put(key, values[v++]);
                if (v < values.length) continue;
                v = 0;
            }
            this.keys = null;
            return this;
        }

        public MBuilder<K, V, M> put(Collection<? extends V> values) {
            Iterator<V> vi = null;
            for (K key : this.keys) {
                if (vi == null || !vi.hasNext()) {
                    vi = values.iterator();
                }
                this.put(key, vi.next());
            }
            return this;
        }

        public MBuilder<K, V, M> putAll(Map<? extends K, ? extends V> m3) {
            if (this.equalAction == EqualAction.NATIVE) {
                this.map.putAll(m3);
            } else {
                for (Map.Entry<K, V> keyValue : m3.entrySet()) {
                    this.put(keyValue.getKey(), keyValue.getValue());
                }
            }
            this.keys = null;
            return this;
        }

        public MBuilder<K, V, M> putAll(K[][] m3) {
            for (K[] pair : m3) {
                this.put(pair[0], (V)pair[1]);
            }
            this.keys = null;
            return this;
        }

        public MBuilder<K, V, M> putAllTransposed(Map<? extends V, ? extends K> m3) {
            for (Map.Entry<V, K> keyValue : m3.entrySet()) {
                this.put(keyValue.getValue(), keyValue.getKey());
            }
            return this;
        }

        public MBuilder<K, V, M> remove(K key) {
            this.map.remove(key);
            return this;
        }

        public MBuilder<K, V, M> removeAll(Collection<? extends K> keys) {
            this.map.keySet().removeAll(keys);
            return this;
        }

        public MBuilder<K, V, M> removeAll(K ... keys) {
            return this.removeAll((Collection<? extends K>)Arrays.asList(keys));
        }

        public MBuilder<K, V, M> removeAll(Transform<K, Boolean> predicate) {
            this.map.keySet().removeAll(Builder.getMatchingItems(predicate, this.map.keySet(), new HashSet()));
            return this;
        }

        public MBuilder<K, V, M> retainAll(Transform<K, Boolean> predicate) {
            this.map.keySet().retainAll(Builder.getMatchingItems(predicate, this.map.keySet(), new HashSet()));
            return this;
        }

        public MBuilder<K, V, M> retainAll(Collection<? extends K> keys) {
            this.map.keySet().retainAll(keys);
            return this;
        }

        public MBuilder<K, V, M> retainAll(K ... keys) {
            return this.retainAll((Collection<? extends K>)Arrays.asList(keys));
        }

        public <N extends Map<K, V>> MBuilder<K, V, M> xor(N c) {
            for (K item : c.keySet()) {
                if (this.map.containsKey(item)) {
                    this.map.remove(item);
                    continue;
                }
                this.put(item, c.get(item));
            }
            return this;
        }

        public <N extends Map<K, V>> MBuilder<K, V, M> keepNew(N c) {
            HashSet<K> extras = new HashSet<K>(c.keySet());
            extras.removeAll(this.map.keySet());
            this.map.clear();
            for (K key : extras) {
                this.map.put(key, c.get(key));
            }
            return this;
        }

        public M get() {
            M temp = this.map;
            this.map = null;
            return temp;
        }

        public M freeze() {
            Map temp = this.map instanceof SortedMap ? Collections.unmodifiableSortedMap((SortedMap)this.map) : Collections.unmodifiableMap(this.map);
            this.map = null;
            return (M)temp;
        }

        public String toString() {
            return this.map.toString();
        }

        private MBuilder(M map, EqualAction ea) {
            this.map = map;
            this.equalAction = ea;
        }

        /* synthetic */ MBuilder(Map x0, EqualAction x1, 1 x2) {
            this(x0, x1);
        }
    }
}

