/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.dev.test.TestLog;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRURLS;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StackTracker;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StaticCLDRURLS;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CLDRConfig
extends Properties {
    public static boolean SKIP_SEED = System.getProperty("CLDR_SKIP_SEED") != null;
    private static final long serialVersionUID = -2605254975303398336L;
    public static boolean DEBUG = false;
    private static CLDRConfig INSTANCE = null;
    public static final String SUBCLASS = CLDRConfig.class.getName() + "Impl";
    private static final Object CLDR_FACTORY_SYNC = new Object();
    private static final Object FULL_FACTORY_SYNC = new Object();
    private static final Object EXEMPLARS_FACTORY_SYNC = new Object();
    private static final Object COLLATION_FACTORY_SYNC = new Object();
    private static final Object RBNF_FACTORY_SYNC = new Object();
    private static final Object ANNOTATIONS_FACTORY_SYNC = new Object();
    private static final Object SUBDIVISION_FACTORY_SYNC = new Object();
    private static final Object SUPPLEMENTAL_DATA_SYNC = new Object();
    private static final Object GET_COLLATOR_SYNC = new Object();
    private static final Object GET_COLLATOR_SYNC_ROOT = new Object();
    private static final Object GET_STANDARD_CODES_SYNC = new Object();
    private static Object COVERAGE_INFO_SYNC = new Object();
    String initStack = null;
    private CoverageInfo coverageInfo = null;
    private SupplementalDataInfo supplementalDataInfo;
    private StandardCodes sc;
    private Factory cldrFactory;
    private Factory fullFactory;
    private Factory mainAndAnnotationsFactory;
    private Factory commonAndSeedAndMainAndAnnotationsFactory;
    private Factory exemplarsFactory;
    private Factory collationFactory;
    private Factory rbnfFactory;
    private Factory annotationsFactory;
    private Factory subdivisionFactory;
    private Factory supplementalFactory;
    private RuleBasedCollator colRoot;
    private RuleBasedCollator col;
    private CheckCLDR.Phase phase = null;
    private LoadingCache<String, CLDRFile> cldrFileResolvedCache = CacheBuilder.newBuilder().maximumSize(200L).build(new CacheLoader<String, CLDRFile>(){

        @Override
        public CLDRFile load(String locale) {
            return CLDRConfig.this.getFullCldrFactory().make(locale, true);
        }
    });
    private LoadingCache<String, CLDRFile> cldrFileUnresolvedCache = CacheBuilder.newBuilder().maximumSize(1000L).build(new CacheLoader<String, CLDRFile>(){

        @Override
        public CLDRFile load(String locale) {
            return CLDRConfig.this.getFullCldrFactory().make(locale, false);
        }
    });
    private TestLog testLog = null;
    static Factory allFactory;
    private Set<String> shown = new HashSet<String>();
    private Map<String, String> localSet = null;
    private Environment curEnvironment = null;
    private static final String COMMON_DIR = "common";
    private static final String EXEMPLARS_DIR = "exemplars";
    private static final String SEED_DIR = "seed";
    private static final String KEYBOARDS_DIR = "keyboards";
    private static final String MAIN_DIR = "main";
    private static final String ANNOTATIONS_DIR = "annotations";
    private static final String SUBDIVISIONS_DIR = "subdivisions";
    private static final String[] CLDR_DATA_DIRECTORIES;
    private static final ImmutableSet<String> STANDARD_SUBDIRS;
    private CLDRURLS urls = null;
    private CLDRURLS absoluteUrls = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLDRConfig getInstance() {
        Class<CLDRConfig> clazz = CLDRConfig.class;
        synchronized (CLDRConfig.class) {
            if (INSTANCE == null) {
                String env = System.getProperty("CLDR_ENVIRONMENT");
                if (env != null && env.equals(Environment.UNITTEST.name())) {
                    if (DEBUG) {
                        System.err.println("-DCLDR_ENVIRONMENT=" + env + " - not loading " + SUBCLASS);
                    }
                } else {
                    try {
                        INSTANCE = (CLDRConfig)Class.forName(SUBCLASS).newInstance();
                        if (INSTANCE != null) {
                            System.err.println("Using CLDRConfig: " + INSTANCE.toString() + " - " + INSTANCE.getClass().getName());
                        } else if (DEBUG) {
                            System.err.println("Note: CLDRConfig Subclass " + SUBCLASS + ".newInstance() returned NULL ( this is OK if we aren't inside the SurveyTool's web server )");
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        // empty catch block
                    }
                }
            }
            if (INSTANCE == null) {
                INSTANCE = new CLDRConfig();
                CldrUtility.checkValidDirectory(INSTANCE.getProperty("CLDR_DIR"), "You have to set -DCLDR_DIR=<validdirectory>");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    protected CLDRConfig() {
        this.initStack = StackTracker.currentStack();
    }

    public String getInitStack() {
        return this.initStack;
    }

    public TestLog setTestLog(TestLog log) {
        this.testLog = log;
        return log;
    }

    public TestFmwk setTestLog(TestFmwk log) {
        this.testLog = log;
        return log;
    }

    protected void logln(String msg) {
        if (this.testLog != null) {
            this.testLog.logln(msg);
        } else {
            System.out.println(msg);
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SupplementalDataInfo getSupplementalDataInfo() {
        Object object = SUPPLEMENTAL_DATA_SYNC;
        synchronized (object) {
            if (this.supplementalDataInfo == null) {
                this.supplementalDataInfo = SupplementalDataInfo.getInstance(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY);
            }
        }
        return this.supplementalDataInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardCodes getStandardCodes() {
        Object object = GET_STANDARD_CODES_SYNC;
        synchronized (object) {
            if (this.sc == null) {
                this.sc = StandardCodes.make();
            }
        }
        return this.sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageInfo getCoverageInfo() {
        Object object = COVERAGE_INFO_SYNC;
        synchronized (object) {
            if (this.coverageInfo == null) {
                this.coverageInfo = new CoverageInfo(this.getSupplementalDataInfo());
            }
        }
        return this.coverageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getCldrFactory() {
        Object object = CLDR_FACTORY_SYNC;
        synchronized (object) {
            if (this.cldrFactory == null) {
                this.cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
            }
        }
        return this.cldrFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getExemplarsFactory() {
        Object object = EXEMPLARS_FACTORY_SYNC;
        synchronized (object) {
            if (this.exemplarsFactory == null) {
                this.exemplarsFactory = Factory.make(CLDRPaths.EXEMPLARS_DIRECTORY, ".*");
            }
        }
        return this.exemplarsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getCollationFactory() {
        Object object = COLLATION_FACTORY_SYNC;
        synchronized (object) {
            if (this.collationFactory == null) {
                this.collationFactory = Factory.make(CLDRPaths.COLLATION_DIRECTORY, ".*");
            }
        }
        return this.collationFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getRBNFFactory() {
        Object object = RBNF_FACTORY_SYNC;
        synchronized (object) {
            if (this.rbnfFactory == null) {
                this.rbnfFactory = Factory.make(CLDRPaths.RBNF_DIRECTORY, ".*");
            }
        }
        return this.rbnfFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getAnnotationsFactory() {
        Object object = ANNOTATIONS_FACTORY_SYNC;
        synchronized (object) {
            if (this.annotationsFactory == null) {
                this.annotationsFactory = Factory.make(CLDRPaths.ANNOTATIONS_DIRECTORY, ".*");
            }
        }
        return this.annotationsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getSubdivisionFactory() {
        Object object = SUBDIVISION_FACTORY_SYNC;
        synchronized (object) {
            if (this.subdivisionFactory == null) {
                this.subdivisionFactory = Factory.make(CLDRPaths.SUBDIVISIONS_DIRECTORY, ".*");
            }
        }
        return this.subdivisionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getMainAndAnnotationsFactory() {
        Object object = FULL_FACTORY_SYNC;
        synchronized (object) {
            if (this.mainAndAnnotationsFactory == null) {
                File[] paths = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), new File(CLDRPaths.ANNOTATIONS_DIRECTORY)};
                this.mainAndAnnotationsFactory = SimpleFactory.make(paths, ".*");
            }
        }
        return this.mainAndAnnotationsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getCommonSeedExemplarsFactory() {
        Object object = FULL_FACTORY_SYNC;
        synchronized (object) {
            if (allFactory == null) {
                allFactory = SimpleFactory.make(this.addStandardSubdirectories(CLDR_DATA_DIRECTORIES), ".*");
            }
        }
        return allFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getCommonAndSeedAndMainAndAnnotationsFactory() {
        Object object = FULL_FACTORY_SYNC;
        synchronized (object) {
            if (this.commonAndSeedAndMainAndAnnotationsFactory == null) {
                File[] paths = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), new File(CLDRPaths.ANNOTATIONS_DIRECTORY), SKIP_SEED ? null : new File(CLDRPaths.SEED_DIRECTORY), SKIP_SEED ? null : new File(CLDRPaths.SEED_ANNOTATIONS_DIRECTORY)};
                this.commonAndSeedAndMainAndAnnotationsFactory = SimpleFactory.make(paths, ".*");
            }
        }
        return this.commonAndSeedAndMainAndAnnotationsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getFullCldrFactory() {
        Object object = FULL_FACTORY_SYNC;
        synchronized (object) {
            if (this.fullFactory == null) {
                File[] paths = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), SKIP_SEED ? null : new File(CLDRPaths.SEED_DIRECTORY)};
                this.fullFactory = SimpleFactory.make(paths, ".*");
            }
        }
        return this.fullFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Factory getSupplementalFactory() {
        Object object = CLDR_FACTORY_SYNC;
        synchronized (object) {
            if (this.supplementalFactory == null) {
                this.supplementalFactory = Factory.make(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY, ".*");
            }
        }
        return this.supplementalFactory;
    }

    public CLDRFile getEnglish() {
        return this.getCLDRFile("en", true);
    }

    public CLDRFile getCLDRFile(String locale, boolean resolved) {
        return resolved ? this.cldrFileResolvedCache.getUnchecked(locale) : this.cldrFileUnresolvedCache.getUnchecked(locale);
    }

    public CLDRFile getRoot() {
        return this.getCLDRFile("root", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collator getCollatorRoot() {
        Object object = GET_COLLATOR_SYNC_ROOT;
        synchronized (object) {
            if (this.colRoot == null) {
                CLDRFile root = this.getCollationFactory().make("root", false);
                String rules = root.getStringValue("//ldml/collations/collation[@type=\"emoji\"][@visibility=\"external\"]/cr");
                try {
                    this.colRoot = new RuleBasedCollator(rules);
                }
                catch (Exception e) {
                    this.colRoot = (RuleBasedCollator)this.getCollator();
                    return this.colRoot;
                }
                this.colRoot.setStrength(15);
                this.colRoot.setNumericCollation(true);
                this.colRoot.freeze();
            }
        }
        return this.colRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collator getCollator() {
        Object object = GET_COLLATOR_SYNC;
        synchronized (object) {
            if (this.col == null) {
                this.col = (RuleBasedCollator)Collator.getInstance(ULocale.forLanguageTag("en-u-co-emoji"));
                this.col.setStrength(15);
                this.col.setNumericCollation(true);
                this.col.freeze();
            }
        }
        return this.col;
    }

    public synchronized CheckCLDR.Phase getPhase() {
        if (this.phase == null) {
            this.phase = this.getEnvironment() == Environment.UNITTEST ? CheckCLDR.Phase.BUILD : CheckCLDR.Phase.SUBMISSION;
        }
        return this.phase;
    }

    @Override
    public String getProperty(String key, String d) {
        String result = this.getProperty(key);
        if (result == null) {
            return d;
        }
        return result;
    }

    @Override
    public String get(Object key) {
        return this.getProperty(key.toString());
    }

    @Override
    public String getProperty(String key) {
        String result = null;
        if (this.localSet != null) {
            result = this.localSet.get(key);
        }
        if (result == null) {
            result = System.getProperty(key);
        }
        if (result == null) {
            result = System.getProperty(key.toUpperCase(Locale.ENGLISH));
        }
        if (result == null) {
            result = System.getProperty(key.toLowerCase(Locale.ENGLISH));
        }
        if (result == null) {
            result = System.getenv(key);
        }
        if (DEBUG && !this.shown.contains(key)) {
            this.logln("-D" + key + "=" + result);
            this.shown.add(key);
        }
        return result;
    }

    public Environment getEnvironment() {
        if (this.curEnvironment == null) {
            String envString = this.getProperty("CLDR_ENVIRONMENT");
            if (envString != null) {
                this.curEnvironment = Environment.valueOf(envString.trim());
            }
            if (this.curEnvironment == null) {
                this.curEnvironment = this.getDefaultEnvironment();
            }
        }
        return this.curEnvironment;
    }

    protected Environment getDefaultEnvironment() {
        return Environment.LOCAL;
    }

    public void setEnvironment(Environment environment) {
        this.curEnvironment = environment;
    }

    @Override
    public Object setProperty(String k, String v) {
        if (this.getEnvironment() != Environment.UNITTEST) {
            throw new InternalError("setProperty() only valid in UNITTEST Environment.");
        }
        if (this.localSet == null) {
            this.localSet = new ConcurrentHashMap<String, String>();
        }
        this.shown.remove(k);
        return this.localSet.put(k, v);
    }

    @Override
    public Object put(Object k, Object v) {
        return this.setProperty(k.toString(), v.toString());
    }

    public boolean getProperty(String k, boolean defVal) {
        String val = this.getProperty(k, defVal ? "true" : null);
        if (val == null) {
            return false;
        }
        return (val = val.trim().toLowerCase()).equals("true") || val.equals("t") || val.equals("yes") || val.equals("y");
    }

    public int getProperty(String k, int defVal) {
        String val = this.getProperty(k, Integer.toString(defVal));
        if (val == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return defVal;
        }
    }

    public File getCldrBaseDirectory() {
        return FileWrapper.getFileWrapperInstance().getCldrDir();
    }

    public Set<File> getAllCLDRFilesEndingWith(final String suffix) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(suffix) && !CLDRConfig.isJunkFile(name);
            }
        };
        File dir = this.getCldrBaseDirectory();
        Set<File> list = this.getCLDRFilesMatching(filter, dir);
        return list;
    }

    public Set<File> getCLDRFilesMatching(FilenameFilter filter, File baseDir) {
        LinkedHashSet<File> list = new LinkedHashSet<File>();
        for (String subdir : this.getCLDRDataDirectories()) {
            this.getFilesRecursively(new File(baseDir, subdir), filter, list);
        }
        return list;
    }

    public Iterable<String> getCLDRDataDirectories() {
        return Arrays.asList(CLDR_DATA_DIRECTORIES);
    }

    public File[] getCLDRDataDirectories(String list) {
        File dir = this.getCldrBaseDirectory();
        String[] stubs = list.split(",");
        File[] ret = new File[stubs.length];
        for (int i = 0; i < stubs.length; ++i) {
            ret[i] = new File(dir, stubs[i]);
        }
        return ret;
    }

    public File[] addStandardSubdirectories(String ... base) {
        return this.addStandardSubdirectories(this.fileArrayFromStringArray(this.getCldrBaseDirectory(), base));
    }

    public File[] addStandardSubdirectories(File ... base) {
        ArrayList<File> ret = new ArrayList<File>();
        for (int i = 0; i < base.length; ++i) {
            File baseFile = base[i];
            String name = baseFile.getName();
            if (STANDARD_SUBDIRS.contains(name)) {
                ret.add(baseFile);
                continue;
            }
            for (String sub : STANDARD_SUBDIRS) {
                this.addIfExists(ret, baseFile, sub);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    public File[] fileArrayFromStringArray(File dir, String ... subdirNames) {
        File[] fileList = new File[subdirNames.length];
        int i = 0;
        for (String item : subdirNames) {
            fileList[i++] = new File(dir, item);
        }
        return fileList;
    }

    private void addIfExists(List<File> ret, File baseFile, String sub) {
        File file = new File(baseFile, sub);
        if (file.exists()) {
            ret.add(file);
        }
    }

    public Set<File> getFilesRecursively(File directory, FilenameFilter filter, Set<File> toAddTo) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File subfile : files) {
                if (subfile.isDirectory()) {
                    if (CLDRConfig.isJunkFile(subfile.getName())) continue;
                    this.getFilesRecursively(subfile, filter, toAddTo);
                    continue;
                }
                if (!filter.accept(directory, subfile.getName())) continue;
                toAddTo.add(subfile);
            }
        }
        return toAddTo;
    }

    public static final boolean isJunkFile(String name) {
        return name.startsWith(".") || name.startsWith("#");
    }

    public boolean getDebugSettingsFor(Class<?> callingClass) {
        return this.getDebugSettingsFor(callingClass, false);
    }

    public boolean getDebugSettingsFor(Class<?> callingClass, boolean defaultValue) {
        if (callingClass == null) {
            return defaultValue;
        }
        return this.getProperty(callingClass.getCanonicalName() + ".debug", defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLDRURLS urls() {
        if (this.urls == null) {
            CLDRConfig cLDRConfig = this;
            synchronized (cLDRConfig) {
                this.urls = this.internalGetUrls();
            }
        }
        return this.urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLDRURLS absoluteUrls() {
        if (this.absoluteUrls == null) {
            CLDRConfig cLDRConfig = this;
            synchronized (cLDRConfig) {
                this.absoluteUrls = this.internalGetAbsoluteUrls();
            }
        }
        return this.absoluteUrls;
    }

    protected CLDRURLS internalGetAbsoluteUrls() {
        return new StaticCLDRURLS(this.getProperty("CLDR_SURVEY_BASE", "http://st.unicode.org/cldr-apps"));
    }

    protected CLDRURLS internalGetUrls() {
        return this.absoluteUrls();
    }

    public boolean isCldrVersionBefore(int ... version) {
        return this.getEnglish().getDtdVersionInfo().compareTo(CLDRConfig.getVersion(version)) < 0;
    }

    public static VersionInfo getVersion(int ... versionInput) {
        int[] version = new int[4];
        for (int i = 0; i < versionInput.length; ++i) {
            version[i] = versionInput[i];
        }
        return VersionInfo.getInstance(version[0], version[1], version[2], version[3]);
    }

    static {
        CLDR_DATA_DIRECTORIES = new String[]{COMMON_DIR, SEED_DIR, KEYBOARDS_DIR, EXEMPLARS_DIR};
        STANDARD_SUBDIRS = ImmutableSet.of(MAIN_DIR, ANNOTATIONS_DIR, SUBDIVISIONS_DIR);
    }

    public static enum Environment {
        LOCAL,
        SMOKETEST,
        PRODUCTION,
        UNITTEST;

    }

    private static class FileWrapper {
        private File cldrDir = null;
        private static FileWrapper fileWrapperInstance = new FileWrapper();

        private FileWrapper() {
            String dir = CLDRConfig.getInstance().getProperty("CLDR_DIR", null);
            this.cldrDir = dir != null ? new File(dir) : null;
        }

        public File getCldrDir() {
            return this.cldrDir;
        }

        public static FileWrapper getFileWrapperInstance() {
            return fileWrapperInstance;
        }
    }
}

