/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.CanonicalIterator;
import com.ibm.icu.text.CollationElementIterator;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RawCollationKey;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.VariantFolder;
import org.unicode.cldr.util.XEquivalenceMap;

public class CollationMapMaker {
    public static final boolean SHOW_DEBUG = false;
    static final boolean showDetails = false;
    static final RuleBasedCollator uca = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
    static final UnicodeSet filteredChars = new UnicodeSet("[{ss}[^[:Co:][:Cf:][:Cc:][:Cn:][:Cs:][:script=Han:][:script=Hangul:]-[:nfkcquickcheck=no:]]]").freeze();
    RuleBasedCollator equivalenceClassCollator;
    Comparator exemplarComparator;
    Map<String, String> reasonMap = new TreeMap<String, String>();
    XEquivalenceMap equivMap = new XEquivalenceMap();
    VariantFolder caseFolder = new VariantFolder(new VariantFolder.CaseVariantFolder());
    VariantFolder.AlternateFetcher COLLATION_FETCHER = new VariantFolder.AlternateFetcher(){

        @Override
        public Set<String> getAlternates(String item, Set<String> output) {
            output.add(item);
            Set<String> set = CollationMapMaker.this.equivMap.getEquivalences(item);
            if (set != null) {
                output.addAll(set);
            }
            return output;
        }
    };
    private static UnicodeSet fullExpansions = null;
    CanonicalIterator canonicalIterator = new CanonicalIterator("");
    Set<CharSequence> seenSoFar = new TreeSet<CharSequence>();
    static UnicodeSet spaceTatweelAndNSM = new UnicodeSet("[\\u0020\\u0640[:Mn:][:Me:]]");
    static UnicodeSet NSM = new UnicodeSet("[[:Mn:][:Me:]]");

    public Map<CharSequence, String> generateCollatorFolding(RuleBasedCollator equivalenceClassCollator, Map<CharSequence, String> mapping) {
        String item;
        this.equivalenceClassCollator = equivalenceClassCollator;
        try {
            RuleBasedCollator exemplarCollator = (RuleBasedCollator)equivalenceClassCollator.clone();
            exemplarCollator.setStrength(15);
            exemplarCollator.setDecomposition(17);
            exemplarCollator.setUpperCaseFirst(false);
            exemplarCollator.setAlternateHandlingShifted(false);
            exemplarCollator.setNumericCollation(false);
            exemplarCollator.setCaseLevel(false);
            exemplarCollator.setFrenchCollation(false);
            exemplarCollator.setHiraganaQuaternary(false);
            this.exemplarComparator = new ExemplarComparator(exemplarCollator);
        }
        catch (CloneNotSupportedException exemplarCollator) {
            // empty catch block
        }
        UnicodeSet expansions = new UnicodeSet();
        UnicodeSet contractions = new UnicodeSet();
        try {
            equivalenceClassCollator.getContractionsAndExpansions(contractions, expansions, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UnicodeSet trialCharacters = new UnicodeSet(filteredChars).addAll(equivalenceClassCollator.getTailoredSet()).addAll(contractions).addAll(expansions);
        UnicodeSetIterator i = new UnicodeSetIterator(trialCharacters);
        while (i.next()) {
            item = i.getString();
            this.addItems(item);
        }
        i = new UnicodeSetIterator(CollationMapMaker.getFullExpansions());
        while (i.next()) {
            item = i.getString();
            this.addItems(item);
        }
        this.closeUnderFolding();
        int count = 0;
        int countMapped = 0;
        TreeSet values = new TreeSet(this.exemplarComparator);
        for (Set values1 : this.equivMap) {
            if (values1.size() == 1) continue;
            values.clear();
            values.addAll(values1);
            Iterator chars = values.iterator();
            String target = (String)chars.next();
            while (chars.hasNext()) {
                String source = (String)chars.next();
                mapping.put(source, target);
            }
            ++count;
            countMapped += values.size() - 1;
        }
        return mapping;
    }

    private void closeUnderFolding() {
        HashSet<String> others = new HashSet<String>();
        ArrayList input = new ArrayList();
        VariantFolder recursiveFolder = new VariantFolder(this.COLLATION_FETCHER);
        TreeSet<String> hack = new TreeSet<String>();
        hack.add("aa");
        block0: while (true) {
            others.clear();
            for (CharSequence charSequence : hack) {
                String str;
                if (charSequence.length() == 1 || UTF16.countCodePoint(str = charSequence.toString()) <= 1) continue;
                Set<String> results = recursiveFolder.getClosure(charSequence.toString());
                results.removeAll(this.seenSoFar);
                Log.logln(charSequence + "\t" + results);
                others.addAll(results);
            }
            if (others.size() == 0) break;
            Iterator iterator = others.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String string = (String)iterator.next();
                this.addToEquiv(string, string);
            }
            break;
        }
    }

    static UnicodeSet getFullExpansions() {
        if (fullExpansions == null) {
            fullExpansions = new UnicodeSet();
            CollationMapMaker.addExpansionResults(fullExpansions);
        }
        return fullExpansions;
    }

    private static UnicodeSet addExpansionResults(UnicodeSet fullExpansions) {
        StringBuffer trialString = new StringBuffer();
        TreeMap<String, String> stringToKey = new TreeMap<String, String>();
        TreeMap<String, String> keyToString = new TreeMap<String, String>();
        HashSet<String> nfkc = new HashSet<String>();
        for (int i = 0; i < 0x10FFFF; ++i) {
            int element;
            int cat = UCharacter.getType(i);
            if (cat == 0 || cat == 17 || cat == 18) continue;
            String source = UTF16.valueOf(i);
            nfkc.add(Normalizer.compose(source, true));
            CollationElementIterator x = uca.getCollationElementIterator(source);
            trialString.setLength(0);
            while ((element = x.next()) != -1) {
                char primaryOrder = (char)CollationElementIterator.primaryOrder(element);
                if (primaryOrder == '\u0000') continue;
                trialString.append(primaryOrder);
            }
            if (trialString.length() == 0) continue;
            String key = trialString.toString();
            stringToKey.put(source, key);
            String newSource = (String)keyToString.get(key);
            if (newSource != null) continue;
            keyToString.put(key, source);
        }
        UnicodeSet expansions = new UnicodeSet();
        UnicodeSet contractions = new UnicodeSet();
        try {
            uca.getContractionsAndExpansions(contractions, expansions, true);
        }
        catch (Exception e1) {
            throw new IllegalArgumentException(e1);
        }
        fullExpansions = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(expansions);
        block4: while (usi.next()) {
            trialString.setLength(0);
            String source = usi.getString();
            String key = (String)stringToKey.get(source);
            if (key == null || key.length() == 1) continue;
            block5: while (key.length() > 0) {
                for (Map.Entry e : keyToString.entrySet()) {
                    String otherKey = (String)e.getKey();
                    if (!key.startsWith(otherKey)) continue;
                    trialString.append((String)e.getValue());
                    key = key.substring(otherKey.length());
                    continue block5;
                }
                System.out.println("Failed with: " + source);
                continue block4;
            }
            String result = trialString.toString();
            if (contractions.contains(result) || nfkc.contains(result)) continue;
            fullExpansions.add(result);
        }
        fullExpansions.freeze();
        return fullExpansions;
    }

    private void addItems(String item) {
        this.addItems2(item, item);
        String minNFKD = this.getMinimalNKFD(item, this.equivalenceClassCollator);
        if (!minNFKD.equals(item)) {
            this.addItems2(minNFKD, item);
        }
        this.canonicalIterator.setSource(item);
        String nextItem = this.canonicalIterator.next();
        while (nextItem != null) {
            this.addItems2(nextItem, item);
            nextItem = this.canonicalIterator.next();
        }
    }

    private void addItems2(String item, String original) {
        this.addItems3(item, original);
        for (String nextItem : this.caseFolder.getClosure(item)) {
            this.addItems3(nextItem, original);
        }
    }

    private void addItems3(String item, String original) {
        this.addToEquiv(item, original);
        this.canonicalIterator.setSource(item);
        String newItem = this.canonicalIterator.next();
        while (newItem != null) {
            this.addToEquiv(newItem, original);
            newItem = this.canonicalIterator.next();
        }
    }

    private void addToEquiv(String item, String original) {
        if (item.equals("aA")) {
            System.out.println("ouch");
        }
        if (this.seenSoFar.contains(item)) {
            return;
        }
        this.seenSoFar.add(item);
        RawCollationKey k = this.equivalenceClassCollator.getRawCollationKey(item, null);
        this.equivMap.add(item, k);
        this.reasonMap.put(item, original);
    }

    private String getMinimalNKFD(String item, Collator ucaWeak) {
        String nfkd = Normalizer.decompose(item, true);
        if (nfkd.startsWith(" ") && spaceTatweelAndNSM.containsAll(nfkd)) {
            return item;
        }
        String start = "";
        String end = nfkd;
        while (end.length() != 0) {
            int cp = UTF16.charAt(end, 0);
            String tryEnd = end.substring(UTF16.getCharCount(cp));
            String trial = start + tryEnd;
            if (!ucaWeak.equals(trial, item)) {
                start = start + UTF16.valueOf(cp);
            }
            end = tryEnd;
        }
        return start;
    }

    static class ExemplarComparator
    implements Comparator {
        Comparator comp;

        public int compare(Object o1, Object o2) {
            int n2;
            String s1 = (String)o1;
            String s2 = (String)o2;
            int n1 = Normalizer.isNormalized(s1, Normalizer.DECOMP_COMPAT, 0) ? 0 : 1;
            int result = n1 - (n2 = Normalizer.isNormalized(s2, Normalizer.DECOMP_COMPAT, 0) ? 0 : 1);
            if (result != 0) {
                return result;
            }
            result = UTF16.countCodePoint(s2) - UTF16.countCodePoint(s1);
            if (result != 0) {
                if (s1.length() == 0) {
                    return -1;
                }
                if (s2.length() == 0) {
                    return 1;
                }
                return result;
            }
            result = this.comp.compare(s1, s2);
            if (result != 0) {
                return result;
            }
            return s1.compareTo(s2);
        }

        public ExemplarComparator(Comparator comp) {
            this.comp = comp;
        }
    }

    public static class Folder
    implements Cloneable {
        private UnicodeMap m = new UnicodeMap();
        static Transliterator FullWidthKana = Transliterator.getInstance("fullwidth-halfwidth; [[:script=katakana:][:script=hangul:]] halfwidth-fullwidth; katakana-hiragana");

        public Object clone() {
            try {
                Folder result = (Folder)super.clone();
                result.m = this.m.cloneAsThawed();
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("Clone problem");
            }
        }

        public Object getValue(int i) {
            return this.m.getValue(i);
        }

        public UnicodeSet keySet() {
            return this.m.keySet();
        }

        public Folder put(int cp, String result) {
            this.m.put(cp, result);
            return this;
        }

        public Folder putAll(UnicodeSet set, String result) {
            this.m.putAll(set, result);
            return this;
        }

        public UnicodeSet getCharactersMapped() {
            return this.m.keySet();
        }

        public void minimalize() {
            Object newMap = this.m.cloneAsThawed();
            UnicodeSetIterator i = new UnicodeSetIterator(this.m.keySet());
            while (i.next()) {
                String s2 = (String)this.m.getValue(i.codepoint);
                ((UnicodeMap)newMap).put(i.codepoint, null);
                String t = ((UnicodeMap)newMap).transform(((UnicodeMap)newMap).transform(i.getString()));
                if (t.equals(s2)) continue;
                ((UnicodeMap)newMap).put(i.codepoint, s2);
            }
        }

        public void complete() {
            while (this.fixNeeded()) {
            }
        }

        public boolean fixNeeded() {
            UnicodeMap<String> newMap = new UnicodeMap<String>();
            UnicodeSet values = this.m.keySet();
            boolean changed = false;
            UnicodeSetIterator i = new UnicodeSetIterator(values);
            while (i.next()) {
                String result = (String)this.m.getValue(i.codepoint);
                String newResult = this.fold(result);
                if (!newResult.equals(result)) {
                    changed = true;
                }
                newMap.put(i.codepoint, newResult);
            }
            this.m = newMap;
            return changed;
        }

        public String fold(String s2) {
            return this.m.transform(s2);
        }

        Folder removeEquals(Folder toRemove, boolean addIdentity) {
            UnicodeMap result = new UnicodeMap();
            for (int i = 0; i <= 0x10FFFF; ++i) {
                Object y;
                Object x = this.m.getValue(i);
                if (UnicodeMap.areEqual(x, y = toRemove.m.getValue(i))) continue;
                if (x != null) {
                    result.put(i, x);
                    continue;
                }
                if (!addIdentity) continue;
                result.put(i, UTF16.valueOf(i));
            }
            this.m = result;
            return this;
        }

        static String getSpecialFolded(String a) {
            String result = a;
            result = Normalizer.normalize(result, Normalizer.NFKC);
            result = FullWidthKana.transliterate(result);
            result = UCharacter.foldCase(result, true);
            result = Normalizer.normalize(result, Normalizer.NFKC);
            return result;
        }

        public UnicodeMap getUnicodeMap() {
            return this.m.cloneAsThawed();
        }
    }
}

