/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.IOException;
import java.io.Writer;

public final class DualWriter
extends Writer {
    private boolean autoflush;
    private Writer a;
    private Writer b;

    public DualWriter(Writer a, Writer b) {
        this.a = a;
        this.b = b;
    }

    public DualWriter(Writer a, Writer b, boolean autoFlush) {
        this.a = a;
        this.b = b;
        this.autoflush = autoFlush;
    }

    public void setAutoFlush(boolean value) {
        this.autoflush = value;
    }

    public boolean getAutoFlush() {
        return this.autoflush;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.a.write(cbuf, off, len);
        this.b.write(cbuf, off, len);
        if (this.autoflush) {
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.a.close();
        this.b.close();
    }

    @Override
    public void flush() throws IOException {
        this.a.flush();
        this.b.flush();
    }
}

