/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.FileReaders;

public class FileProcessor {
    private int lineCount;
    protected boolean doHash = true;

    protected void handleStart() {
    }

    protected boolean handleLine(int lineCount, String line) {
        return true;
    }

    protected void handleEnd() {
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void handleComment(String line, int commentCharPosition) {
    }

    public FileProcessor process(Class<?> classLocation, String fileName) {
        try {
            System.err.println("# Reading config file " + fileName);
            BufferedReader in = FileReaders.openFile(classLocation, fileName);
            return this.process(in, fileName);
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException(this.lineCount + ":\t" + 0 + " - while reading" + fileName).initCause(e);
        }
    }

    public FileProcessor process(String fileName) {
        try {
            FileInputStream fileStream = new FileInputStream(fileName);
            InputStreamReader reader = new InputStreamReader((InputStream)fileStream, CldrUtility.UTF8);
            BufferedReader bufferedReader = new BufferedReader(reader, 65536);
            return this.process(bufferedReader, fileName);
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException(this.lineCount + ":\t" + 0).initCause(e);
        }
    }

    public FileProcessor process(String directory, String fileName) {
        try {
            FileInputStream fileStream = new FileInputStream(directory + File.separator + fileName);
            InputStreamReader reader = new InputStreamReader((InputStream)fileStream, CldrUtility.UTF8);
            BufferedReader bufferedReader = new BufferedReader(reader, 65536);
            return this.process(bufferedReader, fileName);
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException(this.lineCount + ":\t" + 0).initCause(e);
        }
    }

    public FileProcessor process(BufferedReader in, String fileName) {
        this.handleStart();
        String line = null;
        this.lineCount = 1;
        try {
            while ((line = in.readLine()) != null) {
                int comment = line.indexOf("#");
                if (comment == 0 || this.doHash && comment >= 0) {
                    this.handleComment(line, comment);
                    line = line.substring(0, comment);
                }
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if ((line = line.trim()).length() != 0 && !this.handleLine(this.lineCount, line)) break;
                ++this.lineCount;
            }
            in.close();
            this.handleEnd();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(this.lineCount + ":\t" + line, e);
        }
        return this;
    }
}

