/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringRange;
import org.unicode.cldr.util.Validity;

public class StringRangeTest
extends TestFmwk {
    static final Splitter ONSPACE = Splitter.on(' ').omitEmptyStrings();
    static final Splitter ONTILDE = Splitter.on('~').omitEmptyStrings();

    public static void main(String[] args) {
        new StringRangeTest().run(args);
    }

    static String show(Set<String> output) {
        StringBuilder b = new StringBuilder();
        for (String s2 : output) {
            StringRangeTest.append(b, s2);
        }
        return b.toString();
    }

    static void append(StringBuilder b, String start) {
        if (start.codePointCount(0, start.length()) == 1) {
            b.append(start);
        } else {
            b.append('{').append(start).append('}');
        }
    }

    public void TestSimple() {
        String[][] tests = new String[][]{{"a", "cd", "Must have start-length \u2265 end-length", "", ""}, {"a", "", "Must have end-length > 0", "", ""}, {"ab", "ad", "{ab}{ac}{ad}", "{ab}-{ad}", "{ab}-d", "{ab}-{ad}", "{ab}-d"}, {"ab", "cd", "{ab}{ac}{ad}{bb}{bc}{bd}{cb}{cc}{cd}", "{ab}-{ad} {bb}-{bd} {cb}-{cd}", "{ab}-d {bb}-d {cb}-d", "{ab}-{cd}", "{ab}-{cd}"}, {"\ud83d\udc66\ud83c\udffb", "\ud83d\udc66\ud83c\udfff", "{\ud83d\udc66\ud83c\udffb}{\ud83d\udc66\ud83c\udffc}{\ud83d\udc66\ud83c\udffd}{\ud83d\udc66\ud83c\udffe}{\ud83d\udc66\ud83c\udfff}", "{\ud83d\udc66\ud83c\udffb}-{\ud83d\udc66\ud83c\udfff}", "{\ud83d\udc66\ud83c\udffb}-\ud83c\udfff", "{\ud83d\udc66\ud83c\udffb}-{\ud83d\udc66\ud83c\udfff}", "{\ud83d\udc66\ud83c\udffb}-\ud83c\udfff"}, {"qax\ud83d\udc66\ud83c\udffb", "cx\ud83d\udc66\ud83c\udfff", "{qax\ud83d\udc66\ud83c\udffb}{qax\ud83d\udc66\ud83c\udffc}{qax\ud83d\udc66\ud83c\udffd}{qax\ud83d\udc66\ud83c\udffe}{qax\ud83d\udc66\ud83c\udfff}{qbx\ud83d\udc66\ud83c\udffb}{qbx\ud83d\udc66\ud83c\udffc}{qbx\ud83d\udc66\ud83c\udffd}{qbx\ud83d\udc66\ud83c\udffe}{qbx\ud83d\udc66\ud83c\udfff}{qcx\ud83d\udc66\ud83c\udffb}{qcx\ud83d\udc66\ud83c\udffc}{qcx\ud83d\udc66\ud83c\udffd}{qcx\ud83d\udc66\ud83c\udffe}{qcx\ud83d\udc66\ud83c\udfff}", "{qax\ud83d\udc66\ud83c\udffb}-{qax\ud83d\udc66\ud83c\udfff} {qbx\ud83d\udc66\ud83c\udffb}-{qbx\ud83d\udc66\ud83c\udfff} {qcx\ud83d\udc66\ud83c\udffb}-{qcx\ud83d\udc66\ud83c\udfff}", "{qax\ud83d\udc66\ud83c\udffb}-\ud83c\udfff {qbx\ud83d\udc66\ud83c\udffb}-\ud83c\udfff {qcx\ud83d\udc66\ud83c\udffb}-\ud83c\udfff", "{qax\ud83d\udc66\ud83c\udffb}-{qcx\ud83d\udc66\ud83c\udfff}", "{qax\ud83d\udc66\ud83c\udffb}-{cx\ud83d\udc66\ud83c\udfff}"}};
        final StringBuilder b = new StringBuilder();
        StringRange.Adder myAdder = new StringRange.Adder(){

            @Override
            public void add(String start, String end) {
                if (b.length() != 0) {
                    b.append(' ');
                }
                StringRangeTest.append(b, start);
                if (end != null) {
                    b.append('-');
                    StringRangeTest.append(b, end);
                }
            }
        };
        for (String[] test : tests) {
            LinkedHashSet<String> output = new LinkedHashSet<String>();
            String start = test[0];
            String end = test[1];
            String expectedExpand = test[2];
            try {
                StringRange.expand(start, end, output);
                this.assertEquals("Expand " + start + "-" + end, expectedExpand, StringRangeTest.show(output));
            }
            catch (Exception e) {
                this.assertEquals("Expand " + start + "-" + end, expectedExpand, e.getMessage());
                continue;
            }
            int expectedIndex = 3;
            for (Boolean more : Arrays.asList(false, true)) {
                for (Boolean shorterPairs : Arrays.asList(false, true)) {
                    b.setLength(0);
                    String expectedCompact = test[expectedIndex++];
                    String message = "Compact " + ((Object)output).toString() + ", " + shorterPairs + ", " + more + "\n\t";
                    try {
                        StringRange.compact(output, myAdder, shorterPairs, more);
                        this.assertEquals(message, expectedCompact, b.toString());
                    }
                    catch (Exception e) {
                        this.assertEquals(message, null, e.getMessage());
                    }
                }
            }
        }
    }

    public void TestWithValidity() {
        final StringBuilder b = new StringBuilder();
        StringRange.Adder myAdder = new StringRange.Adder(){

            @Override
            public void add(String start, String end) {
                if (b.length() != 0) {
                    b.append(' ');
                }
                b.append(start);
                if (end != null) {
                    b.append('~');
                    b.append(end);
                }
            }
        };
        Validity validity = Validity.getInstance();
        NumberFormat pf = NumberFormat.getPercentInstance();
        for (StandardCodes.LstrType type : StandardCodes.LstrType.values()) {
            Map<Validity.Status, Set<String>> statusToCodes = validity.getStatusToCodes(type);
            for (Map.Entry<Validity.Status, Set<String>> entry2 : statusToCodes.entrySet()) {
                Set<String> values = entry2.getValue();
                String raw = Joiner.on(" ").join(values);
                double rawsize = raw.length();
                for (Boolean more : Arrays.asList(false, true)) {
                    for (Boolean shorterPairs : Arrays.asList(false, true)) {
                        Validity.Status key = entry2.getKey();
                        b.setLength(0);
                        if (more.booleanValue()) {
                            StringRange.compact(values, myAdder, shorterPairs, true);
                        } else {
                            StringRange.compact(values, myAdder, shorterPairs);
                        }
                        String compacted2 = b.toString();
                        this.logln((Object)((Object)type) + ":" + (Object)((Object)key) + ":\t" + compacted2.length() + "/" + raw.length() + " = " + pf.format((double)compacted2.length() / rawsize - 1.00000000000001) + "\t" + compacted2);
                        HashSet<String> restored = new HashSet<String>();
                        for (String part : ONSPACE.split(compacted2)) {
                            Iterator<String> mini = ONTILDE.split(part).iterator();
                            String main = mini.next();
                            if (mini.hasNext()) {
                                StringRange.expand(main, mini.next(), restored);
                                continue;
                            }
                            restored.add(main);
                        }
                        this.assertEquals((Object)((Object)type) + ":" + (Object)((Object)key) + "," + more + "," + shorterPairs, values, restored);
                    }
                }
            }
        }
    }
}

