/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class Visitor {
    public void doAt(Object item) {
        if (item instanceof Collection) {
            this.doAt((Collection)item);
        } else if (item instanceof Map) {
            this.doAt((Map)item);
        } else if (item instanceof Object[]) {
            this.doAt((Object[])item);
        } else if (item instanceof UnicodeSet) {
            this.doAt((UnicodeSet)item);
        } else {
            this.doSimpleAt(item);
        }
    }

    public int count(Object item) {
        if (item instanceof Collection) {
            return ((Collection)item).size();
        }
        if (item instanceof Map) {
            return ((Map)item).size();
        }
        if (item instanceof Object[]) {
            return ((Object[])item).length;
        }
        if (item instanceof UnicodeSet) {
            return ((UnicodeSet)item).size();
        }
        return 1;
    }

    public void doAt(int o) {
        this.doSimpleAt(new Integer(o));
    }

    public void doAt(double o) {
        this.doSimpleAt(new Double(o));
    }

    public void doAt(char o) {
        this.doSimpleAt(new Character(o));
    }

    protected void doAt(Collection c) {
        if (c.size() == 0) {
            this.doBefore(c, null);
        }
        Iterator it = c.iterator();
        boolean first = true;
        Object last = null;
        while (it.hasNext()) {
            Object item = it.next();
            if (first) {
                this.doBefore(c, item);
                first = false;
            } else {
                this.doBetween(c, last, item);
            }
            Object e = item;
            last = e;
            this.doAt(e);
        }
        this.doAfter(c, last);
    }

    protected void doAt(Map c) {
        this.doAt(c.entrySet());
    }

    protected void doAt(UnicodeSet c) {
        if (c.size() == 0) {
            this.doBefore(c, null);
        }
        UnicodeSetIterator it = new UnicodeSetIterator(c);
        boolean first = true;
        String last = null;
        CodePointRange cpr0 = new CodePointRange();
        CodePointRange cpr1 = new CodePointRange();
        while (it.nextRange()) {
            Object item;
            if (it.codepoint == UnicodeSetIterator.IS_STRING) {
                item = it.string;
            } else {
                CodePointRange cpr = last == cpr0 ? cpr1 : cpr0;
                cpr.codepoint = it.codepoint;
                cpr.codepointEnd = it.codepointEnd;
                item = cpr;
            }
            if (!first) {
                this.doBefore(c, item);
                first = true;
            } else {
                this.doBetween(c, last, item);
            }
            last = item;
            this.doAt(last);
        }
        this.doAfter(c, last);
    }

    protected void doAt(Object[] c) {
        this.doBefore(c, c.length == 0 ? null : c[0]);
        Object last = null;
        for (int i = 0; i < c.length; ++i) {
            if (i != 0) {
                this.doBetween(c, last, c[i]);
            }
            last = c[i];
            this.doAt(last);
        }
        this.doAfter(c, last);
    }

    protected abstract void doBefore(Object var1, Object var2);

    protected abstract void doBetween(Object var1, Object var2, Object var3);

    protected abstract void doAfter(Object var1, Object var2);

    protected abstract void doSimpleAt(Object var1);

    public static class CodePointRange {
        public int codepoint;
        public int codepointEnd;

        public String toString() {
            return "[" + this.codepoint + ", " + this.codepointEnd + "]";
        }
    }
}

