/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.tool.SubdivisionNode;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.XPathParts;

public final class WikiSubdivisionLanguages {
    static final SupplementalDataInfo SDI = SupplementalDataInfo.getInstance();
    static final Set<String> regularSubdivisions = Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.subdivision).get((Object)Validity.Status.regular);
    static final Map<String, Row.R2<List<String>, String>> SUBDIVISION_ALIASES = SDI.getLocaleAliasInfo().get("subdivision");
    private static final boolean DEBUG_CONSOLE = false;
    private static final String DEBUG_LANG_FILTER = null;
    private static final String BEFORE_TYPE = "//ldml/localeDisplayNames/subdivisions/subdivision[@type=\"";
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final Normalizer2 NFC = Normalizer2.getNFCInstance();
    private static ChainedMap.M3<String, String, String> SUB_LANG_NAME = ChainedMap.of(new TreeMap(), new TreeMap(), String.class);
    private static ChainedMap.M3<String, String, String> LANG_SUB_NAME = ChainedMap.of(new TreeMap(), new TreeMap(), String.class);
    private static Set<String> bogus = new TreeSet<String>();
    private static Multimap<Validity.Status, String> bogusStatus = TreeMultimap.create();
    static final List<String> MARKERS;

    public static String getSubdivisionName(String subdivisionId, String languageId) {
        return LANG_SUB_NAME.get(languageId, subdivisionId);
    }

    public static String getBestWikiEnglishName(String subdivisionId) {
        String languageId = "en";
        String name = WikiSubdivisionLanguages.getSubdivisionName(subdivisionId, languageId);
        if (name != null) {
            return name;
        }
        name = WikiSubdivisionLanguages.getSubdivisionName(subdivisionId, "es");
        if (name != null) {
            return name;
        }
        name = WikiSubdivisionLanguages.getSubdivisionName(subdivisionId, "fr");
        if (name != null) {
            return name;
        }
        Map<String, String> data = SUB_LANG_NAME.get(subdivisionId);
        if (data != null) {
            return data.entrySet().iterator().next().getValue();
        }
        return null;
    }

    private static String getSubdivisionPath(String subdivision) {
        return BEFORE_TYPE + subdivision + "\"][@draft=\"contributed\"]";
    }

    private static String getSubdivisionFromPath(String path) {
        return path.substring(BEFORE_TYPE.length(), path.indexOf(34, BEFORE_TYPE.length()));
    }

    public static void main(String[] args) {
        Counter<String> counter = new Counter<String>();
        Factory cldrFactory = CLDR_CONFIG.getCldrFactory();
        Factory cldrFactorySubdivisions = Factory.make(CLDRPaths.SUBDIVISIONS_DIRECTORY, ".*");
        CLDRFile file = null;
        UnicodeSet exemplars = null;
        ChainedMap.M4<Integer, String, String, String> exemplarFailureLangSubdivisionName = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), String.class);
        for (Map.Entry<String, Map<String, String>> entry : LANG_SUB_NAME) {
            CLDRFile oldFileSubdivisions;
            String lang = entry.getKey();
            file = cldrFactory.make(lang, true);
            try {
                oldFileSubdivisions = cldrFactorySubdivisions.make(lang, false);
            }
            catch (Exception e) {
                oldFileSubdivisions = new CLDRFile(new SimpleXMLSource(lang)).freeze();
            }
            LinkedHashMultimap<String, String> inverse = LinkedHashMultimap.create();
            CLDRFile fileSubdivisions = WikiSubdivisionLanguages.fixedFile(oldFileSubdivisions, inverse);
            UnicodeSet main = file.getExemplarSet("", CLDRFile.WinningChoice.WINNING, 0);
            UnicodeSet auxiliary = file.getExemplarSet("auxiliary", CLDRFile.WinningChoice.WINNING);
            UnicodeSet punctuation = file.getExemplarSet("punctuation", CLDRFile.WinningChoice.WINNING);
            UnicodeSet numbers = file.getExemplarsNumeric(CLDRFile.NumberingSystem.defaultSystem);
            exemplars = new UnicodeSet().addAll(main).addAll(auxiliary).addAll(WikiSubdivisionLanguages.scriptsFor(main)).addAll(punctuation).addAll(numbers).addAll(new UnicodeSet("[\\ ]")).freeze();
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                String path;
                String oldName;
                String subdivision = entry2.getKey();
                String name2 = entry2.getValue();
                if (name2.equals("B\u00f6y\u00fck Britaniya")) {
                    boolean bl = false;
                }
                if ((oldName = fileSubdivisions.getStringValue(path = WikiSubdivisionLanguages.getSubdivisionPath(subdivision))) != null) {
                    if (oldName.equals(name2)) continue;
                    continue;
                }
                if (!exemplars.containsAll(name2)) {
                    UnicodeSet unicodeSet = new UnicodeSet().addAll(name2).removeAll(exemplars);
                    WikiSubdivisionLanguages.addExemplarFailures(exemplarFailureLangSubdivisionName, unicodeSet, lang, subdivision, name2);
                    continue;
                }
                fileSubdivisions.add(path, name2);
                inverse.put(name2, path);
                counter.add(lang, 1L);
            }
            for (Map.Entry<String, Object> entry3 : inverse.asMap().entrySet()) {
                Collection paths;
                String name = entry3.getKey();
                if (name.isEmpty()) continue;
                if (name.equals("B\u00f6y\u00fck Britaniya")) {
                    boolean name2 = false;
                }
                if ((paths = (Collection)entry3.getValue()).size() <= 1) continue;
                if (paths.size() > 3) {
                    boolean path = false;
                }
                LinkedHashMultimap<String, String> regionToPaths = LinkedHashMultimap.create();
                for (String string : paths) {
                    String sdId = WikiSubdivisionLanguages.getSubdivisionFromPath(string);
                    String region = sdId.substring(0, 2).toUpperCase(Locale.ROOT);
                    regionToPaths.put(region, string);
                }
                for (Map.Entry entry4 : regionToPaths.asMap().entrySet()) {
                    Collection paths2 = (Collection)entry4.getValue();
                    int markerIndex = 0;
                    if (paths2.size() <= 1) continue;
                    Iterator it = paths2.iterator();
                    while (it.hasNext()) {
                        String path = (String)it.next();
                        String sdId = WikiSubdivisionLanguages.getSubdivisionFromPath(path);
                        if (regularSubdivisions.contains(sdId)) continue;
                        fileSubdivisions.remove(path);
                        it.remove();
                        WikiSubdivisionLanguages.fail("Duplicate, not regular ", lang, WikiSubdivisionLanguages.getSubdivisionFromPath(path), "REMOVING", -1);
                    }
                    if (paths2.size() <= 1) continue;
                    String otherId = null;
                    for (String path : paths2) {
                        if (markerIndex == 0) {
                            otherId = WikiSubdivisionLanguages.getSubdivisionFromPath(path);
                        } else {
                            String fixedName = name + MARKERS.get(markerIndex);
                            WikiSubdivisionLanguages.fail("Superscripting ", lang + "\t(" + otherId + ")", WikiSubdivisionLanguages.getSubdivisionFromPath(path), fixedName, -1);
                            fileSubdivisions.add(path, fixedName);
                        }
                        ++markerIndex;
                    }
                }
            }
            try {
                PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.SUBDIVISIONS_DIRECTORY, lang + ".xml");
                try {
                    fileSubdivisions.write(out);
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            catch (Exception e) {
                throw new ICUUncheckedIOException(e);
            }
        }
        WikiSubdivisionLanguages.fail("ExemplarFailures", exemplarFailureLangSubdivisionName);
        for (String string : counter.getKeysetSortedByKey()) {
            WikiSubdivisionLanguages.fail("Superscripting", string, String.valueOf(counter.get(string)), null, -1);
        }
        System.out.println("Bogus subdivisionIds:\t*\t" + bogus.size() + "\t" + bogus);
        for (Map.Entry<Object, Object> entry : bogusStatus.asMap().entrySet()) {
            System.out.println("SubdivisionId:\t\t:\t" + entry.getKey() + "\t" + ((Collection)entry.getValue()).size() + "\t" + entry.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CLDRFile fixedFile(CLDRFile oldFileSubdivisions, Multimap<String, String> inverse) {
        CLDRFile fileSubdivisions = oldFileSubdivisions.cloneAsThawed();
        HashSet<String> toRemove = new HashSet<String>();
        HashMap<String, String> toAdd = new HashMap<String, String>();
        for (String string : fileSubdivisions) {
            void var6_6;
            String type;
            Row.R2<List<String>, String> replacement;
            XPathParts parts = XPathParts.getFrozenInstance(string);
            if (!"subdivision".equals(parts.getElement(-1))) continue;
            String name = fileSubdivisions.getStringValue(string);
            if (name.equals("B\u00f6y\u00fck Britaniya")) {
                boolean bl = false;
            }
            if ((replacement = SUBDIVISION_ALIASES.get(type = parts.getAttributeValue(-1, "type"))) != null) {
                String fullPath = oldFileSubdivisions.getFullXPath(string);
                XPathParts parts2 = XPathParts.getFrozenInstance(fullPath).cloneAsThawed();
                Iterator iterator = ((List)replacement.get0()).iterator();
                if (iterator.hasNext()) {
                    String replacementType = (String)iterator.next();
                    parts2.setAttribute(-1, "type", replacementType);
                    toRemove.add(string);
                    String string2 = parts2.toString();
                    toAdd.put(string2, name);
                    System.out.println("Adding alias: " + replacementType + "\u00ab" + name + "\u00bb");
                }
            }
            inverse.put(name, (String)var6_6);
        }
        fileSubdivisions.removeAll(toRemove, false);
        for (Map.Entry entry : toAdd.entrySet()) {
            fileSubdivisions.add((String)entry.getKey(), (String)entry.getValue());
        }
        return fileSubdivisions;
    }

    private static void addExemplarFailures(ChainedMap.M4<Integer, String, String, String> exemplarFailureLangSubdivisionName, UnicodeSet exemplarFailures, String language, String subdivision, String name) {
        for (String s2 : exemplarFailures) {
            exemplarFailureLangSubdivisionName.put(s2.codePointAt(0), language, subdivision, name);
        }
    }

    private static void fail(String title, ChainedMap.M4<Integer, String, String, String> exemplarFailureLangSubdivisionName) {
        for (Row.R4<Integer, String, String, String> entry : exemplarFailureLangSubdivisionName.rows()) {
            WikiSubdivisionLanguages.fail(title, (String)entry.get1(), (String)entry.get2(), (String)entry.get3(), (Integer)entry.get0());
        }
    }

    private static void fail(String title, String lang, String subdivision, String name, int exemplarFailure) {
        System.out.println(title + ":\t" + lang + "\t" + subdivision + "\t" + (exemplarFailure < 0 ? "" : "\u00ab" + UTF16.valueOf(exemplarFailure) + "\u00bb") + "\t" + (exemplarFailure < 0 ? "" : "U+" + Utility.hex(exemplarFailure)) + "\t" + CldrUtility.ifNull(WikiSubdivisionLanguages.getBestWikiEnglishName(subdivision), "") + "\t" + CldrUtility.ifNull(name, "").replace("\"", "&quot;"));
    }

    private static UnicodeSet scriptsFor(UnicodeSet main) {
        UnicodeSet result = UnicodeSet.EMPTY;
        for (String s2 : main) {
            int scriptCode = UScript.getScript(s2.codePointAt(0));
            if (scriptCode == 0 && scriptCode == 1) continue;
            result = new UnicodeSet().applyIntPropertyValue(4106, scriptCode);
            if (scriptCode != 25) break;
            result.addAll("\u02bb\u2019&");
            break;
        }
        return result;
    }

    static {
        Splitter TAB = Splitter.on('\t').trimResults();
        File file = new File("data/external", "wikiSubdivisionLanguages.tsv");
        try {
            System.out.println(file.getCanonicalFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, Validity.Status> codeToStatus = Validity.getInstance().getCodeToStatus(StandardCodes.LstrType.subdivision);
        for (String line : FileUtilities.in(WikiSubdivisionLanguages.class, "data/external/wikiSubdivisionLanguages.tsv")) {
            List<String> data = TAB.splitToList(line);
            String subdivision = SubdivisionNode.convertToCldr(data.get(Items.subdivisionId.ordinal()));
            if (!regularSubdivisions.contains(subdivision)) {
                Validity.Status status = codeToStatus.get(subdivision);
                if (status == null) {
                    bogus.add(subdivision);
                    continue;
                }
                bogusStatus.put(status, subdivision);
                continue;
            }
            String lang = data.get(Items.languageId.ordinal());
            if (DEBUG_LANG_FILTER != null && !DEBUG_LANG_FILTER.equals(lang)) continue;
            String name = NFC.normalize(data.get(Items.translation.ordinal()));
            SUB_LANG_NAME.put(subdivision, lang, name);
            LANG_SUB_NAME.put(lang, subdivision, name);
        }
        String oldLang = null;
        DisplayAndInputProcessor daip = null;
        Exception[] internalException = new Exception[]{null};
        for (Row.R3<String, String, String> row : LANG_SUB_NAME.rows()) {
            String path;
            String name2;
            String lang = (String)row.get0();
            String subdivision = (String)row.get1();
            String name = (String)row.get2();
            if (!lang.equals(oldLang)) {
                oldLang = lang;
                daip = new DisplayAndInputProcessor(new ULocale(lang));
            }
            if ((name2 = daip.processInput(path = WikiSubdivisionLanguages.getSubdivisionPath(subdivision), name.replace("\u00ad", ""), internalException)).contains("'")) {
                boolean bl = false;
            }
            if (internalException[0] != null) {
                throw new IllegalArgumentException(lang + "\t" + subdivision + "\t" + name, internalException[0]);
            }
            if (name.equals(name2)) continue;
            SUB_LANG_NAME.put(subdivision, lang, name2);
            LANG_SUB_NAME.put(lang, subdivision, name2);
        }
        MARKERS = Arrays.asList("\u00b9", "\u00b2", "\u00b3");
    }

    static enum Items {
        wid,
        translation,
        subdivisionId,
        languageId;

    }
}

