/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.unicode.cldr.api.CldrData;
import org.unicode.cldr.api.CldrPath;
import org.unicode.cldr.api.CldrValue;

final class PrefixVisitorHost {
    private final Deque<VisitorState> visitorStack = new ArrayDeque<VisitorState>();
    private CldrPath lastValuePath = null;
    private final CldrData.ValueVisitor visitor = value -> {
        CldrPath path = value.getPath();
        int commonLength = 0;
        if (this.lastValuePath != null) {
            commonLength = CldrPath.getCommonPrefixLength(this.lastValuePath, path);
            Preconditions.checkState(commonLength <= this.lastValuePath.getLength(), "unexpected child path encountered: %s is child of %s", (Object)path, (Object)this.lastValuePath);
            this.handleLastPath(commonLength);
        }
        Preconditions.checkState(commonLength <= path.getLength(), "unexpected parent path encountered: %s is parent of %s", (Object)path, (Object)this.lastValuePath);
        this.recursiveStartVisit(path.getParent(), commonLength, new PrefixContext());
        this.visitorStack.peek().visitValue(value);
        this.lastValuePath = path;
    };

    static void accept(BiConsumer<CldrData.PathOrder, CldrData.ValueVisitor> acceptFn, CldrData.PathOrder order, CldrData.PrefixVisitor v) {
        PrefixVisitorHost host = new PrefixVisitorHost(v);
        if (order.ordinal() < CldrData.PathOrder.NESTED_GROUPING.ordinal()) {
            order = CldrData.PathOrder.NESTED_GROUPING;
        }
        acceptFn.accept(order, host.visitor);
        host.endVisitation();
    }

    private PrefixVisitorHost(CldrData.PrefixVisitor visitor) {
        this.visitorStack.push(VisitorState.of(visitor, v -> {}, null));
    }

    private void endVisitation() {
        if (this.lastValuePath != null) {
            this.handleLastPath(0);
        }
    }

    private void recursiveStartVisit(CldrPath prefix, int commonLength, PrefixContext ctx) {
        if (prefix != null && prefix.getLength() > commonLength) {
            this.recursiveStartVisit(prefix.getParent(), commonLength, ctx);
            this.visitorStack.peek().visitPrefixStart(prefix, ctx.setPrefix(prefix));
        }
    }

    private void handleLastPath(int length) {
        for (CldrPath prefix = this.lastValuePath.getParent(); prefix != null && prefix.getLength() > length; prefix = prefix.getParent()) {
            VisitorState e = this.visitorStack.peek();
            if (prefix.equals(e.prefix)) {
                e.doneCallback.run();
                this.visitorStack.pop();
                e = this.visitorStack.peek();
            }
            e.visitPrefixEnd(prefix);
        }
    }

    private static abstract class VisitorState
    implements CldrData.PrefixVisitor {
        private final CldrPath prefix;
        private final Runnable doneCallback;

        static <T extends CldrData.ValueVisitor> VisitorState of(final T visitor, Consumer<T> doneHandler, CldrPath prefix) {
            return new VisitorState(prefix, () -> doneHandler.accept(visitor)){

                @Override
                public void visitValue(CldrValue value) {
                    visitor.visit(value);
                }
            };
        }

        static <T extends CldrData.PrefixVisitor> VisitorState of(final T visitor, Consumer<T> doneHandler, CldrPath prefix) {
            return new VisitorState(prefix, () -> doneHandler.accept(visitor)){

                @Override
                public void visitPrefixStart(CldrPath prefix, CldrData.PrefixVisitor.Context ctx) {
                    visitor.visitPrefixStart(prefix, ctx);
                }

                @Override
                public void visitPrefixEnd(CldrPath prefix) {
                    visitor.visitPrefixEnd(prefix);
                }

                @Override
                public void visitValue(CldrValue value) {
                    visitor.visitValue(value);
                }
            };
        }

        private VisitorState(CldrPath prefix, Runnable doneCallback) {
            this.prefix = prefix;
            this.doneCallback = doneCallback;
        }
    }

    private final class PrefixContext
    implements CldrData.PrefixVisitor.Context {
        private CldrPath prefix = null;

        private PrefixContext() {
        }

        private PrefixContext setPrefix(CldrPath prefix) {
            this.prefix = Preconditions.checkNotNull(prefix);
            return this;
        }

        @Override
        public <T extends CldrData.PrefixVisitor> void install(T visitor, Consumer<T> doneHandler) {
            PrefixVisitorHost.this.visitorStack.push(VisitorState.of(visitor, doneHandler, this.prefix));
        }

        @Override
        public <T extends CldrData.ValueVisitor> void install(T visitor, Consumer<T> doneHandler) {
            PrefixVisitorHost.this.visitorStack.push(VisitorState.of(visitor, doneHandler, this.prefix));
        }
    }
}

