/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import java.util.Iterator;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.RegexTransform;
import org.unicode.cldr.draft.Rule;

public class RegexTransformState {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG2 = false;
    StringBuilder processedAlready = new StringBuilder();
    StringBuilder toBeProcessed;
    RegexTransform regexTransform;

    /*
     * Enabled aggressive block sorting
     */
    public RegexTransformState(RegexTransform regexTransform, CharSequence text) {
        this.regexTransform = regexTransform;
        this.toBeProcessed = new StringBuilder(text);
        while (true) {
            Status s2 = this.match();
            switch (s2) {
                case MATCH: {
                    break;
                }
                case BLOCKED: 
                case NOMATCH: {
                    if (this.toBeProcessed.length() == 0) {
                        return;
                    }
                    this.processedAlready.append(this.toBeProcessed.subSequence(0, 1));
                    this.toBeProcessed.delete(0, 1);
                }
            }
        }
    }

    public Status match() {
        Iterator<Rule> it = this.regexTransform.iterator(this.toBeProcessed);
        while (it.hasNext()) {
            Status status = this.match(it.next());
            if (status == Status.NOMATCH) continue;
            return status;
        }
        return Status.NOMATCH;
    }

    public Status match(Rule rule) {
        Matcher prematcher = rule.getPrematcher(this.processedAlready);
        if (prematcher != null && !rule.prematch(prematcher, this.processedAlready)) {
            return Status.NOMATCH;
        }
        Matcher postmatcher = rule.getPostmatcher(this.toBeProcessed);
        if (!postmatcher.lookingAt()) {
            if (postmatcher.hitEnd()) {
                return Status.NOMATCH;
            }
            return Status.NOMATCH;
        }
        int newCursor = rule.append(this.processedAlready, prematcher, postmatcher);
        this.toBeProcessed.delete(0, postmatcher.end());
        int delta = newCursor - this.processedAlready.length();
        if (delta != 0) {
            if (delta < 0) {
                this.toBeProcessed.insert(0, this.processedAlready.subSequence(newCursor, this.processedAlready.length()));
                this.processedAlready.setLength(newCursor);
            } else {
                this.processedAlready.append(this.toBeProcessed.subSequence(0, delta));
                this.processedAlready.delete(0, delta);
            }
        }
        return Status.MATCH;
    }

    public String toString() {
        return this.processedAlready.toString();
    }

    public static enum Status {
        NOMATCH,
        BLOCKED,
        MATCH;

    }
}

