/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.json;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.PatternCache;

class LdmlConvertRules {
    public static final ImmutableSet<String> IGNORE_FILE_SET = ImmutableSet.of("attributeValueValidity", "coverageLevels", "grammaticalFeatures", "postalCodeData", "subdivisions", "units", new String[0]);
    static final ImmutableSet<String> NAME_PART_DISTINGUISHING_ATTR_SET = ImmutableSet.of("monthWidth:month:yeartype", "characters:parseLenients:scope", "dateFormat:pattern:numbers", "characterLabelPatterns:characterLabelPattern:count", "currencyFormats:unitPattern:count", "currency:displayName:count", new String[]{"numbers:symbols:numberSystem", "numbers:decimalFormats:numberSystem", "numbers:currencyFormats:numberSystem", "numbers:percentFormats:numberSystem", "numbers:scientificFormats:numberSystem", "numbers:miscPatterns:numberSystem", "minimalPairs:pluralMinimalPairs:count", "territoryContainment:group:status", "decimalFormat:pattern:count", "currencyFormat:pattern:count", "unit:unitPattern:count", "compoundUnit:compoundUnitPattern1:count", "compoundUnit:compoundUnitPattern1:gender", "compoundUnit:compoundUnitPattern1:case", "field:relative:type", "field:relativeTime:type", "relativeTime:relativeTimePattern:count", "availableFormats:dateFormatItem:count", "listPatterns:listPattern:type", "timeZoneNames:regionFormat:type", "units:durationUnit:type", "weekData:minDays:territories", "weekData:firstDay:territories", "weekData:weekendStart:territories", "weekData:weekendEnd:territories", "unitPreferenceDataData:unitPreferences:category", "measurementData:measurementSystem:category", "supplemental:plurals:type", "pluralRanges:pluralRange:start", "pluralRanges:pluralRange:end", "pluralRules:pluralRule:count", "languageMatches:languageMatch:desired", "styleNames:styleName:subtype", "styleNames:styleName:alt"});
    static final ImmutableSet<String> ATTR_AS_VALUE_SET = ImmutableSet.of("dayPeriodRules:dayPeriodRule:from", "likelySubtags:likelySubtag:to", "timezone:usesMetazone:mzone", "timezone:usesMetazone:to", "timezone:usesMetazone:from", "mapTimezones:mapZone:other", new String[]{"mapTimezones:mapZone:type", "mapTimezones:mapZone:territory", "numberingSystems:numberingSystem:type", "region:currency:from", "region:currency:to", "region:currency:tender", "calendar:calendarSystem:type", "codeMappings:territoryCodes:numeric", "codeMappings:territoryCodes:alpha3", "codeMappings:currencyCodes:numeric", "timeData:hours:allowed", "timeData:hours:preferred", "validity:variable:type", "deprecated:deprecatedItems:elements", "deprecated:deprecatedItems:attributes", "deprecated:deprecatedItems:type", "codesByTerritory:telephoneCountryCode:code", "mapTimezones:mapZone:other", "keyword:key:alias", "key:type:alias", "key:type:name", "identity:language:type", "identity:script:type", "identity:territory:type", "identity:variant:type"});
    static final ImmutableSet<String> COMPACTABLE_ATTR_AS_VALUE_SET = ImmutableSet.of("calendars:default:choice", "dateFormats:default:choice", "months:default:choice", "monthContext:default:choice", "days:default:choice", "dayContext:default:choice", new String[]{"timeFormats:default:choice", "dateTimeFormats:default:choice", "timeZoneNames:singleCountries:list", "ruleset:rbnfrule:value", "likelySubtags:likelySubtag:to", "calendar:calendarSystem:type", "calendarPreferenceData:calendarPreference:ordering", "codesByTerritory:telephoneCountryCode:code", "collations:default:choice", "pluralRanges:pluralRange:result", "identity:language:type", "identity:script:type", "identity:territory:type", "identity:variant:type"});
    public static final String ANONYMOUS_KEY = "_";
    public static final ImmutableSet<String> IGNORABLE_NONDISTINGUISHING_ATTR_SET = ImmutableSet.of("draft", "references");
    public static final String[] ATTR_SUPPRESS_LIST = new String[]{"dateFormat", "standard", "type", "dateTimeFormat", "standard", "type", "timeFormat", "standard", "type", "decimalFormat", "standard", "type", "percentFormat", "standard", "type", "scientificFormat", "standard", "type", "pattern", "standard", "type"};
    public static final SplittableAttributeSpec[] SPLITTABLE_ATTRS = new SplittableAttributeSpec[]{new SplittableAttributeSpec("calendarPreference", "territories", null), new SplittableAttributeSpec("pluralRanges", "locales", null), new SplittableAttributeSpec("pluralRules", "locales", null), new SplittableAttributeSpec("minDays", "territories", "count"), new SplittableAttributeSpec("firstDay", "territories", "day"), new SplittableAttributeSpec("weekendStart", "territories", "day"), new SplittableAttributeSpec("weekendEnd", "territories", "day"), new SplittableAttributeSpec("measurementSystem", "territories", "type"), new SplittableAttributeSpec("measurementSystem-category-temperature", "territories", "type"), new SplittableAttributeSpec("paperSize", "territories", "type"), new SplittableAttributeSpec("parentLocale", "locales", "parent"), new SplittableAttributeSpec("hours", "regions", null), new SplittableAttributeSpec("dayPeriodRules", "locales", null), new SplittableAttributeSpec("personList", "locales", "type"), new SplittableAttributeSpec("unitPreference", "regions", null)};
    public static final Set<String> TIMEZONE_ELEMENT_NAME_SET = Builder.with(new HashSet()).add("zone").add("timezone").add("zoneItem").add("typeMap").freeze();
    public static final Set<String> ATTRVALUE_AS_ARRAY_SET = Builder.with(new HashSet()).add("territories").add("scripts").add("contains").freeze();
    public static final String[] ELEMENT_NEED_SORT = new String[]{"zone", "timezone", "zoneItem", "typeMap", "dayPeriodRule", "pluralRanges", "pluralRules", "personList", "calendarPreferenceData", "character-fallback", "types", "timeData", "minDays", "firstDay", "weekendStart", "weekendEnd", "measurementData", "measurementSystem"};
    public static final Pattern ARRAY_ITEM_PATTERN = PatternCache.get("(.*/collation[^/]*/rules[^/]*/|.*/character-fallback[^/]*/character[^/]*/|.*/rbnfrule[^/]*/|.*/ruleset[^/]*/|.*/languageMatching[^/]*/languageMatches[^/]*/|.*/windowsZones[^/]*/mapTimezones[^/]*/|.*/metaZones[^/]*/mapTimezones[^/]*/|.*/segmentation[^/]*/variables[^/]*/|.*/segmentation[^/]*/suppressions[^/]*/|.*/transform[^/]*/tRules[^/]*/|.*/region/region[^/]*/|.*/keyword[^/]*/key[^/]*/|.*/telephoneCodeData[^/]*/codesByTerritory[^/]*/|.*/metazoneInfo[^/]*/timezone\\[[^\\]]*\\]/|.*/metadata[^/]*/validity[^/]*/|.*/metadata[^/]*/suppress[^/]*/|.*/metadata[^/]*/deprecated[^/]*/)(.*)");
    public static final Pattern NO_NUMBERING_SYSTEM_PATTERN = Pattern.compile("//ldml/numbers/(symbols|(decimal|percent|scientific|currency)Formats)/.*");
    public static final Pattern NUMBERING_SYSTEM_PATTERN = Pattern.compile("//ldml/numbers/(symbols|miscPatterns|(decimal|percent|scientific|currency)Formats)\\[@numberSystem=\"([^\"]++)\"\\]/.*");
    public static final String[] ACTIVE_NUMBERING_SYSTEM_XPATHS = new String[]{"//ldml/numbers/defaultNumberingSystem", "//ldml/numbers/otherNumberingSystems/native", "//ldml/numbers/otherNumberingSystems/traditional", "//ldml/numbers/otherNumberingSystems/finance"};
    public static final Pattern ROOT_IDENTITY_PATTERN = Pattern.compile("//ldml/identity/language\\[@type=\"root\"\\]");
    public static final PathTransformSpec[] PATH_TRANSFORMATIONS = new PathTransformSpec[]{new PathTransformSpec("(.*ldml/exemplarCharacters)\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2$3"), new PathTransformSpec("(.*ldml/exemplarCharacters)(.*)$", "$1/standard$2"), new PathTransformSpec("(.+)/identity/version\\[@number=\"([^\"]*)\"\\]", "$1/identity/version\\[@cldrVersion=\"38\"\\]"), new PathTransformSpec("(.+)/version\\[@number=\"([^\"]*)\"\\]\\[@unicodeVersion=\"([^\"]*\")(\\])", "$1/version\\[@cldrVersion=\"38\"\\]\\[@unicodeVersion=\"$3\\]"), new PathTransformSpec("(.*/language\\[@type=\"[a-z]{2,3})_([^\"]*\"\\](\\[@alt=\"short\"])?)", "$1-$2"), new PathTransformSpec("(.*/ellipsis)\\[@type=\"([^\"]*)\"\\](.*)$", "$1/$2$3"), new PathTransformSpec("(.*/calendars)/calendar\\[@type=\"([^\"]*)\"\\](.*)Length\\[@type=\"([^\"]*)\"\\]/(date|time|dateTime)Format\\[@type=\"([^\"]*)\"\\]/pattern\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2/$5Formats/$4$8"), new PathTransformSpec("(.*/calendars)/calendar\\[@type=\"([^\"]*)\"\\](.*)$", "$1/$2$3"), new PathTransformSpec("(.*/metazone)\\[@type=\"([^\"]*)\"\\]/(.*)$", "$1/$2/$3"), new PathTransformSpec("(.*)/types/type\\[@key=\"([^\"]*)\"\\]\\[@type=\"([^\"]*)\"\\](.*)$", "$1/types/$2/$3$4"), new PathTransformSpec("(.*)/(typographicNames)/(axisName|featureName)\\[@type=\"([^\"]*)\"\\](.*)$", "$1/$2/$3s/$4$5"), new PathTransformSpec("(.*)/(typographicNames)/(styleName)(.*)$", "$1/$2/$3s/$3$4"), new PathTransformSpec("(.*)/(characterLabels)/(characterLabelPattern)(.*)$", "$1/characterLabelPatterns/$3$4"), new PathTransformSpec("(.*/numbers/(decimal|scientific|percent|currency)Formats\\[@numberSystem=\"([^\"]*)\"\\])/(decimal|scientific|percent|currency)FormatLength/(decimal|scientific|percent|currency)Format\\[@type=\"standard\"]/pattern.*$", "$1/standard"), new PathTransformSpec("(.*/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"\\])/currencyFormatLength/currencyFormat\\[@type=\"accounting\"]/pattern.*$", "$1/accounting"), new PathTransformSpec("(.*/numbers/(decimal|scientific|percent)Formats\\[@numberSystem=\"([^\"]*)\"\\]/(decimal|scientific|percent)FormatLength)/(.*)$", "$1[@type=\"standard\"]/$5"), new PathTransformSpec("(.*/listPattern)/(.*)$", "$1[@type=\"standard\"]/$2"), new PathTransformSpec("(.*/languagePopulation)\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2$3"), new PathTransformSpec("(.*/languageAlias)\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2$3"), new PathTransformSpec("(.*/scriptAlias)\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2$3"), new PathTransformSpec("(.*/territoryAlias)\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2$3"), new PathTransformSpec("(.*/subdivisionAlias)\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2$3"), new PathTransformSpec("(.*/variantAlias)\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2$3"), new PathTransformSpec("(.*/zoneAlias)\\[@type=\"([^\"]*)\"\\](.*)", "$1/$2$3"), new PathTransformSpec("(.*/alias)(.*)", "$1/alias$2"), new PathTransformSpec("(.*currencyData/region)(.*)", "$1/region$2"), new PathTransformSpec("(.*(GMT|UTC).*/exemplarCity)(.*)", ""), new PathTransformSpec("(.*/transforms/transform[^/]*)/(.*)", "$1/tRules/$2"), new PathTransformSpec("(.*)\\[@territories=\"([^\"]*)\"\\](.*)\\[@alt=\"variant\"\\](.*)", "$1\\[@territories=\"$2-alt-variant\"\\]"), new PathTransformSpec("(.*)/weekData/(.*)\\[@alt=\"variant\"\\](.*)", "$1/weekData/$2$3"), new PathTransformSpec("(.*)/unitPreferenceData/unitPreferences\\[@category=\"([^\"]*)\"\\]\\[@usage=\"([^\"]*)\"\\](.*)", "$1/unitPreferenceData/unitPreferences/$2/$3$4"), new PathTransformSpec("(.*)/(annotations)/(annotation)\\[@cp=\"([^\"]*)\"\\]\\[@type=\"([^\"]*)\"\\](.*)$", "$1/$2/$4/$5$6"), new PathTransformSpec("(.*)/(annotations)/(annotation)\\[@cp=\"([^\"]*)\"\\](.*)$", "$1/$2/$4/default$5")};

    LdmlConvertRules() {
    }

    public static boolean IsSuppresedAttr(String attr) {
        return attr.endsWith("_q") || attr.endsWith("-q");
    }

    public static class SplittableAttributeSpec {
        public String element;
        public String attribute;
        public String attrAsValueAfterSplit;

        SplittableAttributeSpec(String el, String attr, String av) {
            this.element = el;
            this.attribute = attr;
            this.attrAsValueAfterSplit = av;
        }
    }

    public static class PathTransformSpec {
        public Pattern pattern;
        public String replacement;

        PathTransformSpec(String patternStr, String replacement) {
            this.pattern = PatternCache.get(patternStr);
            this.replacement = replacement;
        }
    }
}

