/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.text.NumberingSystem;
import java.io.PrintWriter;
import org.unicode.cldr.posix.POSIXUtilities;
import org.unicode.cldr.posix.POSIXVariant;
import org.unicode.cldr.util.CLDRFile;

public class POSIX_LCTime {
    String[] abday = new String[7];
    String[] day = new String[7];
    String[] abmon = new String[12];
    String[] mon = new String[12];
    String d_t_fmt;
    String d_fmt;
    String t_fmt;
    String[] am_pm = new String[2];
    String t_fmt_ampm;
    String[] alt_digits = new String[100];
    String date_fmt;
    String nlldate;

    public POSIX_LCTime(CLDRFile doc, POSIXVariant variant) {
        String SearchLocation;
        int i;
        String[] days = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        for (i = 0; i < 7; ++i) {
            SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/days/dayContext[@type='format']/dayWidth[@type='abbreviated']/day[@type='" + days[i] + "']";
            this.abday[i] = POSIXUtilities.POSIXCharName(doc.getWinningValue(SearchLocation));
            SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/days/dayContext[@type='format']/dayWidth[@type='wide']/day[@type='" + days[i] + "']";
            this.day[i] = POSIXUtilities.POSIXCharName(doc.getWinningValue(SearchLocation));
        }
        for (i = 0; i < 12; ++i) {
            SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/months/monthContext[@type='format']/monthWidth[@type='abbreviated']/month[@type='" + String.valueOf(i + 1) + "']";
            this.abmon[i] = POSIXUtilities.POSIXCharName(doc.getWinningValue(SearchLocation));
            SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/months/monthContext[@type='format']/monthWidth[@type='wide']/month[@type='" + String.valueOf(i + 1) + "']";
            this.mon[i] = POSIXUtilities.POSIXCharName(doc.getWinningValue(SearchLocation));
        }
        this.alt_digits[0] = "";
        String numsys = doc.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        if (numsys != null && !numsys.equals("latn")) {
            int i2;
            NumberingSystem ns = NumberingSystem.getInstanceByName(numsys);
            String nativeZeroDigit = ns.getDescription().substring(0, 1);
            this.alt_digits[0] = POSIXUtilities.POSIXCharName(nativeZeroDigit);
            char base_value = nativeZeroDigit.charAt(0);
            for (i2 = 1; i2 < 10; i2 = (int)((short)(i2 + 1))) {
                this.alt_digits[i2] = POSIXUtilities.POSIXCharName(Character.toString((char)((short)base_value + i2)));
            }
            for (i2 = 10; i2 < 100; i2 = (int)((short)(i2 + 1))) {
                this.alt_digits[i2] = this.alt_digits[i2 / 10] + this.alt_digits[i2 % 10];
            }
        }
        SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/timeFormats/timeFormatLength[@type='medium']/timeFormat[@type='standard']/pattern[@type='standard']";
        this.t_fmt = POSIXUtilities.POSIXDateTimeFormat(doc.getWinningValue(SearchLocation), this.alt_digits[0].length() > 0, variant);
        this.t_fmt = this.t_fmt.replaceAll("\"", "/\"");
        if (this.t_fmt.indexOf("%p") >= 0) {
            this.t_fmt_ampm = this.t_fmt;
        } else {
            SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/dateTimeFormats/availableFormats/dateFormatItem[@id='hms']";
            this.t_fmt_ampm = doc.getWinningValue(SearchLocation);
            if (this.t_fmt_ampm != null) {
                this.t_fmt_ampm = POSIXUtilities.POSIXDateTimeFormat(this.t_fmt_ampm, this.alt_digits[0].length() > 0, variant);
                this.t_fmt_ampm = this.t_fmt_ampm.replaceAll("\"", "/\"");
            }
            if (this.t_fmt_ampm.indexOf("%p") < 0) {
                this.t_fmt_ampm = "";
            }
        }
        SearchLocation = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateFormats/dateFormatLength[@type=\"short\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
        this.d_fmt = POSIXUtilities.POSIXDateTimeFormat(doc.getWinningValue(SearchLocation), this.alt_digits[0].length() > 0, variant);
        this.d_fmt = this.d_fmt.replaceAll("\"", "/\"");
        SearchLocation = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/dateTimeFormatLength[@type=\"long\"]/dateTimeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
        this.d_t_fmt = doc.getWinningValue(SearchLocation);
        SearchLocation = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"long\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
        this.d_t_fmt = this.d_t_fmt.replaceAll("\\{0\\}", doc.getWinningValue(SearchLocation));
        SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/dateFormats/dateFormatLength[@type=\"long\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
        this.d_t_fmt = this.d_t_fmt.replaceAll("\\{1\\}", doc.getWinningValue(SearchLocation));
        this.d_t_fmt = POSIXUtilities.POSIXDateTimeFormat(this.d_t_fmt, this.alt_digits[0].length() > 0, variant);
        this.d_t_fmt = POSIXUtilities.POSIXCharNameNP(this.d_t_fmt);
        this.d_t_fmt = this.d_t_fmt.replaceAll("\"", "/\"");
        SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/dayPeriods/dayPeriodContext[@type='format']/dayPeriodWidth[@type='wide']/dayPeriod[@type='am']";
        this.am_pm[0] = POSIXUtilities.POSIXCharName(doc.getWinningValue(SearchLocation));
        SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/dayPeriods/dayPeriodContext[@type='format']/dayPeriodWidth[@type='wide']/dayPeriod[@type='pm']";
        this.am_pm[1] = POSIXUtilities.POSIXCharName(doc.getWinningValue(SearchLocation));
        if (variant.platform.equals("solaris")) {
            SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/dateTimeFormats/dateTimeFormatLength/dateTimeFormat/pattern";
            this.date_fmt = doc.getWinningValue(SearchLocation);
            SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/timeFormats/timeFormatLength[@type='full']/timeFormat/pattern";
            this.date_fmt = this.date_fmt.replaceAll("\\{0\\}", doc.getWinningValue(SearchLocation));
            SearchLocation = "//ldml/dates/calendars/calendar[@type='gregorian']/dateFormats/dateFormatLength[@type='full']/dateFormat/pattern";
            this.date_fmt = this.date_fmt.replaceAll("\\{1\\}", doc.getWinningValue(SearchLocation));
            this.date_fmt = POSIXUtilities.POSIXDateTimeFormat(this.date_fmt, this.alt_digits[0].length() > 0, variant);
            this.date_fmt = POSIXUtilities.POSIXCharNameNP(this.date_fmt);
            this.date_fmt = this.date_fmt.replaceAll("\"", "/\"");
        } else if (variant.platform.equals("aix")) {
            this.nlldate = "";
            String[] SearchLocations = new String[]{"//ldml/dates/calendars/calendar[@type='gregorian']/dateTimeFormats/availableFormats/dateFormatItem[@id='yyyyMMMdd']", "//ldml/dates/calendars/calendar[@type='gregorian']/dateTimeFormats/availableFormats/dateFormatItem[@id='yyyyMMMd']"};
            for (int i3 = 0; i3 < SearchLocations.length; ++i3) {
                this.nlldate = doc.getWinningValue(SearchLocation);
                if (this.nlldate != null) break;
            }
            if (this.nlldate != null) {
                this.nlldate = POSIXUtilities.POSIXDateTimeFormat(this.nlldate, this.alt_digits[0].length() > 0, variant);
            }
            if (this.nlldate.indexOf("%d") < 0 || this.nlldate.indexOf("%b") < 0 || this.nlldate.indexOf("%Y") < 0) {
                this.nlldate = "%d %b %Y";
                this.nlldate = this.nlldate.replaceAll("\"", "/\"");
            }
        }
    }

    public void write(PrintWriter out, POSIXVariant variant) {
        int i;
        out.println("*************");
        out.println("LC_TIME");
        out.println("*************");
        out.println();
        out.print("abday   \"");
        for (i = 0; i < 7; ++i) {
            out.print(this.abday[i]);
            if (i < 6) {
                out.println("\";/");
                out.print("        \"");
                continue;
            }
            out.println("\"");
        }
        out.println();
        out.print("day     \"");
        for (i = 0; i < 7; ++i) {
            out.print(this.day[i]);
            if (i < 6) {
                out.println("\";/");
                out.print("        \"");
                continue;
            }
            out.println("\"");
        }
        out.println();
        out.print("abmon   \"");
        for (i = 0; i < 12; ++i) {
            out.print(this.abmon[i]);
            if (i < 11) {
                out.println("\";/");
                out.print("        \"");
                continue;
            }
            out.println("\"");
        }
        out.println();
        out.print("mon     \"");
        for (i = 0; i < 12; ++i) {
            out.print(this.mon[i]);
            if (i < 11) {
                out.println("\";/");
                out.print("        \"");
                continue;
            }
            out.println("\"");
        }
        out.println();
        out.println("d_fmt    \"" + this.d_fmt + "\"");
        out.println();
        out.println("t_fmt    \"" + this.t_fmt + "\"");
        out.println();
        out.println("d_t_fmt  \"" + this.d_t_fmt + "\"");
        out.println();
        out.println("am_pm    \"" + this.am_pm[0] + "\";\"" + this.am_pm[1] + "\"");
        out.println();
        out.println("t_fmt_ampm  \"" + this.t_fmt_ampm + "\"");
        out.println();
        if (variant.platform.equals("solaris")) {
            out.println("date_fmt    \"" + this.date_fmt + "\"");
            out.println();
        } else if (variant.platform.equals("aix")) {
            out.println("nlldate    \"" + this.nlldate + "\"");
            out.println();
        }
        if (!this.alt_digits[0].equals("")) {
            out.print("alt_digits \"");
            for (i = 0; i < 100; ++i) {
                out.print(this.alt_digits[i]);
                if (i < 99) {
                    out.println("\";/");
                    out.print("           \"");
                    continue;
                }
                out.println("\"");
            }
        }
        out.println("END LC_TIME");
    }
}

