/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.number.DecimalFormatProperties;
import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class BuildIcuCompactDecimalFormat {
    static SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    static final int MINIMUM_ARRAY_LENGTH = 15;
    static final Pattern PATTERN = PatternCache.get("([^0,]*)([0]+)([.]0+)?([^0]*)");
    static final Pattern TYPE = PatternCache.get("1([0]*)");

    public static final CompactDecimalFormat build(CLDRFile resolvedCldrFile, Set<String> debugCreationErrors, String[] debugOriginals, CompactDecimalFormat.CompactStyle style, ULocale locale, CurrencyStyle currencyStyle, String currencyCodeOrUnit) {
        final Map<String, Map<String, String>> customData = BuildIcuCompactDecimalFormat.buildCustomData(resolvedCldrFile, style, currencyStyle);
        CompactDecimalFormat cdf = CompactDecimalFormat.getInstance(locale, style);
        ICUServiceBuilder builder = new ICUServiceBuilder().setCldrFile(resolvedCldrFile);
        cdf.setDecimalFormatSymbols(builder.getDecimalFormatSymbols("latn"));
        cdf.setProperties(new DecimalFormat.PropertySetter(){

            @Override
            public void set(DecimalFormatProperties props) {
                props.setCompactCustomData(customData);
            }
        });
        return cdf;
    }

    public static Map<String, Map<String, String>> buildCustomData(CLDRFile resolvedCldrFile, CompactDecimalFormat.CompactStyle style, CurrencyStyle currencyStyle) {
        TreeMap<String, Map<String, String>> customData = new TreeMap<String, Map<String, String>>();
        String prefix = currencyStyle == CurrencyStyle.PLAIN ? "//ldml/numbers/decimalFormats[@numberSystem=\"latn\"]/decimalFormatLength" : "//ldml/numbers/currencyFormats[@numberSystem=\"latn\"]/currencyFormatLength";
        Iterator<String> it = resolvedCldrFile.iterator(prefix);
        String styleString = style.toString().toLowerCase(Locale.ENGLISH);
        while (it.hasNext()) {
            XPathParts parts;
            String stype;
            String path = it.next();
            if (path.endsWith("/alias") || !styleString.equals(stype = (parts = XPathParts.getFrozenInstance(path)).getAttributeValue(3, "type"))) continue;
            String type = parts.getAttributeValue(-1, "type");
            String key = parts.getAttributeValue(-1, "count");
            String pattern = resolvedCldrFile.getStringValue(path);
            if (pattern.contentEquals("0")) continue;
            BuildIcuCompactDecimalFormat.add(customData, type, key, pattern);
        }
        return customData;
    }

    private static <A, B, C> void add(Map<A, Map<B, C>> customData, A a, B b, C c) {
        Map<B, C> inner = customData.get(a);
        if (inner == null) {
            inner = new HashMap<B, C>();
            customData.put(a, inner);
        }
        inner.put(b, c);
    }

    public static enum CurrencyStyle {
        PLAIN,
        CURRENCY,
        LONG_CURRENCY,
        ISO_CURRENCY,
        UNIT;

    }

    static class MyCurrencySymbolDisplay {
        CLDRFile cldrFile;

        public MyCurrencySymbolDisplay(CLDRFile cldrFile) {
            this.cldrFile = cldrFile;
        }

        public String getName(Currency currency, int count) {
            String currencyCode = currency.getCurrencyCode();
            if (count > 1) {
                return currencyCode;
            }
            String prefix = "//ldml/numbers/currencies/currency[@type=\"" + currencyCode + "\"]/";
            String currencySymbol = this.cldrFile.getWinningValue(prefix + "symbol");
            return currencySymbol != null ? currencySymbol : currencyCode;
        }
    }
}

