/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTransforms;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.XMLSource;

public class CLDRFileTransformer {
    private UnicodeSet unconverted = new UnicodeSet();
    private Factory factory;
    private static Map<LocaleTransform, Transliterator> transliterators = new ConcurrentHashMap<LocaleTransform, Transliterator>();
    private String transformDir;

    public CLDRFileTransformer(Factory factory, String transformDir) {
        this.factory = factory;
        this.transformDir = transformDir;
    }

    public Transliterator loadTransliterator(LocaleTransform localeTransform) {
        Transliterator transliterator;
        if (transliterators.containsKey((Object)localeTransform)) {
            return transliterators.get((Object)localeTransform);
        }
        if (localeTransform.getTransformFilename().contains(".xml")) {
            CLDRTransforms.ParsedTransformID directionInfo = new CLDRTransforms.ParsedTransformID();
            String ruleString = CLDRTransforms.getIcuRulesFromXmlFile(this.transformDir, localeTransform.getTransformFilename(), directionInfo);
            transliterator = Transliterator.createFromRules(directionInfo.getId(), ruleString, localeTransform.getDirection());
        } else {
            transliterator = Transliterator.getInstance(localeTransform.getTransformFilename());
        }
        transliterators.put(localeTransform, transliterator);
        return transliterator;
    }

    public CLDRFile transform(LocaleTransform localeTransform) {
        CLDRFile output;
        CLDRFile input;
        Transliterator transliterator = this.loadTransliterator(localeTransform);
        try {
            input = this.factory.make(localeTransform.getInputLocale(), false);
        }
        catch (ICUUncheckedIOException e1) {
            return null;
        }
        boolean hadOutput = true;
        try {
            output = this.factory.make(localeTransform.getOutputLocale(), false);
        }
        catch (SimpleFactory.NoSourceDirectoryException e) {
            SimpleXMLSource dataSource = new SimpleXMLSource(localeTransform.getOutputLocale());
            output = new CLDRFile(dataSource);
            hadOutput = false;
        }
        String outputParentString = LocaleIDParser.getParent(localeTransform.getOutputLocale());
        CLDRFile outputParent = this.factory.make(outputParentString, true);
        outputParent = this.factory.make(localeTransform.getInputLocale(), false);
        SimpleXMLSource outputSource = new SimpleXMLSource(localeTransform.toString());
        for (String xpath : input) {
            String parentValue;
            String value = input.getStringValue(xpath);
            if (CldrUtility.INHERITANCE_MARKER.equals(value)) {
                value = null;
            }
            if (value == null) continue;
            String fullPath = input.getFullXPath(xpath);
            String oldValue = output.getStringValue(xpath);
            if ((value = this.transformValue(transliterator, localeTransform, xpath, value, oldValue, parentValue = outputParent.getStringValue(xpath))) == null || CldrUtility.INHERITANCE_MARKER.equals(value)) continue;
            outputSource.putValueAtPath(fullPath, value);
        }
        if (!((XMLSource)outputSource).iterator().hasNext() && !hadOutput) {
            return null;
        }
        return new CLDRFile(outputSource);
    }

    private String transformValue(Transliterator transliterator, LocaleTransform localeTransform, String path, String value, String oldValue, String parentValue) {
        String transliterated;
        switch (localeTransform.policy) {
            case RETAIN: 
            case MINIMIZE: {
                if (oldValue == null) break;
                return oldValue;
            }
        }
        UnicodeSet chars = localeTransform.getInputChars();
        if (path.contains("exemplarCharacters")) {
            transliterated = oldValue != null ? oldValue : value;
        } else {
            transliterated = transliterator.transliterate(value);
            transliterated = Normalizer.compose(transliterated, false);
        }
        if (localeTransform.policy == PolicyIfExisting.MINIMIZE && transliterated.equals(value)) {
            return null;
        }
        if (chars.containsSome(transliterated)) {
            this.unconverted.addAll(new UnicodeSet().addAll(chars).retainAll(transliterated));
        }
        return transliterated;
    }

    public static void main(String[] args) throws Exception {
        for (String dir : DtdType.ldml.directories) {
            if (dir.equals("casing") || dir.equals("collation") || dir.equals("annotationsDerived")) continue;
            System.out.println("\nDirectory: " + dir);
            String sourceDirectory = CLDRPaths.COMMON_DIRECTORY + dir + "/";
            Factory factory = Factory.make(sourceDirectory, ".*");
            CLDRFileTransformer transformer = new CLDRFileTransformer(factory, CLDRPaths.COMMON_DIRECTORY + "transforms" + File.separator);
            for (LocaleTransform localeTransform : LocaleTransform.values()) {
                CLDRFile output = transformer.transform(localeTransform);
                if (output == null) {
                    System.out.println("SKIPPING missing file: " + dir + "/" + localeTransform.inputLocale + ".xml");
                    continue;
                }
                String outputDir = CLDRPaths.GEN_DIRECTORY + "common/" + dir + File.separator;
                String outputFile = output.getLocaleID() + ".xml";
                try (PrintWriter out = FileUtilities.openUTF8Writer(outputDir, outputFile);){
                    System.out.println("Generating locale file: " + outputDir + outputFile);
                    if (!transformer.unconverted.isEmpty()) {
                        System.out.println("Untransformed characters: " + transformer.unconverted);
                        transformer.unconverted.clear();
                    }
                    output.write(out);
                }
            }
        }
    }

    public static enum LocaleTransform {
        sr_Latn("sr", "Serbian-Latin-BGN.xml", 0, "[:script=Cyrl:]", PolicyIfExisting.DISCARD),
        sr_Latn_BA("sr_Cyrl_BA", "Serbian-Latin-BGN.xml", 0, "[:script=Cyrl:]", PolicyIfExisting.DISCARD),
        sr_Latn_ME("sr_Cyrl_ME", "Serbian-Latin-BGN.xml", 0, "[:script=Cyrl:]", PolicyIfExisting.DISCARD),
        sr_Latn_XK("sr_Cyrl_XK", "Serbian-Latin-BGN.xml", 0, "[:script=Cyrl:]", PolicyIfExisting.DISCARD),
        ha_NE("ha", "ha-ha_NE.xml", 0, "[y Y \u01b4 \u01b3 \u02bc]", PolicyIfExisting.DISCARD),
        yo_BJ("yo", "yo-yo_BJ.xml", 0, "[\u1eb9 \u1ecd \u1e63 \u1eb8 \u1ecc \u1e62]", PolicyIfExisting.DISCARD),
        de_CH("de", "[\u00df] Casefold", 0, "[\u00df]", PolicyIfExisting.MINIMIZE),
        yue_Hans("yue", "Simplified-Traditional.xml", 1, "[:script=Hant:]", PolicyIfExisting.RETAIN);

        private final String inputLocale;
        private final String transformFilename;
        private final int direction;
        private final UnicodeSet inputChars;
        private final PolicyIfExisting policy;

        @Deprecated
        private LocaleTransform(String inputLocale, String transformFilename, int direction, String inputCharPattern) {
            this(inputLocale, transformFilename, direction, inputCharPattern, PolicyIfExisting.DISCARD);
        }

        private LocaleTransform(String inputLocale, String transformFilename, int direction, String inputCharPattern, PolicyIfExisting policy) {
            this.inputLocale = inputLocale;
            this.transformFilename = transformFilename;
            this.direction = direction;
            this.inputChars = new UnicodeSet(inputCharPattern);
            this.policy = policy;
        }

        public PolicyIfExisting getPolicyIfExisting() {
            return this.policy;
        }

        public String getInputLocale() {
            return this.inputLocale;
        }

        public String getOutputLocale() {
            return this.toString();
        }

        public String getTransformFilename() {
            return this.transformFilename;
        }

        public int getDirection() {
            return this.direction;
        }

        private UnicodeSet getInputChars() {
            return this.inputChars;
        }
    }

    public static enum PolicyIfExisting {
        RETAIN,
        DISCARD,
        MINIMIZE;

    }
}

