/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.SupplementalDataInfo;

public abstract class Chart {
    public static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    public static final SupplementalDataInfo SDI = CONFIG.getSupplementalDataInfo();
    public static final CLDRFile ENGLISH = CONFIG.getEnglish();
    public static final String LS = System.lineSeparator();
    public static final String PREV_CHART_VERSION_DIRECTORY = ToolConstants.getBaseDirectory(ToolConstants.PREV_CHART_VERSION);
    public static final String CHART_VERSION_DIRECTORY = ToolConstants.getBaseDirectory(ToolConstants.CHART_VERSION);
    private static final String GITHUB_ROOT = "https://github.com/unicode-org/cldr/blob/master/";
    private static final String LDML_SPEC = "https://unicode.org/reports/tr35/";

    public static String dataScrapeMessage(String specPart, String testFile, String ... dataFiles) {
        String dataFileList = dataFiles.length == 0 ? null : ListFormatter.getInstance(ULocale.ENGLISH).format(Arrays.asList(dataFiles).stream().map(dataFile -> Chart.dataFileLink(dataFile)).collect(Collectors.toSet()));
        return "<p><b>Warning:</b> Do not scrape this chart for production data.\nInstead, for the meaning of the fields and data consult the " + Chart.ldmlSpecLink(specPart) + (dataFileList == null ? "" : ", and for machine-readable source data, access " + dataFileList) + (testFile == null ? "" : ", and for test data, access " + Chart.dataFileLink(testFile)) + ".</p>\n";
    }

    private static String dataFileLink(String dataFile) {
        return "<a href='https://github.com/unicode-org/cldr/blob/master/" + dataFile + "' target='" + dataFile + "'>" + dataFile + "</a>";
    }

    public static String ldmlSpecLink(String specPart) {
        return "<a href='https://unicode.org/reports/tr35/" + (specPart == null ? "" : specPart) + "' target='units.xml'>LDML specification</a>";
    }

    public String getFileName() {
        return null;
    }

    public String getExplanation() {
        return null;
    }

    public boolean getShowDate() {
        return true;
    }

    public abstract String getDirectory();

    public abstract String getTitle();

    public abstract void writeContents(FormattedFileWriter var1) throws IOException;

    public void writeFooter(FormattedFileWriter pw) throws IOException {
        Chart.standardFooter(pw, AnalyticsID.CLDR);
    }

    private static void standardFooter(FormattedFileWriter pw, AnalyticsID analytics) throws IOException {
        pw.write("<div style='text-align: center; margin-top:2em; margin-bottom: 60em;'><br>\n<a href='http://www.unicode.org/unicode/copyright.html'>\n<img src='http://www.unicode.org/img/hb_notice.gif' style='border-style: none; width: 216px; height=50px;' alt='Access to Copyright and terms of use'></a><br>\n<script src='http://www.unicode.org/webscripts/lastModified.js'></script></div><script>\n\n(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script','//www.google-analytics.com/analytics.js','ga');  ga('create', '" + (Object)((Object)analytics) + "', 'auto');  ga('send', 'pageview');</script>\n");
    }

    public final void writeChart(FormattedFileWriter.Anchors anchors) {
        try (FormattedFileWriter x = new FormattedFileWriter(this.getFileName(), this.getTitle(), this.getExplanation(), anchors);){
            x.setDirectory(this.getDirectory());
            x.setShowDate(this.getShowDate());
            this.writeContents(x);
            this.writeFooter(x);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static String getTsvDir(String targetDir, String topicName) {
        String target = targetDir.replaceAll(topicName, "tsv");
        if (target.equals(targetDir)) {
            throw new IllegalArgumentException("Can't make TSV directory from " + targetDir);
        }
        return target;
    }

    private static enum AnalyticsID {
        CLDR("UA-7672775-1"),
        ICU("UA-7670213-1"),
        ICU_GUIDE("UA-7670256-1"),
        UNICODE("UA-7670213-1"),
        UNICODE_UTILITY("UA-8314904-1");

        public final String id;

        private AnalyticsID(String id) {
            this.id = id;
        }
    }
}

