/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.SimpleHtmlParser;
import org.unicode.cldr.util.TransliteratorUtilities;

@CLDRTool(alias="checkhtmlfiles", description="Look for errors in CLDR documentation tools", hidden="Used for CLDR process")
public class CheckHtmlFiles {
    static final Set<String> NOPOP = new HashSet<String>(Arrays.asList("br", "img", "link", "meta", "!doctype", "hr", "col", "input"));
    static final EnumSet<SimpleHtmlParser.Type> SUPPRESS = EnumSet.of(SimpleHtmlParser.Type.ELEMENT, new SimpleHtmlParser.Type[]{SimpleHtmlParser.Type.ELEMENT_START, SimpleHtmlParser.Type.ELEMENT_END, SimpleHtmlParser.Type.ELEMENT_POP, SimpleHtmlParser.Type.ATTRIBUTE, SimpleHtmlParser.Type.ATTRIBUTE_CONTENT});
    static final Option.Options myOptions = new Option.Options();
    static final Writer LOG = new OutputStreamWriter(System.out);
    static Pattern WELLFORMED_HEADER = PatternCache.get("\\s*(\\d+(\\.\\d+)*\\s*).*");
    static Pattern SUPPRESS_SECTION_NUMBER = PatternCache.get("(Annex [A-Z]: .*)|(Appendix [A-Z].*)|(.*Migrati(on|ng).*)|Step \\d+.*|Example \\d+.*|D\\d+\\.\\s.*|References|Acknowledge?ments|Rights to .*Images|Modifications|(Revision \\d+\\.?)");
    static Pattern SUPPRESS_REVISION = PatternCache.get("Revision \\d+\\.?");
    static Pattern SPACES = PatternCache.get("\\s+");
    static Verbosity verbose;
    static boolean doContents;
    static boolean isLdml;
    private static final Set<String> SKIP_ATTR;
    static Pattern WHITESPACE;
    static Pattern BADSECTION;
    static final Set<String> FORCEBREAK;
    static final Set<String> DO_CONTENTS;
    static Matcher headerMatcher;
    static Matcher badSectionMatcher;

    public static void main(String[] args) throws IOException {
        System.out.println("First do a replace of <a\\s+name=\"([^\"]*)\"\\s*> by <a name=\"$1\" href=\"#$1\">");
        System.out.println("Then check for all links with no anchors: <a([^>]*)></a>");
        System.out.println("Then check for all links that don't start with name or href <a (?!href|name)");
        myOptions.parse(MyOptions.target, args, true);
        verbose = Verbosity.of(MyOptions.verbose.option.getValue());
        String targetString = MyOptions.target.option.getValue();
        if (targetString.contains("ldml")) {
            isLdml = true;
        }
        if (targetString.equalsIgnoreCase("ucd")) {
            targetString = CLDRPaths.BASE_DIRECTORY + "../unicode-draft/reports/tr(\\d+)/tr(\\d+).html";
        } else if (targetString.equalsIgnoreCase("security")) {
            targetString = CLDRPaths.BASE_DIRECTORY + "../unicode-draft/reports/tr(3[69])/tr(3[69]).html";
        }
        Data target = new Data().getSentences(targetString);
        if (target.count == 0) {
            throw new IllegalArgumentException("No files matched with " + targetString);
        }
        if (isLdml) {
            CheckHtmlFiles.checkForDtd(target);
        }
        System.out.println("*TOTAL COUNTS*  files:" + target.count + ", fatal errors:" + target.totalFatalCount + ", nonfatal errors:" + target.totalErrorCount);
        if (target.totalFatalCount > 0 || target.totalErrorCount > 0) {
            System.exit(1);
        }
        System.exit(0);
    }

    private static void checkForDtd(Data target) {
        ChainedMap.M4 typeToElements = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
        for (DtdType dtdType : DtdType.values()) {
            if (dtdType == DtdType.ldmlICU) continue;
            DtdData dtdData = DtdData.getInstance(dtdType);
            Set<DtdData.Element> set = dtdData.getElements();
            for (DtdData.Element element : set) {
                if (element.isDeprecated() || element.equals(dtdData.PCDATA) || element.equals(dtdData.ANY)) continue;
                typeToElements.put(element.name, element.toDtdString(), dtdType, Boolean.TRUE);
            }
            Set<DtdData.Attribute> attributes = dtdData.getAttributes();
            for (DtdData.Attribute attribute : attributes) {
                if (attribute.isDeprecated() || SKIP_ATTR.contains(attribute.name)) continue;
                typeToElements.put(attribute.element.name, attribute.appendDtdString(new StringBuilder()).toString(), dtdType, Boolean.TRUE);
            }
        }
        HashMap<String, String> skeletonToInFile = new HashMap<String, String>();
        Relation<String, String> extra = new Relation<String, String>(new TreeMap(), TreeSet.class);
        for (Row.R4<String, String, String, Boolean> r4 : target.dtdItems.rows()) {
            String string = (String)r4.get0();
            String string2 = (String)r4.get1();
            String item = (String)r4.get2();
            extra.put(string2, item);
            skeletonToInFile.put(item.replace(" ", ""), item);
        }
        ChainedMap.M4 status = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), Comparison.class);
        for (Row.R4 r4 : typeToElements.rows()) {
            String string = (String)r4.get0();
            String key = (String)r4.get1();
            DtdType dtdType = (DtdType)((Object)r4.get2());
            String spaceless = key.replace(" ", "");
            String realKey = (String)skeletonToInFile.get(spaceless);
            if (realKey == null) {
                status.put(string, key, dtdType, Comparison.missing);
                continue;
            }
            boolean found = extra.remove(string, realKey);
            if (found) continue;
            status.put(string, key, dtdType, Comparison.no_rem);
        }
        for (Map.Entry entry : extra.entrySet()) {
            status.put((String)entry.getKey(), (String)entry.getValue(), DtdType.ldmlICU, Comparison.extra);
        }
        TreeSet treeSet = new TreeSet(Collections.reverseOrder());
        for (Map.Entry entry : status) {
            String element3 = (String)entry.getKey();
            treeSet.clear();
            Map map = entry.getValue();
            treeSet.addAll(map.keySet());
            for (String item : treeSet) {
                Map typeToComparison = map.get(item);
                for (Map.Entry entry2 : typeToComparison.entrySet()) {
                    System.out.println(element3 + "\t" + (Object)((Object)entry2.getValue()) + "\t" + CldrUtility.ifSame((Serializable)entry2.getKey(), DtdType.ldmlICU, "") + "\t" + item);
                }
            }
        }
    }

    static {
        SKIP_ATTR = ImmutableSet.of("draft", "alt", "references", "cldrVersion", "unicodeVersion");
        WHITESPACE = PatternCache.get("[\\s]+");
        BADSECTION = PatternCache.get("^\\s*(\\d+\\s*)?Section\\s*\\d+\\s*[-:]\\s*");
        FORCEBREAK = new HashSet<String>(Arrays.asList("table", "div", "blockquote", "p", "br", "td", "th", "h1", "h2", "h3", "h4", "h5", "li"));
        DO_CONTENTS = new HashSet<String>(Arrays.asList("h1", "h2", "h3", "h4", "h5", "caption"));
        headerMatcher = WELLFORMED_HEADER.matcher("");
        badSectionMatcher = BADSECTION.matcher("");
    }

    static enum MyOptions {
        target(".*", CLDRPaths.BASE_DIRECTORY + "specs" + File.separator + "ldml" + File.separator + "tr35(-.*)?\\.html", "target data (regex); ucd for Unicode docs; for others use the format -t ${workspace_loc}/unicode-draft/reports/tr51/tr51.html"),
        verbose(".*", "none", "verbose debugging messages");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }

    static enum Verbosity {
        none,
        element,
        all;


        static Verbosity of(String input) {
            return input == null ? none : Verbosity.valueOf(input.toLowerCase(Locale.ROOT));
        }
    }

    static class Data
    implements Iterable<String> {
        private static final Pattern ELEMENT_ATTLIST = Pattern.compile("<!(ELEMENT|ATTLIST)\\s+(\\S+)[^>]*>");
        List<String> sentences = new ArrayList<String>();
        ChainedMap.M4<String, String, String, Boolean> dtdItems = ChainedMap.of(new LinkedHashMap(), new TreeMap(), new TreeMap(), Boolean.class);
        Counter<String> hashedSentences = new Counter();
        int count = 0;
        int totalErrorCount = 0;
        int totalFatalCount = 0;
        SimpleHtmlParser parser = new SimpleHtmlParser();

        Data() {
        }

        public Data getSentences(String fileRegex) throws IOException {
            String regex;
            String base;
            try {
                int firstParen = fileRegex.indexOf(40);
                if (firstParen < 0) {
                    firstParen = fileRegex.length();
                }
                int lastSlash = fileRegex.lastIndexOf(File.separatorChar, firstParen);
                base = fileRegex.substring(0, lastSlash);
                regex = fileRegex.substring(lastSlash + 1);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Target file must be in special format. Up to the first path part /.../ containing a paragraph is constant, and the rest is a regex.");
            }
            File sourceDirectory = new File(base);
            if (!sourceDirectory.exists()) {
                throw new IllegalArgumentException("Can't find " + sourceDirectory);
            }
            String canonicalBase = PathUtilities.getNormalizedPathString(sourceDirectory);
            String FileRegex = canonicalBase + File.separator + regex;
            FileRegex = FileRegex.replace("\\", "\\\\");
            FileRegex = FileRegex.replace("\\\\.", "\\.");
            Matcher m3 = PatternCache.get(FileRegex).matcher("");
            System.out.println("Matcher: " + m3);
            return this.getSentences(sourceDirectory, m3);
        }

        public Data getSentences(File sourceDirectory, Matcher m3) throws IOException {
            for (File file : sourceDirectory.listFiles()) {
                if (file.isDirectory()) {
                    this.getSentences(file, m3);
                    continue;
                }
                String fileString = file.getCanonicalFile().toString();
                File fileCanonical = new File(fileString);
                if (!m3.reset(fileString).matches()) {
                    if (verbose != Verbosity.all) continue;
                    System.out.println("Skipping: " + RegexUtilities.showMismatch(m3, (CharSequence)fileString) + "\t" + sourceDirectory);
                    continue;
                }
                System.out.println("\nProcessing:\t" + sourceDirectory + File.separator + fileString);
                int H2_START = fileString.contains("tr18") ? -1 : 0;
                try (FileReader in = new FileReader(fileCanonical);){
                    this.parseFile(fileCanonical, H2_START, in);
                }
            }
            return this;
        }

        /*
         * Unable to fully structure code
         */
        public void parseFile(File fileCanonical, int H2_START, Reader in) throws IOException {
            wsMatcher = CheckHtmlFiles.WHITESPACE.matcher("");
            ++this.count;
            this.parser.setReader(in);
            buffer = new StringBuilder();
            content = new StringBuilder();
            heading = new HeadingInfo();
            fileName = fileCanonical.getName();
            headingInfoList = new HeadingInfoList(fileName, H2_START);
            elementStack = new Stack<ElementLine>();
            attributeStack = new Stack<Pair<String, String>>();
            inHeading = false;
            inPop = false;
            inAnchor = false;
            haveContents = false;
            lastHeading = null;
            pushedTable = false;
            checkCaption = false;
            captionWarnings = new ArrayList<Integer>();
            block11: while (true) {
                lineCount = this.parser.getLineCount();
                x = this.parser.next(content);
                if (CheckHtmlFiles.verbose == Verbosity.all && !CheckHtmlFiles.SUPPRESS.contains((Object)x)) {
                    CheckHtmlFiles.LOG.write(this.parser.getLineCount() + "\t" + (Object)x + ":\t\u00ab" + content + "\u00bb");
                    CheckHtmlFiles.LOG.write("\n");
                    CheckHtmlFiles.LOG.flush();
                }
                switch (1.$SwitchMap$org$unicode$cldr$util$SimpleHtmlParser$Type[x.ordinal()]) {
                    case 1: {
                        contentString = content.toString().toLowerCase(Locale.ENGLISH).trim();
                        if (!contentString.equalsIgnoreCase("nocaption")) ** GOTO lbl116
                        pushedTable = false;
                        ** GOTO lbl116
                    }
                    case 2: {
                        contentString = content.toString().toLowerCase(Locale.ENGLISH);
                        inAnchor = inHeading != false && (contentString.equals("name") != false || contentString.equals("id") != false);
                        attributeStack.add(new Pair<String, Object>(contentString, null));
                        ** GOTO lbl116
                    }
                    case 3: {
                        contentString = content.toString().toLowerCase(Locale.ENGLISH);
                        if (inAnchor) {
                            heading.addId(content.toString());
                        }
                        if ((lastAttribute = (Pair)attributeStack.peek()).getSecond() != null) {
                            System.out.println(lineCount + "\tDouble Attribute: " + contentString + ", peek=" + lastAttribute);
                        } else {
                            lastAttribute.setSecond(contentString);
                        }
                        ** GOTO lbl116
                    }
                    case 4: {
                        contentString = content.toString().toLowerCase(Locale.ENGLISH);
                        if (inPop) {
                            while (true) {
                                peek = (ElementLine)elementStack.peek();
                                if (!CheckHtmlFiles.NOPOP.contains(peek.element)) break;
                                elementStack.pop();
                            }
                            if (!peek.element.equals(contentString)) {
                                System.out.println(lineCount + "\tCouldn't pop: " + contentString + ", " + this.showElementStack(elementStack));
                            } else {
                                elementStack.pop();
                            }
                        } else {
                            if (pushedTable && !"caption".equals(contentString)) {
                                captionWarnings.add(lineCount);
                            }
                            elementStack.push(new ElementLine(contentString, lineCount));
                            v0 = pushedTable = checkCaption != false && "table".equals(contentString) != false;
                            if (!checkCaption && "h3".equals(contentString)) {
                                checkCaption = true;
                            }
                        }
                        if (CheckHtmlFiles.verbose != Verbosity.none) {
                            CheckHtmlFiles.LOG.write(this.parser.getLineCount() + "\telem:\t" + this.showElementStack(elementStack) + "\n");
                            CheckHtmlFiles.LOG.flush();
                        }
                        if (CheckHtmlFiles.FORCEBREAK.contains(contentString)) {
                            buffer.append("\n");
                        }
                        if (!CheckHtmlFiles.DO_CONTENTS.contains(contentString)) ** GOTO lbl116
                        if (inPop) {
                            if (inHeading) {
                                inHeading = false;
                                if (heading.isContents()) {
                                    haveContents = true;
                                } else if (haveContents) {
                                    headingInfoList.add(this.parser.getLineCount(), heading);
                                    lastHeading = heading;
                                }
                                heading = new HeadingInfo();
                            }
                        } else {
                            heading.setLevel(contentString, lastHeading);
                            inHeading = true;
                        }
                        ** GOTO lbl116
                    }
                    case 5: {
                        inPop = false;
                        ** GOTO lbl116
                    }
                    case 6: {
                        if (CheckHtmlFiles.verbose == Verbosity.all && !attributeStack.isEmpty()) {
                            CheckHtmlFiles.LOG.write(this.parser.getLineCount() + "\tattr:\t" + this.showAttributeStack(attributeStack) + System.lineSeparator());
                            CheckHtmlFiles.LOG.flush();
                        }
                        attributeStack.clear();
                        inPop = false;
                        ** GOTO lbl116
                    }
                    case 7: {
                        inPop = true;
                        ** GOTO lbl116
                    }
                    case 8: {
                        contentString = wsMatcher.reset(content).replaceAll(" ").replace("&nbsp;", " ");
                        buffer.append(contentString.indexOf(38) >= 0 ? TransliteratorUtilities.fromHTML.transform(contentString) : contentString);
                        if (!inHeading) ** GOTO lbl116
                        heading.addText(contentString);
                        ** GOTO lbl116
                    }
                    case 9: {
                        break block11;
                    }
lbl116:
                    // 14 sources

                    default: {
                        continue block11;
                    }
                }
                break;
            }
            m = Data.ELEMENT_ATTLIST.matcher(buffer);
            while (m.find()) {
                this.dtdItems.put(fileName, m.group(2), m.group(), true);
            }
            sentenceBreak = BreakIterator.getSentenceInstance(ULocale.ENGLISH);
            bufferString = this.normalizeWhitespace(buffer);
            sentenceBreak.setText(bufferString);
            last = 0;
            while ((pos = sentenceBreak.next()) != -1) {
                sentence = bufferString.substring(last, pos).trim();
                last = pos;
                if (sentence.isEmpty()) continue;
                this.hashedSentences.add(sentence, 1L);
                this.sentences.add(sentence);
            }
            if (!captionWarnings.isEmpty()) {
                System.out.println("WARNING: Missing <caption> on the following lines: \n    " + Joiner.on(", ").join(captionWarnings) + "\n\tTo fix, add <caption> after the <table>, such as:\n\t\t<table>\n\t\t\t<caption>Private Use Codes in CLDR</a></caption>\n\tOften the sentence just before the <table> can be made into the caption.\n\tThe next time you run this program, you\u2019ll be prompted with double-links.\n\tIf it really shouldn't have a caption, add <!-- nocaption --> after the <table> instead.");
            }
            fatalCount = headingInfoList.showErrors();
            this.totalFatalCount += fatalCount;
            this.totalErrorCount += headingInfoList.totalErrorCount();
            if (fatalCount == 0) {
                headingInfoList.listContents();
            } else {
                System.out.println("\nFix fatal errors in " + fileCanonical + " before contents can be generated");
            }
        }

        private String showAttributeStack(Stack<Pair<String, String>> attributeStack) {
            StringBuilder result = new StringBuilder();
            for (Pair pair : attributeStack) {
                result.append("[@");
                result.append((String)pair.getFirst());
                String second = (String)pair.getSecond();
                if (second != null) {
                    result.append("='");
                    result.append(second);
                    result.append("'");
                }
                result.append("]");
            }
            return result.toString();
        }

        private String showElementStack(Stack<ElementLine> elementStack) {
            StringBuilder result = new StringBuilder();
            for (ElementLine s2 : elementStack) {
                result.append('/').append(s2);
            }
            return result.toString();
        }

        private String normalizeWhitespace(CharSequence input) {
            Matcher m3 = WHITESPACE.matcher(input);
            StringBuilder buffer = new StringBuilder();
            int last = 0;
            while (m3.find()) {
                int start = m3.start();
                buffer.append(input.subSequence(last, start));
                last = m3.end();
                String whiteString = m3.group();
                if (whiteString.indexOf(10) >= 0) {
                    buffer.append('\n');
                    continue;
                }
                buffer.append(' ');
            }
            buffer.append(input.subSequence(last, input.length()));
            return buffer.toString().trim();
        }

        public long getCount(String sentence) {
            return this.hashedSentences.getCount(sentence);
        }

        @Override
        public Iterator<String> iterator() {
            return this.sentences.iterator();
        }
    }

    static enum Comparison {
        missing,
        extra,
        no_rem;

    }

    static class ElementLine {
        final String element;
        final int line;

        public ElementLine(String element, int line) {
            this.element = element;
            this.line = line;
        }

        public String toString() {
            return this.element + '[' + this.line + ']';
        }
    }

    static class HeadingInfoList {
        private static final long serialVersionUID = -6722150173224993960L;
        Levels lastBuildLevel;
        private Set<String> errors = new LinkedHashSet<String>();
        Output<Boolean> missingLevel = new Output<Boolean>(false);
        private String fileName;
        ArrayList<HeadingInfo> list = new ArrayList();
        static final String PAD = "\t";

        public HeadingInfoList(String fileName, int h2_START) {
            this.fileName = fileName;
            this.lastBuildLevel = new Levels(h2_START);
        }

        public boolean add(int line, HeadingInfo h2) {
            h2.fixText();
            if (SUPPRESS_REVISION.matcher(h2.text).matches()) {
                return false;
            }
            if (h2.isHeader) {
                h2.setLevels(line, this.lastBuildLevel.next(h2.level, this.missingLevel), this.errors);
            } else {
                h2.setLevels(line, this.lastBuildLevel, this.errors);
            }
            if (((Boolean)this.missingLevel.value).booleanValue()) {
                this.errors.add("FATAL: Missing Level in: " + h2);
            }
            return this.list.add(h2);
        }

        public void listContents() {
            System.out.print("\n\t\t<!-- START Generated TOC: CheckHtmlFiles -->");
            Counter<String> idCounter = new Counter<String>();
            int lastLevel = new Levels().getDepth();
            String pad = PAD;
            int ulCount = 0;
            int liCount = 0;
            for (HeadingInfo h2 : this.list) {
                int i;
                h2.addIds(idCounter);
                int depth = h2.levels.getDepth() + (h2.isHeader ? 0 : 1);
                int levelDiff = depth - lastLevel;
                lastLevel = depth;
                if (levelDiff > 0) {
                    System.out.println();
                    for (i = 0; i < levelDiff; ++i) {
                        pad = pad + PAD;
                        System.out.println(pad + "<ul class=\"toc\">");
                        ++ulCount;
                    }
                    pad = pad + PAD;
                } else if (levelDiff < 0) {
                    System.out.println("</li>");
                    --liCount;
                    for (i = 0; i > levelDiff; --i) {
                        pad = pad.substring(PAD.length());
                        System.out.println(pad + "</ul>");
                        --ulCount;
                        pad = pad.substring(PAD.length());
                        System.out.println(pad + "</li>");
                        --liCount;
                    }
                } else {
                    System.out.println("</li>");
                    --liCount;
                }
                System.out.print(pad + h2.toHeader());
                ++liCount;
            }
            int levelDiff = -lastLevel;
            System.out.println("</li>");
            --liCount;
            for (int i = 0; i > levelDiff; --i) {
                pad = pad.substring(PAD.length());
                System.out.println(pad + "</ul>");
                --ulCount;
                pad = pad.substring(PAD.length());
                System.out.println(pad + "</li>");
                --liCount;
            }
            pad = pad.substring(PAD.length());
            System.out.println(pad + "</ul>");
            System.out.println(pad + "<!-- END Generated TOC: CheckHtmlFiles -->");
            if (liCount != 0 || --ulCount != 0) {
                throw new IllegalArgumentException("Mismatched counts in generated contents, li:" + liCount + ", ul:" + ulCount);
            }
            for (String id : idCounter) {
                long count = idCounter.get(id);
                if (count == 1L) continue;
                this.errors.add("FATAL: Non-Unique ID: " + id);
            }
        }

        public int showErrors() {
            int fatalCount = 0;
            if (!this.errors.isEmpty()) {
                System.out.println("\n*ERRORS*\n");
                for (String error : this.errors) {
                    if (!error.startsWith("FATAL:")) continue;
                    System.out.println(this.fileName + PAD + error);
                    ++fatalCount;
                }
                if (fatalCount == 0) {
                    for (String error : this.errors) {
                        System.out.println(this.fileName + PAD + error);
                    }
                }
            }
            if (this.list.size() == 0) {
                System.out.println("No header items (eg <h2>) captured.");
                fatalCount = 1;
            }
            return fatalCount;
        }

        public int totalErrorCount() {
            return this.errors.size();
        }
    }

    static class HeadingInfo {
        private Levels levels = new Levels();
        private String text = "";
        private Set<String> ids = new LinkedHashSet<String>();
        private boolean suppressSection;
        private boolean isHeader;
        private int level;

        HeadingInfo() {
        }

        public void setLevel(String headingLabel, HeadingInfo lastHeading) {
            this.isHeader = !headingLabel.equals("caption");
            this.level = this.isHeader ? headingLabel.charAt(1) - 48 : lastHeading.level;
        }

        public String toString() {
            String id = this.ids.isEmpty() ? "NOID" : this.ids.iterator().next();
            String result = "<" + this.getLabel() + "<a name=\"" + id + "\" href=\"#" + id + "\">" + (!this.isHeader ? "" : (this.suppressSection ? "" : this.levels + " ")) + TransliteratorUtilities.toHTML.transform(this.text) + "</a>";
            if (this.ids.size() > 1) {
                boolean first = true;
                for (String id2 : this.ids) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    result = result + "<a name=\"" + id2 + "\"></a>";
                }
            }
            return result + "</" + this.getLabel();
        }

        public String getLabel() {
            return this.isHeader ? "h" + this.level + ">" : "caption>";
        }

        public String toHeader() {
            String id = this.ids.iterator().next();
            return "<li>" + (!this.isHeader ? (this.text.contains("Table") || this.text.contains("Figure") ? "" : "Table: ") : (this.suppressSection ? "" : this.levels + " ")) + "<a href=\"#" + id + "\">" + TransliteratorUtilities.toHTML.transform(this.text) + "</a>";
        }

        public void addText(String toAppend) {
            String temp = TransliteratorUtilities.fromHTML.transform(toAppend);
            this.text = this.text.isEmpty() ? (temp.startsWith(" ") ? temp.substring(1) : temp) : this.text + temp;
            this.text = SPACES.matcher(this.text).replaceAll(" ");
        }

        public boolean isContents() {
            return this.text.toString().startsWith("Contents");
        }

        void addId(String id) {
            this.ids.add(id);
        }

        public void setLevels(int line, Levels levels, Set<String> errors) {
            this.levels.set(levels);
            String error = "";
            if (badSectionMatcher.reset(this.text).find()) {
                this.text = this.text.substring(badSectionMatcher.end());
                error = error + "Extra 'Section...' at start; ";
            }
            if (this.isHeader) {
                if (!headerMatcher.reset(this.text).matches()) {
                    if (!SUPPRESS_SECTION_NUMBER.matcher(this.text).matches()) {
                        error = error + "Missing section numbers; ";
                    }
                } else {
                    Levels parsedLevels;
                    this.text = this.text.substring(headerMatcher.end(1));
                    if (this.text.startsWith(".")) {
                        this.text = this.text.substring(1).trim();
                        error = error + "Extra . at start; ";
                    }
                    if (levels.compareTo(parsedLevels = Levels.parse(headerMatcher.group(1))) != 0) {
                        error = error + "Section numbers mismatch, was " + parsedLevels + "; ";
                    }
                }
            }
            if (this.ids.isEmpty()) {
                this.addId(this.text.toString().trim().replaceAll("[^A-Za-z0-9]+", "_"));
                error = error + "Missing double link";
            }
            if (!error.isEmpty()) {
                errors.add(this + "\t<!-- " + line + ": " + error + " -->");
            }
            this.suppressSection = SUPPRESS_SECTION_NUMBER.matcher(this.text).matches();
        }

        public void addIds(Counter<String> idCounter) {
            for (String id : this.ids) {
                idCounter.add(id, 1L);
            }
        }

        public HeadingInfo fixText() {
            if (this.text.endsWith(" ")) {
                this.text = this.text.substring(0, this.text.length() - 1);
            }
            return this;
        }
    }

    static class Levels
    implements Comparable<Levels> {
        final int[] levels = new int[10];
        final int h2_start;

        public Levels(int h2_start) {
            this.levels[0] = h2_start;
            this.h2_start = h2_start;
        }

        public Levels() {
            this(0);
        }

        Levels next(int level, Output<Boolean> missingLevel) {
            int i;
            level -= 2;
            missingLevel.value = false;
            if (this.levels[0] < this.h2_start) {
                missingLevel.value = true;
            }
            for (i = 1; i < level; ++i) {
                if (this.levels[i] != 0) continue;
                missingLevel.value = true;
            }
            int n = level;
            this.levels[n] = this.levels[n] + 1;
            for (i = level + 1; i < this.levels.length; ++i) {
                this.levels[i] = 0;
            }
            return this;
        }

        public int getDepth() {
            int i = 0;
            int level;
            while ((level = this.levels[i]) != 0) {
                ++i;
            }
            return i - 1;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            int i = 0;
            int level;
            while ((level = this.levels[i]) != 0) {
                if (b.length() != 0) {
                    b.append('.');
                }
                b.append(level);
                ++i;
            }
            return b.toString();
        }

        public static Levels parse(String group) {
            Levels result = new Levels();
            int currentLevel = 0;
            for (int i = 0; i < group.length(); ++i) {
                char ch = group.charAt(i);
                if (ch == '.') {
                    ++currentLevel;
                    continue;
                }
                if ((ch = (char)(ch - 48)) > '9') break;
                result.levels[currentLevel] = result.levels[currentLevel] * 10 + ch;
            }
            return result;
        }

        @Override
        public int compareTo(Levels other) {
            for (int i = 0; i < this.levels.length; ++i) {
                if (this.levels[i] == other.levels[i]) continue;
                return this.levels[i] < other.levels[i] ? -1 : 1;
            }
            return 0;
        }

        public void set(Levels other) {
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = other.levels[i];
            }
        }
    }
}

