/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateDayPeriodChart {
    static final SupplementalDataInfo SUP = CLDRConfig.getInstance().getSupplementalDataInfo();
    static final CLDRFile ENGLISH = CLDRConfig.getInstance().getEnglish();
    static final StandardCodes SC = CLDRConfig.getInstance().getStandardCodes();
    static final int MINUTE = 60000;
    static final int HOUR = 3600000;

    public static void main(String[] args) {
        DateFormat dt = DateFormat.getPatternInstance("HH:mm", ULocale.ENGLISH);
        dt.setTimeZone(TimeZone.GMT_ZONE);
        for (DayPeriodInfo.Type type : DayPeriodInfo.Type.values()) {
            ChainedMap.M4 minimalPairs = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
            EnumSet<DayPeriodInfo.DayPeriod> careAbout = EnumSet.noneOf(DayPeriodInfo.DayPeriod.class);
            ChainedMap.M3 dayPeriodToTimes = ChainedMap.of(new TreeMap(), new TreeMap(), Integer.class);
            System.out.println((Object)type);
            Set<String> dayPeriodLocales = SUP.getDayPeriodLocales(type);
            for (String locale : dayPeriodLocales) {
                DayPeriodInfo info = GenerateDayPeriodChart.getFixedDayPeriodInfo(type, locale);
                if (info == null) continue;
                List<DayPeriodInfo.DayPeriod> list = info.getPeriods();
                careAbout.addAll(list);
                for (DayPeriodInfo.DayPeriod dp1 : list) {
                    for (DayPeriodInfo.DayPeriod dp2 : list) {
                        int comp = dp1.compareTo(dp2);
                        if (comp < 0) {
                            minimalPairs.put(dp2, dp1, locale, Boolean.TRUE);
                            continue;
                        }
                        minimalPairs.put(dp1, dp2, locale, Boolean.TRUE);
                    }
                }
                for (int i = 0; i < 24; ++i) {
                    DayPeriodInfo.DayPeriod period = info.getDayPeriod((i * 60 + 30) * 60000);
                    Integer old = dayPeriodToTimes.get(period, i);
                    dayPeriodToTimes.put(period, i, old == null ? 1 : old + 1);
                }
            }
            System.out.print("\t\t");
            for (int i = 0; i < 24; ++i) {
                if (i == 12 || i == 0) {
                    System.out.print("\t" + dt.format(i * 60 * 60000));
                }
                System.out.print("\t" + dt.format((i * 60 + 30) * 60000));
            }
            System.out.println();
            System.out.flush();
            for (String locale : dayPeriodLocales) {
                System.out.print((Object)((Object)type) + "\t" + locale + "\t" + ENGLISH.getName(locale));
                DayPeriodInfo dayPeriod = GenerateDayPeriodChart.getFixedDayPeriodInfo(type, locale);
                GenerateDayPeriodChart.doRow(dayPeriod);
            }
            for (DayPeriodInfo.DayPeriod column : careAbout) {
                System.out.print("\t" + (Object)((Object)column));
            }
            System.out.println();
            for (DayPeriodInfo.DayPeriod row : careAbout) {
                System.out.print((Object)row);
                ChainedMap.M3 rowValues = minimalPairs.get(row);
                for (DayPeriodInfo.DayPeriod column : careAbout) {
                    Map cell = rowValues == null ? null : rowValues.get(column);
                    System.out.print("\t" + (cell == null ? "" : cell.keySet()));
                }
                System.out.println();
            }
            for (int i = 0; i < 24; ++i) {
                System.out.print("\t" + dt.format((i * 60 + 30) * 60000));
            }
            System.out.println();
            for (DayPeriodInfo.DayPeriod dayPeriod : DayPeriodInfo.DayPeriod.values()) {
                System.out.print((Object)dayPeriod);
                Map times = dayPeriodToTimes.get(dayPeriod);
                for (int i = 0; i < 24; ++i) {
                    Integer count = times == null ? null : times.get(i);
                    System.out.print("\t" + (count == null ? "-" : count));
                }
                System.out.println();
            }
            EnumSet<DayPeriodInfo.DayPeriod> present = EnumSet.allOf(DayPeriodInfo.DayPeriod.class);
            for (String locale : dayPeriodLocales) {
                DayPeriodInfo dayPeriodInfo = GenerateDayPeriodChart.getFixedDayPeriodInfo(type, locale);
                present.retainAll(dayPeriodInfo.getPeriods());
            }
            System.out.println("Present in all: " + present);
        }
    }

    public static DayPeriodInfo getFixedDayPeriodInfo(DayPeriodInfo.Type type, String locale) {
        return SUP.getDayPeriods(type, locale);
    }

    public static void doRow(DayPeriodInfo dayPeriod) {
        for (int i = 0; i < 24; ++i) {
            DayPeriodInfo.DayPeriod period;
            if (dayPeriod == null) {
                System.out.print("\t?");
                continue;
            }
            if (i == 12 || i == 0) {
                period = dayPeriod.getDayPeriod(i * 60 * 60000);
                System.out.print("\t" + (Object)((Object)period));
            }
            period = dayPeriod.getDayPeriod((i * 60 + 30) * 60000);
            System.out.print("\t" + (Object)((Object)period));
        }
        System.out.println();
        System.out.flush();
    }
}

