/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.CaseMap;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.LocaleDisplayNames;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.GenerateSubdivisions;
import org.unicode.cldr.tool.SubdivisionNames;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.WikiSubdivisionLanguages;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class SubdivisionNode {
    static final SupplementalDataInfo SDI = SupplementalDataInfo.getInstance();
    static final Map<String, Row.R2<List<String>, String>> territoryAliases = SDI.getLocaleAliasInfo().get("territory");
    static final Set<String> containment = SDI.getContainers();
    static final Map<String, Map<StandardCodes.LstrField, String>> codeToData = StandardCodes.getEnumLstreg().get((Object)StandardCodes.LstrType.region);
    static LocaleDisplayNames ENGLISH_ICU = LocaleDisplayNames.getInstance(ULocale.ENGLISH);
    static final CaseMap.Title TO_TITLE_WHOLE_STRING_NO_LOWERCASE = CaseMap.toTitle().wholeString().noLowercase();
    static final Comparator<String> ROOT_COL;
    static final CLDRConfig CLDR_CONFIG;
    static final CLDRFile ENGLISH_CLDR;
    static final Normalizer2 nfc;
    final SubdivisionSet sset;
    final String code;
    final int level;
    final SubdivisionNode parent;
    final Map<String, SubdivisionNode> children = new TreeMap<String, SubdivisionNode>(ROOT_COL);

    public static String convertToCldr(String regionOrSubdivision) {
        return SubdivisionNames.isRegionCode(regionOrSubdivision) ? regionOrSubdivision.toUpperCase(Locale.ROOT) : regionOrSubdivision.replace("-", "").toLowerCase(Locale.ROOT);
    }

    public SubdivisionNode(String code, SubdivisionNode parent, SubdivisionSet sset) {
        this.code = code;
        this.level = parent == null ? -1 : parent.level + 1;
        this.parent = parent;
        this.sset = sset;
        sset.ID_TO_NODE.put(code, this);
    }

    public SubdivisionNode addName(String lang, String value) {
        this.sset.NAMES.put(this.code, lang, value);
        return this;
    }

    static {
        RuleBasedCollator _ROOT_COL = (RuleBasedCollator)Collator.getInstance(ULocale.ENGLISH);
        _ROOT_COL.setNumericCollation(true);
        _ROOT_COL.freeze();
        ROOT_COL = _ROOT_COL;
        CLDR_CONFIG = CLDRConfig.getInstance();
        ENGLISH_CLDR = CLDR_CONFIG.getEnglish();
        nfc = Normalizer2.getNFCInstance();
    }

    static class SubdivisionSet {
        final ChainedMap.M3<String, String, String> NAMES = ChainedMap.of(new TreeMap(), new TreeMap(), String.class);
        final Map<String, String> TO_COUNTRY_CODE = new TreeMap<String, String>();
        final Relation<String, String> ID_SAMPLE = Relation.of(new TreeMap(), TreeSet.class);
        final Map<String, String> SUB_TO_CAT = new TreeMap<String, String>();
        final Relation<String, String> REGION_CONTAINS = Relation.of(new TreeMap(), TreeSet.class);
        final Map<String, SubdivisionNode> ID_TO_NODE = new HashMap<String, SubdivisionNode>();
        final SubdivisionNode BASE = new SubdivisionNode("001", null, this).addName("en", "World");
        static final String[] CRUFT = new String[]{"Emirate", "Parish", "County", "District", "Region", "Province of", "Province", "Republic", ", Barbados", ", Burkina Faso", "Governorate", "Department", "Canton of", "(R\u00e9gion des)", "(R\u00e9gion du)", "(R\u00e9gion de la)", "Autonomous", "Archipelago of", "Canton", "kanton", ", Bahamas", "province", "(R\u00e9gion)", "(R\u00e9gion de l')", ", Cameroon", "State of", "State", "Metropolitan Borough of", "London Borough of", "Royal Borough of", "Borough of", "Borough", "Council of", "Council", "City of", ", The", "prefecture", "Prefecture", "municipality"};
        static final Pattern CRUFT_PATTERN = PatternCache.get("(?i)\\b" + String.join((CharSequence)"|", CRUFT) + "\\b");
        static final Pattern BRACKETED = PatternCache.get("\\[.*\\]");
        static Map<String, String> NAME_CORRECTIONS = new HashMap<String, String>();

        public void addName(String code, String lang, String value) {
            int parenPos = value.indexOf("(see also separate country");
            if (parenPos >= 0) {
                value = value.substring(0, parenPos).trim();
            }
            value = value.replace("*", "");
            this.NAMES.put(code, lang, value);
        }

        static String clean(String input) {
            if (input == null) {
                return input;
            }
            input = BRACKETED.matcher(input).replaceAll("");
            input = CRUFT_PATTERN.matcher(input).replaceAll("");
            if ((input = input.replace("  ", " ")).endsWith(",")) {
                input = input.substring(0, input.length() - 1);
            }
            return SubdivisionSet.fixName(input);
        }

        private static void appendName(CLDRFile fileSubdivisions, String sdCode, String name, String level) throws IOException {
            if (name == null) {
                return;
            }
            String cldrCode = SubdivisionNode.convertToCldr(sdCode);
            String path = "//ldml/localeDisplayNames/subdivisions/subdivision[@type=\"" + cldrCode + "\"]";
            String oldValue = fileSubdivisions.getStringValue(path);
            if (oldValue != null) {
                return;
            }
            fileSubdivisions.add(path, name);
            if (level != null) {
                fileSubdivisions.addComment(path, level, XPathParts.Comments.CommentType.LINE);
            }
        }

        private boolean isKosher(String regionCode) {
            if (regionCode.equals("001")) {
                return false;
            }
            if (territoryAliases.containsKey(regionCode) || containment.contains(regionCode) || codeToData.get(regionCode).get((Object)StandardCodes.LstrField.Description).contains("Private use")) {
                Set<String> rc = this.REGION_CONTAINS.get(regionCode);
                if (rc != null) {
                    throw new IllegalArgumentException("? " + regionCode + ": " + rc);
                }
                return false;
            }
            return true;
        }

        private static void addChildren(Set<SubdivisionNode> ordered, Map<String, SubdivisionNode> children2) {
            TreeMap<String, SubdivisionNode> temp = new TreeMap<String, SubdivisionNode>(ROOT_COL);
            temp.putAll(children2);
            ordered.addAll(temp.values());
            for (SubdivisionNode n : temp.values()) {
                if (n.children.isEmpty()) continue;
                SubdivisionSet.addChildren(ordered, n.children);
            }
        }

        private String getBestName(String value, boolean useIso) {
            String country;
            String cldrName = null;
            cldrName = NAME_CORRECTIONS.get(value);
            if (cldrName != null) {
                return SubdivisionSet.fixName(cldrName);
            }
            Row.R2<List<String>, String> subdivisionAlias = GenerateSubdivisions.SubdivisionInfo.SUBDIVISION_ALIASES_FORMER.get(value);
            if (subdivisionAlias != null && (cldrName = ENGLISH_CLDR.getName(2, country = (String)((List)subdivisionAlias.get0()).get(0))) != null) {
                return SubdivisionSet.fixName(cldrName);
            }
            cldrName = GenerateSubdivisions.SubdivisionInfo.SUBDIVISION_NAMES_ENGLISH_FORMER.get(value);
            if (cldrName != null) {
                return SubdivisionSet.fixName(cldrName);
            }
            Collection<String> oldAliases = GenerateSubdivisions.SubdivisionInfo.subdivisionIdToOld.get(value);
            if (oldAliases != null) {
                for (String oldAlias : oldAliases) {
                    cldrName = GenerateSubdivisions.SubdivisionInfo.SUBDIVISION_NAMES_ENGLISH_FORMER.get(oldAlias);
                    if (cldrName == null) continue;
                    return SubdivisionSet.fixName(cldrName);
                }
            }
            if (useIso) {
                cldrName = this.getIsoName(value);
                if (cldrName == null) {
                    cldrName = "UNKNOWN";
                }
                return SubdivisionSet.fixName(cldrName);
            }
            return null;
        }

        private static String fixName(String name) {
            return name == null ? null : nfc.normalize(name.replace('\'', '\u2019').replace("  ", " ").trim());
        }

        public SubdivisionSet(String sourceFile) {
            List<Pair<String, String>> pathValues = XMLFileReader.loadPathValues(sourceFile, new ArrayList<Pair<String, String>>(), false);
            int maxIndent = 0;
            SubdivisionNode lastNode = null;
            String lastCode = null;
            HashSet<String> conflictingTargetCountries = new HashSet<String>();
            for (Pair<String, String> pair : pathValues) {
                String path = pair.getFirst();
                boolean code = path.contains("/subdivision-code");
                boolean name = path.contains("/subdivision-locale-name");
                boolean nameCat = path.contains("/category-name");
                boolean relatedCountry = path.contains("/subdivision-related-country");
                if (!code && !name && !nameCat && !relatedCountry) continue;
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String value = pair.getSecond();
                if (relatedCountry) {
                    String target = parts.getAttributeValue(-1, "country-id");
                    for (Map.Entry<String, String> entry : this.TO_COUNTRY_CODE.entrySet()) {
                        if (!entry.getValue().equals(target)) continue;
                        conflictingTargetCountries.add(target);
                        this.TO_COUNTRY_CODE.remove(entry.getKey(), target);
                        break;
                    }
                    if (conflictingTargetCountries.contains(target)) continue;
                    this.TO_COUNTRY_CODE.put(lastCode, target);
                    continue;
                }
                if (name) {
                    int elementNum = -2;
                    String lang = parts.getAttributeValue(elementNum, "xml:lang");
                    if (lang == null) {
                        lang = parts.getAttributeValue(elementNum, "lang3code");
                    }
                    this.addName(lastCode, lang, value);
                    continue;
                }
                if (nameCat) {
                    int elementNum = -1;
                    String lang = parts.getAttributeValue(elementNum, "xml:lang");
                    if (lang == null) {
                        lang = parts.getAttributeValue(elementNum, "lang3code");
                    }
                    String category = parts.getAttributeValue(-2, "id");
                    this.addName(category, lang, value);
                    continue;
                }
                int countSubdivision = 0;
                for (int i = 0; i < parts.size(); ++i) {
                    if (!parts.getElement(i).equals("subdivision")) continue;
                    ++countSubdivision;
                }
                if (maxIndent < countSubdivision) {
                    maxIndent = countSubdivision;
                }
                value = SubdivisionNode.convertToCldr(value);
                lastNode = countSubdivision == 1 ? this.addNode(null, value) : this.addNode(lastNode, value);
                lastCode = value;
                int subdivisionElement = parts.findElement("subdivision");
                String id = parts.getAttributeValue(subdivisionElement, "category-id");
                this.addIdSample(id, value);
            }
        }

        public void addIdSample(String id, String value) {
            this.SUB_TO_CAT.put(value, id);
            this.ID_SAMPLE.put(this.getIsoName(id), value);
        }

        final SubdivisionNode addNode(SubdivisionNode lastSubdivision, String subdivision) {
            String region = SubdivisionNames.getRegionFromSubdivision(subdivision);
            this.REGION_CONTAINS.put(region, subdivision);
            if (lastSubdivision == null) {
                lastSubdivision = this.BASE.children.get(region);
                if (lastSubdivision == null) {
                    lastSubdivision = new SubdivisionNode(region, this.BASE, this).addName("en", ENGLISH_ICU.regionDisplayName(region));
                    this.BASE.children.put(region, lastSubdivision);
                }
                return this.add(lastSubdivision, subdivision);
            }
            this.add(lastSubdivision, subdivision);
            return lastSubdivision;
        }

        private SubdivisionNode add(SubdivisionNode subdivisionNode1, String subdivision2) {
            SubdivisionNode subdivisionNode2 = subdivisionNode1.children.get(subdivision2);
            if (subdivisionNode2 == null) {
                subdivisionNode2 = new SubdivisionNode(subdivision2, subdivisionNode1, this);
            }
            subdivisionNode1.children.put(subdivision2, subdivisionNode2);
            return subdivisionNode2;
        }

        private String getName(SubdivisionNode base2) {
            return this.getIsoName(base2.code);
        }

        private String getIsoName(String code) {
            if (code == null) {
                return null;
            }
            Map<String, String> map = this.NAMES.get(code);
            if (map == null) {
                return "???";
            }
            String name = map.get("en");
            if (name != null) {
                return name;
            }
            name = map.get("es");
            if (name != null) {
                return name;
            }
            name = map.get("fr");
            if (name != null) {
                return name;
            }
            if (name == null) {
                name = map.entrySet().iterator().next().getValue();
            }
            return name;
        }

        public void print(PrintWriter out) {
            this.print(out, 0, "", this.BASE);
            for (Map.Entry<String, String> entry : this.TO_COUNTRY_CODE.entrySet()) {
                out.println(entry.getKey() + "\t" + entry.getValue());
            }
        }

        private void print(PrintWriter out, int indent, String prefix, SubdivisionNode base2) {
            if (!prefix.isEmpty()) {
                prefix = prefix + "\t";
            }
            prefix = prefix + base2.code;
            String indentString = Utility.repeat("\t", 4 - indent);
            out.println(prefix + indentString + this.getName(base2));
            if (base2.children.isEmpty()) {
                return;
            }
            for (SubdivisionNode child : base2.children.values()) {
                this.print(out, indent + 1, prefix, child);
            }
        }
    }

    static class SubDivisionExtractor {
        final SubdivisionSet sdset;
        final Validity validityFormer;
        final Map<String, Row.R2<List<String>, String>> subdivisionAliasesFormer;
        final Relation<String, String> formerRegionToSubdivisions;

        public SubDivisionExtractor(SubdivisionSet sdset, Validity validityFormer, Map<String, Row.R2<List<String>, String>> subdivisionAliasesFormer, Relation<String, String> formerRegionToSubdivisions) {
            this.sdset = sdset;
            this.validityFormer = validityFormer;
            this.subdivisionAliasesFormer = subdivisionAliasesFormer;
            this.formerRegionToSubdivisions = formerRegionToSubdivisions;
        }

        void printXml(Appendable output) throws IOException {
            output.append(DtdType.supplementalData.header(MethodHandles.lookup().lookupClass()) + "\t<version number=\"$Revision$\"/>\n\t<subdivisionContainment>\n");
            this.printXml(output, this.sdset.BASE, 0);
            output.append("\t</subdivisionContainment>\n</supplementalData>\n");
        }

        void printAliases(Appendable output) throws IOException {
            this.addAliases(output, this.sdset.TO_COUNTRY_CODE.keySet());
            Map<Validity.Status, Set<String>> oldSubdivisionData = this.validityFormer.getStatusToCodes(StandardCodes.LstrType.subdivision);
            TreeSet<String> missing = new TreeSet<String>(ROOT_COL);
            missing.addAll(this.sdset.TO_COUNTRY_CODE.keySet());
            Set<String> nowValid = this.sdset.ID_TO_NODE.keySet();
            for (Map.Entry<Validity.Status, Set<String>> e : oldSubdivisionData.entrySet()) {
                Validity.Status v = e.getKey();
                if (v == Validity.Status.unknown) continue;
                Set<String> set = e.getValue();
                for (String sdcodeRaw : set) {
                    String sdcode = sdcodeRaw;
                    if (nowValid.contains(sdcode)) continue;
                    missing.add(sdcode);
                }
            }
            missing.removeAll(this.sdset.TO_COUNTRY_CODE.keySet());
            this.addAliases(output, missing);
        }

        private void addAliases(Appendable output, Set<String> missing) throws IOException {
            for (String toReplace : missing) {
                List<String> replaceBy = null;
                String reason = "deprecated";
                Row.R2<List<String>, String> aliasInfo = this.subdivisionAliasesFormer.get(toReplace);
                if (aliasInfo != null) {
                    replaceBy = (List<String>)aliasInfo.get0();
                    reason = (String)aliasInfo.get1();
                    System.out.println("Adding former alias: " + toReplace + " => " + replaceBy);
                } else {
                    String replacement = this.sdset.TO_COUNTRY_CODE.get(toReplace);
                    if (replacement != null) {
                        replaceBy = Collections.singletonList(replacement);
                        reason = "overlong";
                        System.out.println("Adding country code alias: " + toReplace + " => " + replaceBy);
                    }
                }
                this.addAlias(output, toReplace, replaceBy, reason);
            }
        }

        private void addAlias(Appendable output, String toReplace, List<String> replaceBy, String reason) throws IOException {
            output.append("\t\t\t");
            if (replaceBy == null) {
                output.append("<!-- ");
            }
            output.append("<subdivisionAlias type=\"" + toReplace + "\" replacement=\"" + (replaceBy == null ? toReplace.substring(0, 2) + "?" : Joiner.on(" ").join(replaceBy)) + "\" reason=\"" + reason + "\"/>" + (replaceBy == null ? " <!- - " : " <!-- ") + this.sdset.getBestName(toReplace, true) + " => " + (replaceBy == null ? "??" : this.getBestName(replaceBy, true)) + " -->\n");
        }

        private String getBestName(List<String> replaceBy, boolean useIso) {
            StringBuilder result = new StringBuilder();
            for (String s2 : replaceBy) {
                if (result.length() != 0) {
                    result.append(", ");
                }
                if (SubdivisionNames.isRegionCode(s2)) {
                    result.append(ENGLISH_CLDR.getName(2, s2));
                    continue;
                }
                result.append(this.sdset.getBestName(s2, useIso));
            }
            return result.toString();
        }

        private void printXml(Appendable output, SubdivisionNode base2, int indent) throws IOException {
            if (base2.children.isEmpty()) {
                return;
            }
            String type = base2.code;
            if (base2 != this.sdset.BASE) {
                type = SubdivisionNode.convertToCldr(type);
                output.append("\t\t<subgroup type=\"" + type + "\" contains=\"");
                boolean first = true;
                for (String child : base2.children.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        output.append(' ');
                    }
                    String subregion = SubdivisionNode.convertToCldr(child);
                    output.append(subregion);
                }
                output.append("\"/>\n");
            }
            for (SubdivisionNode child : base2.children.values()) {
                this.printXml(output, child, indent);
            }
        }

        public void printSamples(Appendable pw) throws IOException {
            HashSet<String> seen = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : this.sdset.ID_SAMPLE.keyValuesSet()) {
                pw.append(entry.getKey());
                seen.clear();
                for (String sample : entry.getValue()) {
                    String region = sample.substring(0, 2);
                    if (seen.contains(region)) continue;
                    seen.add(region);
                    pw.append(";\t" + ENGLISH_ICU.regionDisplayName(region) + ": " + this.sdset.getIsoName(sample) + " (" + sample + ")");
                }
                pw.append(System.lineSeparator());
            }
        }

        public void printEnglishComp(Appendable output) throws IOException {
            TreeSet<String> countEqual = new TreeSet<String>();
            String lastCC = null;
            output.append("Country\tMID\tSubdivision\tCLDR\tISO\tWikidata\tEqual\n");
            for (Map.Entry<String, Set<String>> entry : this.sdset.REGION_CONTAINS.keyValuesSet()) {
                String countryCode = entry.getKey();
                if (!countryCode.equals(lastCC)) {
                    if (lastCC != null && countEqual.size() != 0) {
                        output.append(ENGLISH_ICU.regionDisplayName(lastCC) + "\t\t\tEquals:\t" + countEqual.size() + "\t" + countEqual + "\n");
                    }
                    countEqual.clear();
                    lastCC = countryCode;
                }
                for (String value : entry.getValue()) {
                    String cldrName = this.sdset.getBestName(value, false);
                    String wiki = WikiSubdivisionLanguages.getBestWikiEnglishName(value);
                    String iso = this.sdset.getIsoName(value);
                    if (iso.equals(wiki)) {
                        countEqual.add(iso);
                        continue;
                    }
                    output.append(ENGLISH_ICU.regionDisplayName(countryCode) + "\t" + cldrName + "\t" + value + "\t" + iso + "\t" + wiki + "\n");
                }
            }
            if (countEqual.size() != 0) {
                output.append(ENGLISH_ICU.regionDisplayName(lastCC) + "\t\t\tEquals:\t" + countEqual.size() + "\t" + countEqual + "\n");
            }
        }

        public void printEnglishCompFull(Appendable output) throws IOException {
            output.append("Country\tMID\tSubdivision\tCLDR\tISO\tWikidata\n");
            for (Map.Entry<String, Set<String>> entry : this.sdset.REGION_CONTAINS.keyValuesSet()) {
                String countryCode = entry.getKey();
                for (String value : entry.getValue()) {
                    String cldrName = this.sdset.getBestName(value, false);
                    String wiki = WikiSubdivisionLanguages.getBestWikiEnglishName(value);
                    String iso = this.sdset.getIsoName(value);
                    output.append(ENGLISH_ICU.regionDisplayName(countryCode) + "\t" + value + "\t" + cldrName + "\t" + iso + "\t" + wiki + "\n");
                }
            }
        }

        public void printEnglish(PrintWriter output) throws IOException {
            TreeSet<String> allRegions = new TreeSet<String>();
            allRegions.addAll(codeToData.keySet());
            allRegions.addAll(this.formerRegionToSubdivisions.keySet());
            Factory cldrFactorySubdivisions = Factory.make(CLDRPaths.SUBDIVISIONS_DIRECTORY, ".*");
            CLDRFile oldFileSubdivisions = cldrFactorySubdivisions.make("en", false);
            CLDRFile fileSubdivisions = oldFileSubdivisions.cloneAsThawed();
            LinkedHashSet<String> skipped = new LinkedHashSet<String>();
            for (String regionCode : allRegions) {
                if (!this.sdset.isKosher(regionCode)) {
                    if (regionCode.length() == 3) continue;
                    skipped.add(regionCode);
                    continue;
                }
                LinkedHashSet remainder = this.formerRegionToSubdivisions.get(regionCode);
                remainder = remainder == null ? Collections.emptySet() : new LinkedHashSet(remainder);
                SubdivisionNode regionNode = this.sdset.ID_TO_NODE.get(regionCode);
                if (regionNode == null) continue;
                LinkedHashSet ordered = new LinkedHashSet();
                SubdivisionSet.addChildren(ordered, regionNode.children);
                for (SubdivisionNode node : ordered) {
                    String sdCode = node.code;
                    String name = this.sdset.getBestName(sdCode, true);
                    String upper = UCharacter.toUpperCase(name);
                    String title = TO_TITLE_WHOLE_STRING_NO_LOWERCASE.apply(Locale.ROOT, null, name);
                    if (name.equals(upper) || !name.equals(title)) {
                        System.out.println("Suspicious name: " + name);
                    }
                    SubdivisionSet.appendName(fileSubdivisions, sdCode, name, null);
                    remainder.remove(sdCode);
                }
                for (String sdCode : remainder) {
                    String name = this.sdset.getBestName(sdCode, true);
                    if (name.equals("???")) continue;
                    SubdivisionSet.appendName(fileSubdivisions, sdCode, name, "\t<!-- deprecated -->");
                }
            }
            System.out.println("Skipping: " + skipped);
            fileSubdivisions.write(output);
        }

        public void printMissingMIDs(PrintWriter pw) {
        }
    }
}

