/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.With;

public class Emoji {
    public static final String EMOJI_VARIANT = "\ufe0f";
    public static final String COMBINING_ENCLOSING_KEYCAP = "\u20e3";
    public static final String ZWJ = "\u200d";
    public static final UnicodeSet REGIONAL_INDICATORS = new UnicodeSet(127462, 127487).freeze();
    public static final UnicodeSet MODIFIERS = new UnicodeSet("[\ud83c\udffb-\ud83c\udfff]").freeze();
    public static final UnicodeSet TAGS = new UnicodeSet(917504, 917631).freeze();
    public static final UnicodeSet FAMILY = new UnicodeSet("[\u200d \ud83d\udc66-\ud83d\udc69 \ud83d\udc8b \u2764]").freeze();
    public static final UnicodeSet GENDER = new UnicodeSet().add(9792).add(9794).freeze();
    public static final UnicodeSet SPECIALS = new UnicodeSet("[{\ud83d\udc08\u200d\u2b1b}{\ud83d\udc3b\u200d\u2744}{\ud83d\udc68\u200d\ud83c\udf7c}{\ud83d\udc69\u200d\ud83c\udf7c}{\ud83e\uddd1\u200d\ud83c\udf7c}{\ud83e\uddd1\u200d\ud83c\udf84}{\ud83e\uddd1\u200d\ud83e\udd1d\u200d\ud83e\uddd1}{\ud83c\udff3\u200d\ud83c\udf08} {\ud83d\udc41\u200d\ud83d\udde8} {\ud83c\udff4\u200d\u2620} {\ud83d\udc15\u200d\ud83e\uddba} {\ud83d\udc68\u200d\ud83e\uddaf} {\ud83d\udc68\u200d\ud83e\uddbc} {\ud83d\udc68\u200d\ud83e\uddbd} {\ud83d\udc69\u200d\ud83e\uddaf} {\ud83d\udc69\u200d\ud83e\uddbc} {\ud83d\udc69\u200d\ud83e\uddbd}{\ud83c\udff3\u200d\u26a7}{\ud83e\uddd1\u200d\u2695}{\ud83e\uddd1\u200d\u2696}{\ud83e\uddd1\u200d\u2708}{\ud83e\uddd1\u200d\ud83c\udf3e}{\ud83e\uddd1\u200d\ud83c\udf73}{\ud83e\uddd1\u200d\ud83c\udf93}{\ud83e\uddd1\u200d\ud83c\udfa4}{\ud83e\uddd1\u200d\ud83c\udfa8}{\ud83e\uddd1\u200d\ud83c\udfeb}{\ud83e\uddd1\u200d\ud83c\udfed}{\ud83e\uddd1\u200d\ud83d\udcbb}{\ud83e\uddd1\u200d\ud83d\udcbc}{\ud83e\uddd1\u200d\ud83d\udd27}{\ud83e\uddd1\u200d\ud83d\udd2c}{\ud83e\uddd1\u200d\ud83d\ude80}{\ud83e\uddd1\u200d\ud83d\ude92}{\ud83e\uddd1\u200d\ud83e\uddaf}{\ud83e\uddd1\u200d\ud83e\uddbc}{\ud83e\uddd1\u200d\ud83e\uddbd}{\u2764\u200d\ud83d\udd25}, {\u2764\u200d\ud83e\ude79}, {\ud83d\ude2e\u200d\ud83d\udca8}, {\ud83d\ude35\u200d\ud83d\udcab}]").freeze();
    public static final UnicodeSet MAN_WOMAN = new UnicodeSet("[\ud83d\udc68 \ud83d\udc69]").freeze();
    public static final UnicodeSet OBJECT = new UnicodeSet("[\ud83d\udc69 \ud83c\udf93 \ud83c\udf3e \ud83c\udf73 \ud83c\udfeb \ud83c\udfed \ud83c\udfa8 \ud83d\ude92 \u2708 \ud83d\ude80 \ud83c\udfa4 \ud83d\udcbb \ud83d\udd2c \ud83d\udcbc \ud83d\udd27 \u2696 \u2695]").freeze();
    static final UnicodeMap<String> emojiToMajorCategory = new UnicodeMap();
    static final UnicodeMap<String> emojiToMinorCategory = new UnicodeMap();
    static final UnicodeMap<String> toName = new UnicodeMap();
    static final Map<String, Long> majorToOrder;
    static final Map<String, Long> minorToOrder;
    static final Map<String, Long> emojiToOrder;
    static final UnicodeSet nonConstructed;
    static final UnicodeSet allRgi;
    static final UnicodeSet allRgiNoES;
    public static final UnicodeMap<String> EXTRA_SYMBOL_MINOR_CATEGORIES;
    public static final Map<String, Long> EXTRA_SYMBOL_ORDER;
    private static final boolean DEBUG = false;
    private static Set<String> NAME_PATHS;
    private static Set<String> KEYWORD_PATHS;
    public static final String TYPE_TTS = "[@type=\"tts\"]";

    private static <K, V> void putUnique(Map<K, V> map, K key, V value) {
        V oldValue = map.put(key, value);
        if (oldValue != null) {
            throw new ICUException("Attempt to change value of " + map + " for " + key + " from " + oldValue + " to " + value);
        }
    }

    public static UnicodeSet getAllRgi() {
        return allRgi;
    }

    public static UnicodeSet getAllRgiNoES() {
        return allRgiNoES;
    }

    public static String getMinorCategory(String emoji) {
        String minorCat = emojiToMinorCategory.get(emoji);
        if (minorCat == null && (minorCat = EXTRA_SYMBOL_MINOR_CATEGORIES.get(emoji)) == null) {
            throw new InternalCldrException("No minor category (aka subgroup) found for " + emoji + ". Update emoji-test.txt to latest, and adjust PathHeader.. functionMap.put(\"minor\", ...");
        }
        return minorCat;
    }

    public static String getName(String emoji) {
        return toName.get(emoji);
    }

    public static long getEmojiToOrder(String emoji) {
        Long result = emojiToOrder.get(emoji);
        if (result == null && (result = EXTRA_SYMBOL_ORDER.get(emoji)) == null) {
            throw new InternalCldrException("No Order found for " + emoji + ". Update emoji-test.txt to latest, and adjust PathHeader.. functionMap.put(\"minor\", ...");
        }
        return result;
    }

    public static long getEmojiMinorOrder(String minor) {
        Long result = minorToOrder.get(minor);
        if (result == null) {
            throw new InternalCldrException("No minor category (aka subgroup) found for " + minor + ". Update emoji-test.txt to latest, and adjust PathHeader.. functionMap.put(\"minor\", ...");
        }
        return result;
    }

    public static String getMajorCategory(String emoji) {
        String majorCat = emojiToMajorCategory.get(emoji);
        if (majorCat == null) {
            if (EXTRA_SYMBOL_MINOR_CATEGORIES.containsKey(emoji)) {
                majorCat = "Symbols";
            } else {
                throw new InternalCldrException("No minor category (aka subgroup) found for " + emoji + ". Update emoji-test.txt to latest, and adjust PathHeader.. functionMap.put(\"major\", ...");
            }
        }
        return majorCat;
    }

    public static Set<String> getMajorCategories() {
        return emojiToMajorCategory.values();
    }

    public static Set<String> getMinorCategories() {
        return emojiToMinorCategory.values();
    }

    public static Set<String> getMinorCategoriesWithExtras() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(emojiToMinorCategory.values());
        result.addAll(EXTRA_SYMBOL_MINOR_CATEGORIES.getAvailableValues());
        return ImmutableSet.copyOf(result);
    }

    public static UnicodeSet getEmojiInMinorCategoriesWithExtras(String minorCategory) {
        return new UnicodeSet(emojiToMinorCategory.getSet(minorCategory)).addAll(EXTRA_SYMBOL_MINOR_CATEGORIES.getSet(minorCategory)).freeze();
    }

    public static UnicodeSet getNonConstructed() {
        return nonConstructed;
    }

    public static synchronized Set<String> getNamePaths() {
        return NAME_PATHS != null ? NAME_PATHS : (NAME_PATHS = Emoji.buildPaths(TYPE_TTS));
    }

    public static synchronized Set<String> getKeywordPaths() {
        return KEYWORD_PATHS != null ? KEYWORD_PATHS : (KEYWORD_PATHS = Emoji.buildPaths(""));
    }

    private static ImmutableSet<String> buildPaths(String suffix) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String s2 : Emoji.getNonConstructed()) {
            String base = "//ldml/annotations/annotation[@cp=\"" + s2 + "\"]" + suffix;
            builder.add(base);
        }
        return builder.build();
    }

    static {
        emojiToMajorCategory.setErrorOnReset(true);
        emojiToMinorCategory.setErrorOnReset(true);
        toName.setErrorOnReset(true);
        majorToOrder = new HashMap<String, Long>();
        minorToOrder = new HashMap<String, Long>();
        emojiToOrder = new LinkedHashMap<String, Long>();
        nonConstructed = new UnicodeSet();
        allRgi = new UnicodeSet();
        allRgiNoES = new UnicodeSet();
        Splitter semi = Splitter.on(CharMatcher.anyOf(";#")).trimResults();
        String majorCategory = null;
        String[][] minorCategory = null;
        long majorOrder = 0L;
        long minorOrder = 0L;
        for (String string : FileUtilities.in(Emoji.class, "data/emoji/emoji-test.txt")) {
            boolean singleton;
            if (string.startsWith("#")) {
                String string2 = string.substring(1).trim();
                if (string2.startsWith("group:")) {
                    majorCategory = string2.substring("group:".length()).trim();
                    Long oldMajorOrder = majorToOrder.get(majorCategory);
                    if (oldMajorOrder == null) {
                        majorOrder = majorToOrder.size();
                        majorToOrder.put(majorCategory, majorOrder);
                        continue;
                    }
                    majorOrder = oldMajorOrder;
                    continue;
                }
                if (!string2.startsWith("subgroup:")) continue;
                minorCategory = string2.substring("subgroup:".length()).trim();
                Long oldMinorOrder = minorToOrder.get(minorCategory);
                if (oldMinorOrder == null) {
                    minorOrder = minorToOrder.size();
                    minorToOrder.put((String)minorCategory, minorOrder);
                    continue;
                }
                minorOrder = oldMinorOrder;
                continue;
            }
            String string3 = string.trim();
            if (string3.isEmpty()) continue;
            Iterator<String> it = semi.split(string3).iterator();
            String emojiHex = it.next();
            if (emojiHex.contains("1F6FC")) {
                boolean bl = false;
            }
            String original = Utility.fromHex(emojiHex, 4, " ");
            String type = it.next();
            if (type.startsWith("fully-qualified")) {
                allRgi.add(original);
                allRgiNoES.add(original.replace(EMOJI_VARIANT, ""));
            }
            emojiToMajorCategory.put(original, majorCategory);
            emojiToMinorCategory.put(original, (String)minorCategory);
            String comment = it.next();
            int spacePos = comment.indexOf(32);
            spacePos = comment.indexOf(32, spacePos + 1);
            String name = comment.substring(spacePos + 1).trim();
            toName.put(original, name);
            String minimal = original.replace(EMOJI_VARIANT, "");
            if (!emojiToOrder.containsKey(original)) {
                Emoji.putUnique(emojiToOrder, original, (long)emojiToOrder.size() * 100L);
            }
            if (!emojiToOrder.containsKey(minimal)) {
                Emoji.putUnique(emojiToOrder, minimal, (long)emojiToOrder.size() * 100L);
            }
            boolean bl = singleton = CharSequences.getSingleCodePoint(minimal) != Integer.MAX_VALUE;
            if (minimal.contains(COMBINING_ENCLOSING_KEYCAP) || REGIONAL_INDICATORS.containsSome(minimal) || TAGS.containsSome(minimal) || !singleton && MODIFIERS.containsSome(minimal) || !singleton && FAMILY.containsAll(minimal)) continue;
            if (minimal.contains(ZWJ)) {
                if (!SPECIALS.contains(minimal) && !GENDER.containsSome(minimal) && (!MAN_WOMAN.contains(minimal.codePointAt(0)) || !OBJECT.contains(minimal.codePointBefore(minimal.length())))) continue;
                nonConstructed.add(minimal);
                continue;
            }
            if (minimal.contains("\ud83d\udd1f")) continue;
            nonConstructed.add(minimal);
        }
        emojiToMajorCategory.freeze();
        emojiToMinorCategory.freeze();
        nonConstructed.add(MODIFIERS);
        nonConstructed.freeze();
        toName.freeze();
        allRgi.freeze();
        allRgiNoES.freeze();
        EXTRA_SYMBOL_MINOR_CATEGORIES = new UnicodeMap();
        String[][] data = new String[][]{{"arrow", "\u2192 \u2193 \u2191 \u2190 \u2194 \u2195 \u21c6 \u21c5"}, {"alphanum", "\u00a9 \u00ae \u2117 \u2122 \u00b5"}, {"geometric", "\u25bc \u25b6 \u25b2 \u25c0 \u25cf \u25cb \u25ef \u25ca"}, {"math", "\u00d7 \u00f7 \u221a \u221e \u2206 \u2207 \u207b \u00b9 \u00b2 \u00b3 \u2261 \u2208 \u2282 \u2229 \u222a \u00b0 + \u00b1 \u2212 = \u2248 \u2260 > < \u2264 \u2265 \u00ac | ~"}, {"punctuation", "\u00a7 \u2020 \u2021 \\u0020  , \u3001 \u060c ; : \u061b ! \u00a1 ? \u00bf \u061f \u00b6 \u203b / \\ & # % \u2030 \u2032 \u2033 \u2034 @ * \u266a \u266d \u266f ` \u00b4 ^ \u00a8 \u2010 \u2015 _ - \u2013 \u2014 \u2022 \u00b7 . \u2026 \u3002 \u2027 \u30fb \u2018 \u2019 \u201a ' \u201c \u201d \u201e \u00bb \u00ab ( ) [ ] { } \u3014 \u3015 \u3008 \u3009 \u300a \u300b \u300c \u300d \u300e \u300f \u3016 \u3017 \u3010 \u3011"}, {"currency", "\u20ac \u00a3 \u00a5 \u20b9 \u20bd $ \u00a2 \u0e3f \u20aa \u20ba \u20ab \u20b1 \u20a9 \u20a1 \u20a6 \u20ae \u09f3 \u20b4 \u20b8 \u20b2 \u20b5 \u17db \u20ad \u058f \u20a5 \u20be \u20bc \u20bf \u060b"}, {"other-symbol", "\u203e\u203d\u2038\u2042\u219a\u219b\u21ae\u2199\u219c\u219d\u219e\u219f\u21a0\u21a1\u21a2\u21a3\u21a4\u21a5\u21a6\u21a7\u21a8\u21ab\u21ac\u21ad\u21af\u21b0\u21b1\u21b2\u21b3\u21b4\u21b5\u21b6\u21b7\u21b8\u21b9\u21ba\u21bb\u21bc\u21bd\u21be\u21bf\u21c0\u21c1\u21c2\u21c3\u21c4\u21c7\u21c8\u21c9\u21ca\u21cb\u21cc\u21d0\u21cd\u21d1\u21d2\u21cf\u21d3\u21d4\u21ce\u21d6\u21d7\u21d8\u21d9\u21da\u21db\u21dc\u21dd\u21de\u21df\u21e0\u21e1\u21e2\u21e3\u21e4\u21e5\u21e6\u21e7\u21e8\u21e9\u21ea\u21f5\u2200\u2202\u2203\u2205\u2209\u220b\u220e\u220f\u2211\u226e\u226f\u2213\u2215\u2044\u2217\u2218\u2219\u221d\u221f\u2220\u2223\u2225\u2227\u222b\u222c\u222e\u2234\u2235\u2236\u2237\u223c\u223d\u223e\u2243\u2245\u224c\u2252\u2256\u2263\u2266\u2267\u226a\u226b\u226c\u2273\u227a\u227b\u2281\u2283\u2286\u2287\u2295\u2296\u2297\u2298\u2299\u229a\u229b\u229e\u229f\u22a5\u22ae\u22b0\u22b1\u22ed\u22b6\u22b9\u22bf\u22c1\u22c2\u22c3\u22c5\u22c6\u22c8\u22d2\u22d8\u22d9\u22ee\u22ef\u22f0\u22f1\u25a0\u25a1\u25a2\u25a3\u25a4\u25a5\u25a6\u25a7\u25a8\u25a9\u25ac\u25ad\u25ae\u25b0\u25b3\u25b4\u25b5\u25b7\u25b8\u25b9\u25ba\u25bb\u25bd\u25be\u25bf\u25c1\u25c2\u25c3\u25c4\u25c5\u25c6\u25c7\u25c8\u25c9\u25cc\u25cd\u25ce\u25d0\u25d1\u25d2\u25d3\u25d4\u25d5\u25d6\u25d7\u25d8\u25d9\u25dc\u25dd\u25de\u25df\u25e0\u25e1\u25e2\u25e3\u25e4\u25e5\u25e6\u25f3\u25f7\u25fb\u25fd\u25ff\u2a27\u2a2f\u2a3c\u2a63\u2a7d\u2a8d\u2a9a\u2aba\u20a2\u20a3\u20a4\u20b0\u20b3\u20b6\u20b7\u20a8\ufdfc"}};
        HashMap<String, Object> subcategoryToMaxSuborder = new HashMap<String, Object>();
        for (String[] row : data) {
            String subcategory = row[0];
            for (Map.Entry entry : emojiToMinorCategory.entrySet()) {
                if (!((String)entry.getValue()).equals(subcategory)) continue;
                String emoji = (String)entry.getKey();
                Object order = emojiToOrder.get(emoji);
                Long currentMax = (Long)subcategoryToMaxSuborder.get(subcategory);
                if (currentMax != null && currentMax >= (Long)order) continue;
                subcategoryToMaxSuborder.put(subcategory, order);
            }
        }
        LinkedHashMap<String, Long> _EXTRA_SYMBOL_ORDER = new LinkedHashMap<String, Long>();
        for (String[] row : data) {
            String subcategory = row[0];
            String string = row[1];
            ArrayList<String> items = new ArrayList<String>();
            for (int cp : With.codePointArray(string)) {
                if (cp == 32) continue;
                items.add(With.fromCodePoint(cp));
            }
            UnicodeSet uset = new UnicodeSet().addAll((Iterable<?>)items);
            if (uset.containsSome(EXTRA_SYMBOL_MINOR_CATEGORIES.keySet())) {
                throw new IllegalArgumentException("Duplicate values in " + EXTRA_SYMBOL_MINOR_CATEGORIES);
            }
            EXTRA_SYMBOL_MINOR_CATEGORIES.putAll(uset, subcategory);
            long count = (Long)subcategoryToMaxSuborder.get(subcategory);
            for (String s2 : items) {
                _EXTRA_SYMBOL_ORDER.put(s2, ++count);
            }
            subcategoryToMaxSuborder.put(subcategory, count);
        }
        EXTRA_SYMBOL_MINOR_CATEGORIES.freeze();
        EXTRA_SYMBOL_ORDER = ImmutableMap.copyOf(_EXTRA_SYMBOL_ORDER);
        NAME_PATHS = null;
        KEYWORD_PATHS = null;
    }
}

