/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;

public abstract class Factory
implements CLDRLocale.SublocaleProvider {
    private static final boolean DEBUG_FACTORY = false;
    private File supplementalDirectory = null;

    @Deprecated
    public String getSourceDirectory() {
        return this.getSourceDirectories()[0].getAbsolutePath();
    }

    public abstract File[] getSourceDirectories();

    @Deprecated
    public final File getSourceDirectoryForLocale(String localeID) {
        List<File> temp = this.getSourceDirectoriesForLocale(localeID);
        return temp == null ? null : temp.get(0);
    }

    public static final SourceTreeType getSourceTreeType(File fileOrDir) {
        if (fileOrDir == null) {
            return null;
        }
        File parentDir = fileOrDir.isFile() ? fileOrDir.getParentFile() : fileOrDir;
        File grandparentDir = parentDir.getParentFile();
        try {
            return SourceTreeType.valueOf(grandparentDir.getName());
        }
        catch (IllegalArgumentException iae) {
            try {
                return SourceTreeType.valueOf(parentDir.getName());
            }
            catch (IllegalArgumentException iae2) {
                return SourceTreeType.other;
            }
        }
    }

    public static final DirectoryType getDirectoryType(File fileOrDir) {
        if (fileOrDir == null) {
            return null;
        }
        File parentDir = fileOrDir.isFile() ? fileOrDir.getParentFile() : fileOrDir;
        try {
            return DirectoryType.valueOf(parentDir.getName());
        }
        catch (IllegalArgumentException iae2) {
            return DirectoryType.other;
        }
    }

    protected abstract CLDRFile handleMake(String var1, boolean var2, CLDRFile.DraftStatus var3);

    public CLDRFile make(String localeID, boolean resolved, CLDRFile.DraftStatus madeWithMinimalDraftStatus) {
        return this.handleMake(localeID, resolved, madeWithMinimalDraftStatus).setSupplementalDirectory(this.getSupplementalDirectory());
    }

    public CLDRFile make(String localeID, boolean resolved, boolean includeDraft) {
        return this.make(localeID, resolved, includeDraft ? CLDRFile.DraftStatus.unconfirmed : CLDRFile.DraftStatus.approved);
    }

    public CLDRFile make(String localeID, boolean resolved) {
        return this.make(localeID, resolved, this.getMinimalDraftStatus());
    }

    public CLDRFile makeWithFallback(String localeID) {
        return this.makeWithFallback(localeID, this.getMinimalDraftStatus());
    }

    public CLDRFile makeWithFallback(String localeID, CLDRFile.DraftStatus madeWithMinimalDraftStatus) {
        String currentLocaleID = localeID;
        Set<String> availableLocales2 = this.getAvailable();
        while (!availableLocales2.contains(currentLocaleID) && !"root".equals(currentLocaleID)) {
            currentLocaleID = LocaleIDParser.getParent(currentLocaleID);
        }
        return this.make(currentLocaleID, true, madeWithMinimalDraftStatus);
    }

    public static XMLSource makeResolvingSource(List<XMLSource> sources) {
        return new XMLSource.ResolvingSource(sources);
    }

    public final XMLSource makeSource(String localeID) {
        return this.make((String)localeID, (boolean)false).dataSource;
    }

    protected XMLSource.ResolvingSource makeResolvingSource(String localeID, CLDRFile.DraftStatus madeWithMinimalDraftStatus) {
        ArrayList<XMLSource> sourceList = new ArrayList<XMLSource>();
        String curLocale = localeID;
        while (curLocale != null) {
            CLDRFile file = this.handleMake(curLocale, false, madeWithMinimalDraftStatus);
            if (file == null) {
                throw new NullPointerException(this + ".handleMake returned a null CLDRFile for " + curLocale);
            }
            XMLSource source = file.dataSource;
            sourceList.add(source);
            curLocale = LocaleIDParser.getParent(curLocale);
        }
        return new XMLSource.ResolvingSource(sourceList);
    }

    public abstract CLDRFile.DraftStatus getMinimalDraftStatus();

    public static Factory make(String path, String string) {
        try {
            return SimpleFactory.make(path, string);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("path: " + path + "; string: " + string, e);
        }
    }

    public static Factory make(String mainDirectory, String string, CLDRFile.DraftStatus approved) {
        return SimpleFactory.make(mainDirectory, string, approved);
    }

    public Set<String> getAvailable() {
        return Collections.unmodifiableSet(this.handleGetAvailable());
    }

    protected abstract Set<String> handleGetAvailable();

    public Set<String> getAvailableLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        for (String s2 : this.handleGetAvailable()) {
            if (!XPathParts.isLanguage(s2)) continue;
            result.add(s2);
        }
        return result;
    }

    public Set<String> getAvailableWithParent(String parent, boolean isProper) {
        TreeSet<String> result = new TreeSet<String>();
        for (String s2 : this.handleGetAvailable()) {
            int relation = XPathParts.isSubLocale(parent, s2);
            if (relation < 0 || isProper && relation == 0) continue;
            result.add(s2);
        }
        return result;
    }

    public File getSupplementalDirectory() {
        return this.supplementalDirectory;
    }

    public Factory setSupplementalDirectory(File supplementalDirectory) {
        this.supplementalDirectory = supplementalDirectory;
        return this;
    }

    public CLDRFile getSupplementalData() {
        try {
            return this.make("supplementalData", false);
        }
        catch (RuntimeException e) {
            return Factory.make(this.getSupplementalDirectory().getPath(), ".*").make("supplementalData", false);
        }
    }

    public CLDRFile getSupplementalMetadata() {
        try {
            return this.make("supplementalMetadata", false);
        }
        catch (RuntimeException e) {
            return Factory.make(this.getSupplementalDirectory().getPath(), ".*").make("supplementalMetadata", false);
        }
    }

    @Override
    public Set<CLDRLocale> subLocalesOf(CLDRLocale forLocale) {
        return this.calculateSubLocalesOf(forLocale, this.getAvailableCLDRLocales());
    }

    public Set<CLDRLocale> getAvailableCLDRLocales() {
        return CLDRLocale.getInstance(this.getAvailable());
    }

    public Set<CLDRLocale> calculateSubLocalesOf(CLDRLocale locale, Set<CLDRLocale> available) {
        TreeSet<CLDRLocale> sub = new TreeSet<CLDRLocale>();
        for (CLDRLocale l : available) {
            if (l.getParent() != locale) continue;
            sub.add(l);
        }
        return sub;
    }

    public abstract List<File> getSourceDirectoriesForLocale(String var1);

    public static enum SourceTreeType {
        common,
        seed,
        other;

    }

    public static enum DirectoryType {
        main,
        supplemental,
        bcp47,
        casing,
        collation,
        dtd,
        rbnf,
        segments,
        transforms,
        other;

    }
}

