/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexLogger {
    private static final boolean DEBUG = false;
    private static RegexLoggerInterface instance = null;

    public static RegexLoggerInterface getInstance() {
        if (instance == null) {
            instance = new NullRegexLogger();
        }
        return instance;
    }

    public static interface RegexLoggerInterface {
        public void log(String var1, String var2, boolean var3, LogType var4, Class<?> var5);

        public void log(Matcher var1, String var2, boolean var3, LogType var4, Class<?> var5);

        public void log(Pattern var1, String var2, boolean var3, LogType var4, Class<?> var5);

        public void log(String var1, String var2, boolean var3, double var4, LogType var6, Class<?> var7);

        public NavigableSet<PatternCountInterface> getEntries();

        public NavigableSet<PatternCountInterface> getEntries(int var1);

        public boolean isEnabled();
    }

    private static class NullRegexLogger
    extends AbstractRegexLogger {
        private NullRegexLogger() {
        }

        @Override
        public void log(String pattern, String matchStr, boolean matched, double time, LogType type, Class<?> cls) {
        }

        @Override
        public NavigableSet<PatternCountInterface> getEntries(int minCount) {
            TreeSet<PatternCountInterface> returned = Sets.newTreeSet(Collections.EMPTY_SET);
            return returned;
        }
    }

    private static class RegexLoggerImpl
    extends AbstractRegexLogger {
        private static final Set<String> exactMatchSet = new HashSet<String>(Arrays.asList("^//ldml.*", "^//ldml/dates.*", "^//ldml/units.*", "^//ldml/characters/ellipsis[@type=\"(final|initial|medial)\"]", "^//ldml/characters.*", "^//ldml/listPatterns/listPattern.*", "^//ldml/units/unitLength[@type=\"(long|short|narrow)\"].*"));
        private static final Set<String> patternSet = new HashSet<String>(Arrays.asList("^//ldml/dates/fields", "^//ldml/dates/calendars/calendar", "/(availableFormats"));
        private final Multiset<PatternStringWithBoolean> matchedFindSet = TreeMultiset.create();
        private final Multiset<PatternStringWithBoolean> failedFindSet = TreeMultiset.create();
        private final Multiset<PatternStringWithBoolean> matchedMatchSet = TreeMultiset.create();
        private final Multiset<PatternStringWithBoolean> failedMatchSet = TreeMultiset.create();
        private final Multimap<PatternStringWithBoolean, String> occurrences = TreeMultimap.create();
        private final IterableTransformer<String, String> transformer = new StringIterableTransformer();
        private static final Joiner JOINER = Joiner.on(";");

        private RegexLoggerImpl() {
        }

        @Override
        public void log(String pattern, String matchStr, boolean matched, double time, LogType type, Class<?> cls) {
            boolean isRegexFinder = this.findClassName("org.unicode.cldr.util.RegexLookup", 10);
            PatternStringWithBoolean key = new PatternStringWithBoolean(pattern, isRegexFinder);
            Collection<PatternStringWithBoolean> collectionToAdd = this.determineCollectionToUse(matched, type);
            if (collectionToAdd != null) {
                collectionToAdd.add(key);
            }
            if (this.shouldLogPattern(pattern, isRegexFinder)) {
                this.addElementToList(key);
            }
        }

        private Collection<PatternStringWithBoolean> determineCollectionToUse(boolean matched, LogType type) {
            Multiset<PatternStringWithBoolean> collectionToAdd = null;
            switch (type) {
                case FIND: {
                    if (matched) {
                        collectionToAdd = this.matchedFindSet;
                        break;
                    }
                    collectionToAdd = this.failedFindSet;
                    break;
                }
                case MATCH: {
                    collectionToAdd = matched ? this.matchedMatchSet : this.failedMatchSet;
                }
            }
            return collectionToAdd;
        }

        private boolean shouldLogPattern(String pattern, boolean isRegexFinder) {
            if (!isRegexFinder) {
                return true;
            }
            if (exactMatchSet.contains(pattern)) {
                return true;
            }
            for (String cur : patternSet) {
                if (!pattern.startsWith(cur)) continue;
                return true;
            }
            return false;
        }

        private boolean findClassName(String className, int depth) {
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            int startPos = st.length > 2 ? 2 : 0;
            int endPos = startPos + depth > st.length ? st.length : startPos + depth;
            for (int i = startPos; i < endPos; ++i) {
                StackTraceElement cur = st[i];
                String curClass = cur.getClassName();
                if (!curClass.startsWith(className)) continue;
                return true;
            }
            return false;
        }

        private void addElementToList(PatternStringWithBoolean key) {
            List<String> stList = this.processStackTrace("org.unicode.cldr.util.RegexLookup", 0);
            if (!stList.isEmpty()) {
                this.occurrences.put(key, JOINER.join(this.transformer.transform(stList)));
            }
        }

        private List<String> processStackTrace(String classNameToStartAt, int depth) {
            int pos;
            int startPos;
            StackTraceElement[] st = Thread.currentThread().getStackTrace();
            if (depth == 0) {
                depth = st.length;
            }
            if (depth < 0) {
                startPos = depth + st.length;
                depth = Math.abs(depth);
            } else {
                startPos = st.length > 2 ? 2 : 0;
            }
            boolean found = false;
            for (pos = startPos; pos < st.length; ++pos) {
                if (!st[pos].getClassName().startsWith(classNameToStartAt)) continue;
                found = true;
                break;
            }
            if (!found) {
                return Collections.emptyList();
            }
            int endPos = pos + depth > st.length ? st.length : startPos + depth;
            ArrayList<String> ret = new ArrayList<String>(depth + 2);
            for (int i = pos; i < endPos; ++i) {
                StackTraceElement cur = st[i];
                String curClass = cur.getClassName();
                ret.add(curClass + ":" + cur.getLineNumber());
            }
            return ret;
        }

        @Override
        public NavigableSet<PatternCountInterface> getEntries(int minCount) {
            CountSets c = new CountSets(this.matchedFindSet, this.failedFindSet, this.matchedMatchSet, this.failedMatchSet, this.occurrences);
            AddAllEntryProcessor processor = minCount == 1 ? new AddAllEntryProcessor(minCount, c) : new EntryProcessor(minCount, c);
            for (PatternStringWithBoolean item : this.matchedFindSet) {
                processor.process(item, this.matchedFindSet);
            }
            for (PatternStringWithBoolean item : this.failedFindSet) {
                processor.process(item, this.failedFindSet);
            }
            for (PatternStringWithBoolean item : this.matchedMatchSet) {
                processor.process(item, this.matchedMatchSet);
            }
            for (PatternStringWithBoolean item : this.failedMatchSet) {
                processor.process(item, this.failedMatchSet);
            }
            return Sets.unmodifiableNavigableSet(processor.getResult());
        }
    }

    private static class ClassnameOnlyStringTransformer
    implements IterableTransformer<String, String> {
        private ClassnameOnlyStringTransformer() {
        }

        @Override
        public Iterable<String> transform(Iterable<String> input) {
            ArrayList<String> returned = new ArrayList<String>(Iterables.size(input));
            String lastClass = null;
            for (String current : input) {
                if (current.lastIndexOf(".") > 0) {
                    current = current.substring(current.lastIndexOf("."));
                }
                if (lastClass != null) {
                    if (lastClass.startsWith("RegexLookup") && !current.startsWith("RegexLookup")) {
                        returned.add(lastClass);
                    }
                    if (lastClass.startsWith("VettingViewer")) break;
                    if (current.startsWith("CheckCLDR") && !lastClass.startsWith("CheckCLDR")) {
                        lastClass = current;
                        continue;
                    }
                }
                if (!current.startsWith("RegexLookup")) {
                    returned.add(current);
                }
                lastClass = current;
            }
            return returned;
        }
    }

    private static class StringIterableTransformer
    implements IterableTransformer<String, String> {
        private StringIterableTransformer() {
        }

        @Override
        public Iterable<String> transform(Iterable<String> input) {
            ArrayList<String> returned = new ArrayList<String>(Iterables.size(input));
            String lastClass = null;
            Iterator<String> iterator = input.iterator();
            while (iterator.hasNext()) {
                String current;
                String transformed = current = iterator.next();
                if (lastClass != null) {
                    if (!lastClass.startsWith("RegexLookup") || current.startsWith("org.unicode.cldr.util.RegexLookup")) break;
                    returned.add(lastClass);
                    break;
                }
                if (current.startsWith("org.unicode.cldr.test.CheckCLDR") && (lastClass == null || !lastClass.startsWith("org.unicode.cldr.test.CheckCLDR"))) {
                    lastClass = current;
                    continue;
                }
                if (current.startsWith("org.unicode.cldr.util.")) {
                    transformed = current.substring("org.unicode.cldr.util.".length());
                }
                if (!transformed.startsWith("RegexLookup")) {
                    returned.add(transformed);
                }
                lastClass = transformed;
            }
            return returned;
        }
    }

    private static interface IterableTransformer<E, F> {
        public Iterable<F> transform(Iterable<E> var1);
    }

    public static enum LogType {
        FIND,
        MATCH;

    }

    private static class RegexKeyWithCount
    implements PatternCountInterface,
    Comparable<PatternCountInterface> {
        private final String pattern;
        private final int findMatchCount;
        private final int findFailCount;
        private final int matchMatchCount;
        private final int matchFailCount;
        private final boolean calledFromRegexFinder;
        private final Set<String> callLocations = new HashSet<String>();
        private final int hashCode;

        public RegexKeyWithCount(PatternStringWithBoolean key, CountSets bean) {
            this.pattern = key.getPattern();
            this.calledFromRegexFinder = key.isCalledFromRegexFinder();
            this.findMatchCount = bean.matchedFindSet.count(key);
            this.findFailCount = bean.failedFindSet.count(key);
            this.matchMatchCount = bean.matchedMatchSet.count(key);
            this.matchFailCount = bean.failedMatchSet.count(key);
            Collection<String> tmp = bean.stacktraces.get(key);
            for (String cur : tmp) {
                if (this.callLocations.contains(cur)) continue;
                this.callLocations.add(cur);
            }
            this.hashCode = Objects.hash(this.pattern, this.findMatchCount, this.findFailCount, this.matchFailCount, this.matchMatchCount, this.calledFromRegexFinder, this.callLocations);
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public int getNumberOfFindMatches() {
            return this.findMatchCount;
        }

        @Override
        public int getNumberOfFindFailures() {
            return this.findFailCount;
        }

        @Override
        public int getNumberOfMatchMatches() {
            return this.matchMatchCount;
        }

        @Override
        public int getNumberOfMatchFailures() {
            return this.matchFailCount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.hashCode != obj.hashCode()) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexKeyWithCount other = (RegexKeyWithCount)obj;
            if (this.matchFailCount != other.matchFailCount) {
                return false;
            }
            if (this.matchMatchCount != other.matchMatchCount) {
                return false;
            }
            if (this.findFailCount != other.findFailCount) {
                return false;
            }
            if (this.findMatchCount != other.findMatchCount) {
                return false;
            }
            if (!this.pattern.equals(other.pattern)) {
                return false;
            }
            if (this.calledFromRegexFinder != other.calledFromRegexFinder) {
                return false;
            }
            return this.callLocations == other.callLocations;
        }

        @Override
        public int compareTo(PatternCountInterface o) {
            if (o == null) {
                return 1;
            }
            return new Integer(this.matchFailCount + this.matchMatchCount + this.findFailCount + this.findMatchCount).compareTo(o.getNumberOfFindFailures() + o.getNumberOfFindMatches() + o.getNumberOfMatchFailures() + o.getNumberOfMatchMatches());
        }

        @Override
        public boolean isCalledFromRegexFinder() {
            return this.calledFromRegexFinder;
        }

        @Override
        public Set<String> getCallLocations() {
            return this.callLocations;
        }
    }

    private static class CountSets {
        final Multiset<PatternStringWithBoolean> matchedFindSet;
        final Multiset<PatternStringWithBoolean> failedFindSet;
        final Multiset<PatternStringWithBoolean> matchedMatchSet;
        final Multiset<PatternStringWithBoolean> failedMatchSet;
        final Multimap<PatternStringWithBoolean, String> stacktraces;

        public CountSets(Multiset<PatternStringWithBoolean> matchedFindSet, Multiset<PatternStringWithBoolean> failedFindSet, Multiset<PatternStringWithBoolean> matchedMatchSet, Multiset<PatternStringWithBoolean> failedMatchSet, Multimap<PatternStringWithBoolean, String> occurrences) {
            this.failedFindSet = failedFindSet;
            this.failedMatchSet = failedMatchSet;
            this.matchedMatchSet = matchedMatchSet;
            this.stacktraces = occurrences;
            this.matchedFindSet = matchedFindSet;
        }
    }

    private static class EntryProcessor
    extends AddAllEntryProcessor {
        public EntryProcessor(int minCount, CountSets c) {
            super(minCount, c);
        }

        @Override
        public void process(PatternStringWithBoolean item, Multiset<PatternStringWithBoolean> countSet) {
            if (countSet.count(item) >= this.minCount) {
                super.process(item, countSet);
            }
        }
    }

    private static class AddAllEntryProcessor {
        protected final int minCount;
        protected final CountSets c;
        protected final Set<PatternStringWithBoolean> seen = new HashSet<PatternStringWithBoolean>();
        protected final NavigableSet<PatternCountInterface> result = new TreeSet<PatternCountInterface>();

        public AddAllEntryProcessor(int minCount, CountSets c) {
            this.minCount = minCount;
            this.c = c;
        }

        public NavigableSet<PatternCountInterface> getResult() {
            return this.result;
        }

        public void process(PatternStringWithBoolean item, Multiset<PatternStringWithBoolean> countSet) {
            if (!this.seen.contains(item)) {
                this.result.add(new RegexKeyWithCount(item, this.c));
                this.seen.add(item);
            }
        }
    }

    public static interface PatternCountInterface {
        public String getPattern();

        public int getNumberOfFindMatches();

        public int getNumberOfFindFailures();

        public int getNumberOfMatchMatches();

        public int getNumberOfMatchFailures();

        public boolean isCalledFromRegexFinder();

        public Set<String> getCallLocations();
    }

    private static abstract class AbstractRegexLogger
    implements RegexLoggerInterface {
        private AbstractRegexLogger() {
        }

        @Override
        public void log(Matcher matcher, String matchStr, boolean matched, LogType type, Class<?> cls) {
            this.log(matcher.pattern(), matchStr, matched, type, cls);
        }

        @Override
        public void log(Pattern pattern, String matchStr, boolean matched, LogType type, Class<?> cls) {
            this.log(pattern.pattern(), matchStr, matched, type, cls);
        }

        @Override
        public void log(String pattern, String matchStr, boolean matched, LogType type, Class<?> cls) {
            this.log(pattern, matchStr, matched, 0.0, type, cls);
        }

        @Override
        public NavigableSet<PatternCountInterface> getEntries() {
            return this.getEntries(1);
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }

    private static class PatternStringWithBoolean
    implements Comparable<PatternStringWithBoolean> {
        private final String pattern;
        private final boolean calledFromRegexFinder;
        private final int hashCode;

        public PatternStringWithBoolean(String patternStr, boolean calledFromRegexFinder) {
            this.pattern = patternStr.trim();
            this.calledFromRegexFinder = calledFromRegexFinder;
            this.hashCode = Objects.hash(this.pattern, this.calledFromRegexFinder);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isCalledFromRegexFinder() {
            return this.calledFromRegexFinder;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternStringWithBoolean other = (PatternStringWithBoolean)obj;
            if (this.calledFromRegexFinder != other.calledFromRegexFinder) {
                return false;
            }
            if (this.hashCode != other.hashCode) {
                return false;
            }
            if (other.pattern != null) {
                return false;
            }
            return this.pattern.equals(other.pattern);
        }

        @Override
        public int compareTo(PatternStringWithBoolean o) {
            if (o == null) {
                return 1;
            }
            if (this == o) {
                return 0;
            }
            return this.pattern.compareTo(o.pattern);
        }
    }
}

