/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.BuildIcuCompactDecimalFormat;
import org.unicode.cldr.tool.ChartDelta;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.tool.ShowPlurals;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DateTimeFormats;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class VerifyCompactNumbers {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final String DIR = CLDRPaths.VERIFY_DIR + "numbers/";
    static final Option.Options myOptions = new Option.Options();
    public static final Set<String> USES_GROUPS_OF_4 = new HashSet<String>(Arrays.asList("ko", "ja", "zh", "zh_Hant"));
    private static String surveyUrl = CLDR_CONFIG.getProperty("CLDR_SURVEY_URL", "http://st.unicode.org/cldr-apps/survey");

    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.organization, args, true);
        new File(DIR).mkdirs();
        FileCopier.copy(ShowData.class, "verify-index.html", CLDRPaths.VERIFY_DIR, "index.html");
        FileCopier.copy(ChartDelta.class, "index.css", CLDRPaths.VERIFY_DIR, "index.css");
        FormattedFileWriter.copyIncludeHtmls(CLDRPaths.VERIFY_DIR);
        String organization = MyOptions.organization.option.getValue();
        String filter = MyOptions.filter.option.getValue();
        boolean showCurrency = true;
        String currencyCode = MyOptions.currency.option.getValue();
        Factory factory2 = Factory.make(CLDRPaths.MAIN_DIRECTORY, filter);
        CLDRFile englishCldrFile = factory2.make("en", true);
        SupplementalDataInfo sdi = CLDR_CONFIG.getSupplementalDataInfo();
        Set<String> defaultContentLocales = sdi.getDefaultContentLocales();
        NumberFormat enf = NumberFormat.getIntegerInstance(ULocale.ENGLISH);
        enf.setGroupingUsed(false);
        TreeSet<String> availableLanguages = new TreeSet<String>(factory2.getAvailableLanguages());
        if (Pattern.matches(filter, "pt_PT")) {
            availableLanguages.add("pt_PT");
        }
        PrintWriter plainText = FileUtilities.openUTF8Writer(DIR, "compactTestFile.txt");
        DateTimeFormats.writeCss(DIR);
        CLDRFile english = CLDR_CONFIG.getEnglish();
        TreeMap<Object, String> indexMap = new TreeMap<Object, String>(CLDR_CONFIG.getCollator());
        for (String locale : availableLanguages) {
            Level level;
            if (defaultContentLocales.contains(locale) || Level.MODERN.compareTo(level = StandardCodes.make().getLocaleCoverageLevel(organization, locale)) > 0 || locale.equals("ne") || locale.equals("cy")) continue;
            PrintWriter out = FileUtilities.openUTF8Writer(DIR, locale + ".html");
            String title = "Verify Number Formats: " + englishCldrFile.getName(locale);
            out.println("<!doctype HTML PUBLIC '-//W3C//DTD HTML 4.0 Transitional//EN'><html><head>\n<meta http-equiv='Content-Type' content='text/html; charset=utf-8'>\n<title>" + title + "</title>\n<link rel='stylesheet' type='text/css' href='index.css'>\n</head><body><h1>" + title + "</h1>\n<p><a href='index.html'>Index</a></p>\n");
            CLDRFile cldrFile = factory2.make(locale, true, CLDRFile.DraftStatus.contributed);
            VerifyCompactNumbers.showNumbers(cldrFile, showCurrency, currencyCode, out, factory2);
            out.println("</body></html>");
            out.close();
            indexMap.put(english.getName(locale), locale + ".html");
        }
        try (PrintWriter index = DateTimeFormats.openIndex(DIR, "Numbers");){
            DateTimeFormats.writeIndexMap(indexMap, index);
        }
        plainText.close();
    }

    public static void showNumbers(CLDRFile cldrFile, boolean showCurrency, String currencyCode, Appendable out, Factory factory) {
        try {
            LinkedHashSet<String> debugCreationErrors = new LinkedHashSet<String>();
            LinkedHashSet<String> errors = new LinkedHashSet<String>();
            String locale = cldrFile.getLocaleID();
            TablePrinter tablePrinter1 = new TablePrinter().setTableAttributes("class='dtf-table'").addColumn("Numeric Format").setHeaderCell(true).setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Compact-Short").setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'").addColumn("Compact-Long").setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'");
            if (showCurrency) {
                tablePrinter1.addColumn("Compact-Short<br>+Currency").setHeaderAttributes("class='dtf-th'").setCellAttributes("class='dtf-s'");
            }
            ULocale locale2 = new ULocale(locale);
            ICUServiceBuilder builder = new ICUServiceBuilder().setCldrFile(cldrFile);
            DecimalFormat nf = builder.getNumberFormat(1);
            SupplementalDataInfo sdi = CLDR_CONFIG.getSupplementalDataInfo();
            String[] debugOriginals = null;
            CompactDecimalFormat cdf = BuildIcuCompactDecimalFormat.build(cldrFile, debugCreationErrors, debugOriginals, CompactDecimalFormat.CompactStyle.SHORT, locale2, BuildIcuCompactDecimalFormat.CurrencyStyle.PLAIN, currencyCode);
            VerifyCompactNumbers.captureErrors(debugCreationErrors, errors, locale, "short");
            CompactDecimalFormat cdfs = BuildIcuCompactDecimalFormat.build(cldrFile, debugCreationErrors, debugOriginals, CompactDecimalFormat.CompactStyle.LONG, locale2, BuildIcuCompactDecimalFormat.CurrencyStyle.PLAIN, currencyCode);
            VerifyCompactNumbers.captureErrors(debugCreationErrors, errors, locale, "long");
            CompactDecimalFormat cdfCurr = BuildIcuCompactDecimalFormat.build(cldrFile, debugCreationErrors, debugOriginals, CompactDecimalFormat.CompactStyle.SHORT, locale2, BuildIcuCompactDecimalFormat.CurrencyStyle.CURRENCY, currencyCode);
            VerifyCompactNumbers.captureErrors(debugCreationErrors, errors, locale, "short-curr");
            Set<Double> allSamples = VerifyCompactNumbers.collectSamplesAndSetFormats(currencyCode, locale, sdi, cdf, cdfs, cdfCurr);
            try {
                for (double source : allSamples) {
                    String formattedNumber = nf.format(source);
                    String compactFormattedNumber = cdf == null ? "n/a" : cdf.format(source);
                    String compactLongFormattedNumber = cdfs == null ? "n/a" : cdfs.format(source);
                    String compactCurrFormattedNumber = !showCurrency || cdfs == null ? "n/a" : cdfCurr.format(source);
                    tablePrinter1.addRow().addCell((Comparable)((Object)formattedNumber)).addCell((Comparable)((Object)compactFormattedNumber)).addCell((Comparable)((Object)compactLongFormattedNumber));
                    if (showCurrency) {
                        tablePrinter1.addCell((Comparable)((Object)compactCurrFormattedNumber));
                    }
                    tablePrinter1.finishRow();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            out.append("<p>To correct problems in compact numbers below, please go to <a href='" + CLDR_CONFIG.urls().forPage(cldrFile.getLocaleID(), PathHeader.PageId.Compact_Decimal_Formatting) + "'><em>" + (Object)((Object)PathHeader.PageId.Compact_Decimal_Formatting) + "</em></a>.</p>");
            out.append(tablePrinter1.toString() + "\n");
            out.append("<h3>Plural Rules</h3>");
            out.append("<p>Look over the Minimal Pairs to make sure they are ok. Then review the examples in the cell to the left. All of those you should be able to substitute for the numbers in the Minimal Pairs, with an acceptable result. If any would be incorrect, please <a target='ticket' href='http://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket'>file a ticket</a>.</p><p>For more details, see <a target='CLDR-ST-DOCS' href='http://cldr.unicode.org/index/cldr-spec/plural-rules'>Plural Rules</a>.</p>");
            ShowPlurals showPlurals = new ShowPlurals(CLDR_CONFIG.getSupplementalDataInfo());
            showPlurals.printPluralTable(cldrFile, locale, out, factory);
            ShowPlurals.appendBlanksForScrolling(out);
            VerifyCompactNumbers.showErrors(errors, out);
            VerifyCompactNumbers.showErrors(debugCreationErrors, out);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static Set<Double> collectSamplesAndSetFormats(String currencyCode, String locale, SupplementalDataInfo sdi, CompactDecimalFormat cdf, CompactDecimalFormat cdfs, CompactDecimalFormat cdfCurr) {
        int factor = USES_GROUPS_OF_4.contains(locale) ? 10000 : 1000;
        SupplementalDataInfo.PluralInfo pluralInfo = sdi.getPlurals(locale);
        TreeSet<Double> samples = new TreeSet<Double>();
        samples.add(1.1);
        samples.add(1.5);
        samples.add(1100.0);
        VerifyCompactNumbers.collectItems(pluralInfo, 1.0, 10.0, samples);
        VerifyCompactNumbers.collectItems(pluralInfo, 10.0, 100.0, samples);
        VerifyCompactNumbers.collectItems(pluralInfo, 100.0, 1000.0, samples);
        int sigDigits = 3;
        if (factor > 1000) {
            VerifyCompactNumbers.collectItems(pluralInfo, 1000.0, 10000.0, samples);
            sigDigits = 4;
        }
        if (cdf != null) {
            cdf.setMaximumSignificantDigits(sigDigits);
        }
        if (cdfs != null) {
            cdfs.setMaximumSignificantDigits(sigDigits);
        }
        if (cdfCurr != null) {
            cdfCurr.setCurrency(Currency.getInstance(currencyCode));
            cdfCurr.setMaximumSignificantDigits(sigDigits);
        }
        TreeSet<Double> allSamples = new TreeSet<Double>();
        for (long i = 1L; i <= 100000000000000L; i *= (long)factor) {
            for (Double sample : samples) {
                double source = (double)i * sample;
                allSamples.add(source);
            }
        }
        return allSamples;
    }

    private static void showErrors(Set<String> errors, Appendable out) throws IOException {
        if (errors.size() != 0) {
            out.append("<h2>Errors</h2>\n");
            for (String s2 : errors) {
                out.append("<p>" + s2 + "</p>\n");
            }
            errors.clear();
        }
    }

    private static Set<Double> collectItems(SupplementalDataInfo.PluralInfo pluralInfo, double start, double limit, Set<Double> samples) {
        TreeMap<String, Double> ones = new TreeMap<String, Double>();
        for (double i = start; i < limit; i += 1.0) {
            String cat = pluralInfo.getPluralRules().select(i);
            if (ones.containsKey(cat)) continue;
            ones.put(cat, i);
        }
        samples.addAll(ones.values());
        return samples;
    }

    private static void captureErrors(Set<String> debugCreationErrors, Set<String> errors, String locale, String length) {
        if (debugCreationErrors.size() != 0) {
            for (String s2 : debugCreationErrors) {
                errors.add(locale + "\t" + length + "\t" + s2);
            }
            debugCreationErrors.clear();
        }
    }

    static enum MyOptions {
        organization(".*", "CLDR", "organization"),
        filter(".*", ".*", "locale filter (regex)"),
        currency(".*", "EUR", "show currency");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

