/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.CountryCodeConverter;
import org.unicode.cldr.tool.LanguageCodeConverter;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class WikipediaOfficialLanguages {
    private static Relation<String, Info> regionToLanguageStatus;

    private static SupplementalDataInfo.OfficialStatus guessStatus(String line) {
        if (line.contains("minority")) {
            return SupplementalDataInfo.OfficialStatus.official_minority;
        }
        if (line.contains("regional") || line.startsWith("in ")) {
            return SupplementalDataInfo.OfficialStatus.official_regional;
        }
        if (line.contains("recognized")) {
            return SupplementalDataInfo.OfficialStatus.recognized;
        }
        if (line.contains("de facto")) {
            return SupplementalDataInfo.OfficialStatus.de_facto_official;
        }
        if (line.contains("official") || line.contains("national") || line.isEmpty()) {
            return SupplementalDataInfo.OfficialStatus.official;
        }
        return SupplementalDataInfo.OfficialStatus.official;
    }

    private static Set<String> getRegionSet(Set<String> regionSet, String comments) {
        String[] parts;
        if (regionSet.size() < 2) {
            return regionSet;
        }
        int inLen = WikipediaOfficialLanguages.getStartLen(comments, "in ");
        if (inLen == 0) {
            inLen = WikipediaOfficialLanguages.getStartLen(comments, "minority language in ");
        }
        if (inLen == 0) {
            return regionSet;
        }
        comments = comments.substring(inLen);
        HashSet<String> result = new HashSet<String>();
        for (String part : parts = comments.split("(,?\\s+and|,|;)\\s+")) {
            if (part.isEmpty() || part.equals("de facto")) continue;
            String region = CountryCodeConverter.getCodeFromName(part, false);
            if (region == null) {
                System.err.println("* Can't convert " + region + " in " + part);
                continue;
            }
            result.add(region);
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException(regionSet + ", " + comments);
        }
        return result;
    }

    private static int getStartLen(String comments, String string) {
        return comments.startsWith(string) ? string.length() : 0;
    }

    public static Set<String> getRegions() {
        return regionToLanguageStatus.keySet();
    }

    public static Set<Info> getInfo(String region) {
        return regionToLanguageStatus.get(region);
    }

    public static void main(String[] args) {
        CLDRConfig testInfo = ToolConfig.getToolInstance();
        CLDRFile english = testInfo.getEnglish();
        SupplementalDataInfo supplementalDataInfo = testInfo.getSupplementalDataInfo();
        StandardCodes sc = testInfo.getStandardCodes();
        Set<String> locales = sc.getLocaleCoverageLocales("google");
        System.out.println("Cc\tCountry\tLc\tLanguage Name\tWiki status (heuristic)\tCLDR status\t\tWiki notes");
        HashSet<String> seen = new HashSet<String>();
        for (String region : WikipediaOfficialLanguages.getRegions()) {
            SupplementalDataInfo.PopulationData sInfo;
            Set<String> cldrLanguagesRaw = supplementalDataInfo.getLanguagesForTerritoryWithPopulationData(region);
            HashMap<String, SupplementalDataInfo.PopulationData> cldrLanguageInfo = new HashMap<String, SupplementalDataInfo.PopulationData>();
            for (String s2 : cldrLanguagesRaw) {
                if (!s2.contains("_")) continue;
                sInfo = supplementalDataInfo.getLanguageAndTerritoryPopulationData(s2, region);
                s2 = s2.substring(0, s2.indexOf(95));
                cldrLanguageInfo.put(s2, sInfo);
            }
            for (Info info : WikipediaOfficialLanguages.getInfo(region)) {
                SupplementalDataInfo.OfficialStatus cldrStatus;
                if (!locales.contains(info.language)) continue;
                sInfo = supplementalDataInfo.getLanguageAndTerritoryPopulationData(info.language, region);
                if (sInfo == null) {
                    sInfo = (SupplementalDataInfo.PopulationData)cldrLanguageInfo.get(info.language);
                }
                SupplementalDataInfo.OfficialStatus officialStatus = cldrStatus = sInfo == null ? SupplementalDataInfo.OfficialStatus.unknown : sInfo.getOfficialStatus();
                if (!WikipediaOfficialLanguages.areCompatible(info.status, cldrStatus)) {
                    System.out.print(region + "\t" + english.getName(2, region));
                    System.out.println("\t" + info.language + "\t" + english.getName(info.language) + "\t" + (Object)((Object)info.status) + "\t" + (cldrStatus == null ? "NOT-IN-CLDR" : cldrStatus) + "\t-\t" + info.comments);
                }
                seen.add(info.language);
            }
            for (String r2 : cldrLanguagesRaw) {
                SupplementalDataInfo.OfficialStatus officialStatus;
                if (seen.contains(r2) || r2.contains("_") || !locales.contains(r2) || SupplementalDataInfo.OfficialStatus.unknown == (officialStatus = (sInfo = supplementalDataInfo.getLanguageAndTerritoryPopulationData(r2, region)).getOfficialStatus())) continue;
                System.out.print(region + "\t" + english.getName(2, region));
                System.out.println("\t" + r2 + "\t" + english.getName(r2) + "\tCLDR-ONLY\t" + (sInfo == null ? "NOT-IN-CLDR" : officialStatus));
            }
        }
        Set<String> errors = LanguageCodeConverter.getParseErrors();
        for (String error : errors) {
            if (error.startsWith("Name Collision!") || error.startsWith("Skipping *OMIT")) continue;
            System.err.println(error);
        }
    }

    private static boolean areCompatible(SupplementalDataInfo.OfficialStatus infoStatus, SupplementalDataInfo.OfficialStatus cldrStatus) {
        return infoStatus == cldrStatus || infoStatus == SupplementalDataInfo.OfficialStatus.official_regional && cldrStatus == SupplementalDataInfo.OfficialStatus.official_minority || infoStatus == SupplementalDataInfo.OfficialStatus.official_minority && cldrStatus == SupplementalDataInfo.OfficialStatus.official_regional;
    }

    static {
        String region;
        regionToLanguageStatus = Relation.of(new TreeMap(), TreeSet.class);
        Relation<String, String> REPLACE_REGIONS = Relation.of(new HashMap(), HashSet.class);
        for (String s2 : Arrays.asList("Abkhazia", "Nagorno-Karabakh", "Northern Cyprus", "Sahrawi Arab Democratic Republic", "Tamazight", "Somaliland", "Somalian", "South Ossetia", "Transnistria")) {
            REPLACE_REGIONS.put(s2, "SKIP");
        }
        for (String s2 : Arrays.asList("Anguilla", "Bermuda", "British Indian Ocean Territory", "British Virgin Islands", "Cayman Islands", "Falkland Islands", "Gibraltar", "Montserrat", "Pitcairn Islands", "Saint Helena", "Ascension Island", "Tristan da Cunha")) {
            region = CountryCodeConverter.getCodeFromName(s2, false);
            if (region == null) {
                System.err.println("Couldn't parse region: <" + s2 + ">");
                continue;
            }
            REPLACE_REGIONS.put("United Kingdom and overseas territories", region);
        }
        for (String s2 : Arrays.asList("French Guiana", "French Polynesia", "Guadeloupe", "Martinique", "Mayotte", "New Caledonia", "R\u00e9union", "Saint Barth\u00e9lemy", "Saint Martin", "Saint Pierre and Miquelon", "Wallis and Futuna")) {
            region = CountryCodeConverter.getCodeFromName(s2, false);
            if (region == null) {
                System.err.println("Couldn't parse region: <" + s2 + ">");
                continue;
            }
            REPLACE_REGIONS.put("France and overseas departments and territories", region);
        }
        Matcher pagenote = PatternCache.get("\\[\\d+\\]").matcher("");
        Pattern commentBreak = PatternCache.get("\\)\\s*\\(?|\\s*\\(");
        int count = 0;
        try {
            String line;
            BufferedReader input = FileUtilities.openUTF8Reader(CLDRPaths.UTIL_DATA_DIR, "WikipediaOfficialLanguages.txt");
            Set<String> regionSet = null;
            while ((line = input.readLine()) != null) {
                String[] items;
                if (line.startsWith(" ")) {
                    items = commentBreak.split(line = pagenote.reset(line.trim()).replaceAll(""));
                    Set replacement = REPLACE_REGIONS.get(items[0]);
                    if (replacement != null) {
                        if (replacement.contains("SKIP")) {
                            regionSet = Collections.emptySet();
                            continue;
                        }
                        regionSet = replacement;
                        continue;
                    }
                    String region2 = CountryCodeConverter.getCodeFromName(items[0], false);
                    if (region2 == null) {
                        System.err.println(++count + " Couldn't parse region: <" + items[0] + "> in line: " + line);
                        regionSet = Collections.emptySet();
                        continue;
                    }
                    regionSet = new HashSet();
                    regionSet.add(region2);
                    continue;
                }
                if (line.contains("[edit]") || line.trim().isEmpty() || regionSet.isEmpty() || line.contains("Sign Language")) continue;
                items = commentBreak.split(line = pagenote.reset(line.trim()).replaceAll(""));
                String language = LanguageCodeConverter.getCodeForName(items[0]);
                if (language == null) {
                    System.out.println(++count + " Couldn't parse language:\txxx ; " + items[0] + "\tfor <" + regionSet + "> in line: " + line);
                    continue;
                }
                if ("sgn".equals(language)) continue;
                StringBuffer s3 = new StringBuffer();
                for (int i = 1; i < items.length; ++i) {
                    if (s3.length() != 0) {
                        s3.append("; ");
                    }
                    s3.append(items[i]);
                }
                String comments = s3.toString();
                Set<String> narrowRegionSet = WikipediaOfficialLanguages.getRegionSet(regionSet, comments);
                for (String region3 : narrowRegionSet) {
                    regionToLanguageStatus.put(region3, new Info(language, WikipediaOfficialLanguages.guessStatus(comments), comments));
                }
            }
            regionToLanguageStatus.freeze();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static class Info
    implements Comparable<Info> {
        final String language;
        final SupplementalDataInfo.OfficialStatus status;
        final String comments;

        public Info(String language, SupplementalDataInfo.OfficialStatus status, String comments) {
            this.language = language;
            this.status = status;
            this.comments = comments;
        }

        public boolean equals(Object arg0) {
            return this.compareTo((Info)arg0) == 0;
        }

        public int hashCode() {
            return this.language.hashCode() ^ this.status.hashCode();
        }

        @Override
        public int compareTo(Info other) {
            int s2 = this.status.compareTo(other.status);
            return s2 != 0 ? -s2 : this.language.compareTo(other.language);
        }
    }
}

