/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.StripUTF8BOMInputStream;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLNormalizingLoader {
    private static final int CACHE_LIMIT = 700;
    private static LoadingCache<XMLSourceCacheKey, XMLSource> cache = CacheBuilder.newBuilder().maximumSize(700L).softValues().build(new CacheLoader<XMLSourceCacheKey, XMLSource>(){

        @Override
        public XMLSource load(XMLSourceCacheKey key) {
            return XMLNormalizingLoader.makeXMLSource(key);
        }
    });
    private static final boolean LOG_PROGRESS = false;
    private static final boolean DEBUG = false;

    public static XMLSource getFrozenInstance(String localeId, List<File> dirs, CLDRFile.DraftStatus minimalDraftStatus) {
        XMLSourceCacheKey key = new XMLSourceCacheKey(localeId, dirs, minimalDraftStatus);
        return cache.getUnchecked(key);
    }

    private static XMLSource makeXMLSource(XMLSourceCacheKey key) {
        XMLSource source = null;
        if (key.dirs.size() == 1) {
            File file = new File((File)key.dirs.iterator().next(), key.localeId + ".xml");
            source = XMLNormalizingLoader.loadXMLFile(file, key.localeId, key.minimalDraftStatus);
            source.freeze();
            return source;
        }
        ArrayList<XMLSource> list = new ArrayList<XMLSource>();
        ArrayList<File> dirList = new ArrayList<File>();
        for (File dir : key.dirs) {
            dirList.clear();
            dirList.add(dir);
            XMLSourceCacheKey singleKey = new XMLSourceCacheKey(key.localeId, dirList, key.minimalDraftStatus);
            XMLSource singleSource = cache.getUnchecked(singleKey);
            list.add(singleSource);
        }
        source = ((XMLSource)list.get(0)).cloneAsThawed();
        for (int i = 1; i < list.size(); ++i) {
            XMLSource other = (XMLSource)list.get(i);
            source.putAll(other, 0);
            source.getXpathComments().joinAll(other.getXpathComments());
        }
        source.freeze();
        return source;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static XMLSource loadXMLFile(File f, String localeId, CLDRFile.DraftStatus minimalDraftStatus) {
        try (StripUTF8BOMInputStream fis = new StripUTF8BOMInputStream(new FileInputStream(f));){
            SimpleXMLSource simpleXMLSource;
            try (InputStreamReader reader = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));){
                String fullFileName = f.getCanonicalPath();
                SimpleXMLSource source = new SimpleXMLSource(localeId);
                XMLNormalizingHandler XML_HANDLER = new XMLNormalizingHandler(source, minimalDraftStatus);
                XMLFileReader.read(fullFileName, reader, -1, true, XML_HANDLER);
                if (XML_HANDLER.supplementalStatus == SupplementalStatus.NEVER_SET) {
                    throw new IllegalArgumentException("root of file must be either ldml or supplementalData");
                }
                source.setNonInheriting(XML_HANDLER.supplementalStatus == SupplementalStatus.NOT_SUPPLEMENTAL);
                if (XML_HANDLER.overrideCount > 0) {
                    throw new IllegalArgumentException("Internal problems: either data file has duplicate path, or CLDRFile.isDistinguishing() or CLDRFile.isOrdered() need updating: " + XML_HANDLER.overrideCount + "; The exact problems are printed on the console above.");
                }
                simpleXMLSource = source;
            }
            return simpleXMLSource;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Cannot read the file " + f, e);
        }
    }

    private static class XMLSourceCacheKey {
        private final String localeId;
        private final Set<File> dirs;
        private final CLDRFile.DraftStatus minimalDraftStatus;
        private final int hashCode;

        public XMLSourceCacheKey(String localeId, List<File> dirs, CLDRFile.DraftStatus minimalDraftStatus) {
            this.localeId = localeId;
            if (dirs == null || dirs.isEmpty()) {
                throw new ICUUncheckedIOException("Attempt to create a XMLSourceCacheKey with a null directory, please supply a non-null one.");
            }
            ImmutableSet.Builder _dirs = ImmutableSet.builder();
            for (File dir : dirs) {
                if (!dir.canRead()) {
                    throw new ICUUncheckedIOException("The directory specified, " + dir.getPath() + ", cannot be read");
                }
                _dirs.add(dir);
            }
            this.dirs = _dirs.build();
            this.minimalDraftStatus = minimalDraftStatus;
            this.hashCode = Objects.hash(new Object[]{this.localeId, this.dirs, this.minimalDraftStatus});
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XMLSourceCacheKey other = (XMLSourceCacheKey)obj;
            if (this.hashCode != other.hashCode) {
                return false;
            }
            if (!Objects.equals(this.dirs, other.dirs)) {
                return false;
            }
            if (this.minimalDraftStatus != other.minimalDraftStatus) {
                return false;
            }
            return Objects.equals(this.localeId, other.localeId);
        }
    }

    private static class XMLNormalizingHandler
    implements XMLFileReader.AllHandler {
        private CLDRFile.DraftStatus minimalDraftStatus;
        private static final boolean SHOW_START_END = false;
        private int commentStackIndex;
        private boolean justPopped = false;
        private String lastChars = "";
        private StringBuilder currentFullXPathSb = new StringBuilder("/");
        private String comment = null;
        private Map<String, String> attributeOrder;
        private DtdData dtdData;
        private XMLSource source;
        private String lastActiveLeafNode;
        private String lastLeafNode;
        private SupplementalStatus supplementalStatus = SupplementalStatus.NEVER_SET;
        private static final int MAX_DEPTH = 30;
        private int[] orderedCounter = new int[30];
        private String[] orderedString = new String[30];
        private int level = 0;
        private int overrideCount = 0;
        private static final Set<String> CHANGED_TYPES = new HashSet<String>(Arrays.asList("abbreviationFallback", "default", "mapping", "measurementSystem", "preferenceOrdering"));
        private static final Pattern DRAFT_PATTERN = PatternCache.get("\\[@draft=\"([^\"]*)\"\\]");
        private static final Pattern WHITESPACE_WITH_LF = PatternCache.get("\\s*\\u000a\\s*");
        private Matcher draftMatcher = DRAFT_PATTERN.matcher("");
        private Matcher whitespaceWithLf = WHITESPACE_WITH_LF.matcher("");
        private static final UnicodeSet CONTROLS = new UnicodeSet("[:cc:]").freeze();
        private static final UnicodeSet WHITESPACE = new UnicodeSet("[:whitespace:]").freeze();

        XMLNormalizingHandler(XMLSource source, CLDRFile.DraftStatus minimalDraftStatus) {
            this.source = source;
            this.minimalDraftStatus = minimalDraftStatus;
        }

        private String show(Attributes attributes) {
            if (attributes == null) {
                return "null";
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getQName(i);
                String value = attributes.getValue(i);
                result.append("[@" + attribute + "=\"" + value + "\"]");
            }
            return result.toString();
        }

        private void push(String qName, Attributes attributes) {
            Log.logln(false, "push\t" + qName + "\t" + this.show(attributes));
            ++this.level;
            if (!qName.equals(this.orderedString[this.level])) {
                this.orderedString[this.level] = qName;
            }
            if (this.lastChars.length() != 0) {
                if (WHITESPACE.containsAll(this.lastChars)) {
                    this.lastChars = "";
                } else {
                    throw new IllegalArgumentException("Must not have mixed content: " + qName + ", " + this.show(attributes) + ", Content: " + this.lastChars);
                }
            }
            this.currentFullXPathSb.append("/" + qName);
            if (this.dtdData.isOrdered(qName)) {
                this.currentFullXPathSb.append(this.orderingAttribute());
            }
            if (attributes.getLength() > 0) {
                this.attributeOrder.clear();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attribute = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    if (attribute.equals("cldrVersion") && qName.equals("version")) {
                        ((SimpleXMLSource)this.source).setDtdVersionInfo(VersionInfo.getInstance(value));
                        continue;
                    }
                    this.putAndFixDeprecatedAttribute(qName, attribute, value);
                }
                for (Map.Entry<String, String> entry : this.attributeOrder.entrySet()) {
                    String attribute = entry.getKey();
                    String value = entry.getValue();
                    String both = "[@" + attribute + "=\"" + value + "\"]";
                    this.currentFullXPathSb.append(both);
                }
            }
            if (this.comment != null) {
                String currentFullXPath = this.currentFullXPathSb.toString();
                if (currentFullXPath.equals("//ldml") || currentFullXPath.equals("//supplementalData")) {
                    this.source.setInitialComment(this.comment);
                } else {
                    this.source.addComment(currentFullXPath, this.comment, XPathParts.Comments.CommentType.PREBLOCK);
                }
                this.comment = null;
            }
            this.justPopped = false;
            this.lastActiveLeafNode = null;
            Log.logln(false, "currentFullXPath\t" + this.currentFullXPathSb.toString());
        }

        private String orderingAttribute() {
            int n = this.level;
            int n2 = this.orderedCounter[n];
            this.orderedCounter[n] = n2 + 1;
            return "[@_q=\"" + n2 + "\"]";
        }

        private void putAndFixDeprecatedAttribute(String element, String attribute, String value) {
            if (attribute.equals("draft")) {
                if (value.equals("true")) {
                    value = "approved";
                } else if (value.equals("false")) {
                    value = "unconfirmed";
                }
            } else if (attribute.equals("type") && CHANGED_TYPES.contains(element) && this.supplementalStatus != SupplementalStatus.NOT_SUPPLEMENTAL) {
                attribute = "choice";
            }
            this.attributeOrder.put(attribute, value);
        }

        private void addPath(String fullXPath, String value) {
            String former = this.source.getValueAtPath(fullXPath);
            if (former != null) {
                String formerPath = this.source.getFullXPath(fullXPath);
                if (!(former.equals(value) && fullXPath.equals(formerPath) || fullXPath.startsWith("//ldml/identity/version") || fullXPath.startsWith("//ldml/identity/generation"))) {
                    this.warnOnOverride(former, formerPath);
                }
            }
            value = this.trimWhitespaceSpecial(value);
            this.source.add(fullXPath, value);
        }

        private void pop(String qName) {
            Log.logln(false, "pop\t" + qName);
            --this.level;
            String currentFullXPath = this.currentFullXPathSb.toString();
            if (!this.lastChars.isEmpty() || !this.justPopped) {
                boolean acceptItem;
                boolean bl = acceptItem = this.minimalDraftStatus == CLDRFile.DraftStatus.unconfirmed;
                if (!acceptItem) {
                    if (this.draftMatcher.reset(currentFullXPath).find()) {
                        CLDRFile.DraftStatus foundStatus = CLDRFile.DraftStatus.valueOf(this.draftMatcher.group(1));
                        if (this.minimalDraftStatus.compareTo(foundStatus) <= 0) {
                            acceptItem = true;
                        }
                    } else {
                        acceptItem = true;
                    }
                }
                if (acceptItem) {
                    boolean skipAdd = false;
                    if (currentFullXPath.startsWith("//ldml/layout/orientation")) {
                        XPathParts parts = XPathParts.getFrozenInstance(currentFullXPath);
                        String value = parts.getAttributeValue(-1, "characters");
                        if (value != null) {
                            this.addPath("//ldml/layout/orientation/characterOrder", value);
                            skipAdd = true;
                        }
                        if ((value = parts.getAttributeValue(-1, "lines")) != null) {
                            this.addPath("//ldml/layout/orientation/lineOrder", value);
                            skipAdd = true;
                        }
                    }
                    if (!skipAdd) {
                        this.addPath(currentFullXPath, this.lastChars);
                    }
                    this.lastLeafNode = this.lastActiveLeafNode = currentFullXPath;
                }
                this.lastChars = "";
            } else {
                Log.logln(false, "pop: zeroing last leafNode: " + this.lastActiveLeafNode);
                this.lastActiveLeafNode = null;
                if (this.comment != null) {
                    this.source.addComment(this.lastLeafNode, this.comment, XPathParts.Comments.CommentType.POSTBLOCK);
                    this.comment = null;
                }
            }
            this.currentFullXPathSb.setLength(0);
            this.currentFullXPathSb.append(XMLNormalizingHandler.stripAfter(currentFullXPath, qName));
            this.justPopped = true;
        }

        private String trimWhitespaceSpecial(String source) {
            if (!source.contains("\n")) {
                return source;
            }
            source = this.whitespaceWithLf.reset(source).replaceAll("\n");
            return source;
        }

        private void warnOnOverride(String former, String formerPath) {
            String distinguishing = CLDRFile.getDistinguishingXPath(formerPath, null);
            System.out.println("\tERROR in " + this.source.getLocaleID() + ";\toverriding old value <" + former + "> at path " + distinguishing + "\twith\t<" + this.lastChars + ">" + "\n" + "\told fullpath: " + formerPath + "\n" + "\tnew fullpath: " + this.currentFullXPathSb.toString());
            ++this.overrideCount;
        }

        private static String stripAfter(String input, String qName) {
            int pos = XMLNormalizingHandler.findLastSlash(input);
            if (qName != null && !input.substring(pos + 1).startsWith(qName)) {
                throw new IllegalArgumentException("Internal Error: should never get here.");
            }
            return input.substring(0, pos);
        }

        private static int findLastSlash(String input) {
            int braceStack = 0;
            char inQuote = '\u0000';
            block6: for (int i = input.length() - 1; i >= 0; --i) {
                char ch = input.charAt(i);
                switch (ch) {
                    case '\"': 
                    case '\'': {
                        if (inQuote == '\u0000') {
                            inQuote = ch;
                            continue block6;
                        }
                        if (inQuote != ch) continue block6;
                        inQuote = '\u0000';
                        continue block6;
                    }
                    case '/': {
                        if (inQuote != '\u0000' || braceStack != 0) continue block6;
                        return i;
                    }
                    case '[': {
                        if (inQuote != '\u0000') continue block6;
                        --braceStack;
                        continue block6;
                    }
                    case ']': {
                        if (inQuote != '\u0000') continue block6;
                        ++braceStack;
                    }
                }
            }
            return -1;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Log.logln(false, "startElement uri\t" + uri + "\tlocalName " + localName + "\tqName " + qName + "\tattributes " + this.show(attributes));
            try {
                if (this.supplementalStatus == SupplementalStatus.NEVER_SET) {
                    this.attributeOrder = new TreeMap<String, String>(this.dtdData.dtdType == DtdType.ldml ? CLDRFile.getAttributeOrdering() : this.dtdData.getAttributeComparator());
                    this.supplementalStatus = this.source.getXMLNormalizingDtdType() == DtdType.ldml ? SupplementalStatus.IS_SUMPPLEMENTAL : SupplementalStatus.NOT_SUPPLEMENTAL;
                }
                this.push(qName, attributes);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Log.logln(false, "endElement uri\t" + uri + "\tlocalName " + localName + "\tqName " + qName);
            this.pop(qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                String value = new String(ch, start, length);
                Log.logln(false, "characters:\t" + value);
                this.lastChars = this.lastChars + value;
                this.justPopped = false;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            Log.logln(false, "startDTD name: " + name + ", publicId: " + publicId + ", systemId: " + systemId);
            ++this.commentStackIndex;
            this.source.setXMLNormalizingDtdType(DtdType.valueOf(name));
            this.dtdData = DtdData.getInstance(this.source.getXMLNormalizingDtdType());
        }

        @Override
        public void endDTD() throws SAXException {
            Log.logln(false, "endDTD");
            --this.commentStackIndex;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            String string = new String(ch, start, length);
            Log.logln(false, this.commentStackIndex + " comment " + string);
            try {
                if (this.commentStackIndex != 0) {
                    return;
                }
                String comment0 = this.trimWhitespaceSpecial(string).trim();
                if (this.lastActiveLeafNode != null) {
                    this.source.addComment(this.lastActiveLeafNode, comment0, XPathParts.Comments.CommentType.LINE);
                } else {
                    this.comment = this.comment == null ? comment0 : this.comment + "\n" + comment0;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            for (int i = start; i < start + length; ++i) {
                if (ch[i] != '\n') continue;
                Log.logln(false, "\\n: zeroing last leafNode: " + this.lastActiveLeafNode);
                this.lastActiveLeafNode = null;
                break;
            }
        }

        @Override
        public void startDocument() throws SAXException {
            Log.logln(false, "startDocument");
            this.commentStackIndex = 0;
        }

        @Override
        public void endDocument() throws SAXException {
            Log.logln(false, "endDocument");
            try {
                if (this.comment != null) {
                    this.source.addComment(null, this.comment, XPathParts.Comments.CommentType.LINE);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
            Log.logln(false, "Attribute\t" + name + "\t" + model);
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
            Log.logln(false, "Attribute\t" + eName + "\t" + aName + "\t" + type + "\t" + mode + "\t" + value);
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
            Log.logln(false, "Internal Entity\t" + name + "\t" + value);
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
            Log.logln(false, "Internal Entity\t" + name + "\t" + publicId + "\t" + systemId);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            Log.logln(false, "processingInstruction: " + target + ", " + data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            Log.logln(false, "skippedEntity: " + name);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            Log.logln(false, "setDocumentLocator Locator " + locator);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            Log.logln(false, "startPrefixMapping prefix: " + prefix + ", uri: " + uri);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            Log.logln(false, "endPrefixMapping prefix: " + prefix);
        }

        @Override
        public void startEntity(String name) throws SAXException {
            Log.logln(false, "startEntity name: " + name);
        }

        @Override
        public void endEntity(String name) throws SAXException {
            Log.logln(false, "endEntity name: " + name);
        }

        @Override
        public void startCDATA() throws SAXException {
            Log.logln(false, "startCDATA");
        }

        @Override
        public void endCDATA() throws SAXException {
            Log.logln(false, "endCDATA");
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Log.logln(true, "error: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Log.logln(false, "fatalError: " + XMLFileReader.showSAX(exception));
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Log.logln(false, "warning: " + XMLFileReader.showSAX(exception));
            throw exception;
        }
    }

    static enum SupplementalStatus {
        NEVER_SET,
        IS_SUMPPLEMENTAL,
        NOT_SUPPLEMENTAL;

    }
}

