/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool;

public class UOption {
    public String longName;
    public String value;
    public Fn optionFn;
    public Object context;
    public char shortName;
    public int hasArg;
    public boolean doesOccur;
    public static final int NO_ARG = 0;
    public static final int REQUIRES_ARG = 1;
    public static final int OPTIONAL_ARG = 2;

    public static UOption create(String aLongName, char aShortName, int hasArgument) {
        return new UOption(aLongName, aShortName, hasArgument);
    }

    public static UOption DEF(String aLongName, char aShortName, int hasArgument) {
        return UOption.create(aLongName, aShortName, hasArgument);
    }

    public static UOption HELP_H() {
        return UOption.create("help", 'h', 0);
    }

    public static UOption HELP_QUESTION_MARK() {
        return UOption.create("help", '?', 0);
    }

    public static UOption VERBOSE() {
        return UOption.create("verbose", 'v', 0);
    }

    public static UOption QUIET() {
        return UOption.create("quiet", 'q', 0);
    }

    public static UOption VERSION() {
        return UOption.create("version", 'V', 0);
    }

    public static UOption COPYRIGHT() {
        return UOption.create("copyright", 'c', 0);
    }

    public static UOption DESTDIR() {
        return UOption.create("destdir", 'd', 1);
    }

    public static UOption SOURCEDIR() {
        return UOption.create("sourcedir", 's', 1);
    }

    public static UOption ENCODING() {
        return UOption.create("encoding", 'e', 1);
    }

    public static UOption ICUDATADIR() {
        return UOption.create("icudatadir", 'i', 1);
    }

    public static UOption PACKAGE_NAME() {
        return UOption.create("package-name", 'p', 1);
    }

    public static UOption BUNDLE_NAME() {
        return UOption.create("bundle-name", 'b', 1);
    }

    public static int parseArgs(String[] argv, int start, UOption[] options) {
        int i = start;
        int remaining = start;
        boolean stopOptions = false;
        while (i < argv.length) {
            String arg = argv[i];
            if (!stopOptions && arg.length() > 1 && arg.charAt(0) == '-') {
                int j;
                char c = arg.charAt(1);
                UOption option = null;
                arg = arg.substring(2);
                if (c == '-') {
                    if (arg.length() == 0) {
                        stopOptions = true;
                    } else {
                        for (j = 0; j < options.length; ++j) {
                            if (options[j].longName == null || !arg.equals(options[j].longName)) continue;
                            option = options[j];
                            break;
                        }
                        if (option == null) {
                            UOption.syntaxError("Unknown option " + argv[i]);
                        }
                        option.doesOccur = true;
                        if (option.hasArg != 0) {
                            if (i + 1 < argv.length && (argv[i + 1].length() <= 1 || argv[i + 1].charAt(0) != '-')) {
                                option.value = argv[++i];
                            } else if (option.hasArg == 1) {
                                UOption.syntaxError("Option " + argv[i] + " lacks required argument");
                            }
                        }
                    }
                } else {
                    while (true) {
                        for (j = 0; j < options.length; ++j) {
                            if (c != options[j].shortName) continue;
                            option = options[j];
                            break;
                        }
                        if (option == null) {
                            UOption.syntaxError("Unknown option '" + c + "' in " + argv[i]);
                        }
                        option.doesOccur = true;
                        if (option.hasArg != 0) {
                            if (arg.length() != 0) {
                                option.value = arg;
                                break;
                            }
                            if (i + 1 < argv.length && (argv[i + 1].length() <= 1 || argv[i + 1].charAt(0) != '-')) {
                                option.value = argv[++i];
                                break;
                            }
                            if (option.hasArg == 1) {
                                UOption.syntaxError("Option -" + c + " lacks required argument");
                            }
                        }
                        option = null;
                        if (arg.length() == 0) break;
                        c = arg.charAt(0);
                        arg = arg.substring(1);
                    }
                }
                if (option != null && option.optionFn != null && option.optionFn.handle(option) < 0) {
                    UOption.syntaxError("Option handler failed for " + argv[i]);
                }
                ++i;
                continue;
            }
            argv[remaining++] = arg;
            ++i;
        }
        return remaining;
    }

    public UOption setDefault(String s2) {
        this.value = s2;
        return this;
    }

    public static int parseArgs(String[] argv, UOption[] options) {
        return UOption.parseArgs(argv, 0, options);
    }

    private UOption(String aLongName, char aShortName, int hasArgument) {
        this.longName = aLongName;
        this.shortName = aShortName;
        this.hasArg = hasArgument;
    }

    private static void syntaxError(String message) {
        throw new IllegalArgumentException("Error in argument list: " + message);
    }

    public static interface Fn {
        public int handle(UOption var1);
    }
}

