/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.unicode.cldr.api.AttributeKey;
import org.unicode.cldr.api.CldrDataType;
import org.unicode.cldr.api.CldrDraftStatus;
import org.unicode.cldr.api.CldrPath;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.XPathParts;

final class CldrPaths {
    private static final int LHS_FIRST = -1;
    private static final int RHS_FIRST = 1;
    private static final String HIDDEN_SORT_INDEX_ATTRIBUTE = "_q";
    private static final Predicate<DtdData.Element> IS_NOT_DEPRECATED = e -> !e.isDeprecated();
    private static final ImmutableSetMultimap<CldrDataType, String> LEAF_ELEMENTS_MAP;
    private static final ImmutableSetMultimap<CldrDataType, String> ORDERED_ELEMENTS_MAP;
    private static final ImmutableMap<CldrDataType, DtdPathComparator> PATH_COMPARATOR_MAP;
    private static final CldrPath LDML_VERSION;

    static Comparator<CldrPath> getPathComparator(CldrDataType type) {
        return PATH_COMPARATOR_MAP.get((Object)type);
    }

    static boolean isLeafPath(CldrPath path) {
        String lastElementName = path.getName();
        return lastElementName.indexOf(58) != -1 || LEAF_ELEMENTS_MAP.get((Object)path.getDataType()).contains(lastElementName);
    }

    static boolean isOrdered(CldrDataType dtdType, String elementName) {
        if (elementName.indexOf(58) != -1) {
            return false;
        }
        return ORDERED_ELEMENTS_MAP.get((Object)dtdType).contains(elementName);
    }

    static boolean shouldEmit(CldrPath path) {
        if (path.getLength() == 2 && path.getName().equals("version")) {
            return false;
        }
        return !path.equals(LDML_VERSION);
    }

    static CldrPath processXPath(String fullPath, List<CldrPath> previousElements, BiConsumer<AttributeKey, String> valueAttributeCollector) {
        XPathParts pathParts;
        Preconditions.checkArgument(!fullPath.isEmpty(), "path must not be empty");
        try {
            pathParts = XPathParts.getFrozenInstance(fullPath);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("invalid path: " + fullPath);
        }
        int length = pathParts.size();
        Preconditions.checkArgument(length > 0, "cldr path must not be empty: %s", (Object)pathParts);
        DtdData dtd = pathParts.getDtdData();
        Preconditions.checkArgument(dtd != null, "unknown DTD type: %s", (Object)pathParts);
        CldrDataType dtdType = CldrDataType.forRawType(dtd.dtdType);
        CldrPath path = null;
        ArrayList<String> keyValuePairs = new ArrayList<String>();
        Consumer<Map.Entry<String, String>> collectElementAttribute = e -> {
            keyValuePairs.add((String)e.getKey());
            keyValuePairs.add((String)e.getValue());
        };
        boolean diverged = false;
        for (int n = 0; n < length; ++n) {
            CldrPath p;
            CldrDraftStatus draftStatus;
            String elementName = pathParts.getElement(n);
            int sortIndex = -1;
            Map<String, String> attributes = pathParts.getAttributes(n);
            int nameEnd = elementName.indexOf(35);
            if (nameEnd != -1) {
                sortIndex = Integer.parseUnsignedInt(elementName.substring(nameEnd + 1));
                elementName = elementName.substring(0, nameEnd);
            } else {
                String sortIndexStr = attributes.get(HIDDEN_SORT_INDEX_ATTRIBUTE);
                if (sortIndexStr != null) {
                    sortIndex = Integer.parseUnsignedInt(sortIndexStr);
                }
            }
            boolean hasNamespace = elementName.indexOf(58) != -1;
            Preconditions.checkArgument(hasNamespace || dtd.getElementFromName().containsKey(elementName), "invalid path: %s", (Object)fullPath);
            keyValuePairs.clear();
            CldrPaths.processPathAttributes(elementName, attributes, dtdType, collectElementAttribute, valueAttributeCollector);
            CldrDraftStatus cldrDraftStatus = draftStatus = dtd.getAttribute(elementName, "draft") != null ? CldrDraftStatus.forString(attributes.get("draft")) : null;
            if (!diverged && n < previousElements.size() && (p = previousElements.get(n)).matchesContent(elementName, sortIndex, keyValuePairs, draftStatus)) {
                path = p;
                continue;
            }
            path = new CldrPath(path, elementName, keyValuePairs, dtdType, draftStatus, sortIndex);
            diverged = true;
        }
        return path;
    }

    static void processPathAttributes(String elementName, Map<String, String> attributeMap, CldrDataType dtdType, Consumer<Map.Entry<String, String>> collectElementAttribute, BiConsumer<AttributeKey, String> collectValueAttribute) {
        if (attributeMap != null && !attributeMap.isEmpty()) {
            CldrPaths.processAttributes(attributeMap.entrySet().stream(), elementName, collectValueAttribute, dtdType).forEach(collectElementAttribute);
        }
    }

    static Stream<Map.Entry<String, String>> processAttributes(Stream<Map.Entry<String, String>> in, String elementName, BiConsumer<AttributeKey, String> collectValueAttribute, CldrDataType dtdType) {
        Consumer<Map.Entry> collectValueAttributes = e -> {
            if (dtdType.isValueAttribute(elementName, (String)e.getKey())) {
                collectValueAttribute.accept(AttributeKey.keyOf(elementName, (String)e.getKey()), (String)e.getValue());
            }
        };
        return in.filter(e -> !((String)e.getKey()).equals(HIDDEN_SORT_INDEX_ATTRIBUTE)).peek(collectValueAttributes).filter(e -> dtdType.isDistinguishingAttribute(elementName, (String)e.getKey()));
    }

    private CldrPaths() {
    }

    static {
        ImmutableSetMultimap.Builder leafElementsMap = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder orderedElementsMap = ImmutableSetMultimap.builder();
        CldrDataType[] cldrDataTypeArray = CldrDataType.values();
        int n = cldrDataTypeArray.length;
        for (int i = 0; i < n; ++i) {
            CldrDataType type = cldrDataTypeArray[i];
            leafElementsMap.putAll((Object)type, type.getElements().filter(IS_NOT_DEPRECATED).filter(e -> e.getChildren().keySet().stream().noneMatch(IS_NOT_DEPRECATED)).map(DtdData.Element::getName).filter(e -> !e.equals("special"))::iterator);
            orderedElementsMap.putAll((Object)type, type.getElements().filter(IS_NOT_DEPRECATED).filter(DtdData.Element::isOrdered).map(DtdData.Element::getName)::iterator);
        }
        leafElementsMap.put((Object)CldrDataType.LDML, "alias");
        LEAF_ELEMENTS_MAP = leafElementsMap.build();
        ORDERED_ELEMENTS_MAP = orderedElementsMap.build();
        ImmutableMap.Builder<CldrDataType, DtdPathComparator> pathMap = ImmutableMap.builder();
        for (CldrDataType type : CldrDataType.values()) {
            pathMap.put(type, new DtdPathComparator(type));
        }
        PATH_COMPARATOR_MAP = pathMap.build();
        LDML_VERSION = CldrPath.parseDistinguishingPath("//ldml/identity/version");
    }

    private static final class DtdPathComparator
    implements Comparator<CldrPath> {
        private final Comparator<String> elementNameComparator;
        private final Comparator<String> attributeNameComparator;

        private DtdPathComparator(CldrDataType dataType) {
            this.elementNameComparator = dataType.getElementComparator();
            this.attributeNameComparator = dataType.getAttributeComparator();
        }

        @Override
        public int compare(CldrPath lhs, CldrPath rhs) {
            int length = lhs.getLength();
            if (length == rhs.getLength()) {
                if (length == 1) {
                    Preconditions.checkState(lhs.getName().equals(rhs.getName()), "cannot compare paths with different DTD type: %s / %s", (Object)lhs, (Object)rhs);
                    return 0;
                }
                int signum = this.compare(lhs.getParent(), rhs.getParent());
                return signum != 0 ? signum : this.compareCurrentElement(lhs, rhs);
            }
            if (length < rhs.getLength()) {
                int signum = this.compare(lhs, rhs.getParent());
                return signum != 0 ? signum : -1;
            }
            return -this.compare(rhs, lhs);
        }

        private int compareCurrentElement(CldrPath lhs, CldrPath rhs) {
            String elementName = lhs.getName();
            int signum = Integer.signum(this.elementNameComparator.compare(elementName, rhs.getName()));
            if (signum != 0) {
                return signum;
            }
            signum = Integer.compare(lhs.getSortIndex(), rhs.getSortIndex());
            if (signum != 0) {
                return signum;
            }
            int minAttributeCount = Math.min(lhs.getAttributeCount(), rhs.getAttributeCount());
            for (int n = 0; n < minAttributeCount && signum == 0; ++n) {
                String attributeName = lhs.getLocalAttributeName(n);
                signum = -Integer.signum(this.attributeNameComparator.compare(attributeName, rhs.getLocalAttributeName(n)));
                if (signum != 0) continue;
                signum = Integer.signum(DtdData.getAttributeValueComparator(elementName, attributeName).compare(lhs.getLocalAttributeValue(n), rhs.getLocalAttributeValue(n)));
            }
            if (signum == 0) {
                if (lhs.getAttributeCount() > minAttributeCount) {
                    signum = 1;
                } else if (rhs.getAttributeCount() > minAttributeCount) {
                    signum = -1;
                }
            }
            return signum;
        }
    }
}

