/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

final class LocaleIds {
    private static final Pattern LOCALE_ID = Pattern.compile("(?:[a-z]{2,3})(?:_(?:[A-Z][a-z]{3}))?(?:_(?:[A-Z]{2}|[0-9]{3}))?(?:_(?:[A-Z]{5,}|[0-9][A-Z0-9]{3}))?");

    LocaleIds() {
    }

    public static void checkCldrLocaleId(String localeId) {
        Preconditions.checkArgument(LOCALE_ID.matcher(localeId).matches() || localeId.equals("root"), "bad locale ID: %s", (Object)localeId);
    }
}

